/*
 *  BCC2GRX  -  Interfacing Borland based graphics programs to LIBGRX
 *  Copyright (C) 1993  Hartmut Schirmer
 *
 *  see bccgrx.c for details
 */

#include "bccgrx00.h"

static GrContext *draw;
static int lx, ly, mx, my;
static int _border;

#define UP   0x01
#define DOWN 0x02

static int _floodfill(int x, int y, int flg, int xl, int xr)
{
  int sx, xx;

  sx = x;
  while ( sx > lx && GrPixelNC(sx-1,y) != _border)
    --sx;
  while ( x < mx && GrPixelNC(x+1,y) != _border)
    ++x;
  if (draw == NULL)
    GrHLine(sx, x, y, _border); /* _border == Fill color ! */
  else {
    GrSetContext( NULL);
    switch (FPATT) {
      case SOLID_FILL : GrHLine( sx, x, y, FILL);
			break;
      case EMPTY_FILL : GrHLine( sx, x, y, COLBG);
			break;
      default         : GrPatternFilledLine( sx, y, x, y, &FILLP);
			break;
    }
    GrSetContext(draw);
    GrHLineNC(sx, x, y, _border);
  }
  switch (flg) {
    case UP  : if (y<my) {
		 ++y;
		 for (xx=sx; xx <= x; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,UP,sx,x);
		 --y;
	       }
	       if (y>ly) {
		 --y;
		 for (xx=sx; xx <= xl; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,DOWN,sx,x);
		 for (xx=xr; xx <= x; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,DOWN,sx,x);
	       }
	       break;
    case DOWN: if (y>ly) {
		 --y;
		 for (xx=sx; xx <= x; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,DOWN,sx,x);
		 ++y;
	       }
	       if (y<my) {
		 ++y;
		 for (xx=sx; xx <= xl; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,UP,sx,x);
		 for (xx=xr; xx <= x; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,UP,sx,x);
	       }
	       break;
    default  : if (y>ly) {
		 --y;
		 for (xx=sx; xx <= x; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,DOWN,sx,x);
		 ++y;
	       }
	       if (y<my) {
		 ++y;
		 for (xx=sx; xx <= x; ++xx)
		   if (GrPixelNC(xx,y) != _border)
		     xx = _floodfill(xx,y,UP,sx,x);
	       }
	       break;
  }
  return x;
}

void floodfill(int x, int y, int border)
{
  _DO_INIT_CHECK;

  if (__gr_clip) {
    lx = VL; ly = VT;
    mx = VR; my = VB;
  } else {
    lx = 0; ly = 0;
    mx = GrScreenX() - 1;
    my = GrScreenY() - 1;
  }
  x += VL;
  y += VT;
  if ( x < lx || y < ly || x > mx || y > my || GrPixel(x,y) == border)
    return;

  _border = border;
  if (  (border == FILL  && FPATT == SOLID_FILL)
      ||(border == COLBG && FPATT == EMPTY_FILL)) {
    draw = NULL;
    _floodfill(x,y,0,0,0);
  } else {
    draw = GrCreateContext( GrScreenX(), GrScreenY(), NULL, draw);
    if (draw == NULL) {
      ERR = grNoFloodMem;
      return;
    }
    GrBitBlt(draw, lx, ly, NULL, lx, ly, mx, my, GrWRITE);
    GrSetContext( draw);
    FILLP.gp_bmp_fgcolor = FILL;
    FILLP.gp_bmp_bgcolor = COLBG;
    _floodfill(x,y,0,0,0);
    GrSetContext( NULL);
    GrDestroyContext(draw);
  }
}
