DMMPST(1)                      General Commands Manual                      DMMPST(1)

NAME
       dmmpst - DooM MaP StaTistics

SYNOPSIS
       dmmpst -? | -h

       dmmpst [ +v ] -w main WAD file [ -pw patch WAD file ] [ -file patch WAD
       files ...  ] [ +k|+r|+s|+d|+t|+yd|+yf ] [ +b|+6 ] [+8] [ +x | +xs | +xc
       | +xm | +xd ] [ -z classes ] [ -g game ] [ -n name ] [ -u UDMF_mark ] [
       -c CustomMap_file ] [ -i DoomWiki_tpl_dir ] [  -o  DoomWiki_file  ]  -e
       episode -m mission

       dmmpst [ +v ] -w main WAD file [ -pw patch WAD file ] [ -file patch WAD
       files ...  ] -j classes [ +b ] [ -u UDMF_mark ] [ -c  CustomMap_file  ]
       -e episode -m mission

       dmmpst  [  +v ] -w main WAD file [ -pw main WAD file ] [ -file main WAD
       files ...  ] [ -i DoomWiki_tpl_dir ] -o DoomWiki_file [ -a thing_type |
       +l ]

AVAILABILITY
       dmmpst  is  derived  from  dmpsmu / dmpsmap and dmtxls, which have been
       tested  on  SunOS  4.1,  IRIX  4.0,  Ultrix  4.3,  HP-UX   9.0,   Linux
       1.0.9/2.6/3.13/later  and  Windows 32/64-bit, so dmmpst should run fine
       on the same.

DESCRIPTION
       dmmpst is a command-line utility to generate map statistics  of  levels
       in DOOM, DOOM ][, Ultimate DOOM, Final DOOM, DOOM 64, Heretic, Heretic:
       Shadow of the Serpent Riders, Hexen and Hexen: Deathkings of  the  Dark
       Citadel,  the 3D action games by id Software, Raven Software and Midway
       Games; as well as Strife, the 3D  action  role-playing  game  by  Rogue
       Entertainment.

       This program's primary purpose is to use the included templates to gen‐
       erate output suitable for Doom Wiki (https://doomwiki.org/) map  pages,
       or sections thereof.  Statistics displayed for a map include its dimen‐
       sions, structure counts, and a list of secret sectors/things.

       Additionally this program can collect thing appearance  statistics  for
       one or multiple IWADs, or list sortable statistics for their maps.

FEATURES
       DMMPST offers the following features:

       * Supports Doom, Doom 64, Heretic, Hexen and Strife IWADs and PWADs

       * Supports Boom thing flags, Boom/ZDoom/Doom 64 generalized secret sec‐
         tors, Doom 64 secret things, and Doom 64 TC secret/shrine linedefs

       * Supports Doom-in-Hexen format levels (also if mixed with Doom  format
         levels within the same PWAD) and limit removing maps

       * Supports UDMF WAD format levels (but no PK3/7 archives)

       * Generates output files based on Doom Wiki templates that are suitable
         to copy directly into a page's Map data, Things, and --  together  --
         Statistics sections

       * Generates  output  files  that  are  suitable to copy directly into a
         page's Secrets section

       * Generates output files that are suitable  to  copy  directly  into  a
         page's Player spawns section for deathmatch or Capture the Flag

       * Generates  entire map skeletons that are suitable for the creation of
         new map pages

       * Displays basic statistics about  a  map:  its  dimensions,  structure
         counts, and secret sectors/things

       * Notifies  of things that have no skill level flags defined, to assist
         in describing them in a page's Bugs section

       * For Strife stock levels, translates generic actors (acolytes, rebels,
         peasants, beggars) into characters specific to each level

       * For  Doom, Heretic and Strife things, generates a single-player table
         and a multiplayer table; if Boom things format is enabled,  generates
         cooperative and deathmatch tables instead of the MP table

       * For  Hexen  things,  generates  three  single-player  tables  for the
         cleric, fighter and mage classes, as well as Coop and DM tables

       * Optionally excludes SP and Coop tables to generate only the MP or  DM
         table  for  deathmatch-only  levels, or various other combinations of
         in- and excluded tables

       * Optionally splits the MP-only/DM table into two  columns,  especially
         useful for Hexen & Deathkings and Strife: Veteran Edition map pages

       * Optionally displays the additional Things existing in Coop or MP mode
         when compared to SP mode

       * Automatically disables Coop or DM tables if  no  Coop  or  DM  starts
         exist, respectively; or disables the MP table if neither exist

       * Optionally allows to specify maps by a non-standard marker, typically
         for UDMF levels

       * Optionally allows to change and/or add custom Things  that  are  spe‐
         cific to the pertaining PWAD via a mapping file

       * For  any  combination  of things tables, wiki-links entries such that
         only the first of each unique link is applied

       * Counts aggregate things (cooperative  starts  and  voodoo  dolls)  in
         Doom, Heretic and Strife maps

       * Displays  ZDoom's  SecretTrigger  things  and  each matching thing or
         linedef that invokes it.

       * As an  alternative  to  the  above  map-related  features,  generates
         appearance statistics of thing types (DoomEd numbers) per skill level
         for one or more IWADs, or list sortable statistics for their maps

       * Includes source code for compilation on Linux, and 32/64-bit executa‐
         bles for Windows Command

       * Includes example shell scripts and batch files to generate Statistics
         sections for all IWAD levels

OPTIONS
       Options are case-insensitive and filenames and level  names  are  case-
       sensitive.  Both the short and long forms of the options are listed.

       -? -h -help
              Displays usage information.

       -w -main
              Specifies  the  name  of the main WAD file; default is DOOM.WAD.
              E.g. to use the DOOM ][ main WAD file, specify: -w DOOM2.WAD.

       -pw -pwad
              Specifies the name of a patch WAD file (or with -a, another IWAD
              file).   E.g.  to  merge  a  single patch WAD file, specify: -pw
              <file>.WAD.

       -file  Specifies a list of names of patch WAD files (or with  -a,  fur‐
              ther  IWAD files).  E.g. to merge several patch WAD files, spec‐
              ify: -file <file1>.WAD <file2>.WAD <file3>.WAD.

       +v +verbose
              Turns on verbose listing of  PWAD  loading  and  map  statistics
              (default off).

       +k +skeleton
              Turns  on  generation  of  complete skeleton (skeleton.tpl which
              includes secrets.tpl, mapdata.tpl, things.tpl, and  dmspawns.tpl
              or  ctfspawns.tpl) into DoomWiki file (default off). Implies +r,
              +s, and +yd or +yf.

       +r +secrets
              Turns on  generation  of  secrets  template  (secrets.tpl)  into
              DoomWiki file (default off).

       +yd +dmspawns
              Turns  on generation of DM player spawns template (dmspawns.tpl)
              into DoomWiki file (default off).

       +yf +ctfspawns
              Turns  on  generation  of  CTF  player  spawns  template  (ctfs‐
              pawns.tpl) into DoomWiki file (default off).

       +s +statistics
              Turns   on  generation  of  statistics  section  (mapdata.tpl  &
              things.tpl) into DoomWiki file (default off). Implies +d and +t.

       +d +mapdata
              Turns on generation of  map  data  template  (mapdata.tpl)  into
              DoomWiki file (default off).

       +t +things
              Turns   on  generation  of  things  template  (things.tpl)  into
              DoomWiki file (default off).

       +b +boommp
              Counts Boom multiplayer things instead  of  classic  multiplayer
              (default off).  Also needed for Doom-in-Hexen format maps.

       +6 +d64tc
              Counts  Doom  64 TC secret & shrine linedefs instead of general‐
              ized secret sectors and things (default  off).  Should  be  used
              only with doom64_abstin.wad and d64outcast.wad.

       +8 +excludeu68
              Excludes  UDMF  skills 6 through 8 from thing tables.  Useful to
              simplify the tables when most tallied things are absent on those
              skills  or  the skills are not relevant in the modification any‐
              way.

       +x +excludescp
              Excludes single-player and  cooperative  thing  tables,  listing
              only classic multiplayer or deathmatch tables (default off).  In
              classic multiplayer, cooperative starts are also excluded.

       +xs +excludesip
              Excludes single-player thing table, listing only classic  multi‐
              player or cooperative and deathmatch tables (default off).

       +xc +excludesmd
              Excludes  single-player  and  classic  multiplayer or deathmatch
              thing tables, listing only cooperative table (default off).

       +xm +excludemcd
              Excludes classic multiplayer or cooperative and deathmatch thing
              tables, listing only single-player table (default off).

       +xd +excludemdm
              Excludes classic multiplayer or deathmatch thing tables, listing
              only single-player and cooperative tables (default off).

       -z -splitdm
              Splits the multiplayer-only (when +x is enabled)  or  deathmatch
              Things  table  into  two  columns, with the specified classes (a
              series of digits) moving into the second column.  To the  header
              of  the  second  column  "cont."  (for "continued") is appended.
              Primarily intended for Hexen tables.

              The class digits can be specified in  any  order,  although  the
              classes in the second column are still placed in standard order.
              The digits are: 1, Monsters/Enemies;  2,  Other  Characters;  3,
              Weapons;  4, Ammunition; 5, Health & Armor; 6, Items; 7, Keys (&
              Puzzle/Quest Items); 8, Miscellaneous; 9, Ambient  Sounds.  E.g.
              to  move  classes  Weapons,  Ammo and Misc to the second column,
              specify: -y 348.

       -j -extracp
              Displays extra Coop or MP Things in comparison to  SP  mode  for
              the  specified classes (see -z), unless there are no cooperative
              starts.  E.g. to see extra monsters and weapons, specify: -j 13.

       -g -game
              Specifies the user game or megawad name to be used when generat‐
              ing  the  statistics.   Overrules the regular name for that game
              (derived from the IWAD). E.g. to set the  name  for  a  megawad,
              specify: -g <megawad-name>.

       -n -name
              Specifies  the  user  level  name to be used when generating the
              statistics.  Overrules the regular name  for  that  episode/mis‐
              sion.  E.g.  to  set the name for a patch WAD level, specify: -n
              <level-name>.

       -u -udmf
              Specifies the map marker for, typically, UDMF maps. E.g.   AEON,
              DBAB, NEON.

       -c -custommap
              Specifies the name of a custom Things mapping file. The map file
              changes and/or adds things by type ID that should be  listed  in
              the given class with a name and optional wiki link that are cus‐
              tom to the specified PWAD file. E.g. to  define  a  things  map,
              specify: -c pwad_file.map.

              Lines  starting with '#' are comments, map lines need to consist
              of four tab-separated values: class, thingID, wikiname and  wik‐
              ilink.   The  class  number  should be 0-8 (like the -z classes,
              minus one). The wikilink can be '~' to use the wikiname field as
              a link, or empty to prevent linking altogether. See the included
              example.map for several custom maps combined into one demonstra‐
              tion file.

       -i -wikitempl
              Specifies  the  path  to the input DoomWiki templates directory;
              default is the currect directory. E.g. to define a central  tem‐
              plates directory, specify: -i /usr/local/share/dw_templates.

       -o -wikifile
              Specifies  the  name of the output DoomWiki file. E.g. to define
              an output file for level Mt. Erebus, specify: -o E3M6.lst.

       -e -episode
              Specifies the episode  number  for  DOOM/Heretic  levels,  or  0
              (zero)  for DOOM ][/Final DOOM/DOOM 64/Hexen/Strife levels. E.g.
              to set the episode for level Mt. Erebus, specify: -e 3.

       -m -mission
              Specifies the mission number for DOOM/Heretic levels, or the map
              number  for DOOM ][/Final DOOM/DOOM 64/Hexen/Strife levels. E.g.
              to set the mission for level Mt. Erebus, specify: -m 6.

       -a -appearance
              Tallies the appearance statistics of a thing  type  for  one  or
              more  IWADs.   For  episodic  IWADs  (Doom,  Heretic,  Hexen's &
              Deathkings' hubs) counts per episode/hub and  an  overall  total
              are  collected,  for  other IWADs (Doom II, Final Doom, Doom 64,
              Strife) only totals.  Tallies within the same game  family  (all
              Doom and both Hexen variants) can be combined into one table.

              The  counts  are generated per skill level for single-player and
              multiplayer modes -- or for multiplayer or deathmatch mode  only
              when  +x  is enabled -- via the appearance template (appear.tpl)
              into DoomWiki file.  Additionally, a table is included  of  maps
              per  episode/hub/IWAD  where the given thing first appears. E.g.
              to tally the megasphere, specify: -a 83.

       +l     Lists sortable statistics of the maps in one or more  IWADs  via
              the maps list template (mapslist.tpl) into DoomWiki file.

       The  options v, k, r, yd, yf, s, d, t, b and x[csmd] are actually bool‐
       eans that can be preceded by + or -.  The x[csmd] are  mutually  exclu‐
       sive so only one can be specified.

NOTES
       When  a map contains Things with Boom multiplayer flags and the +b flag
       is off, a warning is shown to turn it on.

       When a map contains Things without skill  flags,  their  Thing  number,
       name,  and  type  ID  are  displayed,  and they are not included in the
       Things table.

       For Strife's IWAD maps, generic actors are translated  into  level-spe‐
       cific  major  and  minor  characters.  If one or more PWADs are loaded,
       this translation is disabled.

       Before generating DoomWiki files for e.g.  deathmatch  maps,  copy  the
       skeleton.dm  template file to its .tpl counterpart (it already includes
       things.mp instead of  things.tpl).   When  returning  to  single-player
       maps,  copy  back  the *.orig file.  The lists of secret sectors and/or
       player spawns appear only  in  skeleton  pages  if  their  template  is
       included in the skeleton template in use.

       DOOM  64  has the maps stored as WADs in the IWAD.  To save development
       work for this one-off problem, DMMPST requires a modified IWAD with the
       maps inlined in the correct slots.

EXAMPLES
       The command:

         dmmpst -w DOOM.WAD -file foobar.wad -name FooBar -e 1 -m 1 +V +S -o foobar.lst

       illustrates how various forms of the options can be mixed and gives the
       following messages:

         DMMPST: DooM MaP StaTistics, ver 2.10
          By Frans P. de Vries <fpv@gamers.org>
         Main WAD file: DOOM.WAD.
         Patch WAD file: foobar.wad.
         User level name: FooBar.
         Episode number: 1.
         Mission number: 1.
         Verbose log & statistics.
         Statistics wiki output.
         DoomWiki output file: foobar.lst.
         Loading main WAD file: DOOM.WAD...
         Main WAD version: 0x01.
         Loading patch WAD file: foobar.wad...
            [Updating level E1M1]

         Outputting DoomWiki template of level E1M1 to "foobar.lst".

       The command:

         dmmpst +v -w DOOM.WAD -pw DOOM2.WAD -o bfg9000.lst -A 2006

       collects appearance statistics of the BFG9000 and gives  the  following
       messages:

         DMMPST: DooM MaP StaTistics, ver 2.10
          By Frans P. de Vries <fpv@gamers.org>
         Verbose log & statistics.
         Main WAD file: DOOM.WAD.
         Patch WAD file: DOOM2.WAD.
         DoomWiki output file: bfg9000.lst.
         Appearance of thing type: 2006.
         Loading main WAD file: DOOM.WAD...
         Main WAD version: 0x01.
         Main WAD name: Doom (registered).
         Loading main WAD file: DOOM2.WAD...
         Main WAD version: 0x02.
         Main WAD name: Doom II.

         Outputting DoomWiki template of thing type 2006 to "bfg9000.lst".
         Thing name: BFG9000.

SEE ALSO
       DEU  5.21, by Raphael Quinet and Brendon J. Wyber, ported to GCC by Per
       Allansson and Per Kofod

       DOOM Specs v1.666, by Matt Fell

       Doom  Wiki  at   https://doomwiki.org/   and   the   DMMPST   page   at
       https://doomwiki.org/wiki/DMMPST

DIAGNOSTICS
       dmmpst can terminate with error messages in the following format:
              Program Error: *** <error message> ***
       The messages are fairly self-explanatory and are therefore not repeated
       here.

AUTHOR
       Frans P. de Vries <fpv@gamers.org>

DMMPST                              16 March 2024                           DMMPST(1)
