/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	DMMPST.H - Main DMMPST definitions.
*/

#define _GNU_SOURCE
#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include "dmunix.h"

/*
	the global definitions
*/
#define DMMPST_VERSION "2.4"
#define DEU_VERSION "5.21 GCC" /* DJGPP/GO32 version */

typedef int16_t  BCINT;
typedef uint16_t UBCINT;
typedef uint8_t  UBYTE;
typedef int32_t  BCLNG;
typedef uint32_t UBCLNG;

/*
	syntactic sugar
*/
typedef UBYTE Bool; /* Boolean data: true or false */

/* boolean constants */
#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif


/*
	Description of the command line arguments and config file keywords
*/
typedef struct
{
	char *short_name;   /* abbreviated command line argument */
	char *long_name;    /* command line arg. or keyword */
	enum {              /* type of this option: */
		OPT_BOOLEAN,      /* boolean (toggle) */
		OPT_INTEGER,      /* integer number */
		OPT_LONG,         /* long int number */
		OPT_STRING,       /* character string */
		OPT_STRINGACC,    /* character string, but store in a list */
		OPT_STRINGLIST,   /* list of character strings */
		OPT_END           /* end of the options description */
	}     opt_type;
	char *msg_if_true;  /* message printed if option is true */
	char *msg_if_false; /* message printed if option is false */
	void *data_ptr;     /* pointer to the data */
} OptDesc;


/*
	the global variables
*/
extern BCINT GameVersion; /* which game and version? */
extern char *MainWad;     /* name of the main WAD file */
extern char **PatchWads;  /* list of patch WAD files */
extern char *UserLvlNm;   /* user defined level name */
extern char *UserGamNm;   /* user defined game/megawad name */
extern char *CustomMap;   /* path to custom Things translations */
extern char *WkTpPath;    /* path to DoomWiki input templates */
extern FILE *WkFile;      /* the DoomWiki output file */
extern Bool Verbose;      /* verbose statistics? */
extern Bool WSkeleton;    /* skeleton wiki? */
extern Bool WSecrets;     /* secrets wiki? */
extern Bool WStatistics;  /* statistics wiki? */
extern Bool WMapdata;     /* map data wiki? */
extern Bool WThings;      /* things wiki? */
extern Bool WDmSpawns;    /* DM player spawns wiki? */
extern Bool WCtfSpawns;   /* CTF player spawns wiki? */
extern Bool WBoomMP;      /* Boom multiplayer in things wiki? */
extern Bool WD64TC;       /* Doom 64 TC secret & shrine linedefs? */
extern Bool WXcludeSP;    /* exclude SP/Coop, only MP/DM things? */
extern BCLNG WExtraCP;    /* list extra Coop things by classes */
extern BCLNG WSplitDM;    /* split DM table by classes */
extern BCINT AppearType;  /* tally appearance by thing type */
extern Bool WMapsList;    /* list statistics by map */
extern char *UDMFmark;    /* marker for (UDMF) maps */

/*
	the global function prototypes
*/
int main( int, char *[]);
void ProgError( char *, ...);

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
