/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.H - Thing type and flag definitions.
*/

#ifndef THINGS_H
#define THINGS_H

#include "wstructs.h"

/*
	the global definitions
*/
enum {
	ThModeSP,  // 0
	ThModeXC,  // 1
	ThModeXF,  // 2
	ThModeXM,  // 3
	ThModeMP,  // 4
	ThModeCP,  // 5
	ThModeDM,  // 6
	ThMode_End // 7
};

enum {
	ThClassMnst, // 0
	ThClassChar, // 1
	ThClassWeap, // 2
	ThClassAmmo, // 3
	ThClassHlAr, // 4
	ThClassItem, // 5
	ThClassKeys, // 6
	ThClassMisc, // 7
	ThClassSnds, // 8
	ThClassObst, // 9
	ThClassDeco, // 10
	ThClass_End  // 11
};

/*
	the global data types and variables
*/
typedef struct
{
	UBCINT class;
	char  *wikiname;
	char  *wikilink;
	char  *wikistr;
} ThClass;

extern UBCINT NumThClasses;
extern ThClass **ThClasses;

typedef struct
{
	UBCINT class;
	UBCINT type;
	char  *wikiname;
	char  *wikilink;
	char  *wikistr;
	UBCINT skill[MAX_UDMF][ThMode_End];
	Bool   custom;
} ThItem;

extern UBCINT NumThItems;
extern ThItem  **ThItems;


/*
	the global function prototypes
*/
void InitDoomThings( void);
void InitHereticThings( void);
void InitHexenThings( void);
void InitStrifeThings( BCINT);
void ReadCustomThings( void);
void AnalyzeThings( BCINT, Bool);
void ForgetThings( void);
void AggregateSpecials( void);
Bool ThingInMode( UBCINT, int);
Bool CheckThingBoomFlags( void);
Bool CheckThingTypes( int, int);
int CountThings( BCINT);
int CountSecretThings( void);
int TotalThingSkills( ThItem *, int);
void ResetThingSkills( ThItem *, int);
char *UsedWiki( char *, char *, char *);


/*
	DOOM, Heretic, Hexen & Strife common Things
*/

/* Starting points */
#define THING_PLAYER1         1
#define THING_PLAYER2         2
#define THING_PLAYER3         3
#define THING_PLAYER4         4
#define THING_DEATHMATCH      11
#define THING_TELEPORT        14
#define THING_TEAMBLUE        5080  /* ZDoom, VE */
#define THING_TEAMRED         5081  /* ZDoom, VE */
#define THING_TEAMGREEN       5083  /* ZDoom */
#define THING_TEAMGOLD        5084  /* ZDoom */
#define THING_FLAGBLUE        5130  /* ZDoom, VE */
#define THING_FLAGRED         5131  /* ZDoom, VE */
#define THING_FLAGGREEN       5133  /* ZDoom */
#define THING_FLAGGOLD        5134  /* ZDoom */
#define THING_FLAGWHITE       5132  /* ZDoom, neutral */
#define THING_BUILDCAM        32000

/* Aggregate things */
#define THING_COOPSTARTS      32500
#define THING_VOODOODOLLS     32501


/*
	DOOM Things
*/

/* Starting points */
#define THING_PLAYER5D        4001
#define THING_PLAYER6D        4002
#define THING_PLAYER7D        4003
#define THING_PLAYER8D        4004

/* Enemies */
#define THING_HUMAN           3004
#define THING_SERGEANT        9
#define THING_COMMANDO        65    /* ][ */
#define THING_IMP             3001
#define THING_NIGHTMAREIMP    3007  /* 64 */
#define THING_LOSTSOUL        3006
#define THING_DEMON           3002
#define THING_SPECTRE         58
#define THING_SPECTRE1PSX     892
#define THING_SPECTRE2PSX     893
#define THING_SPECTRE3PSX     890
#define THING_SPECTRENMPSX    889
#define THING_REVENANT        66    /* ][ */
#define THING_CACODEMON       3005
#define THING_CACODEMONSPEC   894
#define THING_PAINELEM        71    /* ][ */
#define THING_KNIGHT          69    /* ][ */
#define THING_BARON           3003
#define THING_ARACHNO         68    /* ][ */
#define THING_MANCUBUS        67    /* ][ */
#define THING_ARCHVILE        64    /* ][ */
#define THING_SPIDERBOSS      7
#define THING_CYBERDEMON      16
#define THING_RESURRECTOR     3013  /* 64 */
#define THING_WOLF3DSS        84    /* ][ */
#define THING_KEEN            72    /* ][ */

/* Custom Enemies */
#define THING_ST_HUMAN        9061
#define THING_ST_SERGEANT     9060
#define THING_ST_COMMANDO     9054
#define THING_ST_IMP          9057
#define THING_ST_DEMON        9055
#define THING_ST_REVENANT     9059
#define THING_ST_CACODEMON    9053
#define THING_ST_KNIGHT       9056
#define THING_ST_BARON        9052
#define THING_ST_ARACHNO      9050
#define THING_ST_MANCUBUS     9058
#define THING_ST_ARCHVILE     9051
#define THING_HELPERDOG       888
#define THING_SCRIPT_MARINE   9100
#define THING_MARINE_FIST     9101
#define THING_MARINE_BERSERK  9102
#define THING_MARINE_CHNSAW   9103
#define THING_MARINE_PISTOL   9104
#define THING_MARINE_SHOTGUN  9105
#define THING_MARINE_SUPERSG  9106
#define THING_MARINE_CHNGUN   9107
#define THING_MARINE_ROCKET   9108
#define THING_MARINE_PLASMA   9109
#define THING_MARINE_RAILGUN  9110
#define THING_MARINE_BFG9000  9111

/* Weapons & ammo */
#define THING_CHAINSAW        2005
#define THING_SHOTGUN         2001
#define THING_COMBATGUN       82    /* ][ */
#define THING_CHAINGUN        2002
#define THING_LAUNCHER        2003
#define THING_PLASMAGUN       2004
#define THING_BFG9000         2006
#define THING_64_LASER        84    /* 64 */
#define THING_AMMOCLIP        2007
#define THING_AMMOBOX         2048
#define THING_SHELLS          2008
#define THING_SHELLBOX        2049
#define THING_ROCKET          2010
#define THING_ROCKETBOX       2046
#define THING_ENERGYCELL      2047
#define THING_ENERGYPACK      17

/* Enhancements & bonuses */
#define THING_STIMPACK        2011
#define THING_MEDIKIT         2012
#define THING_GREENARMOR      2018
#define THING_BLUEARMOR       2019

#define THING_ARMBONUS1       2015
#define THING_HLTBONUS1       2014
#define THING_SOULSPHERE      2013
#define THING_MEGASPHERE      83    /* ][ */
#define THING_BACKPACK        8
#define THING_BERSERK         2023
#define THING_COMPMAP         2026
#define THING_INVULN          2022
#define THING_LITEAMP         2045
#define THING_BLURSPHERE      2024
#define THING_RADSUIT         2025
#define THING_ARTIFACT1       1042  /* 64 */
#define THING_ARTIFACT2       1043  /* 64 */
#define THING_ARTIFACT3       1044  /* 64 */

/* Keys */
#define THING_BLUECARD        5
#define THING_BLUESKULLKEY    40
#define THING_YELLOWCARD      6
#define THING_YELLOWSKULLKEY  39
#define THING_REDCARD         13
#define THING_REDSKULLKEY     38

/* Specials */
#define THING_BARREL          2035
#define THING_BOSSBRAIN       88    /* ][ */
#define THING_BOSSSHOOT       89    /* ][ */
#define THING_SPAWNSPOT       87    /* ][ */

/* Obstacles */
#define THING_FLAMECAN        70    /* ][ */
#define THING_GREYTREE        43
#define THING_CANDELABRA      35
#define THING_EYEINSYMBOL     41
#define THING_HEADSKEWER      28
#define THING_SKULLSINFLAMES  42
#define THING_LAMP            2028
#define THING_HANGINGLEG      53
#define THING_HANGINGTORSO    52
#define THING_HANGINGTORSO4   78    /* ][ */
#define THING_HANGINGLOOKDN   75    /* ][ */
#define THING_HANGINGLOOKUP   77    /* ][ */
#define THING_HANGINGTORSO3   76    /* ][ */
#define THING_HANGINGARMSOUT  50
#define THING_HANGINGNOGUTS2  74    /* ][ */
#define THING_HANGINGNOGUTS   73    /* ][ */
#define THING_HANGINGONELEG   51
#define THING_HANGINGSWAYING  49
#define THING_IMPALEDBODY     25
#define THING_BROWNTREE       54
#define THING_PILEOFSKULLS    29
#define THING_SBLUETORCH      55
#define THING_SGREENTORCH     56
#define THING_SGREENPILLAR    31
#define THING_PILLARHEART     36
#define THING_SREDTORCH       57
#define THING_SREDPILLAR      33
#define THING_PILLARSKULL     37
#define THING_SHORTLAMP       86    /* ][ */
#define THING_SKULLTOPPOLE    27
#define THING_BROWNSTUB       47
#define THING_TBLUETORCH      44
#define THING_TGREENTORCH     45
#define THING_TGREENPILLAR    30
#define THING_TREDTORCH       46
#define THING_TREDPILLAR      32
#define THING_TALLLAMP        85    /* ][ */
#define THING_TECHCOLUMN      48
#define THING_IMPALEDBODY2    26

/* Decorations */
#define THING_BONES           10
#define THING_BONES2          12
#define THING_CANDLE          34
#define THING_DEADCACODEMON   22
#define THING_DEADDEMON       21
#define THING_DEADHUMAN       18
#define THING_DEADSERGEANT    19
#define THING_DEADIMP         20
#define THING_DEADLOSTSOUL    23
#define THING_DEADPLAYER      15
#define THING_HANGINGLEG2     62
#define THING_HANGINGTORSO2   60
#define THING_HANGINGARMSOUT2 59
#define THING_HANGINGONELEG2  61
#define THING_HANGINGSWAYING2 63
#define THING_POOLOFBLOOD2    79    /* ][ */
#define THING_POOLOFBLOOD3    80    /* ][ */
#define THING_POOLOFBLOOD     24
#define THING_POOLOFBRAINS    81    /* ][ */
#define THING_BLOODYCHAINPSX  891

/* Doom64 Decorations */
#define THING_64_BIGFIRE            2051
#define THING_64_BARREL             1001
#define THING_64_LAMPTECHLONGHANG   1015
#define THING_64_LAMPTECHSHORTHANG  1016
#define THING_64_BLUETORCH          1003
#define THING_64_REDTORCH           1025
#define THING_64_YELLOWTORCH        1039
#define THING_64_BLUEFIRE           1033
#define THING_64_REDFIRE            1034
#define THING_64_YELLOWFIRE         1035
#define THING_64_TORCHBASELONG      1050
#define THING_64_TORCHBASESHORT     1051
#define THING_64_GIBMEATSTICK       1005
#define THING_64_GIBMEATHANG        1006
#define THING_64_GIBTORSOHANG       1007
#define THING_64_GIBRIBFLOOR        1008
#define THING_64_GIBTWITCHFLOOR     1009
#define THING_64_GIBBLOODPOOL       1010
#define THING_64_GIBBONEFLOOR       1011
#define THING_64_GIBMEATRIBFLOOR    1012
#define THING_64_GIBMEATRIBCAGE     1013
#define THING_64_GIBCHAINHOOK       1014
#define THING_64_GIBHANGCAGE        1017
#define THING_64_GIBCHAINPINCER     1018
#define THING_64_GIBCHAINARM        1019
#define THING_64_GIBMACEBLOODY      1020
#define THING_64_GIBMACECLEAN       1046
#define THING_64_GIBHANGWHITEMEAT   1047
#define THING_64_GIBHEADHANG        1048
#define THING_64_GIBHANGRIBROTTING  1049
#define THING_64_GIBSKULLSTICK      1022
#define THING_64_GIBHEADSTICK       1023
#define THING_64_GIBDOUBLEMEATSTICK 1024
#define THING_64_STATUEDRAGON       1028
#define THING_64_STATUEDEMON        1029
#define THING_64_TECHPOLELONG       1031
#define THING_64_TECHPOLESHORT      1032
#define THING_64_TREESTUMPSMALL     1036
#define THING_64_TREESTUMPLARGE     1037
#define THING_64_TREE               1038
#define THING_64_BLOODYMETALPOLE    1045

/* Doom64 Misc */
#define THING_64_CAMERA             0
#define THING_64_PROJECTILESPOT     2050
#define THING_64_TRIGGER            89
#define THING_64_LASERMARKER        90
#define THING_64_TITLECYBERDEMON    3014
#define THING_64_MARINE_RED         3008
#define THING_64_MARINE_AQUA        3009
#define THING_64_MARINE_GREEN       3010

/* ZDoom Specials */
#define THING_Z_SECTRIG             9046
#define THING_Z_ACTIVATE            130


/*
	Heretic Things
*/

/* Starting points */
#define THING_PLAYER5H        4001
#define THING_PLAYER6H        4002
#define THING_PLAYER7H        4003
#define THING_PLAYER8H        4004

/* Enemies */
#define THING_GARGOYLE        66
#define THING_FRGARGOYLE      5
#define THING_GOLEM           68
#define THING_GOLEMGH         69
#define THING_NTGOLEM         45
#define THING_NTGOLEMGH       46
#define THING_SABRECLAW       90
#define THING_DISCIPLE        15
#define THING_WARRIOR         64
#define THING_WARRIORGH       65
#define THING_WEREDRAGON      70
#define THING_OPHIDIAN        92
#define THING_IRONLICH        6
#define THING_MAULOTAUR       9
#define THING_DSPARIL         7

/* Weapons & ammo */
#define THING_GAUNTLETS       2005
#define THING_CROSSBOW        2001
#define THING_DRAGONCLAW      53
#define THING_HELLSTAFF       2004
#define THING_PHOENIXROD      2003
#define THING_FIREMACE        2002
#define THING_CRYSTAL         10
#define THING_CRGEODE         12
#define THING_ARROWS          18
#define THING_ARQUIVER        19
#define THING_CLAWORB         54
#define THING_ENERGYORB       55
#define THING_RUNESSML        20
#define THING_RUNESLRG        21
#define THING_FLAMEORBSML     22
#define THING_FLAMEORBLRG     23
#define THING_MACESPHSML      13
#define THING_MACESPHLRG      16

/* Enhancements & bonuses */
#define THING_CRYSTALVIAL     81
#define THING_ENCHSHIELD      31
#define THING_SILVSHIELD      85

#define THING_BAGHOLDING      8
#define THING_CHAOSDEV        36
#define THING_MAPSCROLL       35
#define THING_MORPHOVUM       30
#define THING_MYSTICURN       32
#define THING_QUARTZFLASK     82
#define THING_RINGINVULN      84
#define THING_SHADOWSPHR      75
#define THING_TIMEBOMB        34
#define THING_TOMEPOWER       86
#define THING_TORCH           33
#define THING_WINGS           83

/* Keys */
#define THING_BLUEKEY         79
#define THING_GREENKEY        73
#define THING_YELLOWKEY       80

/* Specials */
#define THING_DSPARILSPOT     56
#define THING_GLITTELEPORT    74
#define THING_GLITTELEEXIT    52
#define THING_KEYGIZMOBLUE    94
#define THING_KEYGIZMOGREEN   95
#define THING_KEYGIZMOYELLOW  96
#define THING_POD             2035
#define THING_PODGENERATOR    43

/* Sounds */
#define THING_SNDBELSS        1205
#define THING_SNDDROPS        1202
#define THING_SNDFASTFOOT     1209
#define THING_SNDGROWL        1206
#define THING_SNDHEARTBEAT    1204
#define THING_SNDLAUGHTER     1208
#define THING_SNDMAGIC        1207
#define THING_SNDSCREAM       1200
#define THING_SNDSLOWFOOT     1203
#define THING_SNDSQUISH       1201
#define THING_SNDWATERFALL    41
#define THING_SNDWIND         42

/* Obstacles */
#define THING_VOLCANO         87
#define THING_BROWNBARREL     44
#define THING_TBROWNPILLAR    47
#define THING_SGREYPILLAR     29
#define THING_SERPENTTORCH    27
#define THING_FIREBRAZIER     76
#define THING_HANGINGCORPSE   51
#define THING_STALACTSMALL    39
#define THING_STALACTLARGE    40
#define THING_STALAGMSMALL    37
#define THING_STALAGMLARGE    38

/* Decorations */
#define THING_CHANDELIER      28
#define THING_WALLTORCH       50
#define THING_MOSS1STR        49
#define THING_MOSS3STR        48
#define THING_HANGINGSKULL1   26
#define THING_HANGINGSKULL2   25
#define THING_HANGINGSKULL3   24
#define THING_HANGINGSKULL4   17


/*
	Hexen Things
*/

/* Starting points */
#define THING_PLAYER5X        9100
#define THING_PLAYER6X        9101
#define THING_PLAYER7X        9102
#define THING_PLAYER8X        9103

/* Enemies */
#define THING_AFRIT           10060
#define THING_STALKER         121
#define THING_STALKERBOSS     120
#define THING_WENDIGO         8020
#define THING_DARKBISHOP      114
#define THING_REIVER          34
#define THING_REIVERBURIED    10011
#define THING_ETTIN           10030
#define THING_CENTAUR         107
#define THING_BROWNCSERP      8080
#define THING_GREENCSERP      31
#define THING_SLAUGHTAUR      115
#define THING_DEATHWYVERN     254
#define THING_MENELKIR        10102
#define THING_TRADUCTUS       10101
#define THING_ZEDEK           10100
#define THING_HERESIARCH      10080
#define THING_KORAX           10200

/* Weapons & ammo */
#define THING_TIMONSAXE       8010
#define THING_HAMMERRETR      123
#define THING_QUIETUSHILT     16
#define THING_QUIETUSCROSS    13
#define THING_QUIETUSBLADE    12
#define THING_SERPENTSTAFF    10
#define THING_FIRESTORM       8009
#define THING_WVERGESHAFT     20
#define THING_WVERGECROSS     19
#define THING_WVERGEARC       18
#define THING_FROSTSHARDS     53
#define THING_ARCDEATH        8040
#define THING_BSCOURGESTICK   23
#define THING_BSCOURGESTUB    22
#define THING_BSCOURGESKULL   21
#define THING_BLUEMANA        122
#define THING_GREENMANA       124
#define THING_COMBMANA        8004

/* Enhancements & bonuses */
//efine THING_CRYSTALVIAL     81
#define THING_AMULETWARD      8008
#define THING_FALCONSHIELD    8006
#define THING_MESHARMOR       8005
#define THING_PLATINUMHELM    8007

#define THING_BANISHDEV       10040
#define THING_BOOTSSPEED      8002
//efine THING_CHAOSDEV        36
#define THING_DARKSERVANT     86
#define THING_DISCREPULS      10110
#define THING_DSKINBRACERS    8041
#define THING_FLECHETTE       8000
#define THING_ICONDEFEND      84
#define THING_KRATERMIGHT     8003
#define THING_MYSTAMBINC      10120
//efine THING_MYSTICURN       32
#define THING_PORKALATOR      30
//efine THING_QUARTZFLASK     82
//efine THING_TORCH           33
//efine THING_WINGS           83

/* Puzzle items */
#define THING_FLAMEMASK       9014
#define THING_HEARTDSPARIL    9003
#define THING_EMERALDPLANET1  9005
#define THING_EMERALDPLANET2  9009
#define THING_RUBYPLANET      9004
#define THING_SAPPHPLANET1    9006
#define THING_SAPPHPLANET2    9010
#define THING_CLOCKGBRNZSTL   9021
#define THING_CLOCKGBRONZE    9019
#define THING_CLOCKGSTLBRNZ   9020
#define THING_CLOCKGSTEEL     9018
#define THING_DAEMONCODEX     9007
#define THING_LIBEROSCURA     9008
#define THING_YORICKSSKULL    9002
#define THING_GLAIVESEAL      9015
#define THING_HOLYRELIC       9016
#define THING_SIGILMAGUS      9017

/* Keys */
#define THING_AXEKEY          8032
#define THING_CASTLEKEY       8200
#define THING_CAVEKEY         8031
#define THING_DUNGEONKEY      8035
#define THING_EMERALDKEY      8034
#define THING_FIREKEY         8033
#define THING_HORNKEY         8038
#define THING_RUSTYKEY        8037
#define THING_SILVERKEY       8036
#define THING_STEELKEY        8030
#define THING_SWAMPKEY        8039

/* Specials */
#define THING_BATSPAWNER      10225
#define THING_BELL            8065
#define THING_DESTRUCTREE     8062
#define THING_EVERGRNTREE     8068
#define THING_FOGPATCHLRG     10003
#define THING_FOGPATCHMED     10002
#define THING_FOGPATCHSML     10001
#define THING_FOGSPAWNER      10000
#define THING_GLITTBRIDGE     118
#define THING_LEAFSPAWNER     113
#define THING_MUSHROOM        8104
#define THING_POTTLL          104
#define THING_POTMED          105
#define THING_POTSHT          106
#define THING_SHRUBSML        8101
#define THING_SHRUBLRG        8102
#define THING_SITTINGCORPSE   110
#define THING_SPIKE_UP        10091
#define THING_SPIKE_DN        10090
#define THING_SUITARMOR       8064
#define THING_TELEPSMOKE      140

/* Invisible specials */
#define THING_MAPSPOT         9001
#define THING_MAPSPOTGRAV     9013
#define THING_POLYANCHOR      3000
#define THING_POLYSPAWN       3001
#define THING_POLYSPAWNCR     3002

/* Obstacles */
#define THING_WINGEDSTATUE    5
#define THING_YORICKSTATUE    9011
#define THING_PEDDSPARIL      9012
#define THING_TOMBRIP         63
#define THING_TOMBSHANE       64
#define THING_TOMBSLIMY       65
#define THING_TOMBBRIANR      66
#define THING_TOMBCRSCIRC     67
#define THING_TOMBSMCROSS     68
#define THING_TOMBBRIANP      69
#define THING_IMPALEDCORPSE   61
#define THING_HANGINGCORPSEX  71
#define THING_LYNCHDCORPSE    108
#define THING_LYNCHDCORPSEHL  109
#define THING_TWINEDTORCHLIT  116
#define THING_TWINEDTORCHULT  117
#define THING_MINOTSTATLIT    8042
#define THING_MINOTSTATULT    8043
#define THING_SKULLWFLAME     8060
#define THING_BRAZIERWFLAME   8061
#define THING_CAULDRONLIT     8069
#define THING_CAULDRONULT     8070
#define THING_BARRELX         8100
#define THING_PILLARWVASE     103
#define THING_BATTLERAGBNNR   77
#define THING_IRONMAIDEN      8067
#define THING_HANGINGBUCKET   8103
#define THING_ICEGARGTLL      73
#define THING_ICEGARGSHT      76
#define THING_STONEGARGTLL    72
#define THING_STONEGARGSHT    74
#define THING_RUSTYGARGTLL    8044
#define THING_DLAVAGARGTLL    8045
#define THING_DLAVAGARGSHT    8049
#define THING_LLAVAGARGTLL    8046
#define THING_LLAVAGARGSHT    8050
#define THING_BRONZEGARGTLL   8047
#define THING_BRONZEGARGSHT   8051
#define THING_STEELGARGTLL    8048
#define THING_STEELGARGSHT    8052
#define THING_DEADTREE        24
#define THING_LEAFLESSTREE    25
#define THING_MOSSYTREE1      26
#define THING_MOSSYTREE2      27
#define THING_MOSSYDEADTREE   60
#define THING_TREESTUMPBRND   28
#define THING_TREESTUMPBARE   29
#define THING_TREELOG         88
#define THING_TALLTREE1       78
#define THING_TALLTREE2       79
#define THING_GNARLEDTREE1    80
#define THING_GNARLEDTREE2    87
#define THING_STALAGMPILLAR   48
#define THING_STALAGMLRG      49
#define THING_STALAGMMED      50
#define THING_STALAGMSML      51
#define THING_STALACTLRG      52
#define THING_STALACTMED      56
#define THING_STALACTSML      57
#define THING_ICICLELRG       89
#define THING_ICICLEMED       90
#define THING_ICICLESML       91
#define THING_ICICLETNY       92
#define THING_ICESPIKELRG     93
#define THING_ICESPIKEMED     94
#define THING_ICESPIKESML     95
#define THING_ICESPIKETNY     96
#define THING_BROWNROCKLRG    97
#define THING_BROWNROCKSML    98
#define THING_BLACKROCK       99
#define THING_MOSSYROCKLRG    15

/* Decorations */
#define THING_CHANDELIERLIT   17
#define THING_CHANDELIERULT   8063
#define THING_WALLTORCHLIT    54
#define THING_WALLTORCHULT    55
#define THING_3CANDLESLIT     119
#define THING_BLUECANDLELIT   8066
#define THING_CANDLEWWEBULT   8502
#define THING_GRAYCANDLEULT   8503
#define THING_CANDLEWOWEBULT  8504
#define THING_SMLFLAMETMD     10500
#define THING_SMLFLAME        10501
#define THING_LRGFLAMETMD     10502
#define THING_LRGFLAME        10503
#define THING_CHAINSHT        8071
#define THING_CHAINLONG       8072
#define THING_CHAINWLRGHOOK   8074
#define THING_CHAINWSMLHOOK   8075
#define THING_CHAINWSPKBALL   8076
#define THING_HOOKWHEART      8073
#define THING_HOOKWSKULL      8077
#define THING_POOLBLOOD       111
#define THING_SLEEPINGCORPSE  62
#define THING_WOODENSTEIN     8500
#define THING_METALSTEIN      8501
#define THING_GOBLETSPILLED   8505
#define THING_GOBLETTLL       8506
#define THING_GOBLETSHT       8507
#define THING_GOBLETSILVER    8508
#define THING_MEATCLEAVER     8509
#define THING_MOSSYROCKTNY    6
#define THING_MOSSYROCKSML    7
#define THING_MOSSYROCKMED    9
#define THING_TREESTUMP1      37
#define THING_TREESTUMP2      38
#define THING_LARGEMUSHROOM1  39
#define THING_LARGEMUSHROOM2  40
#define THING_MEDIUMMUSHROOM  41
#define THING_SMALLMUSHROOM1  42
#define THING_SMALLMUSHROOM2  44
#define THING_SMALLMUSHROOM3  45
#define THING_SMALLMUSHROOM4  46
#define THING_SMALLMUSHROOM5  47
#define THING_HANGINGMOSS1    58
#define THING_HANGINGMOSS2    59
#define THING_BRICKRUBBLELRG  100
#define THING_BRICKRUBBLESML  101
#define THING_BRICKRUBBLEMED  102

/* Ambient sounds */
#define THING_SNDCREAK        1403
#define THING_SNDEARTH        1408
#define THING_SNDHEAVY        1401
#define THING_SNDICE          1407
#define THING_SNDLAVA         1405
#define THING_SNDMETAL        1402
#define THING_SNDMETAL2       1409
#define THING_SNDSILENCE      1404
#define THING_SNDSTONE        1400
#define THING_SNDWATER        1406
#define THING_SNDWINDX        1410


/*
	Strife Things
*/

/* Starting points */
#define THING_PLAYER5S        5
#define THING_PLAYER6S        6
#define THING_PLAYER7S        7
#define THING_PLAYER8S        8

/* Enemies */
#define THING_ACOLYTE1TAN     3002
#define THING_ACOLYTE2RED     142
#define THING_ACOLYTE3RUST    143
#define THING_ACOLYTE4GRAY    146
#define THING_ACOLYTE5DGREEN  147
#define THING_ACOLYTE6GOLD    148
#define THING_ACOLYTE7LGREEN  232
#define THING_ACOLYTE8BLUE    231
#define THING_SHADOWACOLYTE   58
#define THING_BECOMACOLYTE    201
#define THING_STALKER2        186
#define THING_SENTINEL        3006
#define THING_CEILTURRET      27
#define THING_REAVER          3001
#define THING_TEMPLAR         3003
#define THING_CRUSADER        3005
#define THING_BISHOP          187
#define THING_ORACLE          199
#define THING_MACIL1          64
#define THING_MACIL2SP        200
#define THING_LOREMASTER      12
#define THING_INQUISITOR      16
#define THING_PROGRAMMER      71
#define THING_SPECTREPROGR    129
#define THING_SPECTREBISHOP   75
#define THING_SPECTREORACLE   76
#define THING_SPECTREMACIL    167
#define THING_SPECTRELOREM    168
#define THING_ENTITY          128
#define THING_ENTITYNEST      26
#define THING_ENTITYPOD       198

/* Other characters */
#define THING_ARMORER         73
#define THING_BARKEEP         72
#define THING_MEDIC           74
#define THING_WEAPONSMITH     116
#define THING_REBEL1          9
#define THING_REBEL2          144
#define THING_REBEL3          145
#define THING_REBEL4          149
#define THING_REBEL5          150
#define THING_REBEL6          151
#define THING_BEGGAR1         141
#define THING_BEGGAR2         155
#define THING_BEGGAR3         156
#define THING_BEGGAR4         157
#define THING_BEGGAR5         158
#define THING_KNEELGUY        204
#define THING_ZOMBIE          169
#define THING_ZOMBIESPAWN     170
#define THING_PEASANTBLUE     181
#define THING_PEASANTDGRN1    172
#define THING_PEASANTDGRN2    173
#define THING_PEASANTDGRN3    174
#define THING_PEASANTGOLD1    178
#define THING_PEASANTGOLD2    179
#define THING_PEASANTGOLD3    180
#define THING_PEASANTGRAY1    66
#define THING_PEASANTGRAY2    134
#define THING_PEASANTGRAY3    135
#define THING_PEASANTLGRN1    175
#define THING_PEASANTLGRN2    176
#define THING_PEASANTLGRN3    177
#define THING_PEASANTRED1     65
#define THING_PEASANTRED2     132
#define THING_PEASANTRED3     133
#define THING_PEASANTRUST1    67
#define THING_PEASANTRUST2    136
#define THING_PEASANTRUST3    137
#define THING_PEASANTTAN1     3004
#define THING_PEASANTTAN2     130
#define THING_PEASANTTAN3     131

/* Weapons & ammo */
#define THING_CROSSBOW2       2001
#define THING_ASSAULTRIFLE    2002
#define THING_ASSAULTRIFLE2   2006
#define THING_MINIMSLAUNCH    2003
#define THING_GRENADELAUNCH   154
#define THING_FLAMETHROW      2005
#define THING_MAULER          2004
#define THING_SIGIL1          77
#define THING_SIGIL2          78
#define THING_SIGIL3          79
#define THING_SIGIL4          80
#define THING_SIGIL5          81
#define THING_ELECBOLTS       114
#define THING_POISBOLTS       115
#define THING_BULLETCLIP      2007
#define THING_BULLETSBOX      2048
#define THING_MISSILES        2010
#define THING_MISSILECRATE    2046
#define THING_GASGRENADE      84    /* unused */
#define THING_HEGRENADE       152
#define THING_PHOSPHGRENADE   153
#define THING_ENERGYPOD       2047
#define THING_ENERGYPACK      17

/* Enhancements & bonuses */
#define THING_MEDPATCH        2011
#define THING_MEDICALKIT      2012
#define THING_SURGERYKIT      83
#define THING_LEATHERARMOR    2018
#define THING_METALARMOR      2019
#define THING_AMMOSATCHEL     183
#define THING_COMMUNICATOR    206
#define THING_ENVIRONSUIT     2025
#define THING_MAPSTRIFE       2026
#define THING_SCANNER         2027
#define THING_SHADOWARMOR     2024
#define THING_TARGETER        207
#define THING_TELEPBEACON     10

/* Quest items */
#define THING_GOLDCOIN        93
#define THING_GOLD10          138
#define THING_GOLD25          139
#define THING_GOLD50          140
#define THING_BRKNPWRCOUPL    226
#define THING_POWERCOUPL      220
#define THING_DEGNINORE       59
#define THING_ORESPAWNER      7975    /* VE */
#define THING_FFIELDGUARD     25
#define THING_GATEPISTON      45
#define THING_OFFICERUNIF     52
#define THING_GUARDUNIF       90
#define THING_POWERCRYSTAL    92
#define THING_OFFERCHALICE1   205
#define THING_OFFERCHALICE2   7970    /* VE */
#define THING_COMPUTER        182
#define THING_REDTALIS        7966    /* VE */
#define THING_GREENTALIS      7967    /* VE */
#define THING_BLUETALIS       7968    /* VE */

/* Keys */
#define THING_IDBADGE         184
#define THING_IDCARD          13
#define THING_BASEKEY         230
#define THING_BLUECRYSKEY     193
#define THING_BRASSKEY        39
#define THING_CHAPELKEY       195
#define THING_COREKEY         236
#define THING_FACTORYKEY      234
#define THING_GOLDKEY         40
#define THING_MAULERKEY       233
#define THING_MINEKEY         235
#define THING_ORACLEKEY       61
#define THING_ORDERKEY        86
#define THING_PASSCARD        185
#define THING_REDCRYSKEY      192
#define THING_SEVEREDHAND     91
#define THING_SILVERKEY2      38
#define THING_WAREHOUSEKEY    166

/* Specials */
#define THING_BARRELSTRIFE    94
#define THING_WOODENBARREL    82
#define THING_PRACTTARGET     208
#define THING_RATBUDDY        85
#define THING_TELEPSWIRL      23
#define THING_TELEMAPSPOT1    118
#define THING_TELEMAPSPOT2    119
#define THING_TELEMAPSPOT3    120
#define THING_TELEMAPSPOT4    121
#define THING_TELEMAPSPOT5    122
#define THING_TELEMAPSPOT6    123
#define THING_TELEMAPSPOT7    124
#define THING_TELEMAPSPOT8    125
#define THING_TELEMAPSPOT9    126
#define THING_TELEMAPSPOT10   127

/* Obstacles */
#define THING_TREESTUB        33
#define THING_SHORTBUSH       60
#define THING_TALLBUSH        62
#define THING_PALMTREE        51
#define THING_BIGTREE         202
#define THING_POTTEDTREE      203
#define THING_CANDELABRA      35
#define THING_MEDIUMTORCH     111
#define THING_LARGETORCH      47
#define THING_HUGETORCH       50
#define THING_OUTSIDELAMP     43
#define THING_POLELANTERN     46
#define THING_GLOBELIGHT      2028
#define THING_SILVERTLAMP     196
#define THING_BRASSTLAMP      197
#define THING_ALIENSPLIGHT    225
#define THING_CHIMNEYSTACK    63
#define THING_BARRCOLUMN      69
#define THING_TECHPILLAR      48
#define THING_AZTECPILLAR     54
#define THING_DAMGDAZPILLAR   55
#define THING_RUINDAZPILLAR   56
#define THING_HUGETCHPILLAR   57
#define THING_HUGEALNPILLAR   227
#define THING_ALIENBCOLUMN    221
#define THING_ALIENFLOORB     222
#define THING_ALIENCEILB      223
#define THING_ALIENASPCL      224
#define THING_STATUE          110
#define THING_RUINEDSTAT      44
#define THING_POT             165
#define THING_PITCHER         188
#define THING_STOOL           189
#define THING_ANVIL           194
#define THING_TRAY            68
#define THING_AMMOFILLER      228
#define THING_BURNINGBARREL   70
#define THING_BURNINGBOWL     105
#define THING_BURNINGBRAZR    106
#define THING_HEARTSINTANK    113
#define THING_SURGERYCRAB     117
#define THING_HUGETANK1       209
#define THING_HUGETANK2       210
#define THING_HUGETANK3       211
#define THING_TANK4           213
#define THING_TANK5           214
#define THING_TANK6           229
#define THING_CAVEPLRTOP      159
#define THING_CAVEPLRBOT      162
#define THING_STALACTLRGS     98
#define THING_STALAGMLRGS     160
#define THING_STALACTSMLS     161
#define THING_STALAGMSMLS     163

/* Decorations */
#define THING_DEADPLAYER      15
#define THING_DEADPEASANT     18
#define THING_DEADREBEL       19
#define THING_DEADREAVER      20
#define THING_DEADACOLYTE     21
#define THING_DEADCRUSADER    22
#define THING_KLAXONWLIGHT    24
#define THING_CAGELIGHT       28
#define THING_CANDLE          34
#define THING_SMLBURNTORCH    107
#define THING_SMLUNLITTORCH   108
#define THING_SILVRFLUORLIT   95
#define THING_BRASSFLUORLIT   96
#define THING_GOLDFLUORLIT    97
#define THING_RUBBLE1         29
#define THING_RUBBLE2         30
#define THING_RUBBLE3         31
#define THING_RUBBLE4         32
#define THING_RUBBLE5         36
#define THING_RUBBLE6         37
#define THING_RUBBLE7         41
#define THING_RUBBLE8         42
#define THING_ROCK1           99
#define THING_ROCK2           100
#define THING_ROCK3           101
#define THING_ROCK4           102
#define THING_CEILWTRDRIP     53
#define THING_FLOORWTRDRIP    103
#define THING_WATERFSPLASH    104
#define THING_WATERFOUNTAIN   112
#define THING_STICKINWATER    215
#define THING_MUG             164
#define THING_METALPOT        190
#define THING_TUB             191
#define THING_WATERBOTTLE     2014
#define THING_REBELBOOTS      217
#define THING_REBELHELMET     218
#define THING_REBELSHIRT      219
#define THING_CEILINGCHAIN    109
#define THING_SACRIFGUY       212
#define THING_SIGILBANNER     216


/* Doom, Heretic, Strife flags */

#define TF_SEASY  0x01    /* skills 1-2 (easy) thing */
#define TF_SMEDM  0x02    /* skill 3 (medium) thing */
#define TF_SHARD  0x04    /* skills 4-5 (hard) thing */
#define TF_NOTSP  0x10    /* not single-player thing */
#define TF_NOTDM  0x20    /* Boom: not deathmatch thing */
#define TF_NCOOP  0x40    /* Boom: not cooperative thing */

/* Hexen flags */

#define TF_HFGHT  0x020   /* Fighter class thing */
#define TF_HCLRC  0x040   /* Cleric class thing */
#define TF_HMAGE  0x080   /* Mage class thing */
#define TF_HXNSP  0x100   /* single-player thing */
#define TF_HXNCP  0x200   /* cooperative thing */
#define TF_HXNDM  0x400   /* deathmatch thing */

/* Doom64 flags */

#define TF_D64SEC 0x100   /* secret thing */

#endif /* THINGS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
