/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	WADS.H - WAD data definitions.
*/

#ifndef WADS_H
#define WADS_H

#include "dmunix.h"

/*
	The directory structure is the structure used by the DOOM-engine
	to order the data in its Wad files.
*/
typedef struct Directory *DirPtr;
struct Directory
{
	BCLNG start;    /* offset to start of data */
	BCLNG size;     /* byte size of data */
	char  name[8];  /* name of data block */
};

/*
	The Wad file structure is used for holding the information on the
	Wad files in a linked list.
	The first Wad file is the main WAD file. The rest are patches.
*/
typedef struct WadFileInfo *WadPtr;
struct WadFileInfo
{
	WadPtr next;      /* next file in linked list */
	char  *filename;  /* name of the WAD file */
	FILE  *fileinfo;  /* C file stream information */
	char   type[4];   /* type of WAD file (IWAD or PWAD) */
	BCLNG  dirsize;   /* directory size of WAD */
	BCLNG  dirstart;  /* offset to start of directory */
	DirPtr directory; /* array of directory information */
};

/*
	The master directory structure is used to build a complete directory
	of all the data blocks from all the various Wad files.
*/
typedef struct MasterDirectory *MDirPtr;
struct MasterDirectory
{
	MDirPtr next;         /* next in list */
	WadPtr  wadfile;      /* file of origin */
	struct Directory dir; /* directory data */
};


/*
	the global variables
*/
extern WadPtr  WadFileList; /* linked list of Wad files */
extern MDirPtr MasterDir;   /* the master directory */


/*
	the global function prototypes
*/
void OpenMainWad( char *);
void OpenPatchWad( char *);
void CloseWadFiles( void);
void CloseUnusedWadFiles( void);
WadPtr BasicWadOpen( char *);
void BasicWadRead( WadPtr, void *, BCLNG);
void BasicWadSeek( WadPtr, BCLNG);
MDirPtr FindMasterDir( MDirPtr, char *);
MDirPtr FindLevelDir( MDirPtr, char *);

#endif /* WADS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
