/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	LEVELS.H - Level data definitions.
*/

#ifndef LEVELS_H
#define LEVELS_H

#include "wstructs.h"
#include "wads.h"

/*
	the global definitions
*/
#define B_GENSEC   0x0080  /* Boom: generalized secret sector, Doom format */
#define B_GENSECH  0x0400  /* Boom: generalized secret sector, Hexen/UDMF format */
#define D64_GENSEC 0x0020  /* Doom 64: generalized secret sector */


/*
	the global variables
*/
extern char *LevelName; /* official name for the level */

extern UBCINT NumThings;   /* number of things */
extern TPtr      Things;   /* things data */
extern UBCLNG NumLineDefs; /* number of line defs */
extern LDPtr     LineDefs; /* line defs data */
extern UBCLNG NumSideDefs; /* number of side defs */
extern SDPtr     SideDefs; /* side defs data */
extern UBCLNG TotVertexes; /* total number of vertexes */
extern UBCLNG NumVertexes; /* number of used vertexes */
extern VPtr      Vertexes; /* vertex data */
/* extern UBCINT NumSegs;     /* number of segments */
/* extern SEPtr     Segs;     /* list of segments */
/* extern UBCINT NumSSectors; /* number of subsectors */
/* extern SSPtr     SSectors; /* list of subsectors */
extern UBCINT NumSectors;  /* number of sectors */
extern SPtr      Sectors;  /* sectors data */

extern BCLNG MapMaxX;      /* maximum X value of map */
extern BCLNG MapMaxY;      /* maximum Y value of map */
extern BCLNG MapMinX;      /* minimum X value of map */
extern BCLNG MapMinY;      /* minimum Y value of map */

extern Bool UDMFmap;       /* UDMF map flag */
extern Bool UDMFall;       /* UDMF all skills flag */

extern char *LevelNames1[4][9];
extern char *LevelNames2[32];
extern char *LevelNamesT[32];
extern char *LevelNamesP[32];
extern char *LevelNamesH[6][9];
extern char *LevelNamesX[40];
extern char *LevelNamesD[30];
extern char *LevelNamesS[38];
extern char *LevelNames64[40];


/*
	the global function prototypes
*/
void CheckLevelParams( BCINT, BCINT);
BCINT ReadLevelData( BCINT, BCINT);
void ForgetLevelData( void);

#endif /* LEVELS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
