/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.C - Thing routines.
*/

#include "dmmpst.h"
#include "things.h"
#include "levels.h"


/*
	the global variables
*/
UBCINT NumThClasses = 0;
ThClass **ThClasses = NULL;

UBCINT NumThItems = 0;
ThItem  **ThItems = NULL;

/*
	the local variables
*/
UBCINT NumUsedLinks = 0;
char    **UsedLinks = NULL;

/*
	the local function prototypes
*/
void DumpThings( UBCINT);
Bool FlaglessThing( BCINT);
void AppendClass( UBCINT, char *, char *, char *);
void AppendStrife( BCINT, UBCINT, UBCINT, char *, char *);
void AppendItem( UBCINT, UBCINT, char *, char *);
void SortStrife( UBCINT);


/*
	Strife character translation table
*/
typedef struct
{
	UBCINT mapnr;
	UBCINT thgid;
	char  *wikiname;
	char  *wikilink;
} StrifeChar;

#define NUMCHARS 131

StrifeChar StrifeChars[NUMCHARS] = {
	{  1, THING_PEASANTGRAY3,   "Beldin", "Strife minor characters - Hub 1#Beldin" },

	{  2, THING_ACOLYTE5DGREEN, "Sewer guard", "Strife minor characters - Hub 1#Acolytes" },
	{  2, THING_ACOLYTE6GOLD,   "Guard (type 58)", "Strife minor characters - Hub 1#Acolytes" },
	{  2, THING_ACOLYTE4GRAY,   "Guard (type 56)", "Strife minor characters - Hub 1#Acolytes" },
	{  2, THING_ACOLYTE2RED,    "Door guard", "Strife minor characters - Hub 1#Acolytes" },
	{  2, THING_ACOLYTE3RUST,   "Guard (type 55)", "Strife minor characters - Hub 1#Acolytes" },
	{  2, THING_MEDIC,          "Medic", "Strife minor characters - Hub 1#Medic" },
	{  2, THING_ARMORER,        "Armorer", "Strife minor characters - Hub 1#Armorer" },
	{  2, THING_WEAPONSMITH,    "Weapon smith (Bowyer)", "Strife minor characters - Hub 1#Bowyer" },
	{  2, THING_BARKEEP,        "Barkeep", "Strife minor characters - Hub 1#Barkeep" },
	{  2, THING_REBEL2,         "Front guard", "Strife minor characters - Hub 1#Front Guard" },
	{  2, THING_BEGGAR1,        "MacGuffin", "" },
	{  2, THING_PEASANTBLUE,    "Governor Mourel", "" },
	{  2, THING_PEASANTDGRN1,   "Irale", "Strife minor characters - Hub 1#Irale" },
	{  2, THING_PEASANTLGRN1,   "Sewer gate watchman", "Strife minor characters - Hub 1#Peasants" },
	{  2, THING_PEASANTRED1,    "Harris", "" },
	{  2, THING_PEASANTRUST1,   "Rowan", "" },
	{  2, THING_PEASANTRUST2,   "Geoff", "" },
	{  2, THING_PEASANTTAN2,    "Arion", "Strife minor characters - Hub 1#Arion" },
	{  2, THING_PEASANTTAN3,    "Ulaine", "Strife minor characters - Hub 1#Ulaine" },

	{  3, THING_MEDIC,          "Medic (Gerard)", "Strife minor characters - Hub 1#Gerard" },
	{  3, THING_WEAPONSMITH,    "Weapon smith (Feris)", "Strife minor characters - Hub 1#Feris" },
	{  3, THING_REBEL2,         "Rebel (type 44)", "Strife minor characters - Hub 1#Rebels" },
	{  3, THING_REBEL3,         "Rebel (type 45)", "Strife minor characters - Hub 1#Rebels" },
	{  3, THING_REBEL4,         "Rebel (type 46)", "Strife minor characters - Hub 1#Rebels" },
	{  3, THING_REBEL5,         "Rebel (type 47)", "Strife minor characters - Hub 1#Rebels" },
	{  3, THING_REBEL6,         "Rebel (type 48)", "Strife minor characters - Hub 1#Rebels" },
	{  3, THING_PEASANTDGRN1,   "Peasant (type 18)", "Strife minor characters - Hub 1#Peasants 2" },
	{  3, THING_PEASANTGRAY1,   "Advisor (type 12)", "Strife minor characters - Hub 1#Advisors" },
	{  3, THING_PEASANTGRAY2,   "Macil's advisor (type 13)", "Strife minor characters - Hub 1#Advisors" },
	{  3, THING_PEASANTGRAY3,   "Advisor (type 14)", "Strife minor characters - Hub 1#Advisors" },
	{  3, THING_PEASANTRUST1,   "Peasant (type 15)", "Strife minor characters - Hub 1#Peasants 2" },
	{  3, THING_PEASANTRUST2,   "Peasant (type 16)", "Strife minor characters - Hub 1#Peasants 2" },
	{  3, THING_PEASANTRUST3,   "Peasant (type 17)", "Strife minor characters - Hub 1#Peasants 2" },

	{  4, THING_ACOLYTE5DGREEN, "Overseer", "Strife minor characters - Hub 1#Acolytes 2" },
	{  4, THING_ACOLYTE6GOLD,   "Core guard", "Strife minor characters - Hub 1#Acolytes 2" },
	{  4, THING_ACOLYTE4GRAY,   "Reactor guard", "Strife minor characters - Hub 1#Acolytes 2" },
	{  4, THING_ACOLYTE2RED,    "Door guard", "Strife minor characters - Hub 1#Acolytes 2" },
	{  4, THING_ACOLYTE3RUST,   "Foreman", "Strife minor characters - Hub 1#Acolytes 2" },
	{  4, THING_PEASANTGRAY1,   "Ketrick", "Strife minor characters - Hub 1#Ketrick" },
	{  4, THING_PEASANTGRAY2,   "Sammis", "Strife minor characters - Hub 1#Sammis" },
	{  4, THING_PEASANTGRAY3,   "Computer tech (type 14)", "Strife minor characters - Hub 1#Technicians" },
	{  4, THING_PEASANTRED1,    "Dock worker (type 9)", "Strife minor characters - Hub 1#Dock_Workers" },
	{  4, THING_PEASANTRED2,    "Derwin", "" },
	{  4, THING_PEASANTRED3,    "Worner", "" },
	{  4, THING_PEASANTRUST1,   "Dock worker (type 15)", "Strife minor characters - Hub 1#Dock Workers" },
	{  4, THING_PEASANTRUST2,   "Technician (type 16)", "Strife minor characters - Hub 1#Technicians" },
	{  4, THING_PEASANTRUST3,   "Technician (type 17)", "Strife minor characters - Hub 1#Technicians" },
	{  4, THING_PEASANTTAN2,    "Technician (type 7)", "Strife minor characters - Hub 1#Technicians" },
	{  4, THING_PEASANTTAN3,    "Technician (type 8)", "Strife minor characters - Hub 1#Technicians" },

	{  5, THING_ACOLYTE2RED,    "Door guard", "Strife minor characters - Hub 1#Door Guard" },
	{  5, THING_ACOLYTE3RUST,   "Prison guard", "Strife minor characters - Hub 1#Prison Guard" },
	{  5, THING_PEASANTDGRN1,   "Prisoner (type 18)", "Strife minor characters - Hub 1#Prisoners" },
	{  5, THING_PEASANTDGRN2,   "Prisoner (type 19)", "Strife minor characters - Hub 1#Prisoners" },
	{  5, THING_PEASANTDGRN3,   "Prisoner (type 20)", "Strife minor characters - Hub 1#Prisoners" },
	{  5, THING_PEASANTGRAY1,   "Warden Montag", "" },
	{  5, THING_PEASANTGRAY2,   "Judge Wolenick", "" },
	{  5, THING_PEASANTRUST1,   "Prisoner (type 15)", "Strife minor characters - Hub 1#Prisoners" },
	{  5, THING_PEASANTRUST2,   "Prisoner (type 16)", "Strife minor characters - Hub 1#Prisoners" },
	{  5, THING_PEASANTRUST3,   "Prisoner (type 17)", "Strife minor characters - Hub 1#Prisoners" },

	{  6, THING_ACOLYTE2RED,    "Acolyte (type 54)", "Strife minor characters - Hub 1#Acolytes 3" },
	{  6, THING_ACOLYTE3RUST,   "Watchman", "Strife minor characters - Hub 1#Acolytes 3" },
	{  6, THING_ACOLYTE1TAN,    "Acolyte (type 53)", "Strife minor characters - Hub 1#Acolytes 3" },
	{  6, THING_BEGGAR1,        "Beggar (type 38)", "Strife minor characters - Hub 1#Sewer mutants" },
	{  6, THING_BEGGAR2,        "Beggar (type 39)", "Strife minor characters - Hub 1#Sewer mutants" },
	{  6, THING_BEGGAR3,        "Beggar (type 40)", "Strife minor characters - Hub 1#Sewer mutants" },
	{  6, THING_BEGGAR4,        "Beggar (type 41)", "Strife minor characters - Hub 1#Sewer mutants" },
	{  6, THING_BEGGAR5,        "Beggar (type 42)", "Strife minor characters - Hub 1#Sewer mutants" },
	{  6, THING_PEASANTDGRN2,   "Weran", "" },

	{  7, THING_ACOLYTE2RED,    "Acolyte (type 54)", "Strife minor characters - Hub 1#Acolytes 4" },
	{  7, THING_PEASANTLGRN1,   "False Programmer", "Strife minor characters - Hub 1#Programmer" },
	{  7, THING_PEASANTRUST1,   "Peasant (type 15)", "Strife minor characters - Hub 1#Peasants 3" },
	{  7, THING_PEASANTTAN1,    "Peasant (type 6)", "Strife minor characters - Hub 1#Peasants 3" },

	{  8, THING_PEASANTBLUE,    "False Programmer", "Strife minor characters - Hub 1#Programmer 2" },

	{ 10, THING_MEDIC,          "Medic (Gerard)", "Strife minor characters - Hub 2#Gerard" },
	{ 10, THING_ARMORER,        "Armorer (Justin)", "Strife minor characters - Hub 2#Justin" },
	{ 10, THING_WEAPONSMITH,    "Weapon smith (Feris)", "Strife minor characters - Hub 2#Feris" },
	{ 10, THING_REBEL2,         "Rebel (type 44)", "Strife minor characters - Hub 2#Rebels" },
	{ 10, THING_REBEL3,         "Rebel (type 45)", "Strife minor characters - Hub 2#Rebels" },
	{ 10, THING_REBEL4,         "Rebel (type 46)", "Strife minor characters - Hub 2#Rebels" },

	{ 11, THING_ACOLYTE4GRAY,   "Sergeant", "Strife minor characters - Hub 2#Sergeant" },
	{ 11, THING_ACOLYTE2RED,    "Temple guard", "Strife minor characters - Hub 2#Temple Guards" },
	{ 11, THING_PEASANTGOLD1,   "Keymaster", "Strife minor characters - Hub 2#Keymaster" },
	{ 11, THING_PEASANTRUST1,   "Prisoner (type 15)", "Strife minor characters - Hub 2#Prisoners" },
	{ 11, THING_PEASANTRUST2,   "Prisoner (type 16)", "Strife minor characters - Hub 2#Prisoners" },
	{ 11, THING_PEASANTRUST3,   "Prisoner (type 17)", "Strife minor characters - Hub 2#Prisoners" },

	{ 14, THING_PEASANTGOLD1,   "Drone (type 24)", "Strife minor characters - Hub 3#Drones" },
	{ 14, THING_PEASANTGOLD2,   "Drone (type 25)", "Strife minor characters - Hub 3#Drones" },
	{ 14, THING_PEASANTGOLD3,   "Drone (type 26)", "Strife minor characters - Hub 3#Drones" },
	{ 14, THING_PEASANTRED1,    "James", "Strife minor characters - Hub 3#James" },

	{ 15, THING_ACOLYTE2RED,    "Foreman", "Strife minor characters - Hub 2#Foreman" },
	{ 15, THING_PEASANTRUST1,   "Technician (type 15)", "Strife minor characters - Hub 2#Technicians" },
	{ 15, THING_PEASANTRUST2,   "Technician (type 16)", "Strife minor characters - Hub 2#Technicians" },

	{ 17, THING_ACOLYTE5DGREEN, "Warehouse guard", "Strife minor characters - Hub 2#Warehouse Guard" },
	{ 17, THING_ACOLYTE2RED,    "Bailey guard", "Strife minor characters - Hub 2#Bailey Guard" },
	{ 17, THING_MEDIC,          "Medic (Quincy)", "Quincy" },
	{ 17, THING_PEASANTGRAY1,   "Assistant", "Strife minor characters - Hub 2#Assistant" },

	{ 18, THING_ACOLYTE6GOLD,   "Warehouse guard", "Strife minor characters - Hub 2#Warehouse Guard 2" },

	{ 23, THING_MEDIC,          "Medic", "Strife minor characters - Hub 3#Medic" },
	{ 23, THING_ARMORER,        "Armorer", "Strife minor characters - Hub 3#Armorer" },
	{ 23, THING_WEAPONSMITH,    "Weapon smith", "Strife minor characters - Hub 3#Weapon Smith" },
	{ 23, THING_BARKEEP,        "Barkeep", "Strife minor characters - Hub 3#Barkeep" },
	{ 23, THING_PEASANTDGRN1,   "Richter", "" },
	{ 23, THING_PEASANTGOLD1,   "Timothy", "Strife minor characters - Hub 3#Timothy" },
	{ 23, THING_PEASANTRED1,    "Tevick", "Strife minor characters - Hub 3#Tevick" },

	{ 27, THING_PEASANTGRAY1,   "Loremaster's slave", "Strife minor characters - Hub 3#Peasant" },

	{ 31, THING_PEASANTGOLD1,   "False Programmer", "Strife minor characters - Hub 1#Programmer 3" },

	{ 32, THING_ACOLYTE2RED,    "Order Sergeant", "Acolyte" },
	{ 32, THING_BEGGAR1,        "Prisoner", "Beggar" },

	{ 33, THING_ACOLYTE5DGREEN, "Acolyte", "Strife minor characters - Hub 1#Acolytes" },
	{ 33, THING_ACOLYTE6GOLD,   "Body guard", "Strife minor characters - Hub 1#Acolytes" },
	{ 33, THING_MEDIC,          "Medic", "Strife minor characters - Hub 1#Medic" },
	{ 33, THING_ARMORER,        "Armorer", "Strife minor characters - Hub 1#Armorer" },
	{ 33, THING_WEAPONSMITH,    "Weapon smith (Bowyer)", "Strife minor characters - Hub 1#Bowyer" },
	{ 33, THING_BARKEEP,        "Barkeep", "Strife minor characters - Hub 1#Barkeep" },
	{ 33, THING_PEASANTBLUE,    "Governor Mourel", "" },
	{ 33, THING_PEASANTRED1,    "Harris", "" },
	{ 33, THING_PEASANTRED2,    "Harris", "" },
	{ 33, THING_PEASANTTAN3,    "Ulaine", "Strife minor characters - Hub 1#Ulaine" },

	{ 34, THING_REBEL2,         "Rebel (type 44)", "Strife minor characters - Hub 1#Rebels" },
	{ 34, THING_REBEL3,         "Rebel (type 45)", "Strife minor characters - Hub 1#Rebels" },
	{ 34, THING_REBEL4,         "Rebel (type 46)", "Strife minor characters - Hub 1#Rebels" },
	{ 34, THING_REBEL5,         "Rebel (type 47)", "Strife minor characters - Hub 1#Rebels" },
	{ 34, THING_REBEL6,         "Rebel (type 48)", "Strife minor characters - Hub 1#Rebels" },
	{ 34, THING_MEDIC,          "Medic (Gerard)", "Strife minor characters - Hub 1#Gerard" },
	{ 34, THING_WEAPONSMITH,    "Weapon smith (Feris)", "Strife minor characters - Hub 1#Feris" },
	{ 34, THING_PEASANTGRAY1,   "Advisor (type 12)", "Strife minor characters - Hub 1#Advisors" },
	{ 34, THING_PEASANTGRAY2,   "Macil's advisor (type 13)", "Strife minor characters - Hub 1#Advisors" },
	{ 34, THING_PEASANTGRAY3,   "Advisor (type 14)", "Strife minor characters - Hub 1#Advisors" },
	{ 34, THING_PEASANTRUST1,   "Peasant (type 15)", "Strife minor characters - Hub 1#Peasants 2" },
	{ 34, THING_PEASANTRUST2,   "Peasant (type 16)", "Strife minor characters - Hub 1#Peasants 2" },
};


/*
	initialize Doom thing classes and items
*/
void InitDoomThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster", NULL);
	//AppendClass( ThClassChar, "Other characters", NULL, NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Doom games", NULL);
	AppendClass( ThClassItem, "Items", "Item#Doom games", NULL);
	AppendClass( ThClassKeys, "Keys", "Key", NULL);
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_HUMAN, "Zombieman", ""); // 20
	AppendItem( ThClassMnst, THING_ST_HUMAN, "Stealth human", "Stealth monsters"); // 20
	AppendItem( ThClassMnst, THING_SERGEANT, "Shotgun guy", ""); // 30
	AppendItem( ThClassMnst, THING_ST_SERGEANT, "Stealth sergeant", "Stealth monsters"); // 30
	AppendItem( ThClassMnst, THING_COMMANDO, "Heavy weapon dude", ""); // 70
	AppendItem( ThClassMnst, THING_ST_COMMANDO, "Stealth commando", "Stealth monsters"); // 70
	AppendItem( ThClassMnst, THING_IMP, "Imp", ""); // 60
	AppendItem( ThClassMnst, THING_NIGHTMAREIMP, "Nightmare imp", ""); // 60, Doom 64
	AppendItem( ThClassMnst, THING_ST_IMP, "Stealth imp", "Stealth monsters"); // 60
	AppendItem( ThClassMnst, THING_LOSTSOUL, "Lost soul", ""); // 100
	AppendItem( ThClassMnst, THING_DEMON, "Demon", ""); // 150
	AppendItem( ThClassMnst, THING_ST_DEMON, "Stealth demon", "Stealth monsters"); // 150
	AppendItem( ThClassMnst, THING_SPECTRE, "Spectre", ""); // 150
	AppendItem( ThClassMnst, THING_SPECTRE1PSX, "Spectre \"1\"", "Spectre"); // 150
	AppendItem( ThClassMnst, THING_SPECTRE2PSX, "Spectre \"2\"", "Spectre#Variations"); // 150
	AppendItem( ThClassMnst, THING_SPECTRE3PSX, "Spectre \"3\"", "Spectre#Variations"); // 150
	AppendItem( ThClassMnst, THING_SPECTRENMPSX, "Nightmare spectre", ""); // 300
	AppendItem( ThClassMnst, THING_REVENANT, "Revenant", ""); // 300
	AppendItem( ThClassMnst, THING_ST_REVENANT, "Stealth revenant", "Stealth monsters"); // 300
	AppendItem( ThClassMnst, THING_CACODEMON, "Cacodemon", ""); // 400
	AppendItem( ThClassMnst, THING_CACODEMONSPEC, "Spectral cacodemon", "Cacodemon#PlayStation Doom"); // 400
	AppendItem( ThClassMnst, THING_ST_CACODEMON, "Stealth cacodemon", "Stealth monsters"); // 400
	AppendItem( ThClassMnst, THING_PAINELEM, "Pain elemental", ""); // 400
	AppendItem( ThClassMnst, THING_KNIGHT, "Hell knight", ""); // 500
	AppendItem( ThClassMnst, THING_ST_KNIGHT, "Stealth knight", "Stealth monsters"); // 500
	AppendItem( ThClassMnst, THING_BARON, "Baron of Hell", ""); // 1000
	AppendItem( ThClassMnst, THING_ST_BARON, "Stealth baron", "Stealth monsters"); // 1000
	AppendItem( ThClassMnst, THING_ARACHNO, "Arachnotron", ""); // 500
	AppendItem( ThClassMnst, THING_ST_ARACHNO, "Stealth arachnotron", "Stealth monsters"); // 500
	AppendItem( ThClassMnst, THING_MANCUBUS, "Mancubus", ""); // 600
	AppendItem( ThClassMnst, THING_ST_MANCUBUS, "Stealth mancubus", "Stealth monsters"); // 600
	AppendItem( ThClassMnst, THING_ARCHVILE, "Arch-vile", ""); // 700
	AppendItem( ThClassMnst, THING_ST_ARCHVILE, "Stealth arch-vile", "Stealth monsters"); // 700
	AppendItem( ThClassMnst, THING_SPIDERBOSS, "Spiderdemon", ""); // 3000
	AppendItem( ThClassMnst, THING_CYBERDEMON, "Cyberdemon", ""); // 4000
	AppendItem( ThClassMnst, THING_RESURRECTOR, "Mother demon", ""); // 5000, Doom 64
	AppendItem( ThClassMnst, THING_WOLF3DSS, "Wolfenstein SS", ""); // 50
	AppendItem( ThClassMnst, THING_KEEN, "Commander Keen", ""); // 100
	AppendItem( ThClassMnst, THING_BOSSBRAIN, "Romero's head", ""); // 250
	AppendItem( ThClassMnst, THING_BOSSSHOOT, "Monster spawner", "");
	AppendItem( ThClassMnst, THING_SPAWNSPOT, "Spawn spot", "");
	AppendItem( ThClassMnst, THING_HELPERDOG, "Helper dog", ""); // 500
	AppendItem( ThClassMnst, THING_SCRIPT_MARINE, "Scripted marine", "zdoom:Classes:ScriptedMarine"); // 100
	AppendItem( ThClassMnst, THING_MARINE_FIST, "Fists marine", "zdoom:Classes:MarineFist"); // 100
	AppendItem( ThClassMnst, THING_MARINE_BERSERK, "Berserk marine", "zdoom:Classes:MarineBerserk"); // 100
	AppendItem( ThClassMnst, THING_MARINE_CHNSAW, "Chainsaw marine", "zdoom:Classes:MarineChainsaw"); // 100
	AppendItem( ThClassMnst, THING_MARINE_PISTOL, "Pistol marine", "zdoom:Classes:MarinePistol"); // 100
	AppendItem( ThClassMnst, THING_MARINE_SHOTGUN, "Shotgun marine", "zdoom:Classes:MarineShotgun"); // 100
	AppendItem( ThClassMnst, THING_MARINE_SUPERSG, "Super shotgun marine", "zdoom:Classes:MarineSSG"); // 100
	AppendItem( ThClassMnst, THING_MARINE_CHNGUN, "Chaingun marine", "zdoom:Classes:MarineChaingun"); // 100
	AppendItem( ThClassMnst, THING_MARINE_ROCKET, "Rocket launcher marine", "zdoom:Classes:MarineRocket"); // 100
	AppendItem( ThClassMnst, THING_MARINE_PLASMA, "Plasma gun marine", "zdoom:Classes:MarinePlasma"); // 100
	AppendItem( ThClassMnst, THING_MARINE_RAILGUN, "Railgun marine", "zdoom:Classes:MarineRailgun"); // 100
	AppendItem( ThClassMnst, THING_MARINE_BFG9000, "BFG9000 marine", "zdoom:Classes:MarineBFG"); // 100

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_CHAINSAW, "Chainsaw", "");
	AppendItem( ThClassWeap, THING_SHOTGUN, "Shotgun", "");
	AppendItem( ThClassWeap, THING_COMBATGUN, "Super shotgun", "");
	AppendItem( ThClassWeap, THING_CHAINGUN, "Chaingun", "");
	AppendItem( ThClassWeap, THING_LAUNCHER, "Rocket launcher", "");
	AppendItem( ThClassWeap, THING_PLASMAGUN, "Plasma gun", "");
	AppendItem( ThClassWeap, THING_BFG9000, "BFG9000", "");
	AppendItem( ThClassWeap, THING_64_LASER, "Unmaker", ""); // Doom 64

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_AMMOCLIP, "Clip", "");
	AppendItem( ThClassAmmo, THING_AMMOBOX, "Box of bullets", "");
	AppendItem( ThClassAmmo, THING_SHELLS, "4 shotgun shells", "");
	AppendItem( ThClassAmmo, THING_SHELLBOX, "Box of shotgun shells", "");
	AppendItem( ThClassAmmo, THING_ROCKET, "Rocket", "");
	AppendItem( ThClassAmmo, THING_ROCKETBOX, "Box of rockets", "");
	AppendItem( ThClassAmmo, THING_ENERGYCELL, "Energy cell", "Energy cell (Doom)");
	AppendItem( ThClassAmmo, THING_ENERGYPACK, "Energy cell pack", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_STIMPACK, "Stimpack", "");
	AppendItem( ThClassHlAr, THING_MEDIKIT, "Medikit", "");
	AppendItem( ThClassHlAr, THING_GREENARMOR, "Armor", "");
	AppendItem( ThClassHlAr, THING_BLUEARMOR, "Megaarmor", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_ARMBONUS1, "Armor bonus", "");
	AppendItem( ThClassItem, THING_HLTBONUS1, "Health bonus", "");
	AppendItem( ThClassItem, THING_SOULSPHERE, "Supercharge", "");
	AppendItem( ThClassItem, THING_MEGASPHERE, "Megasphere", "");
	AppendItem( ThClassItem, THING_BACKPACK, "Backpack", "");
	AppendItem( ThClassItem, THING_BERSERK, "Berserk", "");
	AppendItem( ThClassItem, THING_COMPMAP, "Computer area map", "");
	AppendItem( ThClassItem, THING_INVULN, "Invulnerability", "");
	AppendItem( ThClassItem, THING_LITEAMP, "Light amplification visor", "");
	AppendItem( ThClassItem, THING_BLURSPHERE, "Partial invisibility", "");
	AppendItem( ThClassItem, THING_RADSUIT, "Radiation shielding suit", "");
	AppendItem( ThClassItem, THING_ARTIFACT1, "Orange demon key", "Demon Key"); // Doom 64
	AppendItem( ThClassItem, THING_ARTIFACT2, "Cyan demon key", "Demon Key"); // Doom 64
	AppendItem( ThClassItem, THING_ARTIFACT3, "Purple demon key", "Demon Key"); // Doom 64

	/* initialize keys */
	AppendItem( ThClassKeys, THING_BLUECARD, "Blue keycard", NULL);
	AppendItem( ThClassKeys, THING_BLUESKULLKEY, "Blue skull key", NULL);
	AppendItem( ThClassKeys, THING_REDCARD, "Red keycard", NULL);
	AppendItem( ThClassKeys, THING_REDSKULLKEY, "Red skull key", NULL);
	AppendItem( ThClassKeys, THING_YELLOWCARD, "Yellow keycard", NULL);
	AppendItem( ThClassKeys, THING_YELLOWSKULLKEY, "Yellow skull key", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5D, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6D, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7D, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8D, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_BARREL, "Exploding barrel", "Barrel");
	AppendItem( ThClassMisc, THING_64_BARREL, "Barrel", ""); // Doom 64
	AppendItem( ThClassMisc, THING_TEAMBLUE, "Team Blue start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMRED, "Team Red start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGREEN, "Team Green start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGOLD, "Team Gold start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGBLUE, "Blue flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGRED, "Red flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGGREEN, "Green flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGGOLD, "Gold flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGWHITE, "White flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_VOODOODOLL, "Voodoo doll", "");

	/* initialize Doom 64 specials */
	AppendItem( ThClassMisc, THING_64_CAMERA, "Camera", "");
	AppendItem( ThClassMisc, THING_64_PROJECTILESPOT, "Projectile spot", "");
	AppendItem( ThClassMisc, THING_64_TRIGGER, "Trigger", NULL);
	AppendItem( ThClassMisc, THING_64_LASERMARKER, "Laser marker", NULL);
	AppendItem( ThClassMisc, THING_64_TITLECYBERDEMON, "Cyberdemon dummy", NULL);
	AppendItem( ThClassMisc, THING_64_MARINE_RED, "Red marine bot", "Marine (Doom 64)");
	AppendItem( ThClassMisc, THING_64_MARINE_AQUA, "Aqua marine bot", "Marine (Doom 64)");
	AppendItem( ThClassMisc, THING_64_MARINE_GREEN, "Green marine bot", "Marine (Doom 64)");

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_FLAMECAN, "Burning barrel", "Barrel");
	AppendItem( ThClassObst, THING_GREYTREE, "Burnt tree", NULL);
	AppendItem( ThClassObst, THING_CANDELABRA, "Candelabra", NULL);
	AppendItem( ThClassObst, THING_EYEINSYMBOL, "Evil eye", NULL);
	AppendItem( ThClassObst, THING_HEADSKEWER, "Five skulls \"shish kebab\"", NULL);
	AppendItem( ThClassObst, THING_SKULLSINFLAMES, "Floating skull", NULL);
	AppendItem( ThClassObst, THING_LAMP, "Floor lamp", NULL);
	AppendItem( ThClassObst, THING_HANGINGLEG, "Hanging leg", NULL);
	AppendItem( ThClassObst, THING_HANGINGTORSO, "Hanging pair of legs", NULL);
	AppendItem( ThClassObst, THING_HANGINGTORSO4, "Hanging torso, brain removed", NULL);
	AppendItem( ThClassObst, THING_HANGINGLOOKDN, "Hanging torso, looking down", NULL);
	AppendItem( ThClassObst, THING_HANGINGLOOKUP, "Hanging torso, looking up", NULL);
	AppendItem( ThClassObst, THING_HANGINGTORSO3, "Hanging torso, open skull", NULL);
	AppendItem( ThClassObst, THING_HANGINGARMSOUT, "Hanging victim, arms out", NULL);
	AppendItem( ThClassObst, THING_HANGINGNOGUTS2, "Hanging victim, guts and brain removed", NULL);
	AppendItem( ThClassObst, THING_HANGINGNOGUTS, "Hanging victim, guts removed", NULL);
	AppendItem( ThClassObst, THING_HANGINGONELEG, "Hanging victim, one-legged", NULL);
	AppendItem( ThClassObst, THING_HANGINGSWAYING, "Hanging victim, twitching", NULL);
	AppendItem( ThClassObst, THING_IMPALEDBODY, "Impaled human", NULL);
	AppendItem( ThClassObst, THING_BROWNTREE, "Large brown tree", NULL);
	AppendItem( ThClassObst, THING_PILEOFSKULLS, "Pile of skulls and candles", NULL);
	AppendItem( ThClassObst, THING_SBLUETORCH, "Short blue firestick", NULL);
	AppendItem( ThClassObst, THING_SGREENTORCH, "Short green firestick", NULL);
	AppendItem( ThClassObst, THING_SGREENPILLAR, "Short green pillar", NULL);
	AppendItem( ThClassObst, THING_PILLARHEART, "Short green pillar with beating heart", NULL);
	AppendItem( ThClassObst, THING_SREDTORCH, "Short red firestick", NULL);
	AppendItem( ThClassObst, THING_SREDPILLAR, "Short red pillar", NULL);
	AppendItem( ThClassObst, THING_PILLARSKULL, "Short red pillar with skull", NULL);
	AppendItem( ThClassObst, THING_SHORTLAMP, "Short techno floor lamp", NULL);
	AppendItem( ThClassObst, THING_SKULLTOPPOLE, "Skull on a pole", NULL);
	AppendItem( ThClassObst, THING_BROWNSTUB, "Brown stump", NULL);
	AppendItem( ThClassObst, THING_TBLUETORCH, "Tall blue firestick", NULL);
	AppendItem( ThClassObst, THING_TGREENTORCH, "Tall green firestick", NULL);
	AppendItem( ThClassObst, THING_TGREENPILLAR, "Tall green pillar", NULL);
	AppendItem( ThClassObst, THING_TREDTORCH, "Tall red firestick", NULL);
	AppendItem( ThClassObst, THING_TREDPILLAR, "Tall red pillar", NULL);
	AppendItem( ThClassObst, THING_TALLLAMP, "Tall techno floor lamp", NULL);
	AppendItem( ThClassObst, THING_TECHCOLUMN, "Tall techno column", NULL);
	AppendItem( ThClassObst, THING_IMPALEDBODY2, "Twitching impaled human", NULL);

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_BONES, "Bloody mess", NULL);
	AppendItem( ThClassDeco, THING_BONES2, "Bloody mess 2", NULL);
	AppendItem( ThClassDeco, THING_CANDLE, "Candle", NULL);
	AppendItem( ThClassDeco, THING_DEADCACODEMON, "Dead cacodemon", NULL);
	AppendItem( ThClassDeco, THING_DEADDEMON, "Dead demon", NULL);
	AppendItem( ThClassDeco, THING_DEADHUMAN, "Dead former human", NULL);
	AppendItem( ThClassDeco, THING_DEADSERGEANT, "Dead former sergeant", NULL);
	AppendItem( ThClassDeco, THING_DEADIMP, "Dead imp", NULL);
	AppendItem( ThClassDeco, THING_DEADLOSTSOUL, "Dead lost soul (invisible)", NULL);
	AppendItem( ThClassDeco, THING_DEADPLAYER, "Dead player", NULL);
	AppendItem( ThClassDeco, THING_HANGINGLEG2, "Hanging leg", NULL);
	AppendItem( ThClassDeco, THING_HANGINGTORSO2, "Hanging pair of legs", NULL);
	AppendItem( ThClassDeco, THING_HANGINGARMSOUT2, "Hanging victim, arms out", NULL);
	AppendItem( ThClassDeco, THING_HANGINGONELEG2, "Hanging victim, one-legged", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSWAYING2, "Hanging victim, twitching", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBLOOD2, "Pool of blood", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBLOOD3, "Pool of blood", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBLOOD, "Pool of blood and flesh", NULL);
	AppendItem( ThClassDeco, THING_POOLOFBRAINS, "Pool of brains", NULL);

	/* initialize Doom 64 obstacles/decorations */
	AppendItem( ThClassObst, THING_64_TORCHBASELONG, "Long torch base", NULL);
	AppendItem( ThClassObst, THING_64_TORCHBASESHORT, "Short torch base", NULL);
	AppendItem( ThClassObst, THING_64_GIBMEATSTICK, "Gib meat stick", NULL);
	AppendItem( ThClassObst, THING_64_GIBSKULLSTICK, "Gib skull stick", NULL);
	AppendItem( ThClassObst, THING_64_GIBHEADSTICK, "Gib head stick", NULL);
	AppendItem( ThClassObst, THING_64_GIBDOUBLEMEATSTICK, "Gib double meat stick", NULL);
	AppendItem( ThClassObst, THING_64_STATUEDRAGON, "Dragon statue", NULL);
	AppendItem( ThClassObst, THING_64_STATUEDEMON, "Demon statue", NULL);
	AppendItem( ThClassObst, THING_64_TECHPOLELONG, "Tech pole, long", NULL);
	AppendItem( ThClassObst, THING_64_TECHPOLESHORT, "Tech pole, short", NULL);
	AppendItem( ThClassObst, THING_64_TREESTUMPSMALL, "Tree stump, small", NULL);
	AppendItem( ThClassObst, THING_64_TREESTUMPLARGE, "Tree stump, large", NULL);
	AppendItem( ThClassObst, THING_64_TREE, "Tree", NULL);
	AppendItem( ThClassObst, THING_64_BLOODYMETALPOLE, "Bloody metal pole", NULL);

	AppendItem( ThClassDeco, THING_64_BIGFIRE, "Big fire", NULL);
	AppendItem( ThClassDeco, THING_64_LAMPTECHLONGHANG, "Long hanging tech lamp", NULL);
	AppendItem( ThClassDeco, THING_64_LAMPTECHSHORTHANG, "Short hanging tech lamp", NULL);
	AppendItem( ThClassDeco, THING_64_BLUETORCH, "Blue torch", NULL);
	AppendItem( ThClassDeco, THING_64_REDTORCH, "Red torch", NULL);
	AppendItem( ThClassDeco, THING_64_YELLOWTORCH, "Yellow torch", NULL);
	AppendItem( ThClassDeco, THING_64_BLUEFIRE, "Blue fire", NULL);
	AppendItem( ThClassDeco, THING_64_REDFIRE, "Red fire", NULL);
	AppendItem( ThClassDeco, THING_64_YELLOWFIRE, "Yellow fire", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMEATHANG, "Gib meat hang", NULL);
	AppendItem( ThClassDeco, THING_64_GIBTORSOHANG, "Gib torso hang", NULL);
	AppendItem( ThClassDeco, THING_64_GIBRIBFLOOR, "Gib rib floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBTWITCHFLOOR, "Gib twitch floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBBLOODPOOL, "Gib blood pool", NULL);
	AppendItem( ThClassDeco, THING_64_GIBBONEFLOOR, "Gib bone floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMEATRIBFLOOR, "Gib meat rib floor", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMEATRIBCAGE, "Gib meat rib cage", NULL);
	AppendItem( ThClassDeco, THING_64_GIBCHAINHOOK, "Gib chain hook", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHANGCAGE, "Gib hang cage", NULL);
	AppendItem( ThClassDeco, THING_64_GIBCHAINPINCER, "Gib chain pincer", NULL);
	AppendItem( ThClassDeco, THING_64_GIBCHAINARM, "Gib chain arm", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMACEBLOODY, "Gib hang mace bloody", NULL);
	AppendItem( ThClassDeco, THING_64_GIBMACECLEAN, "Gib mace clean", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHANGWHITEMEAT, "Gib hang white meat", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHEADHANG, "Gib head hang", NULL);
	AppendItem( ThClassDeco, THING_64_GIBHANGRIBROTTING, "Gib hang rib rotting", NULL);
}

/*
	initialize Heretic thing classes and items
*/
void InitHereticThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster#Heretic", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Heretic", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Heretic", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Heretic", NULL);
	AppendClass( ThClassItem, "Items", "Item#Heretic", NULL);
	AppendClass( ThClassKeys, "Keys", "Heretic keys", NULL);
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);
	AppendClass( ThClassSnds, "Ambient sounds", "Heretic ambient sound things", NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_GARGOYLE, "Gargoyle", ""); // 50
	AppendItem( ThClassMnst, THING_FRGARGOYLE, "Fire gargoyle", "Gargoyle"); // 80
	AppendItem( ThClassMnst, THING_GOLEM, "Golem", ""); // 80
	AppendItem( ThClassMnst, THING_GOLEMGH, "Golem ghost", "Golem"); // 80
	AppendItem( ThClassMnst, THING_NTGOLEM, "Nitrogolem", "Golem"); // 100
	AppendItem( ThClassMnst, THING_NTGOLEMGH, "Nitrogolem ghost", "Golem"); // 100
	AppendItem( ThClassMnst, THING_SABRECLAW, "Sabreclaw", ""); // 150
	AppendItem( ThClassMnst, THING_DISCIPLE, "Disciple", "Disciple of D'Sparil"); // 180
	AppendItem( ThClassMnst, THING_WARRIOR, "Undead warrior", ""); // 200
	AppendItem( ThClassMnst, THING_WARRIORGH, "Undead warrior ghost", "Undead warrior"); // 200
	AppendItem( ThClassMnst, THING_WEREDRAGON, "Weredragon", ""); // 220
	AppendItem( ThClassMnst, THING_OPHIDIAN, "Ophidian", ""); // 280
	AppendItem( ThClassMnst, THING_IRONLICH, "Iron lich", ""); // 700
	AppendItem( ThClassMnst, THING_MAULOTAUR, "Maulotaur", ""); // 3000
	AppendItem( ThClassMnst, THING_DSPARIL, "D'Sparil", ""); // 5500

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_GAUNTLETS, "Gauntlets of the Necromancer", "");
	AppendItem( ThClassWeap, THING_CROSSBOW, "Ethereal crossbow", "");
	AppendItem( ThClassWeap, THING_DRAGONCLAW, "Dragon claw", "");
	AppendItem( ThClassWeap, THING_HELLSTAFF, "Hellstaff", "");
	AppendItem( ThClassWeap, THING_PHOENIXROD, "Phoenix rod", "");
	AppendItem( ThClassWeap, THING_FIREMACE, "Firemace", "");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_CRYSTAL, "Wand crystal", "");
	AppendItem( ThClassAmmo, THING_CRGEODE, "Crystal geode", "");
	AppendItem( ThClassAmmo, THING_ARROWS, "Ethereal arrows", "");
	AppendItem( ThClassAmmo, THING_ARQUIVER, "Quiver of ethereal arrows", "");
	AppendItem( ThClassAmmo, THING_CLAWORB, "Claw orb", "");
	AppendItem( ThClassAmmo, THING_ENERGYORB, "Energy orb", "");
	AppendItem( ThClassAmmo, THING_RUNESSML, "Lesser runes", "");
	AppendItem( ThClassAmmo, THING_RUNESLRG, "Greater runes", "");
	AppendItem( ThClassAmmo, THING_FLAMEORBSML, "Flame orb", "");
	AppendItem( ThClassAmmo, THING_FLAMEORBLRG, "Inferno orb", "");
	AppendItem( ThClassAmmo, THING_MACESPHSML, "Mace spheres", "");
	AppendItem( ThClassAmmo, THING_MACESPHLRG, "Pile of mace spheres", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_CRYSTALVIAL, "Crystal vial", "");
	AppendItem( ThClassHlAr, THING_ENCHSHIELD, "Enchanted shield", "");
	AppendItem( ThClassHlAr, THING_SILVSHIELD, "Silver shield", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_BAGHOLDING, "Bag of Holding", "");
	AppendItem( ThClassItem, THING_CHAOSDEV, "Chaos Device", "");
	AppendItem( ThClassItem, THING_MAPSCROLL, "Map scroll", "");
	AppendItem( ThClassItem, THING_MORPHOVUM, "Morph Ovum", "");
	AppendItem( ThClassItem, THING_MYSTICURN, "Mystic urn", "");
	AppendItem( ThClassItem, THING_QUARTZFLASK, "Quartz flask", "");
	AppendItem( ThClassItem, THING_RINGINVULN, "Ring of Invincibility", "");
	AppendItem( ThClassItem, THING_SHADOWSPHR, "Shadowsphere", "");
	AppendItem( ThClassItem, THING_TIMEBOMB, "Time Bomb of the Ancients", "");
	AppendItem( ThClassItem, THING_TOMEPOWER, "Tome of Power", "");
	AppendItem( ThClassItem, THING_TORCH, "Torch", "");
	AppendItem( ThClassItem, THING_WINGS, "Wings of Wrath", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_BLUEKEY, "Blue key", NULL);
	AppendItem( ThClassKeys, THING_GREENKEY, "Green key", NULL);
	AppendItem( ThClassKeys, THING_YELLOWKEY, "Yellow key", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5H, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6H, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7H, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8H, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_DSPARILSPOT, "D'Sparil teleport spot", "D'Sparil");
	AppendItem( ThClassMisc, THING_KEYGIZMOBLUE, "Key gizmo (blue)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_KEYGIZMOGREEN, "Key gizmo (green)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_KEYGIZMOYELLOW, "Key gizmo (yellow)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_POD, "Pod", "");
	AppendItem( ThClassMisc, THING_PODGENERATOR, "Pod generator", "Pod");
	AppendItem( ThClassMisc, THING_VOLCANO, "Volcano", "");
	AppendItem( ThClassMisc, THING_TEAMBLUE, "Team Blue start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMRED, "Team Red start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGREEN, "Team Green start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGOLD, "Team Gold start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGBLUE, "Blue flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGRED, "Red flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGGREEN, "Green flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGGOLD, "Gold flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_FLAGWHITE, "White flag spot", "Capture the Flag");
	AppendItem( ThClassMisc, THING_GLITTELEEXIT, "Teleport glitter (blue)", NULL);
	AppendItem( ThClassMisc, THING_GLITTELEPORT, "Teleport glitter (red)", NULL);
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_VOODOODOLL, "Voodoo doll", "");

	/* initialize ambient sounds */
	AppendItem( ThClassSnds, THING_SNDBELSS, "Bells", NULL);
	AppendItem( ThClassSnds, THING_SNDDROPS, "Drops", NULL);
	AppendItem( ThClassSnds, THING_SNDFASTFOOT, "Fast footsteps", NULL);
	AppendItem( ThClassSnds, THING_SNDGROWL, "Growl", NULL);
	AppendItem( ThClassSnds, THING_SNDHEARTBEAT, "Heart beat", NULL);
	AppendItem( ThClassSnds, THING_SNDLAUGHTER, "Laughter", NULL);
	AppendItem( ThClassSnds, THING_SNDMAGIC, "Magic", NULL);
	AppendItem( ThClassSnds, THING_SNDSCREAM, "Scream", NULL);
	AppendItem( ThClassSnds, THING_SNDSLOWFOOT, "Slow footsteps", NULL);
	AppendItem( ThClassSnds, THING_SNDSQUISH, "Squish", NULL);
	AppendItem( ThClassSnds, THING_SNDWATERFALL, "Waterfall", NULL);
	AppendItem( ThClassSnds, THING_SNDWIND, "Wind", NULL);

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_BROWNBARREL, "Barrel", NULL);
	AppendItem( ThClassObst, THING_TBROWNPILLAR, "Tall brown pillar", NULL);
	AppendItem( ThClassObst, THING_SGREYPILLAR, "Short grey pillar", NULL);
	AppendItem( ThClassObst, THING_SERPENTTORCH, "Serpent torch", NULL);
	AppendItem( ThClassObst, THING_FIREBRAZIER, "Fire brazier", NULL);
	AppendItem( ThClassObst, THING_HANGINGCORPSE, "Hanging corpse", NULL);
	AppendItem( ThClassObst, THING_STALACTSMALL, "Small stalactite", NULL);
	AppendItem( ThClassObst, THING_STALACTLARGE, "Large stalactite", NULL);
	AppendItem( ThClassObst, THING_STALAGMSMALL, "Small stalagmite", NULL);
	AppendItem( ThClassObst, THING_STALAGMLARGE, "Large stalagmite", NULL);

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_CHANDELIER, "Chandelier", NULL);
	AppendItem( ThClassDeco, THING_WALLTORCH, "Wall torch", NULL);
	AppendItem( ThClassDeco, THING_MOSS1STR, "Moss 1 string", NULL);
	AppendItem( ThClassDeco, THING_MOSS3STR, "Moss 2 strings", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL4, "Hanging skull (long rope)", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL3, "Hanging skull (medium rope)", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL2, "Hanging skull (short rope)", NULL);
	AppendItem( ThClassDeco, THING_HANGINGSKULL1, "Hanging skull (shortest rope)", NULL);
}

/*
	initialize Hexen thing classes and items
*/
void InitHexenThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster#Hexen", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Hexen", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Hexen", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Hexen", NULL);
	AppendClass( ThClassItem, "Items", "Item#Hexen", NULL);
	AppendClass( ThClassKeys, "Keys & Puzzle items", "Hexen keys",
	                          "[[Hexen keys|Keys]] & [[Item#Puzzle items|Puzzle items]]");
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);
	AppendClass( ThClassSnds, "Ambient sounds", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_AFRIT, "Afrit", ""); // 80
	AppendItem( ThClassMnst, THING_STALKER, "Stalker", ""); // 90
	AppendItem( ThClassMnst, THING_STALKERBOSS, "Stalker boss", "Stalker"); // 90
	AppendItem( ThClassMnst, THING_WENDIGO, "Wendigo", ""); // 120
	AppendItem( ThClassMnst, THING_DARKBISHOP, "Dark bishop", ""); // 130
	AppendItem( ThClassMnst, THING_REIVER, "Reiver", ""); // 150
	AppendItem( ThClassMnst, THING_REIVERBURIED, "Reiver (buried)", "Reiver"); // 150
	AppendItem( ThClassMnst, THING_ETTIN, "Ettin", ""); // 175
	AppendItem( ThClassMnst, THING_CENTAUR, "Centaur", ""); // 200
	AppendItem( ThClassMnst, THING_BROWNCSERP, "Brown chaos serpent", ""); // 250
	AppendItem( ThClassMnst, THING_GREENCSERP, "Green chaos serpent", ""); // 250
	AppendItem( ThClassMnst, THING_SLAUGHTAUR, "Slaughtaur", ""); // 250
	AppendItem( ThClassMnst, THING_DEATHWYVERN, "Death wyvern", ""); // 640
	AppendItem( ThClassMnst, THING_MENELKIR, "Menelkir", ""); // 800
	AppendItem( ThClassMnst, THING_TRADUCTUS, "Traductus", ""); // 800
	AppendItem( ThClassMnst, THING_ZEDEK, "Zedek", ""); // 800
	AppendItem( ThClassMnst, THING_HERESIARCH, "Heresiarch", ""); // 5000
	AppendItem( ThClassMnst, THING_KORAX, "Korax", ""); // 5000

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_TIMONSAXE, "Timon's Axe", "");
	AppendItem( ThClassWeap, THING_HAMMERRETR, "Hammer of Retribution", "");
	AppendItem( ThClassWeap, THING_QUIETUSHILT, "Quietus (hilt)", "Quietus");
	AppendItem( ThClassWeap, THING_QUIETUSCROSS, "Quietus (cross)", "Quietus");
	AppendItem( ThClassWeap, THING_QUIETUSBLADE, "Quietus (blade)", "Quietus");
	AppendItem( ThClassWeap, THING_SERPENTSTAFF, "Serpent staff", "");
	AppendItem( ThClassWeap, THING_FIRESTORM, "Firestorm", "");
	AppendItem( ThClassWeap, THING_WVERGESHAFT, "Wraithverge (shaft)", "Wraithverge");
	AppendItem( ThClassWeap, THING_WVERGECROSS, "Wraithverge (cross)", "Wraithverge");
	AppendItem( ThClassWeap, THING_WVERGEARC, "Wraithverge (arc)", "Wraithverge");
	AppendItem( ThClassWeap, THING_FROSTSHARDS, "Frost shards", "");
	AppendItem( ThClassWeap, THING_ARCDEATH, "Arc of Death", "");
	AppendItem( ThClassWeap, THING_BSCOURGESTICK, "Bloodscourge (stick)", "Bloodscourge");
	AppendItem( ThClassWeap, THING_BSCOURGESTUB, "Bloodscourge (stub)", "Bloodscourge");
	AppendItem( ThClassWeap, THING_BSCOURGESKULL, "Bloodscourge (skull)", "Bloodscourge");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_BLUEMANA, "Blue mana", "");
	AppendItem( ThClassAmmo, THING_GREENMANA, "Green mana", "");
	AppendItem( ThClassAmmo, THING_COMBMANA, "Combined mana", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_CRYSTALVIAL, "Crystal vial", "");
	AppendItem( ThClassHlAr, THING_AMULETWARD, "Amulet of Warding", "");
	AppendItem( ThClassHlAr, THING_FALCONSHIELD, "Falcon shield", "");
	AppendItem( ThClassHlAr, THING_MESHARMOR, "Mesh armor", "");
	AppendItem( ThClassHlAr, THING_PLATINUMHELM, "Platinum helm", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_BANISHDEV, "Banishment Device", "");
	AppendItem( ThClassItem, THING_BOOTSSPEED, "Boots of Speed", "");
	AppendItem( ThClassItem, THING_CHAOSDEV, "Chaos Device", "");
	AppendItem( ThClassItem, THING_DARKSERVANT, "Dark Servant", "");
	AppendItem( ThClassItem, THING_DISCREPULS, "Disc of Repulsion", "");
	AppendItem( ThClassItem, THING_DSKINBRACERS, "Dragonskin bracers", "");
	AppendItem( ThClassItem, THING_FLECHETTE, "Fléchette", "");
	AppendItem( ThClassItem, THING_ICONDEFEND, "Icon of the Defender", "");
	AppendItem( ThClassItem, THING_KRATERMIGHT, "Krater of Might", "");
	AppendItem( ThClassItem, THING_MYSTAMBINC, "Mystic Ambit Incant", "");
	AppendItem( ThClassItem, THING_MYSTICURN, "Mystic urn", "");
	AppendItem( ThClassItem, THING_PORKALATOR, "Porkalator", "");
	AppendItem( ThClassItem, THING_QUARTZFLASK, "Quartz flask", "");
	AppendItem( ThClassItem, THING_TORCH, "Torch", "");
	AppendItem( ThClassItem, THING_WINGS, "Wings of Wrath", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_AXEKEY, "Axe key", NULL);
	AppendItem( ThClassKeys, THING_CASTLEKEY, "Castle key", NULL);
	AppendItem( ThClassKeys, THING_CAVEKEY, "Cave key", NULL);
	AppendItem( ThClassKeys, THING_DUNGEONKEY, "Dungeon key", NULL);
	AppendItem( ThClassKeys, THING_EMERALDKEY, "Emerald key", NULL);
	AppendItem( ThClassKeys, THING_FIREKEY, "Fire key", NULL);
	AppendItem( ThClassKeys, THING_HORNKEY, "Horn key", NULL);
	AppendItem( ThClassKeys, THING_RUSTYKEY, "Rusty key", NULL);
	AppendItem( ThClassKeys, THING_SILVERKEY, "Silver key", NULL);
	AppendItem( ThClassKeys, THING_STEELKEY, "Steel key", NULL);
	AppendItem( ThClassKeys, THING_SWAMPKEY, "Swamp key", NULL);

	/* initialize puzzle items */
	AppendItem( ThClassKeys, THING_FLAMEMASK, "Flame Mask", "Puzzle item#Flame Mask");
	AppendItem( ThClassKeys, THING_HEARTDSPARIL, "Heart of D'Sparil", "Puzzle item#Heart of D'Sparil");
	AppendItem( ThClassKeys, THING_EMERALDPLANET1, "Emerald planet 1", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_EMERALDPLANET2, "Emerald planet 2", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_RUBYPLANET, "Ruby planet", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_SAPPHPLANET1, "Sapphire planet 1", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_SAPPHPLANET2, "Sapphire planet 2", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_CLOCKGBRNZSTL, "Clock gear (bronze in steel)", "Puzzle item#The Clock");
	AppendItem( ThClassKeys, THING_CLOCKGBRONZE, "Clock gear (bronze)", "Puzzle item#The Clock");
	AppendItem( ThClassKeys, THING_CLOCKGSTLBRNZ, "Clock gear (steel in bronze)", "Puzzle item#The Clock");
	AppendItem( ThClassKeys, THING_CLOCKGSTEEL, "Clock gear (steel)", "Puzzle item#The Clock");
	AppendItem( ThClassKeys, THING_DAEMONCODEX, "Daemon Codex", "Puzzle item#The Books");
	AppendItem( ThClassKeys, THING_LIBEROSCURA, "Liber Oscura", "Puzzle item#The Books");
	AppendItem( ThClassKeys, THING_YORICKSSKULL, "Yorick's Skull", "Puzzle item#Yorick's Statue");
	AppendItem( ThClassKeys, THING_GLAIVESEAL, "Glaive Seal", "Puzzle item#Hub 5: Necropolis");
	AppendItem( ThClassKeys, THING_HOLYRELIC, "Holy Relic", "Puzzle item#Hub 5: Necropolis");
	AppendItem( ThClassKeys, THING_SIGILMAGUS, "Sigil of the Magus", "Puzzle item#Hub 5: Necropolis");

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5X, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6X, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7X, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8X, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_BATSPAWNER, "Bat spawner", NULL);
	AppendItem( ThClassMisc, THING_BELL, "Bell", NULL);
	AppendItem( ThClassMisc, THING_DESTRUCTREE, "Destructible tree", NULL);
	AppendItem( ThClassMisc, THING_EVERGRNTREE, "Evergreen tree", NULL);
	AppendItem( ThClassMisc, THING_FOGPATCHLRG, "Fog patch (large)", NULL);
	AppendItem( ThClassMisc, THING_FOGPATCHMED, "Fog patch (medium)", NULL);
	AppendItem( ThClassMisc, THING_FOGPATCHSML, "Fog patch (small)", NULL);
	AppendItem( ThClassMisc, THING_FOGSPAWNER, "Fog spawner", NULL);
	AppendItem( ThClassMisc, THING_GLITTBRIDGE, "Glitter bridge", NULL);
	AppendItem( ThClassMisc, THING_LEAFSPAWNER, "Leaf spawner", NULL);
	AppendItem( ThClassMisc, THING_MUSHROOM, "Mushroom", "");
	AppendItem( ThClassMisc, THING_POTTLL, "Pot (tall)", NULL);
	AppendItem( ThClassMisc, THING_POTMED, "Pot (medium)", NULL);
	AppendItem( ThClassMisc, THING_POTSHT, "Pot (short)", NULL);
	AppendItem( ThClassMisc, THING_SHRUBLRG, "Shrub (large)", NULL);
	AppendItem( ThClassMisc, THING_SHRUBSML, "Shrub (small)", NULL);
	AppendItem( ThClassMisc, THING_SITTINGCORPSE, "Sitting corpse", NULL);
	AppendItem( ThClassMisc, THING_SPIKE_DN, "Spike down", "Spike");
	AppendItem( ThClassMisc, THING_SPIKE_UP, "Spike up", "Spike");
	AppendItem( ThClassMisc, THING_SUITARMOR, "Suit of armor", NULL);
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_TELEPSMOKE, "Teleport smoke", NULL);
	//AppendItem( ThClassMisc, THING_VOODOODOLL, "Voodoo doll", "");

	/* initialize invisible specials */
	AppendItem( ThClassDeco, THING_MAPSPOT, "Map spot", NULL);
	AppendItem( ThClassDeco, THING_MAPSPOTGRAV, "Map spot (gravity)", NULL);
	AppendItem( ThClassDeco, THING_POLYANCHOR, "Polyobject anchor", "Polyobject");
	AppendItem( ThClassDeco, THING_POLYSPAWN, "Polyobject start spot", NULL);
	AppendItem( ThClassDeco, THING_POLYSPAWNCR, "Polyobject start spot (crush)", NULL);

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_WINGEDSTATUE, "Winged statue", NULL);
	AppendItem( ThClassObst, THING_YORICKSTATUE, "Yorick's statue", NULL);
	AppendItem( ThClassObst, THING_PEDDSPARIL, "Pedestal of D'Sparil", NULL);
	AppendItem( ThClassObst, THING_TOMBRIP, "Tombstone (RIP)", NULL);
	AppendItem( ThClassObst, THING_TOMBSHANE, "Tombstone (Shane)", NULL);
	AppendItem( ThClassObst, THING_TOMBSLIMY, "Tombstone (slimy)", NULL);
	AppendItem( ThClassObst, THING_TOMBBRIANR, "Tombstone (Brian R)", NULL);
	AppendItem( ThClassObst, THING_TOMBCRSCIRC, "Tombstone (cross circle)", NULL);
	AppendItem( ThClassObst, THING_TOMBSMCROSS, "Tombstone (small cross)", NULL);
	AppendItem( ThClassObst, THING_TOMBBRIANP, "Tombstone (Brian P)", NULL);
	AppendItem( ThClassObst, THING_IMPALEDCORPSE, "Impaled corpse", NULL);
	AppendItem( ThClassObst, THING_HANGINGCORPSEX, "Hanging corpse", NULL);
	AppendItem( ThClassObst, THING_LYNCHDCORPSE, "Lynched corpse", NULL);
	AppendItem( ThClassObst, THING_LYNCHDCORPSEHL, "Lynched corpse (heartless)", NULL);
	AppendItem( ThClassObst, THING_SITTINGCORPSE, "Sitting corpse", NULL);
	AppendItem( ThClassObst, THING_TWINEDTORCHLIT, "Twined torch (lit)", NULL);
	AppendItem( ThClassObst, THING_TWINEDTORCHULT, "Twined torch (unlit)", NULL);
	AppendItem( ThClassObst, THING_MINOTSTATLIT, "Minotaur statue (lit)", NULL);
	AppendItem( ThClassObst, THING_MINOTSTATULT, "Minotaur statue (unlit)", NULL);
	AppendItem( ThClassObst, THING_SKULLWFLAME, "Skull with flame", NULL);
	AppendItem( ThClassObst, THING_BRAZIERWFLAME, "Brazier with flame", NULL);
	AppendItem( ThClassObst, THING_CAULDRONLIT, "Cauldron (lit)", NULL);
	AppendItem( ThClassObst, THING_CAULDRONULT, "Cauldron (unlit)", NULL);
	AppendItem( ThClassObst, THING_BARRELX, "Barrel", NULL);
	AppendItem( ThClassObst, THING_PILLARWVASE, "Pillar with vase", NULL);
	AppendItem( ThClassObst, THING_BATTLERAGBNNR, "Battle rag banner", NULL);
	AppendItem( ThClassObst, THING_IRONMAIDEN, "Iron maiden", NULL);
	AppendItem( ThClassObst, THING_HANGINGBUCKET, "Hanging bucket", NULL);
	AppendItem( ThClassObst, THING_ICEGARGTLL, "Ice gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_ICEGARGSHT, "Ice gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_STONEGARGTLL, "Stone gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_STONEGARGSHT, "Stone gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_RUSTYGARGTLL, "Rusty gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_DLAVAGARGTLL, "Dark lava gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_DLAVAGARGSHT, "Dark lava gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_LLAVAGARGTLL, "Light lava gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_LLAVAGARGSHT, "Light lava gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_BRONZEGARGTLL, "Bronze gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_BRONZEGARGSHT, "Bronze gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_STEELGARGTLL, "Steel gargoyle (tall)", NULL);
	AppendItem( ThClassObst, THING_STEELGARGSHT, "Steel gargoyle (short)", NULL);
	AppendItem( ThClassObst, THING_DEADTREE, "Dead tree", NULL);
	AppendItem( ThClassObst, THING_LEAFLESSTREE, "Leafless tree", NULL);
	AppendItem( ThClassObst, THING_MOSSYTREE1, "Mossy tree 1", NULL);
	AppendItem( ThClassObst, THING_MOSSYTREE2, "Mossy tree 2", NULL);
	AppendItem( ThClassObst, THING_MOSSYDEADTREE, "Mossy dead tree", NULL);
	AppendItem( ThClassObst, THING_TREESTUMPBRND, "Tree stump (burned)", NULL);
	AppendItem( ThClassObst, THING_TREESTUMPBARE, "Tree stump (bare)", NULL);
	AppendItem( ThClassObst, THING_TREELOG, "Tree log", NULL);
	AppendItem( ThClassObst, THING_TALLTREE1, "Tall tree 1", NULL);
	AppendItem( ThClassObst, THING_TALLTREE2, "Tall tree 2", NULL);
	AppendItem( ThClassObst, THING_GNARLEDTREE1, "Gnarled tree 1", NULL);
	AppendItem( ThClassObst, THING_GNARLEDTREE2, "Gnarled tree 2", NULL);
	AppendItem( ThClassObst, THING_SHRUBSML, "Shrub (small)", NULL);
	AppendItem( ThClassObst, THING_SHRUBLRG, "Shrub (large)", NULL);
	AppendItem( ThClassObst, THING_DESTRUCTREE, "Destructible tree", NULL);
	AppendItem( ThClassObst, THING_EVERGRNTREE, "Evergreen tree", NULL);
	AppendItem( ThClassObst, THING_STALAGMPILLAR, "Stalagmite pillar", NULL);
	AppendItem( ThClassObst, THING_STALAGMLRG, "Stalagmite (large)", NULL);
	AppendItem( ThClassObst, THING_STALAGMMED, "Stalagmite (medium)", NULL);
	AppendItem( ThClassObst, THING_STALAGMSML, "Stalagmite (small)", NULL);
	AppendItem( ThClassObst, THING_STALACTLRG, "Stalactite (large)", NULL);
	AppendItem( ThClassObst, THING_STALACTMED, "Stalactite (medium)", NULL);
	AppendItem( ThClassObst, THING_STALACTSML, "Stalactite (small)", NULL);
	AppendItem( ThClassObst, THING_ICICLELRG, "Icicle (large)", NULL);
	AppendItem( ThClassObst, THING_ICICLEMED, "Icicle (medium)", NULL);
	AppendItem( ThClassObst, THING_ICICLESML, "Icicle (small)", NULL);
	AppendItem( ThClassObst, THING_ICICLETNY, "Icicle (tiny)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKELRG, "Ice spike (large)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKEMED, "Ice spike (medium)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKESML, "Ice spike (small)", NULL);
	AppendItem( ThClassObst, THING_ICESPIKETNY, "Ice spike (tiny)", NULL);
	AppendItem( ThClassObst, THING_BROWNROCKLRG, "Brown rock (large)", NULL);
	AppendItem( ThClassObst, THING_BROWNROCKSML, "Brown rock (small)", NULL);
	AppendItem( ThClassObst, THING_BLACKROCK, "Black rock", NULL);
	AppendItem( ThClassObst, THING_MOSSYROCKLRG, "Mossy rock (large)", NULL);
	AppendItem( ThClassObst, THING_BELL, "Bell", NULL);
	AppendItem( ThClassObst, THING_SUITARMOR, "Suit of armor", NULL);
	AppendItem( ThClassObst, THING_POTTLL, "Pot (tall)", NULL);
	AppendItem( ThClassObst, THING_POTMED, "Pot (medium)", NULL);
	AppendItem( ThClassObst, THING_POTSHT, "Pot (short)", NULL);

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_CHANDELIERLIT, "Chandelier (lit)", NULL);
	AppendItem( ThClassDeco, THING_CHANDELIERULT, "Chandelier (unlit)", NULL);
	AppendItem( ThClassDeco, THING_WALLTORCHLIT, "Wall torch (lit)", NULL);
	AppendItem( ThClassDeco, THING_WALLTORCHULT, "Wall torch (unlit)", NULL);
	AppendItem( ThClassDeco, THING_3CANDLESLIT, "3 Candles (lit)", NULL);
	AppendItem( ThClassDeco, THING_BLUECANDLELIT, "Blue candle (lit)", NULL);
	AppendItem( ThClassDeco, THING_CANDLEWWEBULT, "Candle with web (unlit)", NULL);
	AppendItem( ThClassDeco, THING_GRAYCANDLEULT, "Gray candle (unlit)", NULL);
	AppendItem( ThClassDeco, THING_CANDLEWOWEBULT, "Candle w/o web (unlit)", NULL);
	AppendItem( ThClassDeco, THING_SMLFLAMETMD, "Small flame (timed)", NULL);
	AppendItem( ThClassDeco, THING_SMLFLAME, "Small flame", NULL);
	AppendItem( ThClassDeco, THING_LRGFLAMETMD, "Large flame (timed)", NULL);
	AppendItem( ThClassDeco, THING_LRGFLAME, "Large flame", NULL);
	AppendItem( ThClassDeco, THING_CHAINSHT, "Chain (short)", NULL);
	AppendItem( ThClassDeco, THING_CHAINLONG, "Chain (long)", NULL);
	AppendItem( ThClassDeco, THING_CHAINWLRGHOOK, "Chain with large hook", NULL);
	AppendItem( ThClassDeco, THING_CHAINWSMLHOOK, "Chain with small hook", NULL);
	AppendItem( ThClassDeco, THING_CHAINWSPKBALL, "Chain with spike ball", NULL);
	AppendItem( ThClassDeco, THING_HOOKWHEART, "Hook with heart", NULL);
	AppendItem( ThClassDeco, THING_HOOKWSKULL, "Hook with skull", NULL);
	AppendItem( ThClassDeco, THING_POOLBLOOD, "Pool of blood", NULL);
	AppendItem( ThClassDeco, THING_SLEEPINGCORPSE, "Sleeping corpse", NULL);
	AppendItem( ThClassDeco, THING_WOODENSTEIN, "Wooden beer stein", NULL);
	AppendItem( ThClassDeco, THING_METALSTEIN, "Metal beer stein", NULL);
	AppendItem( ThClassDeco, THING_GOBLETSPILLED, "Goblet (spilled)", NULL);
	AppendItem( ThClassDeco, THING_GOBLETTLL, "Goblet (tall)", NULL);
	AppendItem( ThClassDeco, THING_GOBLETSHT, "Goblet (short)", NULL);
	AppendItem( ThClassDeco, THING_GOBLETSILVER, "Goblet (silver)", NULL);
	AppendItem( ThClassDeco, THING_MEATCLEAVER, "Meat cleaver", NULL);
	AppendItem( ThClassDeco, THING_MOSSYROCKTNY, "Mossy rock (tiny)", NULL);
	AppendItem( ThClassDeco, THING_MOSSYROCKSML, "Mossy rock (small)", NULL);
	AppendItem( ThClassDeco, THING_MOSSYROCKMED, "Mossy rock (medium)", NULL);
	AppendItem( ThClassDeco, THING_TREESTUMP1, "Tree stump 1", NULL);
	AppendItem( ThClassDeco, THING_TREESTUMP2, "Tree stump 2", NULL);
	AppendItem( ThClassDeco, THING_LARGEMUSHROOM1, "Large mushroom 1", NULL);
	AppendItem( ThClassDeco, THING_LARGEMUSHROOM2, "Large mushroom 2", NULL);
	AppendItem( ThClassDeco, THING_MEDIUMMUSHROOM, "Medium mushroom", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM1, "Small mushroom 1", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM2, "Small mushroom 2", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM3, "Small mushroom 3", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM4, "Small mushroom 4", NULL);
	AppendItem( ThClassDeco, THING_SMALLMUSHROOM5, "Small mushroom 5", NULL);
	AppendItem( ThClassDeco, THING_HANGINGMOSS1, "Hanging moss 1", NULL);
	AppendItem( ThClassDeco, THING_HANGINGMOSS2, "Hanging moss 2", NULL);
	AppendItem( ThClassDeco, THING_BRICKRUBBLELRG, "Brick rubble (large)", NULL);
	AppendItem( ThClassDeco, THING_BRICKRUBBLESML, "Brick rubble (small)", NULL);
	AppendItem( ThClassDeco, THING_BRICKRUBBLEMED, "Brick rubble (medium)", NULL);

	/* initialize sounds */
	AppendItem( ThClassSnds, THING_SNDCREAK, "Creak", NULL);
	AppendItem( ThClassSnds, THING_SNDEARTH, "Earth", NULL);
	AppendItem( ThClassSnds, THING_SNDHEAVY, "Heavy", NULL);
	AppendItem( ThClassSnds, THING_SNDICE, "Ice", NULL);
	AppendItem( ThClassSnds, THING_SNDLAVA, "Lava", NULL);
	AppendItem( ThClassSnds, THING_SNDMETAL, "Metal", NULL);
	AppendItem( ThClassSnds, THING_SNDMETAL2, "Metal2", NULL);
	AppendItem( ThClassSnds, THING_SNDSILENCE, "Silence", NULL);
	AppendItem( ThClassSnds, THING_SNDSTONE, "Stone", NULL);
	AppendItem( ThClassSnds, THING_SNDWATER, "Water", NULL);
	AppendItem( ThClassSnds, THING_SNDWINDX, "Wind", NULL);
}

/*
	initialize Strife thing classes and items
*/
void InitStrifeThings( BCINT mission)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Enemies", "Monster#Strife", NULL);
	AppendClass( ThClassChar, "Other characters", ":Category:Strife characters", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Strife", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Strife", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Strife", NULL);
	AppendClass( ThClassItem, "Items", "Item#Strife", NULL);
	AppendClass( ThClassKeys, "Keys & Quest items", "Strife keys",
	                          "[[Strife keys|Keys]] & [[Item#Quest Items|Quest items]]");
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);

	/* initialize enemies w/ hitpoints */
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE8BLUE, "Acolyte (blue)", "Acolyte"); // 60
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE5DGREEN, "Acolyte (dark green)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE6GOLD, "Acolyte (gold)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE4GRAY, "Acolyte (gray)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE7LGREEN, "Acolyte (light green)", "Acolyte"); // 60
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE2RED, "Acolyte (red)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE3RUST, "Acolyte (rust)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE1TAN, "Acolyte (tan)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_SHADOWACOLYTE, "Shadow Acolyte", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_BECOMACOLYTE, "Becoming Acolyte", NULL); // 70
	AppendItem( ThClassMnst, THING_STALKER2, "Stalker", "Stalker (Strife)"); // 80
	AppendItem( ThClassMnst, THING_SENTINEL, "Sentinel", ""); // 100
	AppendItem( ThClassMnst, THING_CEILTURRET, "Ceiling turret", ""); // 125
	AppendItem( ThClassMnst, THING_REAVER, "Reaver", ""); // 150
	AppendItem( ThClassMnst, THING_TEMPLAR, "Templar", ""); // 300
	AppendItem( ThClassMnst, THING_CRUSADER, "Crusader", ""); // 400
	AppendItem( ThClassMnst, THING_BISHOP, "Bishop", ""); // 500
	AppendItem( ThClassMnst, THING_ORACLE, "Oracle", ""); // 1
	AppendItem( ThClassMnst, THING_MACIL1, "Macil", ""); // 95
	AppendItem( ThClassMnst, THING_MACIL2SP, "Macil Spectre", "Macil"); // 95
	AppendItem( ThClassMnst, THING_LOREMASTER, "Loremaster", ""); // 800
	AppendItem( ThClassMnst, THING_INQUISITOR, "Inquisitor", ""); // 1000
	AppendItem( ThClassMnst, THING_PROGRAMMER, "Programmer", ""); // 1100
	AppendItem( ThClassMnst, THING_SPECTREPROGR, "Spectre (Programmer)", "Spectre (Strife)"); // 1000
	AppendItem( ThClassMnst, THING_SPECTREBISHOP, "Spectre (Bishop)", "Spectre (Strife)"); // 1200
	AppendItem( ThClassMnst, THING_SPECTREORACLE, "Spectre (Oracle)", "Spectre (Strife)"); // 1500
	AppendItem( ThClassMnst, THING_SPECTREMACIL, "Spectre (Macil)", "Spectre (Strife)"); // 1700
	AppendItem( ThClassMnst, THING_SPECTRELOREM, "Spectre (Loremaster)", "Spectre (Strife)"); // 2000
	AppendItem( ThClassMnst, THING_ENTITY, "Entity", ""); // 2500
	AppendItem( ThClassMnst, THING_ENTITYNEST, "Entity nest", "Entity"); // 1000
	AppendItem( ThClassMnst, THING_ENTITYPOD, "Entity pod", "Entity"); // 1000

	/* initialize other characters */
	AppendStrife( mission,
	            ThClassChar, THING_ARMORER, "Armorer", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_BARKEEP, "Barkeep", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_MEDIC, "Medic", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_WEAPONSMITH, "Weapon smith", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL1, "Rebel 1", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL2, "Rebel 2", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL3, "Rebel 3", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL4, "Rebel 4", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL5, "Rebel 5", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL6, "Rebel 6", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR1, "Beggar 1", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR2, "Beggar 2", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR3, "Beggar 3", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR4, "Beggar 4", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR5, "Beggar 5", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTBLUE, "Peasant Blue", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTDGRN1, "Peasant Dark Green 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTDGRN2, "Peasant Dark Green 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTDGRN3, "Peasant Dark Green 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGOLD1, "Peasant Gold 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGOLD2, "Peasant Gold 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGOLD3, "Peasant Gold 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGRAY1, "Peasant Gray 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGRAY2, "Peasant Gray 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGRAY3, "Peasant Gray 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTLGRN1, "Peasant Light Green 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTLGRN2, "Peasant Light Green 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTLGRN3, "Peasant Light Green 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRED1, "Peasant Red 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRED2, "Peasant Red 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRED3, "Peasant Red 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRUST1, "Peasant Rust 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRUST2, "Peasant Rust 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRUST3, "Peasant Rust 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTTAN1, "Peasant Tan 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTTAN2, "Peasant Tan 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTTAN3, "Peasant Tan 3", "Peasant");
	AppendItem( ThClassChar, THING_KNEELGUY, "Kneeling Guy", "");
	AppendItem( ThClassChar, THING_ZOMBIE, "Zombie", "Peasant#Related_actors");
	AppendItem( ThClassChar, THING_ZOMBIESPAWN, "Zombie spawner", NULL);

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_CROSSBOW2, "Crossbow", "");
	AppendItem( ThClassWeap, THING_ASSAULTRIFLE, "Assault rifle (lying)", "Assault rifle");
	AppendItem( ThClassWeap, THING_ASSAULTRIFLE2, "Assault rifle (standing)", "Assault rifle");
	AppendItem( ThClassWeap, THING_MINIMSLAUNCH, "Mini-missile launcher", "");
	AppendItem( ThClassWeap, THING_GRENADELAUNCH, "Grenade launcher", "");
	AppendItem( ThClassWeap, THING_FLAMETHROW, "Flamethrower", "");
	AppendItem( ThClassWeap, THING_MAULER, "Mauler", "");
	AppendItem( ThClassWeap, THING_SIGIL1, "Sigil 1 (Lightning)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL2, "Sigil 2 (Rail)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL3, "Sigil 3 (Spread)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL4, "Sigil 4 (Column)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL5, "Sigil 5 (Blast)", "The Sigil of the One God");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_ELECBOLTS, "Electric bolt", "");
	AppendItem( ThClassAmmo, THING_POISBOLTS, "Poison bolt", "");
	AppendItem( ThClassAmmo, THING_BULLETCLIP, "Bullet clip", "");
	AppendItem( ThClassAmmo, THING_BULLETSBOX, "Box of bullets", "Box of bullets (Strife)");
	AppendItem( ThClassAmmo, THING_MISSILES, "Mini-missile", "");
	AppendItem( ThClassAmmo, THING_MISSILECRATE, "Crate of missiles", "");
	AppendItem( ThClassAmmo, THING_GASGRENADE, "Gas grenade", ""); // unused
	AppendItem( ThClassAmmo, THING_HEGRENADE, "HE grenade", "");
	AppendItem( ThClassAmmo, THING_PHOSPHGRENADE, "Phosphorous grenade", "");
	AppendItem( ThClassAmmo, THING_ENERGYPOD, "Energy pod", "");
	AppendItem( ThClassAmmo, THING_ENERGYPACK, "Energy pack", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_MEDPATCH, "Med patch", "");
	AppendItem( ThClassHlAr, THING_MEDICALKIT, "Medical kit", "");
	AppendItem( ThClassHlAr, THING_SURGERYKIT, "Surgery kit", "");
	AppendItem( ThClassHlAr, THING_LEATHERARMOR, "Leather armor", "");
	AppendItem( ThClassHlAr, THING_METALARMOR, "Metal armor", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_AMMOSATCHEL, "Ammo satchel", "");
	AppendItem( ThClassItem, THING_COMMUNICATOR, "Communicator", "");
	AppendItem( ThClassItem, THING_ENVIRONSUIT, "Environmental suit", "");
	AppendItem( ThClassItem, THING_GOLDCOIN, "Gold coin", "Gold");
	AppendItem( ThClassItem, THING_GOLD10, "10 Gold", "Gold");
	AppendItem( ThClassItem, THING_GOLD25, "25 Gold", "Gold");
	AppendItem( ThClassItem, THING_GOLD50, "50 Gold", "Gold");
	AppendItem( ThClassItem, THING_MAPSTRIFE, "Map", "Map (Strife)");
	AppendItem( ThClassItem, THING_SCANNER, "Scanner", "");
	AppendItem( ThClassItem, THING_SHADOWARMOR, "Shadow armor", "");
	AppendItem( ThClassItem, THING_TARGETER, "Targeter", "");
	AppendItem( ThClassItem, THING_TELEPBEACON, "Teleporter beacon", "");
	AppendItem( ThClassItem, THING_REDTALIS, "Red talisman", "Talisman"); // VE
	AppendItem( ThClassItem, THING_GREENTALIS, "Green talisman", "Talisman"); // VE
	AppendItem( ThClassItem, THING_BLUETALIS, "Blue talisman", "Talisman"); // VE

	/* initialize keys */
	AppendItem( ThClassKeys, THING_IDBADGE, "ID badge", NULL);
	AppendItem( ThClassKeys, THING_IDCARD, "ID card", NULL);
	AppendItem( ThClassKeys, THING_BASEKEY, "Base key", NULL);
	AppendItem( ThClassKeys, THING_BLUECRYSKEY, "Blue crystal key", NULL);
	AppendItem( ThClassKeys, THING_BRASSKEY, "Brass key", NULL);
	AppendItem( ThClassKeys, THING_CHAPELKEY, "Chapel key", NULL);
	AppendItem( ThClassKeys, THING_COREKEY, "Core key", NULL);
	AppendItem( ThClassKeys, THING_FACTORYKEY, "Factory key", NULL);
	AppendItem( ThClassKeys, THING_GOLDKEY, "Gold key", NULL);
	AppendItem( ThClassKeys, THING_MAULERKEY, "Mauler key", NULL);
	AppendItem( ThClassKeys, THING_MINEKEY, "Mine key", NULL);
	AppendItem( ThClassKeys, THING_ORACLEKEY, "Oracle key", NULL);
	AppendItem( ThClassKeys, THING_ORDERKEY, "Order key", NULL);
	AppendItem( ThClassKeys, THING_PASSCARD, "Pass card", NULL);
	AppendItem( ThClassKeys, THING_REDCRYSKEY, "Red crystal key", NULL);
	AppendItem( ThClassKeys, THING_SEVEREDHAND, "Severed hand", NULL);
	AppendItem( ThClassKeys, THING_SILVERKEY2, "Silver key", NULL);
	AppendItem( ThClassKeys, THING_WAREHOUSEKEY, "Warehouse key", NULL);

	/* initialize quest items */
	AppendItem( ThClassKeys, THING_BRKNPWRCOUPL, "Broken power coupling", "Strife quest items#Broken power coupling");
	AppendItem( ThClassKeys, THING_POWERCOUPL, "Power coupling", NULL);
	AppendItem( ThClassKeys, THING_DEGNINORE, "Degnin ore", "Strife quest items#Degnin ore");
	AppendItem( ThClassKeys, THING_ORESPAWNER, "Ore spawner", "Strife quest items#Degnin ore"); // VE
	AppendItem( ThClassKeys, THING_FFIELDGUARD, "Force field guard", "Force field");
	AppendItem( ThClassKeys, THING_GATEPISTON, "Gate piston", "Strife technology#Gate control");
	AppendItem( ThClassKeys, THING_OFFICERUNIF, "Officer uniform", "Strife quest items#Officer uniform");
	AppendItem( ThClassKeys, THING_GUARDUNIF, "Guard uniform", "Strife quest items#Guard uniform");
	AppendItem( ThClassKeys, THING_POWERCRYSTAL, "Power crystal", "Strife technology#Power crystal");
	AppendItem( ThClassKeys, THING_OFFERCHALICE1, "Offering chalice", "");
	AppendItem( ThClassKeys, THING_OFFERCHALICE2, "Blue chalice", "Offering chalice#Veteran Edition"); // VE
	AppendItem( ThClassKeys, THING_COMPUTER, "Computer", "Strife technology#Computer");

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5S, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6S, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7S, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8S, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_BARRELSTRIFE, "Exploding barrel", "Barrel (Strife)");
	AppendItem( ThClassMisc, THING_PRACTTARGET, "Practice target", NULL);
	AppendItem( ThClassMisc, THING_RATBUDDY, "Rat buddy", NULL);
	AppendItem( ThClassMisc, THING_TEAMBLUE, "Team Blue start", "Capture the Chalice"); // VE
	AppendItem( ThClassMisc, THING_TEAMRED, "Team Red start", "Capture the Chalice"); // VE
	AppendItem( ThClassMisc, THING_FLAGBLUE, "Blue flag spot", "Capture the Chalice"); // VE
	AppendItem( ThClassMisc, THING_FLAGRED, "Red flag spot", "Capture the Chalice"); // VE
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_TELEPSWIRL, "Teleport swirl", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT1, "Teleport map spot 1", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT2, "Teleport map spot 2", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT3, "Teleport map spot 3", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT4, "Teleport map spot 4", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT5, "Teleport map spot 5", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT6, "Teleport map spot 6", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT7, "Teleport map spot 7", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT8, "Teleport map spot 8", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT9, "Teleport map spot 9", NULL);
	AppendItem( ThClassMisc, THING_TELEMAPSPOT10, "Teleport map spot 10", NULL);
	AppendItem( ThClassMisc, THING_VOODOODOLL, "Voodoo doll", "");
	AppendItem( ThClassMisc, THING_WOODENBARREL, "Wooden barrel", "Barrel (Strife)");

	/* initialize obstacles */
	AppendItem( ThClassObst, THING_TREESTUB, "Tree stub", NULL);
	AppendItem( ThClassObst, THING_SHORTBUSH, "Short bush", NULL);
	AppendItem( ThClassObst, THING_TALLBUSH, "Tall bush", NULL);
	AppendItem( ThClassObst, THING_PALMTREE, "Palm tree", NULL);
	AppendItem( ThClassObst, THING_BIGTREE, "Big tree", NULL);
	AppendItem( ThClassObst, THING_POTTEDTREE, "Potted tree", NULL);
	AppendItem( ThClassObst, THING_CANDELABRA, "Candelabra", NULL);
	AppendItem( ThClassObst, THING_MEDIUMTORCH, "Medium torch", NULL);
	AppendItem( ThClassObst, THING_LARGETORCH, "Large torch", NULL);
	AppendItem( ThClassObst, THING_HUGETORCH, "Huge torch", NULL);
	AppendItem( ThClassObst, THING_OUTSIDELAMP, "Outside lamp", NULL);
	AppendItem( ThClassObst, THING_POLELANTERN, "Pole lantern", NULL);
	AppendItem( ThClassObst, THING_GLOBELIGHT, "Globe light", NULL);
	AppendItem( ThClassObst, THING_SILVERTLAMP, "Silver tech lamp", NULL);
	AppendItem( ThClassObst, THING_BRASSTLAMP, "Brass tech lamp", NULL);
	AppendItem( ThClassObst, THING_ALIENSPLIGHT, "Alien spider light", NULL);
	AppendItem( ThClassObst, THING_CHIMNEYSTACK, "Chimneystack", NULL);
	AppendItem( ThClassObst, THING_BARRCOLUMN, "Barricade column", NULL);
	AppendItem( ThClassObst, THING_TECHPILLAR, "Tech pillar", NULL);
	AppendItem( ThClassObst, THING_AZTECPILLAR, "Aztec pillar", NULL);
	AppendItem( ThClassObst, THING_DAMGDAZPILLAR, "Damaged aztec pillar", NULL);
	AppendItem( ThClassObst, THING_RUINDAZPILLAR, "Ruined aztec pillar", NULL);
	AppendItem( ThClassObst, THING_HUGETCHPILLAR, "Huge tech pillar", NULL);
	AppendItem( ThClassObst, THING_HUGEALNPILLAR, "Huge alien pillar", NULL);
	AppendItem( ThClassObst, THING_ALIENBCOLUMN, "Alien bubble column", NULL);
	AppendItem( ThClassObst, THING_ALIENFLOORB, "Alien floor bubble", NULL);
	AppendItem( ThClassObst, THING_ALIENCEILB, "Alien ceiling bubble", NULL);
	AppendItem( ThClassObst, THING_ALIENASPCL, "Alien asp climber", NULL);
	AppendItem( ThClassObst, THING_STATUE, "Statue", NULL);
	AppendItem( ThClassObst, THING_RUINEDSTAT, "Ruined statue", NULL);
	AppendItem( ThClassObst, THING_POT, "Pot", NULL);
	AppendItem( ThClassObst, THING_PITCHER, "Pitcher", NULL);
	AppendItem( ThClassObst, THING_STOOL, "Stool", NULL);
	AppendItem( ThClassObst, THING_ANVIL, "Anvil", NULL);
	AppendItem( ThClassObst, THING_TRAY, "Tray", NULL);
	AppendItem( ThClassObst, THING_AMMOFILLER, "Ammo filler", NULL);
	AppendItem( ThClassObst, THING_BURNINGBARREL, "Burning barrel", "Barrel (Strife)");
	AppendItem( ThClassObst, THING_BURNINGBOWL, "Burning bowl", NULL);
	AppendItem( ThClassObst, THING_BURNINGBRAZR, "Burning brazier", NULL);
	AppendItem( ThClassObst, THING_HEARTSINTANK, "Hearts in tank", NULL);
	AppendItem( ThClassObst, THING_SURGERYCRAB, "Surgery crab", NULL);
	AppendItem( ThClassObst, THING_HUGETANK1, "Huge tank 1 with skeleton", NULL);
	AppendItem( ThClassObst, THING_HUGETANK2, "Huge tank 2", NULL);
	AppendItem( ThClassObst, THING_HUGETANK3, "Huge tank 3", NULL);
	AppendItem( ThClassObst, THING_TANK4, "Tank 4 spine with organs", NULL);
	AppendItem( ThClassObst, THING_TANK5, "Tank 5 stumpy the acolyte", NULL);
	AppendItem( ThClassObst, THING_TANK6, "Tank 6 spectre", NULL);
	AppendItem( ThClassObst, THING_CAVEPLRTOP, "Cave pillar top", NULL);
	AppendItem( ThClassObst, THING_CAVEPLRBOT, "Cave pillar bottom", NULL);
	AppendItem( ThClassObst, THING_STALACTLRGS, "Stalactite (large)", NULL);
	AppendItem( ThClassObst, THING_STALAGMLRGS, "Stalagmite (large)", NULL);
	AppendItem( ThClassObst, THING_STALACTSMLS, "Stalactite (small)", NULL);
	AppendItem( ThClassObst, THING_STALAGMSMLS, "Stalagmite (small)", NULL);

	/* initialize decorations */
	AppendItem( ThClassDeco, THING_DEADPLAYER, "Dead player (disappears)", NULL);
	AppendItem( ThClassDeco, THING_DEADPEASANT, "Dead peasant (disappears)", NULL);
	AppendItem( ThClassDeco, THING_DEADREBEL, "Dead rebel", NULL);
	AppendItem( ThClassDeco, THING_DEADREAVER, "Dead reaver", NULL);
	AppendItem( ThClassDeco, THING_DEADACOLYTE, "Dead acolyte (disappears)", NULL);
	AppendItem( ThClassDeco, THING_DEADCRUSADER, "Dead crusader", NULL);
	AppendItem( ThClassDeco, THING_KLAXONWLIGHT, "Klaxon warning light", NULL);
	AppendItem( ThClassDeco, THING_CAGELIGHT, "Cage light", NULL);
	AppendItem( ThClassDeco, THING_CANDLE, "Candle", NULL);
	AppendItem( ThClassDeco, THING_SMLBURNTORCH, "Small torch (lit)", NULL);
	AppendItem( ThClassDeco, THING_SMLUNLITTORCH, "Small torch (unlit)", NULL);
	AppendItem( ThClassDeco, THING_SILVRFLUORLIT, "Silver fluorescent light", NULL);
	AppendItem( ThClassDeco, THING_BRASSFLUORLIT, "Brass fluorescent light", NULL);
	AppendItem( ThClassDeco, THING_GOLDFLUORLIT, "Gold fluorescent light", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE1, "Rubble 1", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE2, "Rubble 2", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE3, "Rubble 3", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE4, "Rubble 4", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE5, "Rubble 5", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE6, "Rubble 6", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE7, "Rubble 7", NULL);
	AppendItem( ThClassDeco, THING_RUBBLE8, "Rubble 8", NULL);
	AppendItem( ThClassDeco, THING_ROCK1, "Rock 1", NULL);
	AppendItem( ThClassDeco, THING_ROCK2, "Rock 2", NULL);
	AppendItem( ThClassDeco, THING_ROCK3, "Rock 3", NULL);
	AppendItem( ThClassDeco, THING_ROCK4, "Rock 4", NULL);
	AppendItem( ThClassDeco, THING_CEILWTRDRIP, "Ceiling water drip", NULL);
	AppendItem( ThClassDeco, THING_FLOORWTRDRIP, "Floor water drip", NULL);
	AppendItem( ThClassDeco, THING_WATERFSPLASH, "Waterfall splash", NULL);
	AppendItem( ThClassDeco, THING_WATERFOUNTAIN, "Water fountain", NULL);
	AppendItem( ThClassDeco, THING_STICKINWATER, "Stick in water", NULL);
	AppendItem( ThClassDeco, THING_MUG, "Mug", NULL);
	AppendItem( ThClassDeco, THING_METALPOT, "Metal pot", NULL);
	AppendItem( ThClassDeco, THING_TUB, "Tub", NULL);
	AppendItem( ThClassDeco, THING_WATERBOTTLE, "Water bottle", NULL);
	AppendItem( ThClassDeco, THING_REBELBOOTS, "Rebel boots", NULL);
	AppendItem( ThClassDeco, THING_REBELHELMET, "Rebel helmet", NULL);
	AppendItem( ThClassDeco, THING_REBELSHIRT, "Rebel shirt", NULL);
	AppendItem( ThClassDeco, THING_CEILINGCHAIN, "Ceiling chain", NULL);
	AppendItem( ThClassDeco, THING_SACRIFGUY, "Sacrificed guy", NULL);
	AppendItem( ThClassDeco, THING_SIGILBANNER, "Sigil banner", NULL);
}


/*
	analyze thing statistics
*/
void AnalyzeThings( BCINT lumpver, Bool noskill)
{
	int n, m, item;
	BCINT when;
	Bool flagless, first;

	/* collect all level's things */
	for (n = 0; n < NumThings; n++)
	{
		/* find item for this thing */
		first = TRUE;
		item = -1;
		for (m = 0; m < NumThItems; m++)
			if (Things[n].type == ThItems[m]->type)
			{
				/* kludge for Doom 64 to match THING_64_LASER / THING_64_TRIGGER instead */
				if (first && (lumpver & 0x80) == 0x80 &&
				    (Things[n].type == THING_WOLF3DSS || Things[n].type == THING_BOSSSHOOT))
				{
					first = FALSE;
					continue;
				}
				/* kludge to not collect stray type 0 thing outside Doom 64 */
				if ((lumpver & 0x80) != 0x80 && Things[n].type == THING_64_CAMERA)
					continue;
				item = m;
				break;
			}

		/* check whether this thing shows up */
		when = Things[n].when;
		flagless = FlaglessThing( Things[n].type);
		/* check for special Doom 64 flags */
		/*if ((lumpver & 0x80) == 0x80 && (when & 0x1C00) != 0)
			printf( "Note: Thing %d (type %d%s) has special Doom 64 flags: %X\n", n,
			        Things[n].type, (when & TF_NOTSP) != 0 ? ", MP" : "", (when & 0x1C00));*/
		if (noskill && Things[n].type != THING_BUILDCAM)
		{
			first = FALSE;
			if (UDMFmap)
			{
				for (m = 0; m < MAX_UDMF; m++)
					if (Things[n].skill[m])
					{
						first = TRUE;
						break;
					}
			}
			else
			{
				first = (when & (TF_SEASY | TF_SMEDM | TF_SHARD));
			}
			if (!first)
			{
				/* use name for this thing if available */
				if (item == -1)
					printf( "Note: Thing %d (type %d%s) has no skill flags\n", n,
					        Things[n].type, (when & TF_NOTSP) != 0 ? ", MP" : "");
				else
					printf( "Note: Thing %d (%s, type %d%s) has no skill flags\n", n,
					        ThItems[item]->wikiname,
					        Things[n].type, (when & TF_NOTSP) != 0 ? ", MP" : "");
				if (!flagless)
					continue;
			}
		}

		/* not keeping stats on this thing */
		if (item == -1)
			continue;

		/* check thing flags */
		if (UDMFmap)
		{
			// single-player
			if ((when & TF_HXNSP) != 0)
				for (m = 0; m < MAX_UDMF; m++)
					if (Things[n].skill[m] || flagless)
						ThItems[item]->skill[m][ThModeSP]++;

			// cooperative
			if ((when & TF_HXNCP) != 0)
				for (m = 0; m < MAX_UDMF; m++)
					if (Things[n].skill[m] || flagless)
						ThItems[item]->skill[m][ThModeCP]++;

			// deathmatch
			if ((when & TF_HXNDM) != 0)
				for (m = 0; m < MAX_UDMF; m++)
					if (Things[n].skill[m] || flagless)
						ThItems[item]->skill[m][ThModeDM]++;

			if ((GameVersion & 0x40) == 0x40) // Hexen games
			{
				// Cleric class
				if ((when & TF_HCLRC) != 0)
				{
					for (m = 0; m < MAX_UDMF; m++)
						if (Things[n].skill[m] || flagless)
							ThItems[item]->skill[m][ThModeXC]++;
				}
				// Fighter class
				if ((when & TF_HFGHT) != 0)
				{
					for (m = 0; m < MAX_UDMF; m++)
						if (Things[n].skill[m] || flagless)
							ThItems[item]->skill[m][ThModeXF]++;
				}
				// Mage class
				if ((when & TF_HMAGE) != 0)
				{
					for (m = 0; m < MAX_UDMF; m++)
						if (Things[n].skill[m] || flagless)
							ThItems[item]->skill[m][ThModeXM]++;
				}
			}
		}

		else if ((lumpver & 0x40) == 0x40) // Hexen format
		{
			// single-player
			if ((when & TF_HXNSP) != 0 || flagless)
			{
				// all classes
				if ((when & TF_SEASY) != 0 || flagless)
					ThItems[item]->skill[1][ThModeSP]++;
				if ((when & TF_SMEDM) != 0 || flagless)
					ThItems[item]->skill[2][ThModeSP]++;
				if ((when & TF_SHARD) != 0 || flagless)
					ThItems[item]->skill[3][ThModeSP]++;

				if ((GameVersion & 0x40) == 0x40) // Hexen games
				{
					/* check whether this thing shows up for any class */
					if (noskill &&
					    (when & TF_HCLRC) == 0 && (when & TF_HFGHT) == 0 && (when & TF_HMAGE) == 0)
					{
						if (item == -1)
							printf( "Note: Thing %d (type %d) has no class flags\n", n,
							        Things[n].type);
						else
							printf( "Note: Thing %d (%s, type %d) has no class flags\n", n,
							        ThItems[item]->wikiname, Things[n].type);
					}

					// Cleric class
					if ((when & TF_HCLRC) != 0)
					{
						if ((when & TF_SEASY) != 0 || flagless)
							ThItems[item]->skill[1][ThModeXC]++;
						if ((when & TF_SMEDM) != 0 || flagless)
							ThItems[item]->skill[2][ThModeXC]++;
						if ((when & TF_SHARD) != 0 || flagless)
							ThItems[item]->skill[3][ThModeXC]++;
					}
					// Fighter class
					if ((when & TF_HFGHT) != 0)
					{
						if ((when & TF_SEASY) != 0 || flagless)
							ThItems[item]->skill[1][ThModeXF]++;
						if ((when & TF_SMEDM) != 0 || flagless)
							ThItems[item]->skill[2][ThModeXF]++;
						if ((when & TF_SHARD) != 0 || flagless)
							ThItems[item]->skill[3][ThModeXF]++;
					}
					// Mage class
					if ((when & TF_HMAGE) != 0)
					{
						if ((when & TF_SEASY) != 0 || flagless)
							ThItems[item]->skill[1][ThModeXM]++;
						if ((when & TF_SMEDM) != 0 || flagless)
							ThItems[item]->skill[2][ThModeXM]++;
						if ((when & TF_SHARD) != 0 || flagless)
							ThItems[item]->skill[3][ThModeXM]++;
					}
				}
			}

			// cooperative
			if ((when & TF_HXNCP) != 0 || flagless)
			{
				if ((when & TF_SEASY) != 0 || flagless)
					ThItems[item]->skill[1][ThModeCP]++;
				if ((when & TF_SMEDM) != 0 || flagless)
					ThItems[item]->skill[2][ThModeCP]++;
				if ((when & TF_SHARD) != 0 || flagless)
					ThItems[item]->skill[3][ThModeCP]++;
			}
			// deathmatch
			if ((when & TF_HXNDM) != 0 || flagless)
			{
				if ((when & TF_SEASY) != 0 || flagless)
					ThItems[item]->skill[1][ThModeDM]++;
				if ((when & TF_SMEDM) != 0 || flagless)
					ThItems[item]->skill[2][ThModeDM]++;
				if ((when & TF_SHARD) != 0 || flagless)
					ThItems[item]->skill[3][ThModeDM]++;
			}
		}

		else // Doom format
		{
			// single-player
			if ((when & TF_NOTSP) == 0 || flagless)
			{
				if ((when & TF_SEASY) != 0 || flagless)
					ThItems[item]->skill[1][ThModeSP]++;
				if ((when & TF_SMEDM) != 0 || flagless)
					ThItems[item]->skill[2][ThModeSP]++;
				if ((when & TF_SHARD) != 0 || flagless)
					ThItems[item]->skill[3][ThModeSP]++;
			}
			// classic multi-player
				if ((when & TF_SEASY) != 0 || flagless)
					ThItems[item]->skill[1][ThModeMP]++;
				if ((when & TF_SMEDM) != 0 || flagless)
					ThItems[item]->skill[2][ThModeMP]++;
				if ((when & TF_SHARD) != 0 || flagless)
					ThItems[item]->skill[3][ThModeMP]++;

			// Boom multiplayer
			if ((GameVersion & 0xF0) < 0x20)
			{
				// cooperative
				if ((when & TF_NCOOP) == 0 || flagless)
				{
					if ((when & TF_SEASY) != 0 || flagless)
						ThItems[item]->skill[1][ThModeCP]++;
					if ((when & TF_SMEDM) != 0 || flagless)
						ThItems[item]->skill[2][ThModeCP]++;
					if ((when & TF_SHARD) != 0 || flagless)
						ThItems[item]->skill[3][ThModeCP]++;
				}
				// deathmatch
				if ((when & TF_NOTDM) == 0 || flagless)
				{
					if ((when & TF_SEASY) != 0 || flagless)
						ThItems[item]->skill[1][ThModeDM]++;
					if ((when & TF_SMEDM) != 0 || flagless)
						ThItems[item]->skill[2][ThModeDM]++;
					if ((when & TF_SHARD) != 0 || flagless)
						ThItems[item]->skill[3][ThModeDM]++;
				}
			}
		}

		/* sync up edge skills for classic formats */
		if (!UDMFmap)
			for (m = 0; m < ThMode_End; m++)
			{
				ThItems[item]->skill[0][m] = ThItems[item]->skill[1][m];
				ThItems[item]->skill[4][m] = ThItems[item]->skill[3][m];
			}

/*
		if (Things[n].type >= 1 && Things[n].type <= 8)
		//if (Things[n].type == 7 || Things[n].type == 5)
		{
			printf("thing %d type %d flagless %d\n", n, Things[n].type, flagless);
			for (m = 0; m < ThMode_End; m++)
				printf("%d: %d %d %d\n", m,
				       ThItems[item]->skill[1][m], ThItems[item]->skill[2][m], ThItems[item]->skill[3][m]);
		}
*/
	}
	//DumpThings( (GameVersion & 0x40) == 0x40 ? ThModeCP : ThModeSP);
}

/*
	forget the things data
*/
void ForgetThings( void)
{
	int n;

	for (n = 0; n < NumThClasses; n++)
		if (ThClasses[n] != NULL)
		{
			FreeMemory( ThClasses[n]->wikiname);
			if (ThClasses[n]->wikilink != NULL)
				FreeMemory( ThClasses[n]->wikilink);
			FreeMemory( ThClasses[n]->wikistr);
			FreeMemory( ThClasses[n]);
		}

	FreeMemory( ThClasses);
	ThClasses = NULL;
	NumThClasses = 0;

	for (n = 0; n < NumThItems; n++)
		if (ThItems[n] != NULL)
		{
			FreeMemory( ThItems[n]->wikiname);
			if (ThItems[n]->wikilink != NULL)
				FreeMemory( ThItems[n]->wikilink);
			FreeMemory( ThItems[n]->wikistr);
			FreeMemory( ThItems[n]);
		}

	FreeMemory( ThItems);
	ThItems = NULL;
	NumThItems = 0;

	FreeMemory( UsedLinks);
	UsedLinks = NULL;
	NumUsedLinks = 0;
}

/*
	dump the things data for the given mode
*/
void DumpThings( UBCINT mode)
{
	int c, i;

	for (c = 0; c < NumThClasses; c++)
	{
		printf( "%3d:         %28s %-58.58s (%d)\n", ThClasses[c]->class,
		        ThClasses[c]->wikiname, ThClasses[c]->wikistr, ThClasses[c]->class);
		for (i = 0; i < NumThItems; i++)
			if (ThClasses[c]->class == ThItems[i]->class)
				printf( "%3d: %d %5d %28s %-66.66s %3d %3d %3d\n", i,
				        ThItems[i]->class, ThItems[i]->type, ThItems[i]->wikiname, ThItems[i]->wikistr,
				        ThItems[i]->skill[1][mode], ThItems[i]->skill[2][mode], ThItems[i]->skill[3][mode]);
	}
	printf( "\n");
}


#define PlayerEnd 8

/*
	perform aggregation of special things
*/
void AggregateSpecials( void)
{
	int i, j, m, n, p;
	int players[PlayerEnd];
	Bool found;

	/* init player things to aggregate */
	memset(players, 0, sizeof(players));
	players[0] = THING_PLAYER1;
	players[1] = THING_PLAYER2;
	players[2] = THING_PLAYER3;
	players[3] = THING_PLAYER4;
	switch (GameVersion & 0xF0)
	{
		case 0x00: // Doom
			players[4] = THING_PLAYER5D;
			players[5] = THING_PLAYER6D;
			players[6] = THING_PLAYER7D;
			players[7] = THING_PLAYER8D;
			break;
		case 0x10: // Heretic
			players[4] = THING_PLAYER5H;
			players[5] = THING_PLAYER6H;
			players[6] = THING_PLAYER7H;
			players[7] = THING_PLAYER8H;
			break;
		case 0x20: // Strife
			players[4] = THING_PLAYER5S;
			players[5] = THING_PLAYER6S;
			players[6] = THING_PLAYER7S;
			players[7] = THING_PLAYER8S;
			break;
		case 0x40: // Hexen
			players[4] = THING_PLAYER5X;
			players[5] = THING_PLAYER6X;
			players[6] = THING_PLAYER7X;
			players[7] = THING_PLAYER8X;
			break;
		case 0x80: // Doom64
			players[4] = -1; // prevent match with THING_64_CAMERA (0)
			players[5] = -1;
			players[6] = -1;
			players[7] = -1;
			break;
	}

	/* find coop starts item */
	j = -1;
	for (i = 0; i < NumThItems; i++)
		if (ThItems[i]->type == THING_COOPSTARTS)
		{
			j = i;
			break;
		}
	/* count distinct player starts as coop */
	if (j != -1)
	{
		for (i = 0; i < NumThItems; i++)
			for (p = 0; p < PlayerEnd; p++)
				if (players[p] == ThItems[i]->type)
					for (m = 0; m < ThMode_End; m++)
						for (n = 0; n < MAX_UDMF; n++)
							ThItems[j]->skill[n][m] += (ThItems[i]->skill[n][m] > 0 ? 1 : 0);

		/* clear coop starts if just one */
		for (m = 0; m < ThMode_End; m++)
		{
			for (n = 0; n < (UDMFall ? MAX_UDMF : 5); n++)
				if (ThItems[j]->skill[n][m] > 1)
					break;
			if (n == (UDMFall ? MAX_UDMF : 5))
				ResetThingSkills( ThItems[j], m);
		}
	}

	/* find voodoo dolls item */
	j = -1;
	for (i = 0; i < NumThItems; i++)
		if (ThItems[i]->type == THING_VOODOODOLL)
		{
			j = i;
			break;
		}
	/* count duplicate+ player starts as dolls */
	if (j != -1)
	{
		for (i = 0; i < NumThItems; i++)
			for (p = 0; p < PlayerEnd; p++)
				if (players[p] == ThItems[i]->type)
					for (m = 0; m < ThMode_End; m++)
						for (n = 0; n < MAX_UDMF; n++)
							ThItems[j]->skill[n][m] += (ThItems[i]->skill[n][m] > 0 ? ThItems[i]->skill[n][m]-1 : 0);
	}

	/* clear player things */
	for (i = 0; i < NumThItems; i++)
		for (p = 0; p < PlayerEnd; p++)
			if (players[p] == ThItems[i]->type)
				for (m = 0; m < ThMode_End; m++)
					ResetThingSkills( ThItems[i], m);
}

/*
	check whether to list this thing in this mode
*/
Bool ThingInMode( UBCINT type, int mode)
{
	/* DM & Team starts only in MP & DM modes */
	if (type == THING_DEATHMATCH ||
	    type == THING_TEAMBLUE  || type == THING_TEAMRED ||
	    type == THING_TEAMGREEN || type == THING_TEAMGOLD)
	{
		if (mode == ThModeMP || mode == ThModeDM)
			return TRUE;
		else
			return FALSE;
	}

	/* Coop starts only in MP & Coop modes, unless excluding SP/Coop */
	if (type == THING_COOPSTARTS)
	{
		if (!WXcludeSCP && (mode == ThModeMP || mode == ThModeCP))
			return TRUE;
		else
			return FALSE;
	}

	/* Voodoo dolls not in DM */
	if (type == THING_VOODOODOLL)
	{
		if (mode != ThModeDM)
			return TRUE;
		else
			return FALSE;
	}

	return TRUE;
}

/*
	check whether thing exists independent of mode & skill flags
*/
Bool FlaglessThing( BCINT type)
{
	switch (type)
	{
		// All
		case THING_PLAYER1:
		case THING_PLAYER2:
		case THING_PLAYER3:
		case THING_PLAYER4:
		case THING_DEATHMATCH:
		case THING_FLAGBLUE:
		case THING_FLAGRED:
		case THING_FLAGGREEN:
		case THING_FLAGGOLD:
		case THING_FLAGWHITE:
			return TRUE;
	}

	switch (type)
	{
		// Doom
		case THING_PLAYER5D:
		case THING_PLAYER6D:
		case THING_PLAYER7D:
		case THING_PLAYER8D:
		// Heretic, duplicate values
		//case THING_PLAYER5H:
		//case THING_PLAYER6H:
		//case THING_PLAYER7H:
		//case THING_PLAYER8H:
			if ((GameVersion & 0xF0) <= 0x10)
				return TRUE;
			break;

		// Heretic
		case THING_DSPARILSPOT:
		case THING_SNDBELSS:
		case THING_SNDDROPS:
		case THING_SNDFASTFOOT:
		case THING_SNDGROWL:
		case THING_SNDHEARTBEAT:
		case THING_SNDLAUGHTER:
		case THING_SNDMAGIC:
		case THING_SNDSCREAM:
		case THING_SNDSLOWFOOT:
		case THING_SNDSQUISH:
			if ((GameVersion & 0xF0) == 0x10)
				return TRUE;
			break;

		// Hexen
		case THING_PLAYER5X:
		case THING_PLAYER6X:
		case THING_PLAYER7X:
		case THING_PLAYER8X:
		// Hexen
		case THING_SNDCREAK:
		case THING_SNDEARTH:
		case THING_SNDHEAVY:
		case THING_SNDICE:
		case THING_SNDLAVA:
		case THING_SNDMETAL:
		case THING_SNDMETAL2:
		case THING_SNDSILENCE:
		case THING_SNDSTONE:
		case THING_SNDWATER:
			if ((GameVersion & 0xF0) == 0x40)
				return TRUE;
			break;

		// Strife
		case THING_PLAYER5S:
		case THING_PLAYER6S:
		case THING_PLAYER7S:
		case THING_PLAYER8S:
		// Strife
		case THING_TELEMAPSPOT1:
		case THING_TELEMAPSPOT2:
		case THING_TELEMAPSPOT3:
		case THING_TELEMAPSPOT4:
		case THING_TELEMAPSPOT5:
		case THING_TELEMAPSPOT6:
		case THING_TELEMAPSPOT7:
		case THING_TELEMAPSPOT8:
		case THING_TELEMAPSPOT9:
		case THING_TELEMAPSPOT10:
		// Strife: VE
		case THING_TEAMBLUE:
		case THING_TEAMRED:
			if ((GameVersion & 0xF0) == 0x20)
				return TRUE;
			break;
	}

	return FALSE;
}

/*
	check all things for Boom multiplayer flags
*/
Bool CheckThingBoomFlags( void)
{
	int n;

	/* check in Doom/Heretic for Boom flags */
	if ((GameVersion & 0xF0) < 0x20)
		for (n = 0; n < NumThings; n++)
			if ((Things[n].when & (TF_NOTDM | TF_NCOOP)) != 0)
				return TRUE;

	return FALSE;
}

/*
	check all things for specified type in this mode
*/
Bool CheckThingTypes( int type, int mode)
{
	int n, m;

	for (n = 0; n < NumThItems; n++)
		if (ThItems[n]->type == type)
		{
			for (m = 0; m < (UDMFall ? MAX_UDMF : 5); m++)
				if (ThItems[n]->skill[m][mode] > 0)
					return TRUE;
			break;
		}

	return FALSE;
}

/*
	check whether tallied things occur in high UDMF skills, unless excluded
*/
void CheckUDMFall( void)
{
	int n, i;

	if (UDMFmap && !WXcludeU68)
		for (n = 0; n < NumThings; n++)
			if (Things[n].skill[MAX_UDMF-1] || Things[n].skill[MAX_UDMF-2] ||
			    Things[n].skill[MAX_UDMF-3])
				for (i = 0; i < NumThItems; i++)
					if (Things[n].type == ThItems[i]->type && ThItems[i]->class <= ThClassSnds &&
					    !FlaglessThing(Things[n].type) && Things[n].type != THING_TELEPORT)
					{
						//printf("thing %d type %d\n", n, Things[n].type);
						UDMFall = TRUE;
						return;
					}
}

/*
	count specified things
*/
int CountThings( BCINT type)
{
	int n, things = 0;

	for (n = 0; n < NumThings; n++)
		if (Things[n].type == type)
			things++;

	return things;
}

/*
	count Doom 64 / UDMF secret things
*/
int CountSecretThings( void)
{
	int n, things = 0;

	for (n = 0; n < NumThings; n++)
		if ((UDMFmap && Things[n].secret) ||
		    (!UDMFmap && (Things[n].when & TF_D64SEC) != 0))
			things++;

	return things;
}

/*
	sum thing skill counts of this mode
*/
int TotalThingSkills( ThItem *tptr, int mode)
{
	int n, sum = 0;

	for (n = 0; n < MAX_UDMF; n++)
		sum += tptr->skill[n][mode];

	return sum;
}

/*
	reset thing skill counts for this mode
*/
void ResetThingSkills( ThItem *tptr, int mode)
{
	int n;

	for (n = 0; n < MAX_UDMF; n++)
		tptr->skill[n][mode] = 0;
}


/*
	use (linked) wiki string for the first wiki link, and then wiki name
*/
char *UsedWiki( char *wikiname, char *wikilink, char *wikistr)
{
	Bool found = FALSE;
	int i;

	/* if no link, always use plain name */
	if (wikilink == NULL)
		found = TRUE;
	else
		/* find possibly used wiki link or name */
		for (i = 0; i < NumUsedLinks; i++)
			if (strcmp( (strcmp( wikilink, "") != 0 ? wikilink : wikiname),
			            UsedLinks[i]) == 0)
			{
				found = TRUE;
				break;
			}

	/* if wiki string already used, return name */
	if (found)
		return wikiname;
	else
	{
		/* append wiki string to global array */
		UsedLinks = (char **) ResizeMemory( UsedLinks, (NumUsedLinks+1) * sizeof(char *));
		UsedLinks[NumUsedLinks++] = (strcmp( wikilink, "") != 0) ? wikilink : wikiname;
		return wikistr;
	}
}


/*
	create a thing class and append it to classes array
*/
void AppendClass( UBCINT class, char *wikiname, char *wikilink, char *wikistr)
{
	ThClass *tptr;
	int ret;

	/* initialize class */
	tptr = (ThClass *) GetMemory( sizeof(ThClass));
	tptr->class = class;
	tptr->wikiname = strdup( wikiname);
	if (wikilink != NULL)
	{
		tptr->wikilink = strdup( wikilink);
		/* special handling of class headers with multiple links */
		if (wikistr != NULL)
			tptr->wikistr = strdup( wikistr);
		else
		{
			tptr->wikistr = NULL;
			ret = asprintf( &tptr->wikistr, "[[%s|%s]]", wikilink, wikiname);
			if (ret == -1)
				ProgError( "unable to concatenate class wiki string");
		}
	}
	else /* don't link */
	{
		tptr->wikilink = NULL;
		tptr->wikistr = strdup( wikiname);
	}

	/* append class to global array */
	ThClasses = (ThClass **) ResizeMemory( ThClasses, (NumThClasses+1) * sizeof(tptr));
	ThClasses[NumThClasses++] = tptr;
}

/*
	create a Strife character item and append it to items array
	if in translation table, then use map-specific name and link, otherwise defaults
*/
void AppendStrife( BCINT mission, UBCINT class, UBCINT type, char *wikiname, char *wikilink)
{
	int i;
	Bool found = FALSE;

	/* translate character if no PWAD(s) loaded */
	if (PatchWads == NULL)
		for (i = 0; i < NUMCHARS; i++)
			if (mission == StrifeChars[i].mapnr && type == StrifeChars[i].thgid)
			{
				found = TRUE;
				break;
			}

	if (found)
	{
		AppendItem( class, type, StrifeChars[i].wikiname, StrifeChars[i].wikilink);
		SortStrife( class);
	}
	else
		AppendItem( class, type, wikiname, wikilink);
}

/*
	create a thing item and append it to items array
	wikilink: if non-empty string, use as link in [[link|name]]
	          if empty string, use wikiname as link in [[name]]
	          if NULL, don't link wikiname
*/
void AppendItem( UBCINT class, UBCINT type, char *wikiname, char *wikilink)
{
	ThItem *tptr;
	int m, n, ret = 0;

	/* initialize item */
	tptr = (ThItem *) GetMemory( sizeof(ThItem));
	tptr->class = class;
	tptr->type = type;
	tptr->custom = FALSE;
	for (m = 0; m < ThMode_End; m++)
		for (n = 0; n < MAX_UDMF; n++)
			tptr->skill[n][m] = 0;

	/* compile wiki string */
	tptr->wikiname = strdup( wikiname);
	if (wikilink != NULL)
	{
		tptr->wikilink = strdup( wikilink);
		tptr->wikistr = NULL;
		if (strcmp( wikilink, "") != 0) /* use alternate link */
			ret = asprintf( &tptr->wikistr, "[[%s|%s]]", wikilink, wikiname);
		else /* use name as link */
			ret = asprintf( &tptr->wikistr, "[[%s]]", wikiname);
	}
	else /* don't link */
	{
		tptr->wikilink = NULL;
		tptr->wikistr = strdup( wikiname);
	}
	if (ret == -1)
		ProgError( "unable to concatenate item wiki string");

	/* append item to global array */
	ThItems = (ThItem **) ResizeMemory( ThItems, (NumThItems+1) * sizeof(tptr));
	ThItems[NumThItems++] = tptr;
}

/*
	sort most recently appended, custom Strife item alphabetically within its class,
	leaving the default items in the same order after the custom ones
*/
void SortStrife( UBCINT class)
{
	BCINT i, j;
	ThItem *tptr;

	/* mark most recently appended item as custom */
	tptr = ThItems[NumThItems-1];
	tptr->custom = TRUE;
	/* no sorting of a one-item list */
	if (NumThItems == 1)
		return;

	/* search back within class for item after which to sort the most recent one */
	for (i = NumThItems-2; i >= 0; i--)
	{
		/* check if no longer same class */
		if (ThItems[i]->class != class)
			break;
		/* check if this custom item should stay before most recent one */
		if (ThItems[i]->custom && strcmp( ThItems[i]->wikiname, tptr->wikiname) <= 0)
			break;
	}

	/* move most recent item into new slot */
	for (j = NumThItems-1; j > i+1; j--)
		ThItems[j] = ThItems[j-1];
	ThItems[j] = tptr;
}


/*
	add/update custom things from mapping file
*/
void ReadCustomThings( void)
{
	FILE *mapfile;
	char buf[BUFSIZE], *field;
	BCINT i, j;
	ThItem *tptr;
	UBCINT class, type;
	char *wikiname, *wikilink;

	/* read custom thing translations */
	if ((mapfile = fopen( CustomMap, "r")) == NULL)
		ProgError( "error opening custom mapping \"%s\"", CustomMap);

	while (fgets( buf, BUFSIZE, mapfile) != NULL)
	{
		/* skip comment lines */
		if (buf[0] == '#')
			continue;

		/* read tab-spaced fields */
		if ((field = strtok( buf, "\t")) == NULL)
			ProgError( "error reading custom mapping \"%s\"", CustomMap);
		class = atoi( field);

		if ((field = strtok( NULL, "\t")) == NULL)
			ProgError( "error reading custom mapping \"%s\"", CustomMap);
		type = atoi( field);

		if ((field = strtok( NULL, "\t")) == NULL)
			ProgError( "error reading custom mapping \"%s\"", CustomMap);
		wikiname = strdup( field);

		if ((field = strtok( NULL, "\t")) == NULL)
			ProgError( "error reading custom mapping \"%s\"", CustomMap);
		if (field[strlen( field)-1] == '\n')
			field[strlen( field)-1] = '\0';
		if (field[0] == '\0')
			wikilink = NULL;
		else if (field[0] == '~')
			wikilink = strdup( "");
		else
			wikilink = strdup( field);

		/* find existing item(s) */
		for (i = 0; i < NumThItems; i++)
			if (ThItems[i]->type == type)
			{
				/* discard existing item */
				FreeMemory( ThItems[i]->wikiname);
				if (ThItems[i]->wikilink != NULL)
					FreeMemory( ThItems[i]->wikilink);
				FreeMemory( ThItems[i]->wikistr);

				/* move up subsequent items */
				tptr = ThItems[i];
				for (j = i; j < NumThItems-1; j++)
					ThItems[j] = ThItems[j+1];
				FreeMemory( tptr);
				NumThItems--;

				/* kludge to also discard Doom 64 items THING_64_LASER / THING_64_TRIGGER */
				if (type != THING_WOLF3DSS && type != THING_BOSSSHOOT)
					break;
			}

		/* append custom item */
		AppendItem( class, type, wikiname, wikilink);
		FreeMemory( wikiname);
		FreeMemory( wikilink);
	}

	fclose( mapfile);
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
