struct wad_header
{
	char type[4];
	long int num_entries;
	long int dir_start;
};

struct directory
{
	long int start;
	long int length;
	char name[8];
};


/*- The level structures ---------------------------------------------------*/

struct Thing
{
   short xpos;      /* x position */
   short ypos;      /* y position */
   short angle;     /* facing angle */
   short type;      /* thing type */
   short when;      /* appears when? */
};

struct Vertex
{
   short int x;         /* X coordinate */
   short int y;         /* Y coordinate */
};

struct LineDef
{
   short int start;     /* from this vertex ... */
   short int end;       /* ... to this vertex */
   short int flags;     /* see NAMES.C for more info */
   short int type;      /* see NAMES.C for more info */
   short int tag;       /* crossing this linedef activates the sector with the same tag */
   short int sidedef1;  /* sidedef */
   short int sidedef2;  /* only if this line adjoins 2 sectors */
};

struct SideDef
{
   short int xoff;      /* X offset for texture */
   short int yoff;      /* Y offset for texture */
   char tex1[8];	/* texture name for the part above */
   char tex2[8];	/* texture name for the part below */
   char tex3[8];	/* texture name for the regular part */
   short int sector;    /* adjacent sector */
};

struct Sector
{
   short int floorh;    /* floor height */
   short int ceilh;     /* ceiling height */
   char floort[8];	/* floor texture */
   char ceilt[8];	/* ceiling texture */
   short int light;     /* light level (0-255) */
   short int special;   /* special behaviour (0 = normal, 9 = secret, ...) */
   short int tag;       /* sector activated by a linedef with the same tag */
};

