/*===============================================================
 * Project: Darkbot II 
 * Author : Terry 'Mongoose' Hendrix
 * Website: http://www.westga.edu/~stu7440/
 * Email  : stu7440@westga.edu
 * Version: Prototype
 * Object : item_reg
 * Comment: This is where items are registried for darkbot's
 *          item knowelge database. Currently uses array data 
 *          sturcture to reduce overhead and lookup. 
 *
 *          Define BOT_DEBUG_ITEM_REG for debugging this object.
 *
 * TODO   : Seperate the item registry into AMMO, HEALTH, WEAPON, 
 *          ARMOR, KEY, CUSTOM.  Add fuzzy weights into a struct 
 *          field that contains pointer to edict_t and the fuzzy 
 *          weight.
 *
 *-- Copyright ----------------------------------------------
 * Copyright (C) 1999 Terry Hendrix II.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ==============================================================*/

#ifndef __MONGOOSE_ITEM_REG_H
#define __MONGOOSE_ITEM_REG_H

#define ITEM_MAX 512

void reg_item_db(edict_t *item);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : item - The edict to add to the
                   list.
 Returns  : Nothing
 Purpose  : Adds edict to list. (wrapper)
 --------------------------------------------*/

void unreg_item_db(edict_t *item);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : item - The edict to delete from
                   list.
 Returns  : Nothing
 Purpose  : Deletes edict from list. (wrapper)
 --------------------------------------------*/

void reset_item_array();
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : None
 Returns  : Nothing
 Purpose  : Clears item array.
 --------------------------------------------*/

void reg_item_array(edict_t *item);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : item - The edict to add to the
                   list.
 Returns  : Nothing
 Purpose  : Adds edict to array.
 --------------------------------------------*/

void unreg_item_array(edict_t *item);
/*--------------------------------------------
 Created  : 990507
 Author   : Terry 'Mongoose' Hendrix II
 Inputs   : item - The edict to delete from
                   list.
 Returns  : Nothing
 Purpose  : Deletes edict from array. 
 --------------------------------------------*/

#endif


