// x_misc.c

#include "g_local.h"
#include "x_misc.h"

/*
=========================================================
Churl
=========================================================
*/

/*
This makes you throw up
*/

void ChurlNow(edict_t *self)
{
	// use some local vector variables to work with
	vec3_t	forward, right;
	vec3_t	mouth_pos, spew_vector;
	float rnum;
	int i;

	// set the spew vector, based on the client's view angle
	AngleVectors (self->client->v_angle, forward, right, NULL);

	// Make the spew originate from our mouth
	VectorScale (forward, 24, mouth_pos);
	VectorAdd (mouth_pos, self->s.origin, mouth_pos);
	mouth_pos[2] += self->viewheight;

	// Make the spew come forwards out of our mouth.
	VectorScale (forward, 24, spew_vector);

	// BLOOD !
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BLOOD);
	gi.WritePosition (mouth_pos);
	gi.WriteDir (spew_vector);
	gi.multicast (mouth_pos, MULTICAST_PVS);
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BLOOD);
	gi.WritePosition (mouth_pos);
	gi.WriteDir (spew_vector);
	gi.multicast (mouth_pos, MULTICAST_PVS);
	gi.WriteByte (svc_temp_entity);
	gi.WriteByte (TE_BLOOD);
	gi.WritePosition (mouth_pos);
	gi.WriteDir (spew_vector);
	gi.multicast (mouth_pos, MULTICAST_PVS);

	// make a painful sound
	gi.sound (self, CHAN_VOICE, gi.soundindex("misc/udeath.wav"), 1, ATTN_NORM, 0);

	// Yummy
	for (i = 0; i<3; i++)
	{
		ThrowVomit (self, mouth_pos, forward, right, self->velocity); 
	} 
	// every now and again, cough up MEGA vomit 
	if (random() < 0.2) 
	{ 
		for (i = 0; i<10; i++) 
		{ 
			ThrowVomit (self, mouth_pos, forward, right, self->velocity); 
			ThrowVomit (self, mouth_pos, forward, right, self->velocity); 
		} 
	}

	// You lose health!
	if (self->health > 5)
		self->health -= 5;
}

/*
=========================================================
Menu
=========================================================
*/

/*
pmenu_t fwcreditsmenu[] = {
	{ "*Quake II",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Flag Wars CTF",		PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,				PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Programming",			PMENU_ALIGN_CENTER, NULL, NULL }, 
	{ "Hector 'Xian' Ramos",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Tutorials", 			PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Inside3D",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ "QDeveLS",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,				PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Return to Main Menu",	PMENU_ALIGN_LEFT, NULL, CTFReturnToMain }
};

pmenu_t fwhelpmenu[] = {
	{ "*Quake II",					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Flag Wars CTF",				PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,						PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Help Menu",					PMENU_ALIGN_CENTER, NULL, NULL }, 
	{ NULL,						PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Select a topic for help:",			PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,						PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*FORCE POWERS",		 		PMENU_ALIGN_CENTER, NULL, FWForceMenu },
	{ "*WEAPONS",					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*INFORMATION",					PMENU_ALIGN_CENTER, NULL, FWWeapMenu },
	{ NULL,						PMENU_ALIGN_CENTER, NULL, FWInfoMenu },
	{ "Return to Main Menu",			PMENU_ALIGN_LEFT, NULL, CTFReturnToMain }
};

pmenu_t fwforcemenu[] = {
	{ "*Quake II",					PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Flag Wars CTF",				PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,						PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Force Powers",				PMENU_ALIGN_CENTER, NULL, NULL }, 
	{ "Type FORCE_PREV and FORCE_NEXT",		PMENU_ALIGN_CENTER, NULL, NULL },
	{ "to select a Force Power. Then", 		PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Activate it by typing FORCE.",		PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Bind these commands to different keys",PMENU_ALIGN_CENTER, NULL, NULL },
	{ "for fast and easy selection and use.",	PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,						PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Return to Help Menu",			PMENU_ALIGN_LEFT, NULL, FWReturnToHelp }
};

pmenu_t fwweapmenu[] = {
	{ "*Quake II",									PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Flag Wars CTF",								PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,										PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Weapon Help",									PMENU_ALIGN_CENTER, NULL, NULL }, 
	{ NULL,										PMENU_ALIGN_LEFT, NULL, NULL },
	{ "*Flare Gun - Hit 1 when Blaster is selected.",			PMENU_ALIGN_LEFT, NULL, NULL },
	{ "*Assault Rifle - Hit 4 when Machinegun is selected.",		PMENU_ALIGN_LEFT, NULL, NULL },
	{ "*New Grenades - Hit 6 when Grenades are selected.",		PMENU_ALIGN_LEFT, NULL, NULL },
	{ "*Heat Seekers - Hit 7 when Rocket Launcher is selected.",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "*InviSlugs - Hit 9 when Railgun is selected.",			PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,										PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Return to Help Menu",							PMENU_ALIGN_LEFT, NULL, FWReturnToHelp }
};

pmenu_t fwinfomenu[] = {
	{ "*Quake II",									PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Flag Wars CTF",								PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,										PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Information",									PMENU_ALIGN_CENTER, NULL, NULL }, 
	{ NULL,										PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Visit the Flag Wars homepage for more",				PMENU_ALIGN_LEFT, NULL, NULL },
	{ "information about the new featutes in",				PMENU_ALIGN_LEFT, NULL, NULL },
	{ "this CTF modification:",							PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,										PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*http://www.captured.com/flagwars/",					PMENU_ALIGN_CENTER, NULL, NULL }, 
	{ NULL,										PMENU_ALIGN_CENTER, NULL, NULL },
	{ "Return to Help Menu",							PMENU_ALIGN_LEFT, NULL, FWReturnToHelp }
};


void FWReturnToHelp(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	PMenu_Open(ent, fwhelpmenu, team, sizeof(joinmenu) / sizeof(pmenu_t));
}

void FWCredits(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	PMenu_Open(ent, fwcreditsmenu, -1, sizeof(creditsmenu) / sizeof(pmenu_t));
}

void FWForceMenu(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	PMenu_Open(ent, fwforcemenu, -1, sizeof(creditsmenu) / sizeof(pmenu_t));
}

void FWWeapMenu(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	PMenu_Open(ent, fwweapmenu, -1, sizeof(creditsmenu) / sizeof(pmenu_t));
}

void FWInfoMenu(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	PMenu_Open(ent, fwinfomenu, -1, sizeof(creditsmenu) / sizeof(pmenu_t));
}
*/