// LAST EDITED BY XIAN ON: 3.13.98
// - AutoD
// - Laser

#include        "g_local.h"
#include        "x_weapons.h"

// XIAN START -> Avoid undeclared errors
void Grenade_Touch ();
void Grenade_Explode ();
void rocket_touch ();
// XIAN END -> Avoid undeclared errors

/*
=========================================================
AUTODESTRUCT MODES:
Two options - blow up instantly, or add a 10 second delay
which gives your explosion QUAD damage.

CREDITS:
Got code from QDeveLS
=========================================================
*/

/*
Start 10 second autodestruct delay
*/

void Start_Autodestruct_Mode(edict_t *the_doomed_one)
{
	if (the_doomed_one->client->autodestruct_mode & 1)
	{
		gi.cprintf(the_doomed_one, PRINT_MEDIUM, "Autodestruct already activated. Good luck...");
		return;		    
	}
	if (the_doomed_one->flags & FL_GODMODE)
	{
                gi.cprintf(the_doomed_one, PRINT_MEDIUM, "You are a god!\n");
		return;
	}
	the_doomed_one->client->autodestruct_mode = 1;
	the_doomed_one->client->autodestruct_timeleft = AUTODESTRUCT_BLOW_TIME;
	the_doomed_one->client->autodestruct_framenum = level.framenum + the_doomed_one->client->autodestruct_timeleft;
	gi.bprintf (PRINT_MEDIUM,"%s activated his autodestruct system. 10 seconds remainining...\n", the_doomed_one->client->pers.netname);
        gi.sound( the_doomed_one, CHAN_AUTO, gi.soundindex("makron/rail_up.wav"), 1, ATTN_NONE, 0 );
        gi.sound( the_doomed_one, CHAN_AUTO, gi.soundindex("world/10_0.wav"), 1, ATTN_NONE, 0 );
	return;
}

/*
Is it active?
*/

qboolean Autodestruct_Active(edict_t *the_doomed_one)
{
	return (the_doomed_one->client->autodestruct_mode);
}

/*
Stop it! Aaaaack!
*/

void Autodestruct_Cancel(edict_t *the_spared_one)
{
	the_spared_one->client->autodestruct_mode = 0;
	the_spared_one->client->autodestruct_timeleft = 0;
	the_spared_one->client->autodestruct_framenum = 0;
	return;
}

/*
Explode it. Used for the 10 sec delay
*/

void Autodestruct_Explode(edict_t *the_doomed_one)
{
    float dmg;

    dmg = the_doomed_one->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))];
    T_RadiusDamage (the_doomed_one, the_doomed_one, AUTODESTRUCT_DAMAGE*4*dmg, NULL, AUTODESTRUCT_DAMAGE_RADUIS, MOD_KAMIKAZE);
    gi.WriteByte (svc_temp_entity);
    gi.WriteByte (TE_EXPLOSION1);
    gi.WritePosition(the_doomed_one -> s.origin);
    gi.multicast (the_doomed_one->s.origin, MULTICAST_PVS);
}                          

/*
Explode it. Used for non-delayed
*/

void Autodestruct_Explode2(edict_t *the_doomed_one)
{
    float dmg;

    dmg = the_doomed_one->client->pers.inventory[ITEM_INDEX(FindItem("Grenades"))];
    T_RadiusDamage (the_doomed_one, the_doomed_one, AUTODESTRUCT_DAMAGE*dmg, NULL, AUTODESTRUCT_DAMAGE_RADUIS, MOD_KAMIKAZE);
    gi.WriteByte (svc_temp_entity);
    gi.WriteByte (TE_EXPLOSION1);
    gi.WritePosition(the_doomed_one -> s.origin);
    gi.multicast (the_doomed_one->s.origin, MULTICAST_PVS);
}

/*
=========================================================
DEFENSE LASERS:
Two options - blow up instantly, or add a 10 second delay
which gives your explosion QUAD damage.

CREDITS:
Got code from QDeveLS
=========================================================
*/

/*
Dying lasers explode
*/

static void Laser_Explode (edict_t *ent)
{
	vec3_t		origin;

	if (ent->owner->client)
		PlayerNoise(ent->owner, ent->s.origin, PNOISE_IMPACT);

	//FIXME: if we are onground then raise our Z just a bit since we are a point?
        T_RadiusDamage(ent, ent->owner, ent->dmg, NULL, ent->dmg_radius,MOD_LASER_EXPLODE);

	VectorMA (ent->s.origin, -0.02, ent->velocity, origin);
	gi.WriteByte (svc_temp_entity);
	if (ent->waterlevel)
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION_WATER);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION_WATER);
	}
	else
	{
		if (ent->groundentity)
			gi.WriteByte (TE_GRENADE_EXPLOSION);
		else
			gi.WriteByte (TE_ROCKET_EXPLOSION);
	}
	gi.WritePosition (origin);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	G_FreeEdict (ent);
}

/*
For dying lasers
*/

static void Laser_Die (edict_t *self)
{
	self->takedamage = DAMAGE_NO;
	self->nextthink = level.time + .1;
      self->think = Laser_Explode;
	target_laser_off (self);
}

/*
Place the laser pod
*/

void	PlaceLaser (edict_t *ent)
{
	edict_t         *self, *grenade;
      vec3_t          forward, wallp;
	trace_t		tr;
/*	int		laser_colour[] = {
                                   		0xf2f2f0f0,             // red
                                          0xd0d1d2d3,             // green
                                          0xf3f3f1f1,             // blue
                                          0xdcdddedf,             // yellow
                                          0xe0e1e2e3              // bitty yellow strobe
						};
*/
	int		laser_colour[] = {
                                   		0xf2f2f0f0,             // red
                                          0xf3f3f1f1,             // blue
  						};
	// valid ent ?
  	if ((!ent->client) || (ent->health<=0))
	   return;
	// cells for laser ?
	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] < CELLS_FOR_LASER)
	{
 		gi.cprintf(ent, PRINT_HIGH, "Not enough cells for laser.\n");
		return;
	}

	// Setup "little look" to close wall
	VectorCopy(ent->s.origin,wallp);         

	// Cast along view angle
	AngleVectors (ent->client->v_angle, forward, NULL, NULL);

	// Setup end point
	wallp[0]=ent->s.origin[0]+forward[0]*50;
	wallp[1]=ent->s.origin[1]+forward[1]*50;
	wallp[2]=ent->s.origin[2]+forward[2]*50;  

	// trace
	tr = gi.trace (ent->s.origin, NULL, NULL, wallp, ent, MASK_SOLID);

	// Line complete ? (ie. no collision)
	if (tr.fraction == 1.0)
	{
		gi.cprintf (ent, PRINT_HIGH, "Wall is too far!\n");
		return;
	}

	// Hit sky ?
	if (tr.surface)
		if (tr.surface->flags & SURF_SKY)
			return;

	// Ok, lets stick one on then ...
        gi.cprintf (ent, PRINT_HIGH, "Laser pod attached!\n");

	ent->client->pers.inventory[ITEM_INDEX(FindItem("Cells"))] -= CELLS_FOR_LASER;
      // -----------
	// Setup laser
	// -----------
	self = G_Spawn();

	self -> movetype = MOVETYPE_NONE;
	self -> solid = SOLID_NOT;
	self -> s.renderfx = RF_BEAM|RF_TRANSLUCENT;
      self -> s.modelindex = 1; // must be non-zero
	self -> s.sound = gi.soundindex ("world/laser.wav");
	self -> classname = "defense_laser";
	self -> s.frame = 2;	// beam diameter
  	self -> owner = self;
//	if (self->owner->client->resp.ctf_team)
		self -> s.skinnum = 0xf2f2f0f0;			// red
//	else
//		self -> s.skinnum = 0xf3f3f1f1;			// blue

//	self -> s.skinnum = laser_colour[((int) (random() * 1000)) % 2];
//	self -> s.skinnum = laser_colour[((int) (random() * 1000)) % 5];
  	self -> dmg = LASER_DAMAGE;
	self -> think = pre_target_laser_think;
	self -> delay = level.time + LASER_TIME;

	// Set origin of laser to point of contact with wall
	VectorCopy(tr.endpos,self->s.origin);

	// convert normal at point of contact to laser angles
	vectoangles(tr.plane.normal,self -> s.angles);

	// setup laser movedir (projection of laser)
	G_SetMovedir (self->s.angles, self->movedir);

	VectorSet (self->mins, -8, -8, -8);
	VectorSet (self->maxs, 8, 8, 8);

	// link to world
	gi.linkentity (self);

	// start off ...
	target_laser_off (self);

	// ... but make automatically come on
	self -> nextthink = level.time + 2;
	
	grenade = G_Spawn();

//	VectorClear (grenade->mins);
//	VectorClear (grenade->maxs);
	VectorCopy (tr.endpos, grenade->s.origin);
	vectoangles(tr.plane.normal,grenade -> s.angles);

	grenade -> movetype = MOVETYPE_NONE;
	grenade -> clipmask = MASK_SHOT;
	grenade -> solid = SOLID_NOT;
	grenade -> s.modelindex	= gi.modelindex ("models/objects/grenade2/tris.md2");
	grenade -> owner = self;
	grenade -> nextthink = level.time + LASER_TIME;
	grenade -> think = G_FreeEdict;
//	VectorSet(grenade->mins, -3, -3, 0);
//	VectorSet(grenade->maxs, 3, 3, 6);
	VectorSet(grenade->mins, -5, -5, 0);
	VectorSet(grenade->maxs, 5, 5, 6);
	grenade -> takedamage = DAMAGE_YES;
      grenade -> mass = 10;
	grenade -> health = 50;
      grenade -> die = Laser_Die;
	grenade -> monsterinfo.aiflags = AI_NOSTEP;

	gi.linkentity (grenade);
}

/*
Turn laser on after 2 secs
*/

void	pre_target_laser_think (edict_t *self)
{
	target_laser_on (self);

	self->think = target_laser_think;
}

void	defense_laser_off (edict_t *self)
{
	Laser_Die (self);
}

/*
=========================================================
New weapon definitions
=========================================================
*/

/*
Triple Rocket Launcher
*/

void Weapon_TripleRocketLauncher_Fire (edict_t *ent)
{
	vec3_t	offset, start;
	vec3_t	forward, right;
	int		damage;
	float	damage_radius;
	int		radius_damage;

      vec3_t traj_angle, lineofsight; 
	int startspeed;
	startspeed=600;
                            
	damage = 100 + (int)(random() * 20.0);
      radius_damage = 150;
      damage_radius = 90;

	AngleVectors (ent->client->v_angle, forward, right, NULL);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;
//    if ((ent->client) && (ent->client->rocketType == ROCKET_TRIPLE))
//    {
		VectorCopy(forward, lineofsight);
		VectorCopy(ent->client->v_angle, traj_angle);
//	}

	VectorSet(offset, 8, 8, ent->viewheight-8);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
//	if (ent->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] >= 3)
//	{
//	      ent->client->pers.inventory[ITEM_INDEX(FindItem("Rockets"))] -= 3;
		fire_rocket2 (ent, start, forward, lineofsight, damage, startspeed, damage_radius, radius_damage);
		traj_angle[1] = ent->client->v_angle[1]+5;
		AngleVectors (traj_angle, forward, right, NULL);
		VectorSet(offset, 8, 8, ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
		fire_rocket2 (ent, start, forward, lineofsight, damage, startspeed, damage_radius, radius_damage);
		traj_angle[1] = ent->client->v_angle[1]-5;
		AngleVectors (traj_angle, forward, right, NULL);
		VectorSet(offset, 8, 8, ent->viewheight-8);
		P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);
		fire_rocket2 (ent, start, forward, lineofsight, damage, startspeed, damage_radius, radius_damage);
//	}
//	else
//		fire_rocket (ent, start, forward, damage, 800, 120, 120);
	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
	gi.WriteByte (MZ_ROCKET);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	ent->client->ps.gunframe++;

	PlayerNoise(ent, start, PNOISE_WEAPON);

	ent->client->pers.inventory[ent->client->ammo_index] -= ent->client->pers.weapon->quantity;
}

void Weapon_TripleRocketLauncher (edict_t *ent)
{
	static int	pause_frames[]	= {25, 33, 42, 50, 0};
	static int	fire_frames[]	= {5, 0};

        Weapon_Generic (ent, 4, 12, 50, 54, pause_frames, fire_frames, Weapon_TripleRocketLauncher_Fire);
}

/*
Flaregun
*/

void FlareGun_Fire (edict_t *ent, vec3_t g_offset, int damage)
{
	vec3_t	forward, right;
	vec3_t	start;
	vec3_t	offset;

	AngleVectors (ent->client->v_angle, forward, right, NULL);
	VectorSet(offset, 24, 8, ent->viewheight-8);
	VectorAdd (offset, g_offset, offset);
	P_ProjectSource (ent->client, ent->s.origin, offset, forward, right, start);

	VectorScale (forward, -2, ent->client->kick_origin);
	ent->client->kick_angles[0] = -1;

	fire_flaregun (ent, start, forward, damage, 1000, EF_BLASTER);

	// send muzzle flash
	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (ent-g_edicts);
      gi.WriteByte (MZ_BLASTER);
	gi.multicast (ent->s.origin, MULTICAST_PVS);

	PlayerNoise(ent, start, PNOISE_WEAPON);
}


void Weapon_FlareGun_Fire (edict_t *ent)
{
	int		damage;

      damage = 5;
	FlareGun_Fire (ent, vec3_origin, damage);

	ent->client->ps.gunframe++;
}

void Weapon_FlareGun (edict_t *ent)
{
	static int	pause_frames[]	= {10, 18, 27, 0};
	static int	fire_frames[]	= {6, 0};

	Weapon_Generic (ent, 5, 9, 31, 36, pause_frames, fire_frames, Weapon_FlareGun_Fire);
}
