//=============================================================================
// CSPlayer.
//
// This is our new player Class.  It has been modified to hold information needed
// to do a cut sequence and the different camera views.
//=============================================================================
class CSPlayer expands UnrealIPlayer;

var bool 		bCSCameraMode;  // Are we in Camera Mode
var CS_Camera 	CSCamera;		// Where is the Camera pointed
var int 		oldhudMode;		// what is the old hud mode
var bool		bIsActing;      // Ignore movement commands


var vector AdjVelocity;  // How to adjust his movement.



state PlayerWalking
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);

		Super.PlayerTick(DeltaTime);
	}

	
}

state FeigningDeath
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);

		Super.PlayerTick(DeltaTime);
	}
}
	
state PlayerSwimming
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);
		
		Super.PlayerTick(DeltaTime);
	}
}

state PlayerFlying
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);

		Super.PlayerTick(DeltaTime);
	}
}

state CheatFlying
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);
		
		Super.PlayerTick(DeltaTime);
	}
}

state PlayerWaking
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);

		Super.PlayerTick(DeltaTime);
	}
}

state Dying
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);

		Super.PlayerTick(DeltaTime);
	}
}

state GameEnded
{
	event PlayerTick(float DeltaTime)
	{
		if (bUpdatePosition)
			ClientUpdatePosition();

		PlayerMove(DeltaTime);

		Super.PlayerTick(DeltaTime);
	}
}


event PlayerCalcView(out actor ViewActor, out vector CameraLocation, out rotator CameraRotation)
{
	local vector View,HitLocation,HitNormal;
	local float ViewDist, WallOutDist;

    // If a cut sequence is in progress, grab the current Location and Rotation from the camera.

 	if (bCSCameraMode) {
	    ViewActor = Self;
		CameraLocation = CSCamera.Location;
		CameraRotation = CSCamera.Rotation;
			
		return;
	}
		
	if (ViewTarget != None)
	{
		ViewActor = ViewTarget;
		CameraLocation = ViewTarget.Location;
		CameraRotation = ViewTarget.Rotation;
		if (Pawn(ViewTarget) != None)
		{
			if (PlayerPawn(ViewTarget) != None)
				CameraRotation = PlayerPawn(ViewTarget).ViewRotation;
			CameraLocation.Z += Pawn(ViewTarget).EyeHeight;
		}
		return;
	}

	// View rotation.
	ViewActor = Self;
	CameraRotation = ViewRotation;

	if(bBehindView) //up and behind
	{
	    ViewDist    = 100;
		WallOutDist = 30;
		View = vect(2,0,-1) >> CameraRotation;
		if(Trace(HitLocation, HitNormal, Location - (ViewDist+WallOutDist) * vector(CameraRotation), Location) != None)
			ViewDist = FMin((Location - HitLocation) Dot View, ViewDist);
		CameraLocation -= (ViewDist - WallOutDist) * View;
	}
	else
	{
		// First-person view.
		CameraLocation = Location;
		CameraLocation.Z += EyeHeight;
		CameraLocation += WalkBob;
	}
}

// POVGotoLocation - The original idea for this function came from Green Marine's Omni-Cam mod.  I have however
// modified it to simply take the actual camera as a parameter.  We will generation the view location/rotation from
// the camera it'self.  The benifit to this is it allows us to adjust the camera in real time.

function POVGotoLocation(CS_Camera Camera)
{

//    LOG("****IN POVGOTOLOCATION");

	// Set the Camera Location

	bCSCameraMode = true;	 // We are in camera mode
	CSCamera = Camera;		 // Set the pointer to the camera


//	LOG("****OUT POVGOTOLOCATION");
	
}

// POVThirdPerson - This function switches to 3rd person view

function POVThirdPerson(bool letterboxed)
{

//  	Log("****IN POVTHIRDPERSON");

	// Switch POV to behind the back

  	bBehindView = true;  	
  	
	// Set the custom hud

	OldHudMode = MyHud.HudMode;  // Save this for later
	
	if (!LetterBoxed)
 		MyHud.HudMode=6;
 	else
 		MyHud.HudMode=7;
  

//  	Log("****OUT POVTHIRDPERSON");
}
// POVFirstPerson - This function also was a part of the original Omni-Cam.  

function POVFirstPerson()
{

//    LOG("****IN POVFIRSTPERSON");
	bBehindView = false;
	bCSCameraMode = false;
	CSCAmera = none;

	Log("Old Hude = "$OldHudMode);

    MyHud.HudMode=OldHudMode;
	
//	LOG("****OUT POVFIRSTPERSON");
}

// ShowMenu must be modified so a menu cannot appear while the cut sequence is happening.

exec function ShowMenu()
{

	local CS_ShotList sl;
	local CSPlayer p;
	local int PlayerCnt;

	// If we are in Cut Sequence Mode.. exit it.

	if (bCSCameraMode==true)
	{
	
		// Count the number of players.
		
		PlayerCnt=0;
		
		foreach AllActors(class'CSPlayer',p)
		  PlayerCnt++;
	
		// If there are more than 1 player.. DONT abort.
		// this is to keep Multiplayer games in sync.  It shouldn't
		// be 100% necessary, but nice to keep everyone at the same point
		
		if (PlayerCnt>1)
		  return;
	
		log("ShowMenu: Searching for ShotList");
		foreach AllActors(class'CS_SHOTLIST',sl)
		{
		
//		  log("ShowMenu:Found ShotList");	  
		  if (sl.bActive)
		  {
//		    log("ShowMenu:Aborting Shotlist");
		    sl.bAbort = true;  // Abort the shot
		  }
		  else
		    log("ShowMenu:Shotlist Not Active");		  	
	    
		}

		// return to First person view

	 	POVFirstPerson();	// Reset their view
	 	
	 	
	 	// Set state to walking
	 	
	 	GotoState('PlayerWalking');
	 	
		return;
	
	}

	MyHud.MainMenuType = class'UnrealMainMenu';
	 
	WalkBob = vect(0,0,0);
	bShowMenu = true; // menu is responsible for turning this off
	Player.Console.GotoState('Menuing');
		
	if( Level.Netmode == NM_Standalone )
		SetPause(true);
}


// The player wants to active selected item
exec function ActivateItem()
{
	if( bShowMenu || Level.Pauser!="" )
		return;
	if (SelectedItem!=None) 
	{
	
		SelectedItem.Activate();
		
	}	
}


function Act(int Anim)
{

  switch Anim
  {
  	
 	  case 0:	PlayAnim('Taunt1',0.7,0.2);break;
 	  case 1: 	PlayAnim('Look',0.7,0.2);break;
 	  case 2:	PlayAnim('WaveL',0.7,0.2);break;
 	  case 3:   PlayAnim('Victory1L',0.7,0.2);break;
 	  
   }
 

}

function Freeze(bool value)
{
  bIsActing = value;
  if (value)
    GotoState('PlayerActing');
  else
    GotoState('PlayerWalking');
}


function ScriptedMove(vector NewVelocity)
{

  AdjVelocity = NewVelocity;
  
}

function ResetScriptedMove()
{

  AdjVelocity.X = 0;  
  AdjVelocity.Y = 0;
  AdjVelocity.Z = 0;
}



state PlayerActing
{
ignores SeePlayer, HearNoise, Bump;

	exec function FeignDeath()
	{
		if ( Physics == PHYS_Walking )
		{
			ServerFeignDeath();
			Acceleration = vect(0,0,0);
			GotoState('FeigningDeath');
		}
	}

	function ZoneChange( ZoneInfo NewZone )
	{
		if (NewZone.bWaterZone)
		{
			setPhysics(PHYS_Swimming);
			GotoState('PlayerSwimming');
		}
	}

	function AnimEnd()
	{
		local name MyAnimGroup;

		bAnimTransition = false;
		if (Physics == PHYS_Walking)
		{
			if (bIsCrouching)
			{
				if ( !bIsTurning && ((Velocity.X * Velocity.X + Velocity.Y * Velocity.Y) < 1000) )
					PlayDuck();	
				else
					PlayCrawling();
			}
			else
			{
				MyAnimGroup = GetAnimGroup(AnimSequence);
				if ((Velocity.X * Velocity.X + Velocity.Y * Velocity.Y) < 1000)
				{
					if ( MyAnimGroup == 'Waiting' )
						PlayWaiting();
					else
					{
						bAnimTransition = true;
						TweenToWaiting(0.2);
					}
				}	
				else if (bIsWalking)
				{
					if ( (MyAnimGroup == 'Waiting') || (MyAnimGroup == 'Landing') || (MyAnimGroup == 'Gesture') || (MyAnimGroup == 'TakeHit')  )
					{
						TweenToWalking(0.1);
						bAnimTransition = true;
					}
					else 
						PlayWalking();
				}
				else
				{
					if ( (MyAnimGroup == 'Waiting') || (MyAnimGroup == 'Landing') || (MyAnimGroup == 'Gesture') || (MyAnimGroup == 'TakeHit')  )
					{
						bAnimTransition = true;
						TweenToRunning(0.1);
					}
					else
						PlayRunning();
				}
			}
		}
	}

	function Landed(vector HitNormal)
	{
		Global.Landed(HitNormal);
	}

	
	function ProcessMove(float DeltaTime, vector NewAccel, eDodgeDir DodgeMove, rotator DeltaRot)	
	{
		local vector OldAccel;

		OldAccel = Acceleration;
		Acceleration = NewAccel;

		if ( (Physics == PHYS_Walking) && (GetAnimGroup(AnimSequence) != 'Dodge') )
		{
			if (!bIsCrouching)
			{
				if (bDuck != 0)
				{
					bIsCrouching = true;
					PlayDuck();
				}
			}
			else if (bDuck == 0)
			{
				OldAccel = vect(0,0,0);
				bIsCrouching = false;
			}

			if ( !bIsCrouching )
			{
				if ( (!bAnimTransition || (AnimFrame > 0)) && (GetAnimGroup(AnimSequence) != 'Landing') )
				{
					if ( Acceleration != vect(0,0,0) )
					{
						if ( (GetAnimGroup(AnimSequence) == 'Waiting') || (GetAnimGroup(AnimSequence) == 'Gesture') || (GetAnimGroup(AnimSequence) == 'TakeHit') )
						{
							bAnimTransition = true;
							TweenToRunning(0.1);
						}
					}
			 		else if ( (Velocity.X * Velocity.X + Velocity.Y * Velocity.Y < 1000) 
						&& (GetAnimGroup(AnimSequence) != 'Gesture') ) 
			 		{
			 			if ( GetAnimGroup(AnimSequence) == 'Waiting' )
			 			{
							if ( bIsTurning && (AnimFrame >= 0) ) 
							{
								bAnimTransition = true;
								PlayTurning();
							}
						}
			 			else if ( !bIsTurning ) 
						{
							bAnimTransition = true;
							TweenToWaiting(0.2);
						}
					}
				}
			}
			else
			{
				if ( (OldAccel == vect(0,0,0)) && (Acceleration != vect(0,0,0)) )
					PlayCrawling();
			 	else if ( !bIsTurning && (Acceleration == vect(0,0,0)) && (AnimFrame > 0.1) )
					PlayDuck();
			}
		}
	}
			
	event PlayerTick( float DeltaTime )
	{
		if ( bUpdatePosition )
			ClientUpdatePosition();

		PlayerMove(DeltaTime);
	}

	function PlayerMove( float DeltaTime )
	{
		local vector X,Y,Z,NewAccel;
		local eDodgeDir DodgeMove;

		// Update acceleration.

		ViewRotation = Rotation;	
		GetAxes(Rotation,X,Y,Z);

		aForward = AdjVelocity.Y * 0.4;
		aStrafe  = AdjVelocity.X * 0.4;
		aLookup  = 0;
		aTurn    = 0;

		NewAccel = aForward*X + aStrafe*Y;
		NewAccel.Z = 0;

		bPressedJump = false;

		if ( Role < ROLE_Authority ) // then save this move and replicate it
			ReplicateMove(DeltaTime, NewAccel, DodgeMove, Rotation);
		else
			ProcessMove(DeltaTime, NewAccel, DodgeMove, Rotation);

	}

	function BeginState()
	{
		WalkBob = vect(0,0,0);
		DodgeDir = DODGE_None;
		bIsCrouching = false;
		bIsTurning = false;
		bPressedJump = false;
		if (Physics != PHYS_Falling) SetPhysics(PHYS_Walking);
		if ( !IsAnimating() )
			PlayWaiting();
	}
	
	function EndState()
	{
		WalkBob = vect(0,0,0);
		bIsCrouching = false;
	}
}


// The player wants to fire.
exec function Fire( optional float F )
{
	if( bShowMenu || Level.Pauser!="" || bIsActing)
		return;
	if( Weapon!=None )
	{
		Weapon.bPointing = true;
		Weapon.Fire(F);
		PlayFiring();
	}
}

// The player wants to alternate-fire.
exec function AltFire( optional float F )
{
	if( bShowMenu || Level.Pauser!="" || bIsActing )
		return;
	if( Weapon!=None )
	{
		Weapon.bPointing = true;
		Weapon.AltFire(F);
		PlayFiring();
	}
}

defaultproperties
{
}
