//=============================================================================
// CS_Action.
//
// This Actor has two functions.  First it switches to the proper HUD.  It
// then Calls the necessary SHOT List.
//
//=============================================================================
class CS_Action expands CutSeq;

#exec Texture Import File=Textures\movie.pcx Name=S_Move Group=CutSequences Mips=Off Flags=2

var   bool  Triggered;			  	// Event was triggered
var	  float TriggerTime;			// Time this event was triggered.

var() bool  Retriggerable;			// Is this camera retriggerable
var() name  FirstShotList;			// Name of the first shotlist to call.
var() bool  LetterBoxed;			// Do we use the normal or letterboxed HUD
var() name  FirstCamera;			// The First camera to activate.
var() name  FirstLock;			    // If set, the engine will lock a camera on Other
var() bool  FreezeActor;			// Should the actor be frozen in place

function Touch(Actor Other)
{

 	local CS_Camera C;
	local CS_ShotList SL;
	local CS_LockOn LO;
	local CSPlayer P;
	local int Cnt;
	
	
	LOG("****IN CS_ACTION");
	
    // All cut sequences are called only once.


//	if (Triggered)
//	{   
//	    LOG("****OUT CS_ACTION: Already Triggered");
//		return;
//	}


	if (Triggered && (!Retriggerable))
	{
	  LOG("****OUT CS_ACTION: Already Triggered");
	  return;
	}
	  
	if (Triggered && (Level.TimeSeconds - TriggerTime < 3))
	{
	  Log("****OUT CS_ACTION: Cant Trigger yet..waiting");
	  return;
	}


	TriggerTime = Level.TimeSeconds;
	Triggered = true;

	// Cut Sequences can also only be triggered by the player.

    if (!Other.IsA('CSPlayer'))
    { 
      LOG("****OUT CS_ACTION: Not a Player");
      return;
    }
    
    
    if (FreezeActor)
      CSPlayer(Other).Freeze(True);
              
    // First, track down the camera.
    
    foreach AllActors(class'CS_Camera',c,FirstCamera)
      c.Trigger(Self,pawn(Other));        
    
    // If it should lock on, set it.
    
	if (FirstLock !='')
	{
	
	    foreach AllActors(class'CS_LockOn',LO,FirstLock)
	      LO.Trigger(Self,Pawn(Other));
	}	    
    
    // Switch the cut sequence engine on for all players in
    // the game.
    
    
    cnt=0;
	foreach AllActors(class'CSPlayer',P)
	{
	  cnt++;
	  p.POVThirdPerson(Letterboxed);
	}
	
	Log("CS_Action: CNT="$cnt);
 	
	// Find the first CS_ShotList and trigger it
 						
	foreach AllActors( class 'CS_SHOTLIST', SL, FirstShotList )
	{
	    	LOG("CS_ACTION: Found First Shotlist");
    		SL.Trigger( Other, Other.Instigator );
	}

  LOG("****OUT CS_ACTION");

}

defaultproperties
{
     Sprite=Texture'Engine.S_Dispatcher'
     Texture=Texture'CutSequences.CutSequences.S_Move'
}
