//=============================================================================
// CS_DollyPlayer - This will cause the camera to dolly around the player who
// triggered the CS Engine.
//=============================================================================
class CS_DollyPlayer expands CutSeq;

#exec Texture Import File=Textures\movie.pcx Name=S_Move Group=CutSequences Mips=Off Flags=2

var() Vector DollyVelocity;

function Trigger(actor Other, pawn EventInstigator)
{

 	local CS_Camera C;
	 	
 	LOG("****IN CS_DOLLYPLAYER");
 	
	// Find the camera.

 	foreach ALLActors(class'CS_Camera',c,self.Event)
 	{ 
 	    LOG("CS_DollyPlayer: Found Camera to Lock");

		// Adjust it's settings.

		C.Target = EventInstigator;
		C.bLockedOn = true;
  	    C.Velocity = DollyVelocity;
	    C.SetPhysics(PHYS_Projectile);
		
	}
	
    LOG("****OUT CS_DOLLYPLAYER");
 		
}

defaultproperties
{
     Texture=Texture'CutSequences.CutSequences.S_Move'
}
