@ECHO OFF
REM Quake Server Batch File
REM Author: JakFrost

IF "%1" == "" GOTO HELP

IF "%1" == "qw" GOTO QW
IF "%1" == "QW" GOTO QW
IF "%1" == "wq" GOTO WQ
IF "%1" == "WQ" GOTO WQ
GOTO HELP

:QW
SET QUAKESERVER=QW
IF NOT EXIST QWSV.EXE GOTO NOEXE
QWSV.EXE +rcon_password a -cheats %2 %3 %4 %5 %6 %7 %8 %9
IF ERRORLEVEL 1 GOTO CRASH
GOTO END

:WQ
SET QUAKESERVER=WQ
IF NOT EXIST WINQUAKE.EXE GOTO NOEXE
WINQUAKE.EXE -dedicated 16 %2 %3 %4 %5 %6 %7 %8 %9
IF ERRORLEVEL 1 GOTO CRASH
GOTO END

:CRASH
ECHO 
ECHO Quake Server
ECHO ------------
ECHO ! Error: The server has crashed.
ECHO Time of crash:
DATE /T
TIME /T
ECHO 
ECHO Time of crash: >> CRASH.LOG
DATE /T >> CRASH.LOG
TIME /T >> CRASH.LOG
ECHO  >> CRASH.LOG
GOTO %QUAKESERVER%

:NOEXE
ECHO 
ECHO Quake Server
ECHO ------------
ECHO ! Error: The QWSV.EXE executable file was not found.  Make sure that
ECHO     this batch file is run in the Quake directory.
GOTO END

:HELP
ECHO 
ECHO Quake Server
ECHO ------------
ECHO Author: JakFrost
ECHO Web Site: http://www.planetquake.com/console/
ECHO 
ECHO QS [QW/WQ] (server parameters)
ECHO 
ECHO Parameters:
ECHO    QW - QuakeWorld Server
ECHO    WQ - WinQuake Server
ECHO 
ECHO Example: QS QW +echo Hi
GOTO END

:END
SET QUAKESERVER=
ECHO 
