#define VERSION "1.00"

/*
 -- QDATA Scripter --
 This program generates a QDATA script to convert PCX images to M8
 Heretic2 Textures .. It is meant to be a frontend to EASY creation
 of script files for QDATA .. because they are such a pain in the ass =)

 This program just prints out the script.. so you just pipe it to a text
 file.. that will turn it to a file (I included a batch file to do that
 for you.

 Revision History:
  - 0.90 -
   Initial Release

  - 0.95 (Internal) -
   --> removed the use of aptrings to not infringe possible copyrights
   --> readme.txt touchups =)

  - 1.00 -
   --> not using Allegro library anymore.. (this reduces the size of the exe
       and should be easier on memory)
	   Many thanks to Robin for giving me a hand with the PCX header info
   --> some major code cleanup .. (closed files after opening them.. etc)


*/

/*
This is the PCX header layout..
Byte      Item          Size   Description/Comments
 0         Manufacturer 1      Constant Flag, 10 = ZSoft .pcx
 1         Version      1      Version information
                               0 = Version 2.5 of PC Paintbrush
                               2 = Version 2.8 w/palette information
                               3 = Version 2.8 w/o palette information
                               4 = PC Paintbrush for Windows(Plus for Windows uses Ver 5)
                               5 = Version 3.0 and > of PC Paintbrush and PC Paintbrush +, includes Publisher's Paintbrush . Includes 24-bit .PCX files
 2         Encoding      1     1 = .PCX run length encoding
 3         BitsPerPixel  1     Number of bits to represent a pixel (per Plane) - 1, 2, 4, or 8
 4         Window        8     Image Dimensions: Xmin,Ymin,Xmax,Ymax
12         HDpi          2     Horizontal Resolution of image in DPI*
14         VDpi          2     Vertical Resolution of image in DPI* 
*/


// TO BE COMPILED WITH DJGPP

// ==================================================================================

#include <stdio.h>
#include <fstream.h>
#include <string>

typedef unsigned char byte;
typedef unsigned short word;

// PCX header structure.. declared a lot for future expansion..
struct pcxheader
{
	byte manafacturer; //0
	byte version;      //1
	byte encoding;     //2
	byte bpp;          //3
	word xmin;         //4
	word ymin;         //6
	word xmax;         //8
	word ymax;         //10
	word hres;         //12
	word vres;         //14
}; 

// Functions declared here
word byteflip		( word x );
word getword		( FILE * file );
bool getPCXsize		( string filename , int &height , int &width );
void processlist	( const string & filename );
void readPCXheader	( pcxheader & header , string filename );
void loadCFG		( string &s_spath , string &s_dpath );
void versionfoo		( );
// End of function declares


// ----------------------------------------------------------------------
// this is the main.. duh.. ugly eh?
main()
{
	system( "dir *.pcx /b > pcx.lst" ); // do a system call to do a dir (simplest thing I could think of =)

	versionfoo();
	
	processlist("pcx.lst");
}

// ===== The Rest Of The Functions are below this ======================================

// ----------------------------------------------------------------------
// this is supposed to flip a word..
// eg: AB CD => CD AB
word byteflip ( word x )
{
	byte high	= x>>8;
	byte low	= x&255;
	return ( ( low<<8 ) + high );
}


// ----------------------------------------------------------------------
// this is a rewrite of getw(FILE *) ..
// the getw seemed to grab wrong size words.. so I made one that works
// just right =)
word getword ( FILE * file )
{
	byte low = getc(file);
	byte high = getc(file);
	return ( ( low<<8 ) + high );
}

// ----------------------------------------------------------------------
// reads the pcx header into the header structiure..
void readPCXheader( pcxheader & header , string filename )
{
	FILE * file = fopen ( filename.c_str( ) , "rwb+" );
	header.manafacturer	= getc ( file );
	header.version		= getc ( file );
	header.encoding		= getc ( file );
	header.bpp			= getc ( file );
	// the following words are byteflipped because they are written least
	// significant byte first
	header.xmin			= byteflip ( getword( file ) );
	header.ymin			= byteflip ( getword( file ) );
	header.xmax			= byteflip ( getword( file ) );
	header.ymax			= byteflip ( getword( file ) );
	header.hres			= byteflip ( getword( file ) );
	header.vres			= byteflip ( getword( file ) );
	fclose ( file );
}

// ----------------------------------------------------------------------
// this interprets the data in the pcxheader structure and uses what is needed
bool getPCXsize( string filename , int &height , int &width )
{
	pcxheader	header;
	
	readPCXheader ( header , filename );
	height	= header.ymax - header.ymin + 1;
	width	= header.xmax - header.xmin + 1;
	return( true );
}

// ----------------------------------------------------------------------
// pre: well nada I think .. well the config file is valid
// post: loads the source and dest paths (for use in the script)
void loadCFG( string &s_spath , string &s_dpath )
{
	ifstream in( (char *) "scripter.cfg" );
	if( in.fail() )
	{
		fprintf( stderr , "There was an error opening scripter.cfg ..\n Exiting.." );
		exit( 1 );
	}
	getline( in , s_spath );
	getline( in , s_dpath );
}

// ----------------------------------------------------------------------
// pre: nada
// post: displays the version , other foo about this prog with "//" infront
//       so it is ignored by qdata
void versionfoo()
{
	printf( "//Created with QDATA Scripter Version: %s\n" , VERSION );
}

// ----------------------------------------------------------------------
// this is masicaly the main chunk.. this takes the list of pcx's
// and goes through them 1 by 1 and makes the script file..
void processlist( const string & filename )
{
	int			height,
				width;

	string		s_line,
				s_source,
				s_dest,
                s_spath,
                s_dpath;

	loadCFG( s_spath , s_dpath );

	ifstream in( filename.c_str( ) ); // open the list of pcx's
	if( in.fail() )
	{
		fprintf( stderr , "There was an error opening pcx.lst ..\n Exiting.." );
		exit( 1 );
	}

	getline( in , s_line ); // get first line from list
	while( !in.eof() )
	{
		if(getPCXsize( s_line.c_str() , height , width )) // check if succesfuly loaded. (not implemented yet)
		{
			s_source = s_spath + s_line;  //  put the source path together
			s_dest = s_dpath + s_line.substr( 0 , s_line.length( ) - 4 );  // and the destination
			printf( "$load %s $mip %s 0 0 %i %i\n" , s_source.c_str( ) , s_dest.c_str( ) , width , height ); // now print the formatted string
		}
		else
		{
			fprintf( stderr , "Skipping %s -> The file is a dud\n" , s_line.c_str( ) );
		}
		getline( in , s_line ); // get the next line from the list  
	}

}
