#!/usr/bin/perl

#
# Kroc's Game Server IP Tracker
# rev .000001a  15 Dec 1999

# Author: Ken "Kroc" Kirchner (kenk@shreve.net)

# What it does:   Sorts through a list of IP's and checks for a match against 
#                 a list of class C IP's.  Made for my ISP so we can see how
#                 many of our customers are using our game servers.
#                 Can be made to work for any game server that logs a users
#                 name and IP.  I have it working with all Half-Life mods and
#                 with Quake 2 Lithium.

# Requires:  - Perl 
#            - A list of your class C IP's in a file called ip.lst
#	     - A Half-Life log file with the user IP's on each line

# Init counters and arrays...
$on_net = 0;
$total_connects = 0;
@ip_array = ();

print "\n\n <Your Servername here>'s Daily Game Server Statistics\n\n";
print " List of connected customers:\n";
print "------------------------------------------------------------------------------\n";

# First I read my ISP's list of class C's into the array...
open (IPLIST, "< ip.lst");
while (<IPLIST>) {
      chomp;
      push(@ip_array, $_);
}
close(IPLIST);

# Now I read one line at a time from the parsed log and make a comparison
open(INPUT, "< master.lst");
while(<INPUT>) {

# This is what actually picks the IP out of each line.  It can be modified to work with other
# game server logs that record IP's (Like Quake 2 Lithium).

                $end = substr $_, -23, 15;
                $end =~ /\d/;
                $class_d = "$&$'\n";
                ($a, $b, $c) = split(/\./, $class_d);
                $class_c = "$a.$b.$c";

                foreach $address (@ip_array) {
                        if ($address EQ $class_c){
                            $on_net++;
                            print "Found: $_";  # Show me the user
			    last;
                        }
                }
      $total_connects++;
}
close(INPUT);
if ($total_connects > 0){
   $percentage = ($on_net / $total_connects) * 100;
}

print "------------------------------------------------------------------------------\n";
print "\n Connections from <Your Network Here>: $on_net\n";
print "\t  Total connections: $total_connects\n";
printf "\t\t Percentage: %.2f %\n\n", $percentage;

