// CoolServ.cpp : Defines the class behaviors for the application.
//


// Includes...

#include "stdafx.h"
#include "CoolServ.h"
#include "ShogoServDlg.h"
#include "NetStart.h"
#include "ServerUtils.h"
#include "RezFind.h"
#include "CdStuff.h"


// Macros...

#define IsKeyDown(key)  (GetAsyncKeyState(key) & 0x80000000)


// Debug...

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


// Globals...

ServerInfo		g_ServerInfo;
ServerOptions	g_ServerOptions;
NetGame			g_NetGame;
HINSTANCE		g_hInst = NULL;
BOOL			g_bEmptyExit = FALSE;


// Functions...

/////////////////////////////////////////////////////////////////////////////
// CCoolServApp

BEGIN_MESSAGE_MAP(CCoolServApp, CWinApp)
	//{{AFX_MSG_MAP(CCoolServApp)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG
	ON_COMMAND(ID_HELP, CWinApp::OnHelp)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoolServApp construction

CCoolServApp::CCoolServApp(LPCTSTR lpszAppName) : CWinApp(lpszAppName)
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CCoolServApp object

CCoolServApp theApp("ShogoServ");

CCoolServApp* GetTheApp()
{
	return(&theApp);
}

/////////////////////////////////////////////////////////////////////////////
// CCoolServApp initialization

BOOL CCoolServApp::InitInstance()
{
	AfxEnableControlContainer();

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif


	// Get our instance handle...

	g_hInst = AfxGetInstanceHandle();

	char *pDLLName = "c:\\games\\shogo\\server.dll";
	int i;
	for(i=0; i < (__argc-1); i++)
	{
		if(stricmp(__argv[i], "-DLL") == 0)
		{
			pDLLName = __argv[i+1];
			break;
		}
	}

	// Load the server dll...

	if (!LoadServerDLL(pDLLName))
	{
		AfxMessageBox(IDS_ERROR_LOADSERVER);
		return(FALSE);
	}


	// Get our server interface...

	ServerInterface* pServerMgr = GetServerInterface();
	if (!pServerMgr)
	{
		AfxMessageBox(IDS_ERROR_ACCESSSERVER);
		return(FALSE);
	}


	// Check command-line paramters...

	BOOL bNoDlgs = FALSE;

	char sCmdLine[256];
	strcpy(sCmdLine, theApp.m_lpCmdLine);
	strupr(sCmdLine);

	if (strlen(sCmdLine) > 0 && strstr(sCmdLine, "-GO"))
	{
		bNoDlgs = TRUE;
	}

	if (strlen(sCmdLine) > 0 && strstr(sCmdLine, "-EMPTYEXIT"))
	{
		g_bEmptyExit = TRUE;
	}

	char configFile[256];
	strcpy(configFile, "shogosrv.cfg");

	for (i = 0; i < (__argc-1); i++)
	{
		if (stricmp(__argv[i], "-CONFIG") == 0)
		{
			strncpy(configFile, __argv[i+1], sizeof(configFile));
		}
	}


	// Check for modifier keys...

	Sleep(50);

	if (IsKeyDown(VK_SHIFT))
	{
		bNoDlgs ^= 1;
	}


	// Find our resources...

	FindRezFiles(CD_GetDriveLetterWithGame());

	char* sShogoRez = GetShogoRezFile();

	if (!sShogoRez || sShogoRez[0] == '\0')
	{
		AfxMessageBox(IDS_ERROR_REZFILE);
		return(FALSE);
	}


	// Do the wizard...

	BOOL bRet = NetStart_DoWizard(g_hInst, &g_ServerInfo, &g_ServerOptions, &g_NetGame, bNoDlgs, configFile);
	if (!bRet)
	{
		return(FALSE);
	}


	// Do the main dialog...

	CShogoServDlg dlg;
	m_pMainWnd = &dlg;

	dlg.SetConfigFilename(configFile);
	int nResponse = dlg.DoModal();
	dlg.Clear();

	if (nResponse == IDOK)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with OK
	}
	else if (nResponse == IDCANCEL)
	{
		// TODO: Place code here to handle when the dialog is
		//  dismissed with Cancel
	}


	// Save out all the console variables.
	NetStart_SaveConsoleVars();
	NetStart_SaveConfigFile(configFile);

	// Free the server library...

	FreeServerDLL();


	// Since the dialog has been closed, return FALSE so that we exit the
	//  application, rather than start the application's message pump.

	return FALSE;
}

BOOL CCoolServApp::OnIdle(LONG lCount) 
{
	return CWinApp::OnIdle(lCount);
}


BOOL CCoolServApp::AddResources(CStringList& collRezFiles)
{
	// Add the resources...

	ServerInterface* pServerMgr = GetServerInterface();
	if (!pServerMgr) return(FALSE);

	char* sShogo[128];
	int   i = 0;

	char* sShogoRez = GetShogoRezFile();
	char* sSoundRez = GetSoundRezFile();

	sShogo[i++] = sShogoRez;
	if (sSoundRez && sSoundRez[0] != '\0') sShogo[i++] = sSoundRez;

	sShogo[i++] = "custom";
	sShogo[i++] = "shogop.rez";
	sShogo[i++] = "shogop2.rez";
	sShogo[i++] = "shogop3.rez";
	sShogo[i++] = "shogop4.rez";
	sShogo[i++] = "shogop5.rez";
	sShogo[i++] = "shogop6.rez";
	sShogo[i++] = "shogop7.rez";
	sShogo[i++] = "shogop8.rez";
	sShogo[i++] = "shogop9.rez";
	sShogo[i++] = "shogot.rez";
	sShogo[i++] = "shogol.rez";

	POSITION pos = collRezFiles.GetHeadPosition();

	char sTemps[128][128];

	while (pos)
	{
		CString sRezFile = collRezFiles.GetNext(pos);

		strcpy(sTemps[i], sRezFile);
		sShogo[i] = sTemps[i];

		i++;
	}

	char** sResources = sShogo;
	DBOOL  db;

	{
		CWaitCursor wc;

		db = pServerMgr->AddResources(sResources, i);
	}

	if (db != DTRUE)
	{
		AfxMessageBox(IDS_ERROR_LOADREZ);
		return(FALSE);
	}

	return(TRUE);
}

