// List.h: interface for the List classes.
//
//////////////////////////////////////////////////////////////////////
#ifndef __CLinkedList__
#define __CLinkedList__

#include "server_interface.h"
#include "Node.h"
#define KICK_TIME 50
#define MAX_PNAME_SIZE 30

class CPlayerList
{
public:
	CPlayerList();
	virtual ~CPlayerList();
	void AddNode(char *NewName);
	void DeletePlayer(char *Name);
	void PurgeList();
	DBOOL CreateFromFile(const char *FilePath);
	DBOOL FindPlayer(char *Name);

private:
	void DeleteNode(CName *ThisName);
	CName *m_CurrentPlayer;
	CName *ListHead, *ListTail;
	DBOOL m_bIsEmpty;
};

class CKickList  
{
public:
	CKickList();
	virtual ~CKickList();
	void AddNode(char *NewName, DWORD nPlayerId);
	void KickPlayers(int nTime);
	void ActiveServer(ServerInterface *Server);
	void PurgeList();
	DBOOL FindPlayer(char *Name);

private:
	CNode *m_CurrentNode;
	CNode *ListHead, *ListTail;
	DBOOL m_bIsEmpty;
	void DeleteNode(CNode *ThisNode);
	ServerInterface* m_pServer;

};
#endif