// Node.h: interface for the CNode class.
//
//////////////////////////////////////////////////////////////////////
#include "ServerUtils.h"
#include "NetDefs.h"

#ifndef __CNode__
#define __CNode__

class CNode  
{
friend class CKickList;

public:
	CNode();
	virtual ~CNode();
	DBOOL EOL(){return m_bEOL;};
	DBOOL BOL(){return m_bBOL;};
	const char *PlayerName(){return m_sPlayerName;};
	DWORD PlayerHandle(){return m_nId;};

private:
	DBOOL m_bEOL, m_bBOL;
	char *m_sPlayerName;
	DWORD m_nId;
	int m_nTicks;
	CNode *Next, *Prev;
	void SetPlayerName(const char *NewName);

};

class CName
{
friend class CPlayerList;

public:
	CName();
	virtual ~CName();
	const char *PlayerName(){return m_sPlayerName;};

private:
	char *m_sPlayerName;
	void SetName(const char *NewName);
	DBOOL m_bEOL, m_bBOL;
	CName *Next, *Prev;

};
#endif