// ---------------------------------------------------------------------------
// am_armor.cs -- Version 2.2 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\am_armor.cs", "2.2", "Lorne Laliberte", "- May 22, 1999 - notify team what armor you're wearing - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\inventory_table.cs");
include("writer\\station_events.cs");
include("writer\\whatif.cs");
if(include("presto\\schedule.cs") == notfound)
    include("writer\\schedule.cs");


//
// Notify team whenever you change armor
//
function AutoMessage::CheckArmor()
{
    %armortype = %armorname = "";

    // What armor are we wearing?
    for(%i = $Inv::ArmorCount; %i > 0; %i--)
    {
        if(getItemCount(%armorname = $Inv::Name[%armortype = $Inv::ArmorList[%i]]))
            break;
    }

    if(($AutoMessage::prevArmor != %armortype) || (($FastFaves::actualLoadout != "") && ($FastFaves::actualLoadout != $AutoMessage::prevLoadout)))
    {
        $AutoMessage::prevArmor = %armortype;
        $AutoMessage::prevLoadout = $FastFaves::actualLoadout;
        schedule::add("say(1, \"Wearing " @ %armorname @ wif($FastFaves::actualLoadout == "", "", " - " @ $FastFaves::actualLoadout) @ "\");", 2.0, wearing_armor_message);
    }

    return;
}
Event::Attach(eventExitInventoryStation, "AutoMessage::CheckArmor();");
