// ---------------------------------------------------------------------------
// am_power_down.cs -- Version 1.7 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// Inspired by Plague's notifypowerdown.cs script
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\am_power_down.cs", "1.7", "Lorne Laliberte", "- May 22, 1999 - notify team when power is down - www.planetstarsiege.com/lorne/");

include("writer\\station_events.cs");
include("writer\\ladder.cs");
include("writer\\flood.cs");


function AutoMessage::PowerIsDown()
{
    // Tell teammates power is down if we haven't already done so in the last 30 seconds
    if(Flood::protect("Unit is not powered", 30))
        say(1, "Our Power is Down!~job:need-rep-gen~wneedrep"); // only visible to teammates

    // Set flag to enable eventPowerRestored
    $PowerWasDown = true;

    return;
}
Event::Attach(eventPowerIsDown, AutoMessage::PowerIsDown);


function AutoMessage::PowerRestored()
{
    say(1, "Our Power is Back Up!~wthanks"); // only visible to teammates

    $PowerWasDown = false;
    return;
}
Event::Attach(eventPowerRestored, AutoMessage::PowerRestored);


//
// Prevent us from repeating the "power is up" message if someone else
// is running an equivalent script and finds out first
//
function AutoMessage::TheySayPowerIsUp(%msg)
{
    if(String::findSubStr(%msg, "Power is Back Up") != -1)
    {
        $PowerWasDown = false;
        return true;
    }

    if($PowerWasDown)
    {
        if(String::findSubStr(%msg, "has been repaired!") != -1)
        {
            if(String::findSubStr(%msg, "Generator") != -1)
            {
                say(1, "Thanks for restoring power!~wthanks"); // only visible to teammates

                $PowerWasDown = false;
                return true;
            }
            if(String::findSubStr(%msg, "Solar Panel") != -1)
            {
                say(1, "Thanks for restoring power!~wthanks"); // only visible to teammates

                $PowerWasDown = false;
                return true;
            }
        }
        if(String::findSubStr(%msg, "repairs completed on ") != -1)
        {
            if(String::findSubStr(%msg, "Generator") != -1)
            {
                say(1, "Thanks for restoring power!~wthanks"); // only visible to teammates
    
                $PowerWasDown = false;
                return true;
            }
            if(String::findSubStr(%msg, "Solar Panel") != -1)
            {
                say(1, "Thanks for restoring power!~wthanks"); // only visible to teammates
    
                $PowerWasDown = false;
                return true;
            }
        }
        if(String::findSubStr(%msg, "finished repairs on ") != -1)
        {
            if(String::findSubStr(%msg, "Generator") != -1)
            {
                say(1, "Thanks for restoring power!~wthanks"); // only visible to teammates
    
                $PowerWasDown = false;
                return true;
            }
            if(String::findSubStr(%msg, "Solar Panel") != -1)
            {
                say(1, "Thanks for restoring power!~wthanks"); // only visible to teammates
    
                $PowerWasDown = false;
                return true;
            }
        }
    }
    return false;
}
Event::Attach(ladderOtherPlayerMessage, AutoMessage::TheySayPowerIsUp);
