// ---------------------------------------------------------------------------
// am_station_down.cs -- Version 1.3 -- April 17, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// Inspired by XP-Lux's Repair.cs
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\am_power_down.cs", "1.3", "Lorne Laliberte", "- April 17, 1999 - notify team when a station is down - www.planetstarsiege.com/lorne/");

include("writer\\inventory_table.cs");
include("writer\\station_events.cs");
include("writer\\flood.cs");

//
// Notify your teammates when you learn a station is down and you aren't
// carrying a repair pack
//
function AutoMessage::StationIsDown()
{
    if(getMountedItem(1) != $Inv::Repair_Pack)
    {
        // Tell teammates a station is down if you haven't already done so in the last 30 seconds
        if(Flood::protect("Unit is disabled", 30))
            say(1, "Stations need repairs!~job:need-rep-stat~wneedrep"); // only visible to teammates
    }
    return;
}
Event::Attach(eventStationDisabled, AutoMessage::StationIsDown);
