// ---------------------------------------------------------------------------
// autoexec.cs -- Version 3.1 -- May 23, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


// Put this file in Tribes\config\writer along with the rest of my scripts
// and call it from your own autoexec.cs in Tribes\config with the following line:
// exec("writer\\autoexec.cs");


// Set this to true to turn on extra debug info in all my scripts that support
// it -- I keep this set to false most of the time to avoid any unnecessary
// overhead.
$Debug::echo = false;


exec("writer\\include.cs"); // must be executed first!
include("writer\\version.cs");
version("writer\\autoexec.cs", "3.1", "Lorne Laliberte", "- May 22, 1999 - calls Writer's scripts - www.planetstarsiege.com/lorne/");


//----------------------------------------------------------------------------

// And now...The Scripts!

// Additional support scripts will be included from these scripts as required,
// see the individual script files for details.

//----------------------------------------------------------------------------

// Override Cowboy's mHUD to use my weapon switch events instead of the schedule loop
include("writer\\mHUD_mod.cs");

//----------------------------------------------------------------------------

// If you want to change the key bindings for any of my scripts, change the settings
// in Tribes\config\writer\keys.cs.
//
// To return to my defaults, simply comment out the next include line :)

// Override my default key settings with your own settings
include("writer\\keys.cs");

//----------------------------------------------------------------------------

// Automatically switch weapon when empty
include("writer\\ammo_check.cs");

//----------------------------------------------------------------------------

// Announce what armor you're wearing after you exit a station
include("writer\\am_armor.cs");

//----------------------------------------------------------------------------

// Announce what you're carrying when you leave a station, and what you've
// deployed when you deploy a deployable item
include("writer\\am_deploy.cs");

//----------------------------------------------------------------------------

// Notify team when power is down
include("writer\\am_power_down.cs");

//----------------------------------------------------------------------------

// Announce repairs -- also supports mmb_repair.cs
include("writer\\am_repair.cs");

//----------------------------------------------------------------------------

// Notify team when station needs repairs
include("writer\\am_station_down.cs");

//----------------------------------------------------------------------------

// Thank other players for repairing you
include("writer\\am_thanks.cs");

//----------------------------------------------------------------------------

// Automatically use a repair kit when you pick one up -- and adds a taunt key :)
include("writer\\auto_repair_kit.cs");

//----------------------------------------------------------------------------

// Toggle crouch mode on/off
include("writer\\crouch_toggle.cs");

//----------------------------------------------------------------------------

// Assign up to 4 weapons to each number key! -- recommended/required by some
// of my scripts
include("writer\\custom_weapons.cs");

//----------------------------------------------------------------------------

// Drop all carried unnecessary ammo
include("writer\\drop_ammo.cs");

//----------------------------------------------------------------------------

// The famous Fast Favorites script!
include("writer\\fast_favorites.cs");

//----------------------------------------------------------------------------

// Toggle automatically saying "Fire on my target" on/off
include("writer\\fire_on_my_target.cs");

//----------------------------------------------------------------------------

// The famous Keep Jumping While Key Held Down script!
include("writer\\jump.cs");

//----------------------------------------------------------------------------

// Toggle "keep moving on key tap" mode on/off
include("writer\\keep_moving.cs");

//----------------------------------------------------------------------------

// Play a sound when the energy bar reaches full charge,
// and show a miniature energy bar next to your crosshair
// whenever the laser rifle is in use
include("writer\\laser_ready.cs");

//----------------------------------------------------------------------------

// Quickly toss items from an inventory station for you and
// your teammates to pick up
include("writer\\litterbug.cs");

//----------------------------------------------------------------------------

// Pack a whole lotta features onto your middle mouse button,
// including automatically switching back to your previous weapon
// when you complete a repair
include("writer\\mmb_repair.cs");

//----------------------------------------------------------------------------

// Switch between the repair pack and your current weapon with a
// single key -- also supports mmb_repair.cs
include("writer\\pack_and_back.cs");

//----------------------------------------------------------------------------

// Dance some evasive maneuvers while you're away or in the PDA
include("writer\\pda_dance.cs");

//----------------------------------------------------------------------------

// Automatically increase your mouse sensitivity when you're piloting
include("writer\\pilot_mode.cs");

//----------------------------------------------------------------------------

// A "continuous" smooth zoom at any time -- probably requires zoom.cs
include("writer\\smooth_zoom.cs");

//----------------------------------------------------------------------------

// Throw all or individual grenades/mines, and display a "power bar"
// to help guage how far you will throw them
include("writer\\tap_throw.cs");

//----------------------------------------------------------------------------

// Display the current zoom level on the screen
include("writer\\xHUD.cs");

//----------------------------------------------------------------------------

// Toggle zoom mode on/off, toggle zoom rollover on/off, other nifty features
include("writer\\zoom.cs");

//----------------------------------------------------------------------------


// Important -- this must go last!
if(included("writer\\keys.cs"))
    Writer::bindKeys();
