// ---------------------------------------------------------------------------
// sensitivity.cs -- Version 1.30 -- May 12, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\sensitivity.cs", "1.20", "Lorne Laliberte", "- May 12, 1999 - mouse sensitivity functions - www.planetstarsiege.com/lorne/");

include("writer\\do_nothing.cs");
include("writer\\event.cs");
include("writer\\jump.cs");

$Sensitivity::Normal        = Client::getMouseSensitivity("playMap.sae");

$Sensitivity::Min           = 0.00001; // minimum sensitivity
$Sensitivity::Max           = 0.0260; // maximum sensitivity

$Sensitivity::ChangeStep    = 0.00001; // amount to change sensitivity by each step
$Sensitivity::ChangeDelay   = 0.04; // seconds to delay between steps


//
// Set mouse sensitivity to given value
//
function setSensitivity(%sensitivity)
{
    if(Client::getMouseXaxisFlip("playMap.sae"))
    {
    	EditActionMap("playMap.sae");
    	bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Scale, %sensitivity);
    }
    else
    {
    	EditActionMap("playMap.sae");
    	bindAction(mouse0, xaxis0, TO, IDACTION_YAW, Flip, Scale, %sensitivity);
    }

    if(Client::getMouseYaxisFlip("playMap.sae"))
    {
    	EditActionMap("playMap.sae");
	    bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Scale, %sensitivity);
    }
    else
    {
    	EditActionMap("playMap.sae");
	    bindAction(mouse0, yaxis0, TO, IDACTION_PITCH, Flip, Scale, %sensitivity);
    }
}


//
// Restore normal mouse sensitivity as defined by $Sensitivity::Normal
//
function RestoreSensitivity()
{
    SetSensitivity($Sensitivity::Normal);
}


//
// Increase sensitivity while key held down
//
function IncreaseSensitivity_key(%make)
{
    if(%make) // Key Pressed
    {
        // Start increasing
        $Sensitivity::KeepIncreasing = 1;
        IncreaseSensitivity();
    }
    else // Key released
    {
        // Stop increasing
        $Sensitivity::KeepIncreasing = 0;
    }
}


//
// Decrease sensitivity while key held down
//
function DecreaseSensitivity_key(%make)
{
    if(%make) // Key Pressed
    {
        // Start decreasing
        $Sensitivity::KeepDecreasing = 1;
        DecreaseSensitivity();
    }
    else // Key released
    {
        // Stop decreasing
        $Sensitivity::KeepDecreasing = 0;
    }
}


function IncreaseSensitivity()
{
    if($Sensitivity::KeepIncreasing)
    {
        // Increase sensitivity by another step
        %sensitivity = Client::getMouseSensitivity("actionMap.sae") + $Sensitivity::ChangeStep;

        if(%sensitivity >= $Sensitivity::Max)
        {
            // We've overshot our maximum sensitivity, so
            // set sensitivity to the max and stop increasing

            %sensitivity = $Sensitivity::Max;
            $Sensitivity::KeepIncreasing = 0;        
        }
        else
        {
            // Call IncreaseSensitivity() again after our step delay
            schedule("IncreaseSensitivity();", $Sensitivity::ChangeDelay);
        }

        SetSensitivity(%sensitivity);
        
    	remoteBP(2048, "<L5>Increasing Mouse Sensitivity ( " @ %sensitivity @ " )", 3); 
    }
}


function DecreaseSensitivity()
{
    if($Sensitivity::KeepDecreasing)
    {
        %sensitivity = Client::getMouseSensitivity("actionMap.sae") - $Sensitivity::ChangeStep;

        if(%sensitivity <= $Sensitivity::Min)
        {
            // We've undershot our minimum sensitivity, so
            // set sensitivity to the minimum and stop increasing
            
            %sensitivity = $Sensitivity::Min;
            $Sensitivity::KeepDecreasing = 0;
        }
        else
        {
            // Call IncreaseSensitivity() again after our step delay
            schedule("DecreaseSensitivity();", $Sensitivity::ChangeDelay);
        }

        SetSensitivity(%sensitivity);
        
    	remoteBP(2048, "<L5>Decreasing Mouse Sensitivity ( " @ %Sensitivity @ " )", 3);
    }
}


// Example bindings
EditActionMap("playMap.sae"); 

// Increase mouse sensitivity
bindCommand(keyboard0, make, "=", TO, "IncreaseSensitivity_key(1);");
bindCommand(keyboard0, break, "=", TO, "IncreaseSensitivity_key(0);");

// Restore normal mouse sensitivity
bindCommand(keyboard0, make, shift, "=", TO, "RestoreSensitivity();");
bindCommand(keyboard0, make, shift, "-", TO, "RestoreSensitivity();");

// Decrease mouse sensitivity
bindCommand(keyboard0, make, "-", TO, "DecreaseSensitivity_key(1);");
bindCommand(keyboard0, break, "-", TO, "DecreaseSensitivity_key(0);");
