// ---------------------------------------------------------------------------
// fast_favorites.cs -- Version 5.5 -- May 25, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\fast_favorites.cs", "5.5", "Lorne Laliberte", "- May 25, 1999 - buy favorite items quickly - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\item_events.cs");
include("writer\\station_events.cs");
include("writer\\ladder.cs");
include("writer\\inventory_table.cs");
include("writer\\ping.cs");
include("writer\\queue.cs");
include("writer\\whatif.cs");
include("writer\\do_nothing.cs");
if(include("presto\\schedule.cs") == notfound)
    include("writer\\schedule.cs");


// IMPORTANT! Read this through before enabling the AllowAssignment flags!
//
// Set any of these to true to enable in-game selection of favorites 
// for that numeric keypad + modifier combination.
//
// $FastFaves::AllowAssignment is for numeric keypad keys with no modifiers,
// $FastFaves::AllowAssignment[control] is for numeric keypad keys when the
// control key is held down, etc.
//
// Note that setting one of these flags to true will cause all the numeric
// keypad keys (with that modifier) to be bound to a FastFavorites() call.
//
// This is required so the script can detect when you've pressed one of the
// numeric keypad + modifier combinations when in Assignment mode.
//
// Once you've assigned your current loadout to a favorites key, that loadout
// will get appended to Tribes\config\addedfaves.cs, to help you modify your
// personal favorites.cs file (which is the only way you can assign a name to
// a loadout, and the only way you can assign individual items or vehicles to
// a modifer + key combination.
//
// Your current fast favorites key settings will alse be saved to
// Tribes\config\autofaves.cs, which will override the settings
// in favorites.cs.
//
// This assignment feature is intended only to help you modify your
// favorites.cs file.  It is meant to give you some cut-and-paste
// material whenever you want to add a new loadout, or you aren't sure
// what the $Inv:: variable name for a mod weapon is, etc.

$FastFaves::AllowAssignment          = false;
$FastFaves::AllowAssignment[control] = false;
$FastFaves::AllowAssignment[alt]     = false;
$FastFaves::AllowAssignment[shift]   = false;


// Set this to true to automatically buy the currently selected loadout
// as soon as you access an inventory station
$FastFaves::AutoBuyLoadout = true;


// Set this to true if you want to show the weapons when pre-selecting
// a loadout by default (you can toggle this with ALT-L in the game
$FastFaves::ShowPreloadWeapons = false;


//
// MUTING:
//
// Set this to true if you don't want to see the white "To many weapons for <armor> to carry" messages
// (And hey Dynamix, it's "Too" not "To" :)
$FastFaves::Mute::ToManyWeapons = true;



// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


function FastFaves::toggleAssignmentMode()
{
    $FastFaves::Assign = !$FastFaves::Assign;

    if($FastFaves::Assign)
    {
        if( $FastFaves::AllowAssignment ||
            $FastFaves::AllowAssignment[control] ||
            $FastFaves::AllowAssignment[alt] ||
            $FastFaves::AllowAssignment[shift] )
        {
            remoteBP(2048, "<L5><f1>Fast Favorites Assignment Mode <f2>ON<f0>\n"
                       @ "\n<L5>Your current loadout will be assigned to the next numeric keypad"
                       @ "\n<L5>key + modifier combination you press, and your current favorites"
                       @ "\n<L5>will be saved to Tribes\\config\\autofaves.cs -- they will be loaded"
                       @ "\n<L5>automatically next time you join a game.  To undo these changes,"
                       @ "\n<L5>you will have to either edit or delte the autofaves.cs file.\n"
                       @ "\n<L5>The following keys will be recognized:\n<f1>"
                       @ wif($FastFaves::AllowAssignment, "\n<L5>numeric keypad keys with no modifier", "")
                       @ wif($FastFaves::AllowAssignment[control], "\n<L5>numeric keypad keys + CONTROL", "")
                       @ wif($FastFaves::AllowAssignment[alt], "\n<L5>numeric keypad keys + ALT", "")
                       @ wif($FastFaves::AllowAssignment[shift], "\n<L5>numeric keypad keys + SHIFT", ""), 30);
        }
        else
        {
            $FastFaves::Assign = false;
            remoteBP(2048, "<L5><f1>Fast Favorites Assignment Mode <f2>NOT AVAILABLE<f0>\n"
                       @ "\n<L5>You must set at least one $FastFaves::AllowAssignment"
                       @ "\n<L5>flag to \"true\" in fast_favorites.cs for the assignment"
                       @ "\n<L5>mode to work.", 30);
        }
    }
    else
    {
        remoteBP(2048, "<L5>Fast Favorites Assignment Mode <f2>OFF", 5);
    }
}

function FastFaves::setFavorite(%modifier, %key)
{
    // Erase any current settings for this key
    $FastFaves::key[%modifier, %key, armor]   = 
    $FastFaves::key[%modifier, %key, pack]    = 
    $FastFaves::key[%modifier, %key, weapon1] = 
    $FastFaves::key[%modifier, %key, weapon2] = 
    $FastFaves::key[%modifier, %key, weapon3] = 
    $FastFaves::key[%modifier, %key, weapon4] = 
    $FastFaves::key[%modifier, %key, weapon5] = 
    $FastFaves::key[%modifier, %key, weapon6] = 
    $FastFaves::key[%modifier, %key, vehicle] = "";

    FastFaves::VerifyLoadout();

    $FastFaves::key[%modifier, %key, loadout] = " ";
    $FastFaves::key[%modifier, %key, armor]   = Inv::makename($FastFaves::actualArmor);
    $FastFaves::key[%modifier, %key, pack]    = Inv::makename($FastFaves::actualPack);
    $FastFaves::key[%modifier, %key, exit]    = false;

    // Build list of weapons carried, separated by spaces
    %weapons = FastFaves::actualWeapons(" ");

    %mounted = getMountedItem(0);
    
    %i = 1;
    while( (%weapon[%i] = getWord(%weapons, %i)) != -1)
    {
        if(%weapon[%i] == %mounted)
        {
            if(%i > 1)
            {
                %weapon[%i] = %weapon1;
                %weapon1 = %mounted;
            }
        }
        %i++;
    }

    $FastFaves::key[%modifier, %key, weapon1] = %weapon1;
    $FastFaves::key[%modifier, %key, weapon2] = %weapon2;
    $FastFaves::key[%modifier, %key, weapon3] = %weapon3;
    $FastFaves::key[%modifier, %key, weapon4] = %weapon4;
    $FastFaves::key[%modifier, %key, weapon5] = %weapon5;
    $FastFaves::key[%modifier, %key, weapon6] = %weapon6;

    export("$FastFaves::key" @ %modifier @ "_" @ %key @ "_*", "config\\addedfaves.cs", true); // append
    echo("config\\addedfaves.cs file saved!");
}


function FastFaves::saveFavorites()
{
    export("$FastFaves::key*", "config\\autofaves.cs", false); // overwrite
    echo("config\\autofaves.cs file saved!");
}


//
// Set up the actual favorites settings
//
function FastFaves::setupFavorites()
{
    if(include("favorites.cs", force) == notfound)
        include("writer\\favorites.cs", force);

    // Override with autofaves.cs if one has been created
    include("autofaves.cs", force);

    Event::Trigger(eventFavoritesInitialized);
}
Event::Attach(eventInventoryTableReady, "FastFaves::setupFavorites();");


// Use default favorites after connecting to a game -- great idea Cowboy!
Event::Attach(eventFavoritesInitialized, "FastFavorites($FastFaves::defaultModifier, $FastFaves::defaultKey);");

// Get rid of the mouse pointer bug?
Event::Attach(eventExitStation, "cursorOff(MainWindow);schedule(\"cursorOff(MainWindow);\", 1);");

//
// Quickly (!! :) select favorite items from inventory station
//
// (This is what gets called when you press one of the fast favorites key combos.)
//
function FastFavorites(%modifier, %key)
{
    if(%key == "")
    {
        %key = %modifier;
        %modifier = "";
    }

    if($FastFaves::Assign)
    {
        FastFaves::setFavorite(%modifier, %key);
        FastFaves::saveFavorites();
        
        %text = "<f0><L5>Current loadout assigned to <f2>" @ %modifier @ wif(%modifier == "", "<f0>-<f2>", " ") @ %key
          @ "\n\n<f0><l5>Current favorites saved to Tribes\\config\\autofaves.cs";

        remoteBP(2048, %text, 10);
        
        $FastFaves::Assign = false;
        return;
    }


    $FastFaves::modifier = %modifier;
    $FastFaves::key = %key;

    if($Station::AtInventoryStation)
    {
        if($FastFaves::Handling) // we're not waiting for a previous purchase to arrive
        {
            schedule::add("FastFavorites($FastFaves::modifier,$FastFaves::key);", 0.2, FastFavorites);
        }
        else // we're still waiting for a previous purchase to arrive
        {
            Queue::push(FastFavesModifier, %modifier);
            Queue::push(FastFavesKey, %key);
        }
    }
    else // we're not at an inventory station (selecting favorites in advance)
    {
        FastFaves::doKey(%modifier, %key);
    }
}

//
// The next step after FastFavorites...this might get called again if
// the first attempt doesn't work
//
function FastFaves::doKey(%modifier, %key)
{
    // Set flag to queue any other purchases until this one is done
    $FastFaves::Handling = true;

    // Wait until the last purchase has been received before switching weapons
    // (this isn't perfect but it's close enough :)
    $FastFaves::WeaponSwitch = false;


    // Now, are we buying one item, or many?

    %itemlist = $FastFaves::key[%modifier, %key, armor] @ " "
              @ $FastFaves::key[%modifier, %key, pack] @ " "
              @ $FastFaves::key[%modifier, %key, weapon1] @ " "
              @ $FastFaves::key[%modifier, %key, weapon2] @ " "
              @ $FastFaves::key[%modifier, %key, weapon3] @ " "
              @ $FastFaves::key[%modifier, %key, weapon4] @ " "
              @ $FastFaves::key[%modifier, %key, weapon5] @ " "
              @ $FastFaves::key[%modifier, %key, weapon6];

    if(getWord(%itemlist, 1) != -1) // we're buying many items
    {
        // More than one item requested, so use buyFavorites
        FastFaves::Loadout( $FastFaves::key[%modifier, %key, loadout],
                            $FastFaves::key[%modifier, %key, armor],
                            $FastFaves::key[%modifier, %key, pack],
                            $FastFaves::key[%modifier, %key, weapon1],
                            $FastFaves::key[%modifier, %key, weapon2],
                            $FastFaves::key[%modifier, %key, weapon3],
                            $FastFaves::key[%modifier, %key, weapon4],
                            $FastFaves::key[%modifier, %key, weapon5],
                            $FastFaves::key[%modifier, %key, weapon6]
                          );
    }
    else // we're buying a single item
    {
        if($FastFaves::key[%modifier, %key, pack] != "") // check for most common one first
        {
            FastFaves::BuyPack($FastFaves::key[%modifier, %key, pack], $FastFaves::key[%modifier, %key, loadout]);
        }
        else if($FastFaves::key[%modifier, %key, armor] != "")
        {
            FastFaves::BuyArmor($FastFaves::key[%modifier, %key, armor], $FastFaves::key[%modifier, %key, loadout]);
        }
        else if($FastFaves::key[%modifier, %key, weapon1] != "")
        {
            FastFaves::BuyWeapon($FastFaves::key[%modifier, %key, weapon1], $FastFaves::key[%modifier, %key, loadout]);
        }
        else if($FastFaves::key[%modifier, %key, vehicle] != "")
        {
            FastFaves::BuyVehicle($FastFaves::key[%modifier, %key, vehicle]);
        }
    }

    // Automatically exit the station?
    if( $FastFaves::key[%modifier, %key, exit] || $pref::noEnterInvStation)
        remoteEval(2048, PlayMode);

    // This is a little weird; if our buyItem or buyFavorites request is made before a
    // previous request has finished, the new request will be lost.  So, let's assume
    // this is the case, and prepare to make the same request again in 0.3 seconds.
    // This is a magic number I have determined as the shortest interval that will work
    // on fast servers.  (Slow servers are taken care of by the Ping::Wait call that follows.)

    if($Station::AtInventoryStation)
        schedule::add("FastFaves::redoKey();", 0.3);
}

//
// Try to buy the favorites again if the first attempt was "lost"
//
function FastFaves::redoKey()
{
    // Only try again if we're still waiting for the request to finish,
    // and remember the ping ID so we can cancel the Ping::Wait function call
    // if the request beats the lag delay.

    if($FastFaves::Handling)
        $FastFaves::PingID = Ping::Wait("FastFaves::doKey($FastFaves::modifier, $FastFaves::key);");
}


//
// This loops whenever (and as long as) we're at an inventory station
//
function FastFaves::ScheduleLoop()
{
    if($Station::AtInventoryStation)
    {
        if(Queue::count(FastFavesKey)) // we have queued purchase requests pending
        {
            // (Queue::flush empties the queue and returns the last item from it)

            %modifier = Queue::flush(FastFavesModifier);
            %key = Queue::flush(FastFavesKey);
            FastFaves::doKey(%modifier, %key);
        }
        else
        {
            // Verify what items we're actually carrying, and display an
            // accurate loadout message
            FastFaves::VerifyLoadout();

            // If the request involves a weapon switch and we're not still waiting for
            // the request (or another request)...
            if($FastFaves::SwitchWeapon && !$FastFaves::Handling)
            {
                $FastFaves::SwitchWeapon = false;

                // Get current weapon
                %weapon = getMountedItem(0);

                if(%weapon != $FastFaves::Weapon1) // we're not already using the desired weapon
                {
                    if(getItemCount($Inv::Name[$FastFaves::Weapon1])) // did we manage to buy it?
                    {
                        // Switch to first weapon in loadout
                        // A delay is required to prevent the weapon from firing sometimes, probably
                        // due to colliding calls (i.e. useItem trying to execute at the same time as something else)
                        schedule::add("newuseItem("@ $FastFaves::Weapon1 @");", 0.25, newuseitem);
                    }
                    else
                    {
                        // Switch to next available weapon
                        schedule::add("nextWeapon();", 0.25);
                    }
                }
            }
        }

        // This flag gets cleared when we exit the inventory station
        if($FastFaves::Loop)
            schedule("FastFaves::ScheduleLoop();", 0.2);
    }
}
Event::Attach(eventEnterInventoryStation, "$FastFaves::Loop = true; FastFaves::ScheduleLoop();");
Event::Attach(eventExitInventoryStation, "$FastFaves::Loop = false; $FastFaves::Handling = false;");


//
// Reset stuff
//
Event::Attach(eventConnected, "$FastFaves::Loop = false; $FastFaves::Handling = false; $FastFaves::PingID = 0;");
Event::Attach(eventChangeMission, "$FastFaves::Loop = false; $FastFaves::Handling = false; $FastFaves::PingID = 0;");


//
// Watch for messages passed to onClientMessage
//
function FastFaves::ladderClientMessage(%msg)
{
    if($Station::AtInventoryStation)
    {
        if(%msg == "")
        {
            // A blank message is sent to onClientMessage when we've
            // received what we bought...note that if the message was
            // "You could not buy whatever" this test prevents the
            // loadout message from being updated with erroneous info

            if($FastFaves::PingID) // we may still have a Ping::Wait pending
            {
                // Cancel the Ping::Wait, if it isn't too late
                Ping::cancel($FastFaves::PingID);
                $FastFaves::PingID = 0;
            }

            // Cancel the schedule if we're REALLY early :)
            schedule::cancel("FastFaves::redoKey();");

            // It's now safe to try another request.  Honest. :)
            $FastFaves::Handling = false;

            // We can try to switch weapons now too...
            $FastFaves::SwitchWeapon = true;

            return true;
        }
        else if(String::findSubStr(%msg, "You couldn't buy") != -1)
        {
            // What couldn't we buy?
            %item = String::getSubStr(%msg, 17, 1024);

            // Don't stop ladderClientMessage on these so the functions
            // in ping.cs can get them :)
            if(%item == "false")
                return false;
            else if(%item == "flag")
                return false;

            // Hide the messages generated by FastFaves::AutoBuy
            // when it tries to buy these items automatically and
            // they are already in the player's inventory
            if(%item == "Repair Kit")
                return truemute;
            else if(%item == "Grenade")
                return truemute;
            else if(%item == "Mine")
                return truemute;
            else if(%item == "Beacon")
                return truemute;

            return true;
        }
        else if(String::findSubStr(%msg, "To many weapons for ") != -1)
        {
            if($FastFaves::Mute::ToManyWeapons) // Dynamix' typo, not mine :)
                return truemute;
                
            return true;
        }
    }
    return false;
}
Event::Attach(ladderClientMessage, FastFaves::ladderClientMessage);


//
// Buy (or plan to buy) a vehicle
//
function FastFaves::BuyVehicle(%item)
{
    if($Station::AtVehicleStation)
    {
        $FastFaves::Vehicle = %item;
        remoteEval(2048, buyItem, %item);
    }
    else if(!$Station::AtInventoryStation)
    {
        $FastFaves::Vehicle = %item;
        remoteBP(2048, "<L5>Will buy:		<f1>" @ $Inv::Name[$FastFaves::Vehicle], 5);
    }
}


//
// Buy (or plan to buy) a pack
//
function FastFaves::BuyPack(%item, %loadout)
{
    if($Station::AtInventoryStation)
    {
        $FastFaves::Pack = %item;
        $FastFaves::Loadout = %loadout;

        remoteEval(2048, buyItem, %item);
    }
    else
    {
        if($FastFaves::Pack != %item)
        {
            $FastFaves::Loadout = %loadout;

            if($FastFaves::Pack == $Inv::Energy_Pack) // we were carrying an energy pack,
            {
                // Update the weapon list in case we were carrying a laser rifle -- it gets sold
                // when we replace the energy pack with a different pack
                for(%w = 1; %w <= 6; %w++)
                {
                    if($FastFaves::Weapon[%w] == $Inv::Laser_Rifle)
                    {
                        $FastFaves::Weapon[%w] = "";

                        $FastFaves::Weapons = FastFaves::weaponList();

                        break;
                    }
                }
            }
            $FastFaves::Pack = %item;
        }
        FastFaves::PreloadMessage();
    }
}

//
// Buy (or plan to buy) armor
//
function FastFaves::BuyArmor(%item, %loadout)
{
    if($Station::AtInventoryStation)
    {
        $FastFaves::Armor = %item;
        $FastFaves::loadout = %loadout;
        remoteEval(2048, buyItem, %item);
    }
    else
    {
        if($FastFaves::Armor != %item)
        {
            $FastFaves::loadout = %loadout;
            $FastFaves::Armor = %item;
        }
        FastFaves::PreloadMessage();
    }
}


//
// Buy (or plan to buy) weapon and select it automatically once bought
// if you don't already have this weapon
//
function FastFaves::BuyWeapon(%item)
{
    if($Station::AtInventoryStation)
    {
        for(%i = 1;  %i <= 6; %i++)
        {
            if(%item == $FastFaves::Weapon[%i])
                return;
        }
        $FastFaves::Weapon1 = %item;
        $FastFaves::loadout = %loadout;
        remoteEval(2048, buyItem, %item);
    }
    else
    {
        for(%i = 1;  %i <= 6; %i++)
        {
            if(%item == $FastFaves::Weapon[%i])
            {
                FastFaves::PreloadMessage();
                return;
            }
        }
        $FastFaves::Weapon1 = %item;
        $FastFaves::loadout = %loadout;

        $FastFaves::Weapons = FastFaves::weaponList();

        FastFaves::PreloadMessage();
    }
}


//
// Call this to buy multiple items -- a "loadout" which can be given a name
//
function FastFaves::Loadout(%loadout, %armor, %pack, %w1, %w2, %w3, %w4, %w5, %w6)
{
    $FastFaves::actualLoadout = $FastFaves::Loadout = %loadout;
    $FastFaves::Loadout = %loadout;
    $FastFaves::Armor = %armor;
    $FastFaves::Pack = %pack;
    $FastFaves::Weapon0 = $Inv::Targeting_Laser;
    $FastFaves::Weapon1 = %w1;
    $FastFaves::Weapon2 = %w2;
    $FastFaves::Weapon3 = %w3;
    $FastFaves::Weapon4 = %w4;
    $FastFaves::Weapon5 = %w5;
    $FastFaves::Weapon6 = %w6;

    $FastFaves::Weapons = FastFaves::weaponList();

    // Buy the items if we're at an inventory station
    if($Station::AtInventoryStation)
    {
        if($FastFaves::BuyExtraAmmo)
        {
            remoteEval(2048, buyFavorites, $FastFaves::Armor,
                                           $FastFaves::Pack,
                                           $FastFaves::Weapon1,
                                           $FastFaves::Weapon2,
                                           $FastFaves::Weapon3,
                                           $FastFaves::Weapon4,
                                           $FastFaves::Weapon5,
                                           $FastFaves::Weapon6,
                                           $FastFaves::ExtraAmmo1,
                                           $FastFaves::ExtraAmmo2,
                                           $FastFaves::ExtraAmmo3,
                                           $FastFaves::ExtraAmmo4,
                                           $FastFaves::ExtraAmmo5,
                                           $FastFaves::ExtraAmmo6,
                                           $FastFaves::ExtraAmmo7,
                                           $Inv::Targeting_Laser,
                                           $Inv::Repair_Kit,
                                           $Inv::Mine,
                                           $Inv::Grenade,
                                           $Inv::Beacon );
        }
        else // don't buy extra ammo
        {
            remoteEval(2048, buyFavorites, $FastFaves::Armor,
                                           $FastFaves::Pack,
                                           $FastFaves::Weapon1,
                                           $FastFaves::Weapon2,
                                           $FastFaves::Weapon3,
                                           $FastFaves::Weapon4,
                                           $FastFaves::Weapon5,
                                           $FastFaves::Weapon6,
                                           $Inv::Targeting_Laser,
                                           $Inv::Repair_Kit,
                                           $Inv::Mine,
                                           $Inv::Grenade,
                                           $Inv::Beacon );
        }
    }
    else
    {
        FastFaves::PreloadMessage();
    }
}


//
// Display the current loadout on the screen
//
function FastFaves::LoadoutMessage()
{
    if($Station::AtInventoryStation && $Station::PlayMode)
    {
        %text = "<f0><L5>Loadout:		<f1>" @ $FastFaves::actualLoadout @
            "\n\n<f0><L5>Armor:			<f1>" @ $Inv::Name[$FastFaves::actualArmor] @
            "\n\n<f0><L5>Backpack:		<f1>" @ $Inv::Name[$FastFaves::actualPack] @
            wif($FastFaves::ShowWeapons,
            "\n\n<f0><L5>Weapons:		<f1>" @ $FastFaves::actualWeapons, "");

        remoteBP(2048, %text);
    }
}


// Remove the loadout message when exiting station
Event::Attach(eventExitInventoryStation, "remoteBP(2048, \"\");");


//
// Display the selected intended loadout on the screen
//
function FastFaves::PreloadMessage()
{
    %text = "<f0><L5>Will buy:		<f1>" @ $FastFaves::Loadout @
        "\n\n<f0><L5>Armor:			<f1>" @ $Inv::Name[$FastFaves::Armor] @
        "\n\n<f0><L5>Backpack:		<f1>" @ $Inv::Name[$FastFaves::Pack] @
        wif($FastFaves::ShowPreloadWeapons,
        "\n\n<f0><L5>Weapons:		<f1>" @ $FastFaves::Weapons, "");

    remoteBP(2048, %text, 5);
}


//
// Display the current actual loadout on screen
//
function FastFaves::ShowLoadout()
{
    %actualLoadout = $FastFaves::Loadout;

    %actualArmor = FastFaves::actualArmor();
    %actualPack = FastFaves::actualPack();
    %actualWeapons = FastFaves::actualWeapons();

    // Clear the loadout name in the loadout message if the armor,
    // weapons or pack doesn't match our selected loadout

    if(%actualArmor != $FastFaves::Armor)
        %actualLoadout = "";

    if(%actualPack != $FastFaves::Pack)
        %actualLoadout = "";

    if(%actualWeapons != $FastFaves::Weapons)
        %actualLoadout = "";

    %text = "<f0><L5>Loadout:		<f1>" @ %actualLoadout @
        "\n\n<f0><L5>Armor:			<f1>" @ $Inv::Name[%actualArmor] @
        "\n\n<f0><L5>Backpack:		<f1>" @ $Inv::Name[%actualPack] @
        wif($FastFaves::ShowWeapons,
        "\n\n<f0><L5>Weapons:		<f1>" @ %actualWeapons, "");

    remoteBP(2048, %text, 5);
}


//
// Toggle showing the weapons in the loadout and preload messages
//
function FastFaves::ShowWeaponsToggle()
{
    if($FastFaves::ShowWeapons)
    {
        if($FastFaves::ShowPreloadWeapons)
            $FastFaves::ShowWeapons = false;
        else
            $FastFaves::ShowPreloadWeapons = $FastFaves::ShowWeapons = true;
    }
    else
    {
        if($FastFaves::ShowPreloadWeapons)
            $FastFaves::ShowPreloadWeapons = false;
        else
            $FastFaves::ShowWeapons = true;
    }

    remoteBP(2048, "<L5><f0>Fast Favorites:  Show <f1>Actual<f0>	Weapon List	<f2>" @ wif($FastFaves::ShowWeapons, "ON", "OFF")
               @ "\n<L5><f0>Fast Favorites:  Show <f1>Preload<f0>	Weapon List	<f2>" @ wif($FastFaves::ShowPreloadWeapons, "ON", "OFF") ,4);
}


//
// Function to build a comma delimited weapon list string
// in reverse order as initialized in inventory_table.cs
// (we need a standard list order to be able to compare
// weapon list strings)
//
function FastFaves::weaponList()
{
    %weapons = ""; %count = 0;
    for(%o = $Inv::WeaponCount; %o > 0; %o--)
    {
        for(%i = 0; %i <= 6; %i++)
        {
            if($FastFaves::Weapon[%i] != "")
            {
                if($Inv::WeaponList[%o] == $FastFaves::Weapon[%i])
                {
                    %weapons = $Inv::Name[$FastFaves::Weapon[%i]]
                             @ wif(%count, ", ", "")
                             @ %weapons;
                    %count++;
                    break;
                }
            }
        }
    }
    return %weapons;
}


//
// Return actual armor worn
//
function FastFaves::actualArmor()
{
    // What armor are we wearing?
    for(%i = $Inv::ArmorCount; %i > 0; %i--)
    {
        if(getItemCount($Inv::Name[%armor = $Inv::ArmorList[%i]]))
            return %armor;
    }
    return false;
}

//
// Return actual pack carried
//
function FastFaves::actualPack()
{
    // What pack are we carrying?
    for(%i = $Inv::PackCount; %i > 0; %i--)
    {
        if(getItemCount($Inv::Name[%pack = $Inv::PackList[%i]]))
            return %pack;
    }
    return false;
}

//
// Return list of weapons actually carried
// (format and order same as FastFaves::weaponList() returns)
//
function FastFaves::actualWeapons(%delimiter)
{
    if(%delimiter == "")
        %delimiter = ", ";

    // What weapons are we carrying?
    %weapons = "";
    for(%i = $Inv::WeaponCount; %i > 0; %i--)
    {
        if(getItemCount(%weapon = $Inv::Name[$Inv::WeaponList[%i]]))
        {
            %weapons = %weapon
                     @ wif(%count, %delimiter, "")
                     @ %weapons;

            %count++;
        }
    }
    return %weapons;
}


//
// Verify what items were actually bought, and update the loadout message
//
function FastFaves::VerifyLoadout()
{
    $FastFaves::actualLoadout = $FastFaves::Loadout;

    $FastFaves::actualArmor = FastFaves::actualArmor();
    $FastFaves::actualPack = FastFaves::actualPack();
    $FastFaves::actualWeapons = FastFaves::actualWeapons();

    // Clear the loadout name in the loadout message if the armor,
    // weapons or pack doesn't match our selected loadout

    if($FastFaves::actualArmor != $FastFaves::Armor)
        $FastFaves::actualLoadout = "";

    if($FastFaves::actualPack != $FastFaves::Pack)
        $FastFaves::actualLoadout = "";

    if($FastFaves::actualWeapons != $FastFaves::Weapons)
        $FastFaves::actualLoadout = "";

    // Display an updated loadout message if the loadout has changed
    // or if we didn't get the loadout we expected
    if($FastFaves::actualLoadout != $FastFaves::previousLoadout)
        FastFaves::LoadoutMessage();
    else if ($FastFaves::actualArmor != $FastFaves::previousArmor)
        FastFaves::LoadoutMessage();
    else if ($FastFaves::actualPack != $FastFaves::previousPack)
        FastFaves::LoadoutMessage();
    else if ($FastFaves::actualWeapons != $FastFaves::previousWeapons)
        FastFaves::LoadoutMessage();
//    else if ($FastFaves::actualArmor != $FastFaves::Armor)
//        FastFaves::LoadoutMessage();
//    else if ($FastFaves::actualPack != $FastFaves::Pack)
//        FastFaves::LoadoutMessage();
//    else if ($FastFaves::actualWeapons != $FastFaves::Weapons)
//        FastFaves::LoadoutMessage();

    $FastFaves::previousLoadout = $FastFaves::actualLoadout;
    $FastFaves::previousArmor = $FastFaves::actualArmor;
    $FastFaves::previousPack = $FastFaves::actualPack;
    $FastFaves::previousWeapons = $FastFaves::actualWeapons;

    return;
}


//
// Automatically buy mines, grenades, beacons and a repair kit
// whenever you use to an inventory station...and automatically
// buy the previously selected loadout if AutoBuyLoadout mode is on
//
function FastFaves::AutoBuy()
{
    if($FastFaves::AutoBuyLoadout)
    {
        if($FastFaves::BuyExtraAmmo)
        {
            remoteEval(2048, buyFavorites, $FastFaves::Armor,
                                           $FastFaves::Pack,
                                           $FastFaves::Weapon1,
                                           $FastFaves::Weapon2,
                                           $FastFaves::Weapon3,
                                           $FastFaves::Weapon4,
                                           $FastFaves::Weapon5,
                                           $FastFaves::Weapon6,
                                           $FastFaves::ExtraAmmo1,
                                           $FastFaves::ExtraAmmo2,
                                           $FastFaves::ExtraAmmo3,
                                           $FastFaves::ExtraAmmo4,
                                           $FastFaves::ExtraAmmo5,
                                           $FastFaves::ExtraAmmo6,
                                           $FastFaves::ExtraAmmo7,
                                           $Inv::Targeting_Laser,
                                           $Inv::Repair_Kit,
                                           $Inv::Mine,
                                           $Inv::Grenade,
                                           $Inv::Beacon );
        }
        else // don't buy extra ammo
        {
            remoteEval(2048, buyFavorites, $FastFaves::Armor,
                                           $FastFaves::Pack,
                                           $FastFaves::Weapon1,
                                           $FastFaves::Weapon2,
                                           $FastFaves::Weapon3,
                                           $FastFaves::Weapon4,
                                           $FastFaves::Weapon5,
                                           $FastFaves::Weapon6,
                                           $Inv::Targeting_Laser,
                                           $Inv::Repair_Kit,
                                           $Inv::Mine,
                                           $Inv::Grenade,
                                           $Inv::Beacon );
        }
        $FastFaves::SwitchWeapon = true;
        remoteEval(2048, PlayMode);
    }
    else // auto buy loadout not on, so just buy the misc items
    {
        // Can't just call buyItem four times -- that gets translated into
        // two attempts to buy item 0, the flag :)

        // Get space delimited list of items we're carrying
        %carrieditems = CmdInventory::getVisibleSet(InventoryList);

        // Translate that into an array
        if(%carrieditems != "")
        {
            %i = 0;
            while( (%item[%i] = getWord(%carrieditems, %i)) != -1)
            {
                %i++;
            }
        }
        // ...And re-buy those items plus our four desired misc items
        remoteEval(2048, buyFavorites, $Inv::Repair_Kit, $Inv::Mine, $Inv::Grenade, $Inv::Beacon,
                                       %item[0], %item[1], %item[2], %item[3], %item[4], %item[5], %item[6], %item[7], %item[8], %item[9], %item[10],
                                       %item[10], %item[11], %item[12], %item[13], %item[14], %item[15] );
    }
}
Event::Attach(eventEnterInventoryStation, "FastFaves::AutoBuy();");


//
// Automatically buy the previously selected vehicle
//
function FastFaves::AutoBuyVehicle()
{
    if($FastFaves::AutoBuyLoadout)
    {
        remoteEval(2048, buyItem, $FastFaves::Vehicle);
        remoteEval(2048, PlayMode);
    }
}
Event::Attach(eventEnterVehicleStation, "FastFaves::AutoBuyVehicle();");


//
// Toggle automatic loadout buying mode on/off
//
function FastFaves::AutoBuyToggle()
{
    remoteBP(2048, "<L5>Auto Buy Favorites <f2>" @ wif($FastFaves::AutoBuyLoadout = !$FastFaves::AutoBuyLoadout, "ON", "OFF"),4);
}


//
// Toggle carry extra ammo mode on/off
//
function FastFaves::BuyExtraAmmoToggle()
{
    remoteBP(2048, "<L5>Buy Extra Ammo <f2>" @ wif($FastFaves::BuyExtraAmmo = !$FastFaves::BuyExtraAmmo, "ON", "OFF"),4);
}

//
// Remove the loadout message when we leave the PlayGui,
// and display it again when we return
//
function FastFaves::onGuiOpen(%gui)
{
    if(%gui != PlayGui)
    {
        remoteBP(2048, "");
    }
    else
    {
        if($Station::AtInventoryStation)
            FastFaves::LoadoutMessage();
    }

    return;
}
Event::Attach(eventGuiOpen, FastFaves::onGuiOpen);


//
// Determine whether a given favorite was set in favorites.cs
//
function FastFaves::isSet(%modifier, %key)
{
    if(%key == "")
    {
        %key = %modifier;
        %modifier = "";
    }

    if($FastFaves::AllowAssignment[%modifier])
        return true;

    if($FastFaves::key[%modifier, %key, armor] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, pack] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, weapon1] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, weapon2] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, weapon3] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, weapon4] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, weapon5] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, weapon6] != "")
        return true;
    else if($FastFaves::key[%modifier, %key, vehicle] != "")
        return true;
    else
        return false;
}

function FastFaves::bindKey(%modifier, %key)
{
    if(%key == "")
    {
        %key = %modifier;
        %modifier = "";
    }

    if(FastFaves::isSet(%modifier, %key))
    {
        EditActionMap("actionMap.sae"); // note: these bindings are always active!
        eval("bindCommand(keyboard0, make, " @ wif(%modifier != "", %modifier @ ", ", "") @ %key @", TO, \"FastFavorites(" @ wif(%modifier != "", %modifier @ ", ", "") @ %key @ ");\");");
        eval("bindCommand(keyboard0, break, " @ wif(%modifier != "", %modifier @ ", ", "") @ %key @", TO, \"doNothing();\");");
    }
    else
    {
        EditActionMap("actionMap.sae"); // note: these bindings are always active!
        eval("bindCommand(keyboard0, make, " @ wif(%modifier != "", %modifier @ ", ", "") @ %key @", TO, \"doNothing();\");");
        eval("bindCommand(keyboard0, break, " @ wif(%modifier != "", %modifier @ ", ", "") @ %key @", TO, \"doNothing();\");");
    }
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    function FastFaves::bindKeys()
    {
        echo("binding default keys for fast favorites");

        EditActionMap("actionMap.sae"); // note: these bindings are always active!

        // Toggle inventory screen on/off
        bindCommand(keyboard0, make, "decimal", TO, "remoteEval(2048, ToggleInventoryMode);");
        bindCommand(keyboard0, break, "decimal", TO, "");

        // Toggle assignment mode on/off
        bindCommand(keyboard0, make, alt, "numpad-", TO, "FastFaves::toggleAssignmentMode();");
        bindCommand(keyboard0, break, alt, "numpad-", TO, "");

        // Toggle auto-buying mode on/off (automatically buy selected loadout)
        bindCommand(keyboard0, make, alt, "numpad+", TO, "FastFaves::AutoBuyToggle();");
        bindCommand(keyboard0, break, alt, "numpad+", TO, "");

        // Toggle "buy extra ammo" mode on/off
        bindCommand(keyboard0, make, alt, "/", TO, "FastFaves::BuyExtraAmmoToggle();");
        bindCommand(keyboard0, break, alt, "/", TO, "");

        // Show the items that will be bought next time we access an inventory station
        bindCommand(keyboard0, make, shift, "l", TO, "FastFaves::PreloadMessage();");
        bindCommand(keyboard0, break, shift, "l", TO, "");

        // Show the current loadout
        bindCommand(keyboard0, make, control, "l", TO, "FastFaves::ShowLoadout();");
        bindCommand(keyboard0, break, control, "l", TO, "");

        // Toggle the weapons list on/off in the preload and loadout messages
        bindCommand(keyboard0, make, alt, "l", TO, "FastFaves::ShowWeaponsToggle();");
        bindCommand(keyboard0, break, alt, "l", TO, "");

        // Fast Inventory selection keys


// I've pre-empted this call so I can use the decimal key to toggle the inventory screen on/off.
// If you re-enable this call, make sure you remove or change the decimal key binding above.
//
//        FastFaves::bindKey(decimal)

        FastFaves::bindKey(numpad0);
        FastFaves::bindKey(numpad1);
        FastFaves::bindKey(numpad2);
        FastFaves::bindKey(numpad3);
        FastFaves::bindKey(numpad4);
        FastFaves::bindKey(numpad5);
        FastFaves::bindKey(numpad6);
        FastFaves::bindKey(numpad7);
        FastFaves::bindKey(numpad8);
        FastFaves::bindKey(numpad9);

        FastFaves::bindKey(control, decimal);
        FastFaves::bindKey(control, numpad0);
        FastFaves::bindKey(control, numpad1);
        FastFaves::bindKey(control, numpad2);
        FastFaves::bindKey(control, numpad3);
        FastFaves::bindKey(control, numpad4);
        FastFaves::bindKey(control, numpad5);
        FastFaves::bindKey(control, numpad6);
        FastFaves::bindKey(control, numpad7);
        FastFaves::bindKey(control, numpad8);
        FastFaves::bindKey(control, numpad9);

        FastFaves::bindKey(alt, decimal);
        FastFaves::bindKey(alt, numpad0);
        FastFaves::bindKey(alt, numpad1);
        FastFaves::bindKey(alt, numpad2);
        FastFaves::bindKey(alt, numpad3);
        FastFaves::bindKey(alt, numpad4);
        FastFaves::bindKey(alt, numpad5);
        FastFaves::bindKey(alt, numpad6);
        FastFaves::bindKey(alt, numpad7);
        FastFaves::bindKey(alt, numpad8);
        FastFaves::bindKey(alt, numpad9);

        FastFaves::bindKey(shift, decimal);
        FastFaves::bindKey(shift, numpad0);
        FastFaves::bindKey(shift, numpad1);
        FastFaves::bindKey(shift, numpad2);
        FastFaves::bindKey(shift, numpad3);
        FastFaves::bindKey(shift, numpad4);
        FastFaves::bindKey(shift, numpad5);
        FastFaves::bindKey(shift, numpad6);
        FastFaves::bindKey(shift, numpad7);
        FastFaves::bindKey(shift, numpad8);
        FastFaves::bindKey(shift, numpad9);
    }
    Event::Attach(eventFavoritesInitialized, FastFaves::bindKeys);
}
