// ---------------------------------------------------------------------------
// laser_ready.cs -- Version 2.3 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// Major thank you to LabRat for all his help!  The small energy bar would not
// exist if it wasn't for his code examples and generous assistance.
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\laser_ready.cs", "2.3", "Lorne Laliberte", "- May 22, 1999 - sounds when laser rifle fully charged - www.planetstarsiege.com/lorne/");


// These scripts are required:

include("writer\\event.cs");
include("writer\\item_events.cs");
include("writer\\inventory_table.cs");
include("writer\\fire.cs");
include("writer\\jet.cs");
include("writer\\screensize.cs");
include("writer\\weapon_switch.cs");
if(include("presto\\killtrak.cs") == notfound)
    include("writer\\killtrak.cs");


// These scripts are **highly** recommended:

//include("writer\\pilot_mode.cs");
//include("writer\\custom_weapons.cs");


// IMPORTANT: The 100 "bar" and "sidebar" bitmaps must be installed in
//
// Tribes\config\writer\energybar
//
// ...for this to work!


// Adds a small energy bar just above, below or beside your crosshairs when
// you have the laser rifle selected!
//
// Also plays a local sound ("Ready") when you're using the laser rifle and
// the energy bar reaches full strength.
//
// Note: in order to prevent other players from hearing this sound, make sure
// you copy the wCHANGETHIS.wav file into your Tribes\base\voices directory,
// and change the 'CHANGETHIS' part to a unique string (7 characters or less)
// of your choice.  Then change $LaserReady::Sound (in this script) to match!
//
// For instance, if you change the filename to wLRREADY.wav, change
// $LaserReady = "CHANGETHIS"; below to $LaserReady = "LRREADY";
//
// Note that anyone else who used the same name (LRREADY) will be able to hear
// you say "Ready" when they are nearby...so you should really make up a unique
// string of 7 characters. :)
//
// If you want to use your own sound file, you can, so long as it is in the
// proper format for Tribes (by which I mean sampling frequency, etc.).

$LaserReady::Sound = "CHANGETHIS"; // file name is wCHANGETHIS.wav


// Set energy bar start position
//
// 0 = top
// 1 = right
// 2 = bottom
// 3 = left
//
$EnergyBar::Position = 3;


// Set the size of your normal crosshair (h_reticle.bmp) here
$EnergyBar::reticleSizeX = 63;
$EnergyBar::reticleSizeY = 63;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


function EnergyBar::onWeaponSwitch(%toWeapon, %fromWeapon)
{
    if(!$PilotMode)
    {
        if(%toWeapon == $Inv::Laser_Rifle)
        {
            if(%fromWeapon != $Inv::Laser_Rifle)
                EnergyBar::make();
        }
        else if(%toWeapon == "") // don't know what weapon we're switching to!
        {
            EnergyBar::remove();//**
            WeaponSwitch(%fromWeapon);
        }
        else
        {
            EnergyBar::remove();
        }
    }
}
Event::Attach(eventWeaponSwitch, EnergyBar::onWeaponSwitch);


Event::Attach(eventPilotModeOn, "EnergyBar::remove();");


//
// Turn energy bar off when we die :)
//
function EnergyBar::onKillTrak(%killer, %victim, %weapon)
{
    if(%victim == getManagerID())
        EnergyBar::remove();

    return;
}
Event::Attach(eventKillTrak, EnergyBar::onKillTrak);


function EnergyBar::toggle()
{
    $EnergyBar::disabled = !$EnergyBar::disabled;
    if($EnergyBar::disabled)
        EnergyBar::remove();
    else
        EnergyBar::make();
}

function EnergyBar::cycle()
{
    $EnergyBar::Position++;
    if($EnergyBar::Position > 3)
        $EnergyBar::Position = 0;

    if($EnergyBar::Exists)
        EnergyBar::make();
}

function EnergyBar::make()
{
    if(!$EnergyBar::disabled)
    {

        if($EnergyBar::Exists)
            EnergyBar::Remove();

        %x = %y = 0;

        if($EnergyBar::Position == 0)
        {
            $EnergyBar::BitmapName = "bar";
            %x = (getScreenSizeX() - 51)/2;

            if($Xhair::current)
                %y = (getScreenSizeY() - 11 - $Xhair::ySize[$Xhair::current]) / 2;
        	else
                %y = (getScreenSizeY() - 11 - $EnergyBar::reticleSizeY) / 2;

            $EnergyBar = newObject("EnergyBar", FearGuiFormattedText, %x - 4, %y+1, 50, 10);
    	}
    	else if($EnergyBar::Position == 1)
        {
            $EnergyBar::BitmapName = "sidebar";
            %y = (getScreenSizeY() - 51)/2;

            if($Xhair::current)
                %x = (getScreenSizeX() - 1 + $Xhair::xSize[$Xhair::current]) / 2;
        	else
                %x = (getScreenSizeX() - 1 + $EnergyBar::reticleSizeX) / 2;

            $EnergyBar = newObject("EnergyBar", FearGuiFormattedText, %x - 2, %y+1, 10, 60);
    	}
    	else if($EnergyBar::Position == 2)
        {
            $EnergyBar::BitmapName = "bar";
            %x = (getScreenSizeX() - 51)/2;

            if($Xhair::current)
                %y = (getScreenSizeY() - 1 + $Xhair::ySize[$Xhair::current]) / 2;
        	else
                %y = (getScreenSizeY() - 1 + $EnergyBar::reticleSizeY) / 2;

            $EnergyBar = newObject("EnergyBar", FearGuiFormattedText, %x - 4, %y+1, 50, 10);
    	}
    	else if($EnergyBar::Position == 3)
        {
            $EnergyBar::BitmapName = "sidebar";
            %y = (getScreenSizeY() - 51)/2;

            if($Xhair::current)
                %x = (getScreenSizeX() - 11 - $Xhair::xSize[$Xhair::current]) / 2;
        	else
                %x = (getScreenSizeX() - 11 - $EnergyBar::reticleSizeX) / 2;
            $EnergyBar = newObject("EnergyBar", FearGuiFormattedText, %x - 2, %y+1, 10, 60);
    	}

        addToSet(PlayGui, $EnergyBar);
        Control::setValue("EnergyBar", "<Bwriter\\energybar\\" @ $EnergyBar::BitmapName @ "50.bmp>");
        $EnergyBar::exists = true;
    }
}


function EnergyBar::remove()
{
    if($EnergyBar::exists)
    {
        deleteObject($EnergyBar);
        $EnergyBar::exists = false;
    }
}


function EnergyBar::update()
{
    %now = getSimTime();

    %charge = 0;

    %endTime = $LaserReady::endTime;

    if($LaserReady::Jetting)
    {
        if(%endTime)
            %endTime = $LaserReady::endTime + ((%now - $LaserReady::startJetTime) * 2.25);
        else
            %endTime = %now + (%now - $LaserReady::startJetTime);

        if(%endTime > (%now + 5.0))
        {
            $LaserReady::endTime = %endTime = %now + 5.0;
            $LaserReady::startJetTime = %now;
        }
    }
    %charge = (%endTime - %now) * 10;

    if(%charge < 0)
        %charge = 0;

    if(%charge > 50)
        %charge = 50;

    %i = floor(50 - %charge + 0.5);
    Control::setValue("EnergyBar", "<Bwriter\\energybar\\" @ $EnergyBar::BitmapName @ %i @ ".bmp>");


    if(%charge || $LaserReady::Jetting)
        schedule("EnergyBar::update();", 0.05);
}


function LaserReady::weaponFired(%weapon)
{
	if(%weapon == $Inv::Laser_Rifle)
	{
	    // Start our timer
        $LaserReady::startTime = getSimTime();

        // With an energy pack it takes about 5 seconds to fully recharge
        $LaserReady::endTime = $LaserReady::startTime + 5.0;

        // Clear flag to enable the isRifleReady schedule loop
        $LaserReady::Stop = false;

        // Energy won't be recharged for at least 5 seconds, guaranteed :)
        schedule("LaserReady::isRifleReady();", 5.0);

        if(!$LaserReady::Jetting)
            EnergyBar::update();
	}
}
Event::Attach(eventWeaponFired, LaserReady::weaponFired); // eventWeaponFired is triggered in fire.cs


function LaserReady::isRifleReady()
{
    %now = getSimTime();
    if( !$LaserReady::Jetting && (%now > $LaserReady::endTime) )
    {
        // We're not jetting, and we've passed the time when we figure the energy should be recharged

        // Sound the "ready" if we're using the laser rifle and we fired, or jetted for more than 1.5 seconds total
        if( (getMountedItem(0) == $Inv::Laser_Rifle) && (($LaserReady::endTime - $LaserReady::startTime) > 1.5) )
            localMessage($LaserReady::Sound);

        // Clear the start and end times to enable our jet timer :)
        $LaserReady::startTime = $LaserReady::endTime = 0;

        // Maybe someone else will find this useful?
        Event::Trigger(eventEnergyRecharged);

        return; // note that this stops the schedule loop!
    }

    if(!$LaserReady::Stop) // so we can stop a runaway schedule loop if we have to
        schedule("LaserReady::isRifleReady();", 0.01);
}


//
// Jump jet key/button pressed
//
function LaserReady::jetOn()
{
    // Set flag to prevent the isRifleReady schedule loop from ending prematurely
    $LaserReady::Jetting = true;

    $LaserReady::startJetTime = getSimTime();

    // Set the start time if we haven't already (if we didn't fire and this is the first time we've jetted)
    if(!$LaserReady::startTime)
    {
        $LaserReady::startTime = $LaserReady::startJetTime;
        EnergyBar::update();
    }

    return;
}
Event::Attach(eventJetPressed, LaserReady::jetOn);


//
// Jump jet key/button released
//
function LaserReady::jetOff()
{
    // I figured this out through trial and error, not sure why but it works
    %factor = 2.25;

    %now = getSimTime();

    // If we didn't fire, endTime isn't set
    if(!$LaserReady::endTime)
    {
        $LaserReady::endTime = %now;

        // Strangely enough we need a different factor if we don't fire
        %factor = 1.0;

        // Clear flag to enable the isRifleReady schedule loop
        $LaserReady::Stop = false;

        // Start the isRifleReady schedule loop
        schedule("LaserReady::isRifleReady();", 0.01);
    }
    // Set endTime to our estimated time of full recharge
    if( ((%now - $LaserReady::startJetTime) * %factor) <= 5 )
        $LaserReady::endTime += (%now - $LaserReady::startJetTime) * %factor;
    else
        $LaserReady::endTime = %now + 5.0;

    // Clear flag to allow the isRifleReady schedule loop to end
    $LaserReady::Jetting = false;

    return;
}
Event::Attach(eventJetReleased, LaserReady::jetOff);


function LaserReady::Reset()
{
    $LaserReady::endTime =
    $LaserReady::startTime = 0;
    $LaserReady::Stop = true;
    $LaserReady::Jetting = false;
    EnergyBar::remove();
}
Event::Attach(eventConnected, "LaserReady::Reset();");
Event::Attach(eventChangeMission, "LaserReady::Reset();");


//
// Remove energy bar before play.gui is saved on exit -- important!
//
Event::Attach(eventExit, "EnergyBar::remove();");



// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae");

    // Toggle small energy bar on/off
    bindCommand(keyboard0, make, alt, "quote", TO, "EnergyBar::toggle();");
    bindCommand(keyboard0, break, alt, "quote", TO, "");

    // Cycle through energy bar positions
    bindCommand(keyboard0, make, "quote", TO, "EnergyBar::cycle();");
    bindCommand(keyboard0, break, "quote", TO, "");
}
