// ---------------------------------------------------------------------------
// litterbug.cs -- Version 1.1 -- May 23, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\litterbug.cs", "1.1", "Lorne Laliberte", "- May 23, 1999 - drop stuff for other players - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\station_events.cs");
include("writer\\ping.cs");
if(include("presto\\schedule.cs") == notfound)
    include("writer\\schedule.cs");


$Litterbug::itemlist[0] = "Repair Kit";
$Litterbug::itemlist[1] = "Repair Pack";
$Litterbug::itemlist[2] = "Turret";
$Litterbug::itemlist[3] = "Mortar Ammo"; // I'm ignoring the old MortarAmmo/Mortar Ammo problem :)
$Litterbug::itemlist[4] = "Grenade Ammo";
$Litterbug::itemlist[5] = "Inventory Station";
$Litterbug::itemlist[6] = "Ammo Station";
$Litterbug::itemlist[7] = "Grenade";
$Litterbug::itemlist[8] = "Mine";
$Litterbug::itemlist[9] = "Pulse Sensor";
$Litterbug::itemlist[10] = "Motion Sensor";
$Litterbug::itemlist[11] = "Sensor Jammer";
$Litterbug::itemlist[12] = "Camera";
$Litterbug::itemlist[13] = "Beacon";
$Litterbug::itemlist[14] = "Shield Pack";

// If you add any more items to the list make sure you change this :)
$Litterbug::maxitem = 14;


// Set the delay to use when not in PingWait mode
// Note that a short delay can cause a lot of lag
// especially if you have higher pings, if you usually
// play with higher pings you'll likely want to change
// this to 0.6 or even higher.
$Litterbug::delay = 0.1;


// Set this to true to use a dynamic ping-related delay
// instead of the hardcoded $Litterbug::delay value.  This
// is the safest way to use Litterbug without introducing any
// lag, but unless you have really low pings it's slower than
// the $Litterbug::delay method.  Note that you can switch
// between the two delay methods at any time by pressing
// CONTROL-/ (unless you change the bindings) while in the game.
$Litterbug::UsePingWait = false;


// Start with item 0 in the list
$Litterbug::current = 0;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


$Litterbug::item = $Litterbug::itemlist[$Litterbug::current];

//
// Toggle between the two delay methods
//
function Litterbug::toggleDelay()
{
    $Litterbug::UsePingWait = !$Litterbug::UsePingWait;

    if($Litterbug::UsePingWait)
        remoteBP(2048, "<L5><f0>Litterbug:<f1> using the safer, dynamic <f2>Ping-related delay", 5);
    else
        remoteBP(2048, "<L5><f0>Litterbug:<f1> using the <f2>hardcoded delay<f0> <f1>of " @ $Litterbug::delay + 0.000001, 5);
}

//
// Start tossing stuff from the inventory station :)
// Note that you can bind a key to always toss a specific item.
//
function Litterbug::start(%itemname)
{
    if($Station::AtInventoryStation)
    {
        if(%itemname == "")
            %itemname = $Litterbug::item;

        if(getItemCount(%itemname))
            drop(%itemname);

        buy(%itemname);

        if($Litterbug::UsePingWait)
            $Litterbug::PingID = Ping::wait("Litterbug::Start(\"" @ %itemname @ "\");");
        else
            schedule::add("Litterbug::Start(\""@ %itemname @ "\");", $Litterbug::delay, Litterbug);
    }
}

//
// Stop tossing stuff from the inventory station :)
//
function Litterbug::stop()
{
    if($Litterbug::UsePingWait)
        Ping::cancel($Litterbug::PingID);
    else
        schedule::cancel(Litterbug);
}

function Litterbug::next()
{
    $Litterbug::current++;
    if($Litterbug::current > $Litterbug::maxitem)
        $Litterbug::current = 0;

    $Litterbug::item = $Litterbug::itemlist[$Litterbug::current];

    remoteBP(2048, "<L5>Litterbug set to drop <f2>" @ $Litterbug::item, 5);
}

function Litterbug::prev()
{
    $Litterbug::current--;
    if($Litterbug::current < 0)
        $Litterbug::current = $Litterbug::maxitem;

    $Litterbug::item = $Litterbug::itemlist[$Litterbug::current];

    remoteBP(2048, "<L5>Litterbug set to drop <f2>" @ $Litterbug::item, 5);
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("actionMap.sae");

    // Hold key down to buy and drop items for your teammates
    bindCommand(keyboard0, make, shift, "/", TO, "Litterbug::start();");
    bindCommand(keyboard0, break, shift, "/", TO, "Litterbug::stop();");

    // Toggle between hardcoded and dynamic delays for Litterbug
    bindCommand(keyboard0, make, control, "/", TO, "Litterbug::toggleDelay();");
    bindCommand(keyboard0, break, control, "/", TO, "");

    // Select next droppable item
    bindCommand(keyboard0, make, shift, "quote", TO, "Litterbug::next();");
    bindCommand(keyboard0, break, shift, "quote", TO, "");

    // Select previous droppable item
    bindCommand(keyboard0, make, shift, ";", TO, "Litterbug::prev();");
    bindCommand(keyboard0, break, shift, ";", TO, "");
}
