// ---------------------------------------------------------------------------
// mHUD_mod.cs -- Version 1.3 -- May 22, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


// This script modifies Cowboy's mHUD.cs to replace the schedule loop with
// code that uses the events set up in my scripts.  mHUD uses a schedule loop
// that calls a function every 0.3 seconds to check the current weapon, current
// screensize, and a few other details.  Although you likely won't notice any
// slowdown from this, it theoretically could hinder client-side performance,
// so if you have a slow processor -- or if you're just interested in squeezing out
// that last iota of CPU muscle -- you might want to try running this little mod
// on top of mHUD.


// mHUD.cs must be executed BEFORE this script for this to work.
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


include("writer\\version.cs");
version("writer\\mHUD_mod.cs", "1.3", "Lorne Laliberte", "- May 22, 1999 - modifies mHUD.cs - www.planetstarsiege.com/lorne/");


// This script overrides certain functions in mHUD.cs to watch for my eventWeaponSwitch
// event instad.  This means that mHUD.cs + mHUD_mod.cs will only work properly if you're
// using my scripts to detect the weapon changes!


// These scripts are required:

include("writer\\event.cs");
include("writer\\item_events.cs");
include("writer\\inventory_table.cs");
include("writer\\weapon_switch.cs");
if(include("presto\\killtrak.cs") == notfound)
    include("writer\\killtrak.cs");


// These scripts are **highly** recommended:

//include("writer\\pilot_mode.cs");
//include("writer\\custom_weapons.cs");


// These scripts are optional:

//include("writer\\mmb_repair.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


// Add a little info to Cowboy's ad :)
$mHUD::WriterScriptBanner = "<f2>Writer's mHUD_mod.cs in effect!\n"
                          @ "<f1>www.planetstarsiege.com/lorne<f0>\n"
                          @ "<f0>Read the readme for <f1>Key\n"
                          @ "Bindings <f0>and <f1>New Features!\n" 
                          @ "<f2>Now with Reticle Overlays!\n";


if ($Presto::version >= 0.93) 
{
    Presto::AddScriptBanner(mHUD, $mHUD::CowboyScriptBanner1 
    @ $mHUD::WriterScriptBanner @ $mHUD::CowboyScriptBanner2);
}



Event::Attach(eventZoomOn, mHUD::ToggleSniperWriterOn);
Event::Attach(eventZoomOff, mHUD::ToggleSniperWriterOff);

Event::Attach(eventConnected, "schedule(\"mHUD::LoadGui();\", 3);");

function mHUD::onWeaponSwitch(%toWeapon, %fromWeapon)
{
    if(!$PilotMode)
    {
        if(%toWeapon == "") // don't know what weapon we're switching to!
        {
            WeaponSwitch(%fromWeapon);
        }
        else
        {
            $mHUD::CurrentWeapon = $Inv::Name[%toWeapon];
            $mHUD::ForceMortar = false;
            
        	if ($mHUD::LastResolution != Presto::ScreenSize())
        		mHUD::UpdateResolution();
    
            mHUD::UpdateReticle();
        }
    }
}
Event::Attach(eventWeaponSwitch, mHUD::onWeaponSwitch);


function mHUD::onUnmount(%weapon)
{
    if(!$PilotMode)
    {
        $mHUD::CurrentWeapon = "";
        mHUD::UpdateReticle();
    }
}
Event::Attach(eventUnmount, mHUD::onUnmount);


function mHUD::onPilotModeOn()
{
    $mHUD::CurrentWeapon = "Scout";
    mHUD::UpdateReticle();
}
Event::Attach(eventPilotModeOn, "mHUD::onPilotModeOn();");


function mHUD::onKillTrak(%killer, %victim, %weapon)
{
    if(%victim == getManagerID())
    {
        $mHUD::CurrentWeapon = "";
        mHUD::UpdateReticle();
    }
    return;
}
Event::Attach(eventKillTrak, mHUD::onKillTrak);


function mHUD::CurrentWeapon() 
{
	if (included("cowboy\\CmdHUD.cs") && $CmdHUD::guiMode == 2 && $mHUD::CurrentGui == CommandGui) 
	{
		if ($CmdHUD::MapState && !$mHUD::CmdHUD::ReticleState ) 
		{
			$mHUD::CmdHUD::ReticleState = true;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
		}
		else if (!$CmdHUD::MapState && $mHUD::CmdHUD::ReticleState) 
		{
			$mHUD::CmdHUD::ReticleState = false;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
		}
	}

	return $mHUD::CurrentWeapon;
}

//
// force the mortar rangefinder on (toggle)
//	
function mHUD::ForceMortarToggle(%state) 
{
	if (%state == "")
		$mHUD::ForceMortar = !$mHUD::ForceMortar;
	else
		$mHUD::ForceMortar = (%state && $mHUD::ForceMortar);
		
	$mHUD::ForceMortarOn = $mHUD::ForceMortar;
	
	if ($mHUD::DebugMode) echo("Force Mortar Toggle: " @ $mHUD::ForceMortar);

	if ($mHUD::LastResolution != Presto::ScreenSize())
		mHUD::UpdateResolution();

    mHUD::UpdateReticle();
}


function mHUD::ToggleSniperWriter(%state) 
{
	$mHUD::ToggleSniperState = !$mHUD::ToggleSniperState;

	if (%state && $mHUD::ForceMortar) {
		$mHUD::SnipeAndMortar = true;
		$mHUD::SnipeWeapon = mHUD::CurrentWeapon();
		}
	else if (!%state && $mHUD::SnipeAndMortar && !$mHUD::ForceMortar) {
		$mHUD::ForceMortar = true;
		$mHUD::SnipeAndMortar = false;
		}
		
	if ($mHUD::SnipeWeapon != mHUD::CurrentWeapon())
		$mHUD::ForceMortar = false;

	if ($mHUD::DebugMode) echo("Sniper State: " @ $mHUD::ToggleSniperState);

	if ($mHUD::LastResolution != Presto::ScreenSize())
		mHUD::UpdateResolution();

    mHUD::UpdateReticle();
}


function scheduled_mHUD::Timer(%id) {}
function schedule_mHUD::Timer() {}
Event::Detach(eventConnected, schedule_MHUD::Timer);

function mHUD::Timer() 
{
    if((getMountedItem(0) != -1) && !$mHUD::Initialized)
    {
        $mHUD::Initialized = true;
        mHUD::Init();
        return;
    }
    schedule("mHUD::Timer();", 3);
}
 
//
// toggle 1st person/3rd person views
//
function mHUD::ToggleView() 
{
	$mHUD::ToggleViewState = !$mHUD::ToggleViewState;
	postAction(2048, IDACTION_VIEW, 1);
	if ($mHUD::DebugMode) echo("View State: " @ $mHUD::ToggleViewState);

	if ($mHUD::LastResolution != Presto::ScreenSize())
		mHUD::UpdateResolution();

    mHUD::UpdateReticle();
}
