// ---------------------------------------------------------------------------
// pda_dance.cs -- Version 1.3 -- April 9, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------


include("writer\\version.cs");
version("writer\\pda_dance.cs", "1.3", "Lorne Laliberte", "- April 9, 1999 - evasive action dance - www.planetstarsiege.com/lorne/");


//
// These are the steps our dancer can perform
//
function Dance::Step8(%move) // N
{
    postAction(2048, IDACTION_MOVEFORWARD, %move);
}
function Dance::Step9(%move) // NE
{
    postAction(2048, IDACTION_MOVEFORWARD, %move);
    postAction(2048, IDACTION_MOVERIGHT, %move);
}
function Dance::Step6(%move) // E
{
    postAction(2048, IDACTION_MOVERIGHT, %move);
}
function Dance::Step3(%move) // SE
{
    postAction(2048, IDACTION_MOVEBACK, %move);
    postAction(2048, IDACTION_MOVERIGHT, %move);
}
function Dance::Step2(%move) // S
{
    postAction(2048, IDACTION_MOVEBACK, %move);
}
function Dance::Step1(%move) // SW
{
    postAction(2048, IDACTION_MOVEBACK, %move);
    postAction(2048, IDACTION_MOVELEFT, %move);
}
function Dance::Step4(%move) // W
{
    postAction(2048, IDACTION_MOVELEFT, %move);
}
function Dance::Step7(%move) // NW
{
    postAction(2048, IDACTION_MOVEFORWARD, %move);
    postAction(2048, IDACTION_MOVELEFT, %move);
}
function Dance::Step5(%move) // Duck
{
    if(%move)
        postAction(2048, IDACTION_CROUCH, 0);
    else
        postAction(2048, IDACTION_STAND, 0);
}


//
// Translate a step to the step that will "retrace" it
//
function Dance::getRetraceStep(%step)
{
    if( (%index = String::findSubStr("89632147", %step)) != -1 )
        return String::getSubStr("21478963", %index, 1);
    else
        return %step;
}


//
// Toggle the dance on and off
//
function Dance::pdaDance()
{
    if($Dance::pdaDancing)
    {
        $Dance::pdaDancing = 0;
    }
    else
    {
        $Dance::pdaDancing = 1;
        Dance::pdaDancer(1, 1); // start dancing "forward" and do init
    }
}

//
// Dance away in the pda
//
function Dance::pdaDancer(%forward, %init)
{
    if($Dance::pdaDancing)
    {
        if(%forward) // not retracing our footsteps
        {
            if(%init)
            {
                $Dance::stepcounter = 0;
                
                // Set number of steps for this part of the dance
                $Dance::steps = 3 + floor(getRandom() * 9); // between 3 and 12
            }

            if($Dance::stepcounter < $Dance::steps)
            {
                // Still doing the "forward" steps
                
                // Pick dance step at random (between 1 and 9)
                %step = $Dance::stepsTaken[$Dance::stepcounter] =  1 + floor(getRandom() * 8);
                
                // Start doing the step
                eval("Dance::Step" @ %step @ "(1);");//, 0);

                // Set a duration for this step between 0.25 and 1.25 seconds
                // and remember it in our $Dance::intervals array
                %interval = ($Dance::intervals[$Dance::stepcounter] = 0.25 + getRandom());

                // Stop this step after our interval has passed
                schedule("Dance::Step" @ %step @ "(0);", %interval);

                // Do another step next time (or start reversing)
                $Dance::stepcounter++;

                // Call this function after our interval to do another step
                // but skip the init
                schedule("Dance::pdaDancer(1,0);", %interval);
            }
            else
            {
                // Adjust our counter since we haven't done a step this time
                $Dance::stepcounter--;

                // LOL, this is one way to avoid recursion; I'm amazed this doesn't
                // cause any problems.  My guess is the schedule pushes this onto a FIFO
                // queue and it doesn't get processed until this function returns...or
                // is each item on the schedule given its own thread, or the equivalent?
                
                // Call this function again to start retracing our footsteps
                schedule("Dance::pdaDancer(0,0);", 0);
            }
        }
        else // retracing our footsteps
        {
            if($Dance::stepcounter >= 0)
            {
                // Still retracing the steps -- we're getting the steps in reverse order
                // and doing the opposite action for each
                
                // Get the next step to retrace and determine which step will retrace it
                %step = Dance::getRetraceStep($Dance::stepsTaken[$Dance::stepcounter]);

                // Start retracing this step
                eval("Dance::Step" @ %step @ "(1);");
                
                // Use the same interval used for the "forward" version of this step
                %interval = $Dance::intervals[$Dance::stepcounter];

                // Stop retracing this step after our interval has passed
                schedule("Dance::Step" @ %step @ "(0);", %interval);
                
                // Retrace the next step next time (or start going forward again)
                $Dance::stepcounter--;

                // Call this function again after our interval to keep retracing
                schedule("Dance::pdaDancer(0,0);", %interval);
            }
            else
            {
                // Call this function again to do the init and start dancing "forward" again
                schedule("Dance::pdaDancer(1,1);", 0);
            }
        }
    }
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("actionMap.sae"); 
    
    // Start dancin' and bring up the commander screen
    // or stop dancin' and close the commander screen
    bindCommand(keyboard0, make, alt, "c", TO, "remoteEval(2048, ToggleCommandMode);");
    bindCommand(keyboard0, break, alt, "c", TO, "Dance::pdaDance();");
    
    // Start or stop dancin' :)
    bindCommand(keyboard0, make, alt, "d", TO, "Dance::pdaDance();");
    bindCommand(keyboard0, break, alt, "d", TO, "");
}