// ---------------------------------------------------------------------------
// queue.cs -- Version 2.1 -- May 19, 1999
// by Vis-DS.Writer (Lorne Laliberte, writer@videon.wave.ca)
//
// http://www.videon.wave.ca/~writer/strategy/tribes.html
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\queue.cs", "2.1", "Lorne Laliberte", "- May 19, 1999 - queue functions - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


//
// Get number of items in the queue
//
function Queue::count(%name)
{
    return $Queue::end[%name] - $Queue::start[%name];
}

//
// Push another item onto the queue -- First In, First Out
//
function Queue::push(%name, %value)
{
    %index = $Queue::end[%name]++;
    $Queue::[%name, %index] = %value;
}

//
// Pop the next item off the queue -- First In, First Out
//
function Queue::pop(%name)
{
    %index = $Queue::start[%name]++;
    %value = $Queue::[%name, %index];
    $Queue::[%name, %index] = "";
    if($Queue::start[%name] > $Queue::end[%name])
        $Queue::start[%name] = $Queue::end[%name] = 0;

    return %value;
}

//
// Get the last item on the queue and empty it
//
function Queue::flush(%name)
{
    %value = $Queue::[%name, $Queue::end[%name]];
    $Queue::start[%name] = $Queue::end[%name] = 0;
    return %value;
}

//
// Reset ALL existing queues
//
function Queue::reset()
{
    deleteVariables("$Queue::*");
}
Event::Attach(eventChangeMission, "Queue::Reset();");
Event::Attach(eventConnected, "Queue::Reset();");
