// ---------------------------------------------------------------------------
// station_events.cs -- Version 3.1 -- May 19, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\station_events.cs", "3.1", "Lorne Laliberte", "- May 19, 1999 - enter/exit station events - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");
include("writer\\inventory_table.cs");
include("writer\\ping.cs");


//
// MUTING:
//
// Set this to true if you don't want to see the white "Station Access On" messages
$Station::Mute::StationAccessOn = true;

// Set this to true if you don't want to see the white "Station Access Off" messages
$Station::Mute::StationAccessOff = true;

// Set this to true if you don't want to see the white "Command Access On" messages
$Command::Mute::CommandAccessOn = true;

// Set this to true if you don't want to see the white "Command Access Off" messages
$Command::Mute::CommandAccessOff = true;

// Set this to true if you don't want to see the white "Unit is disabled" messages
$Station::Mute::UnitIsDisabled = false;

// Set this to true if you don't want to see the white "Unit is not powered" messages
$Station::Mute::UnitIsNotPowered = false;

// Set this to true if you don't want to see the white "Resupply Complete" messages
$Station::Mute::ResupplyComplete = false;

// Set this to true if you don't want to see the white "--ACCESS DENIED-- Wrong Team " messages
$Station::Mute::AccessDenied = false;


// You'd best leave everything alone below this line!
//
// ---------S-C-R-I-P-T-I-N-G----L-I-N-E----D-O----N-O-T----C-R-O-S-S---------


function Station::onClientMessage(%client, %msg)
{
    if(%client)
        return true;

    if(%msg == "Station Access On")
    {
        $Station::AtStation = true;

        Event::Trigger(eventEnterStation);

        $Station::AtVehicleStation =
        $Station::AtBaseInventoryStation =
        $Station::AtDeployableInventoryStation =
        $Station::AtInventoryStation = false;
        $Station::prevInventoryCount = $Station::InventoryCount;

        if($pref::noEnterInvStation)
        {
            remoteEval(2048, ToggleInventoryMode);
            schedule("Ping::Wait(\"Station::onAccess();\");", 0.2);
            schedule("remoteEval(2048, PlayMode);", 0.2);
        }
        else
        {
            schedule("Ping::Wait(\"Station::onAccess();\");", 0.2);
        }

        if($Station::Mute::StationAccessOn)
            return mute;
    }
    else if(%msg == "Station Access Off")
    {
        if($Station::AtVehicleStation)
        {
            Event::Trigger(eventExitVehicleStation);
        }
        else if($Station::AtBaseInventoryStation)
        {
            Event::Trigger(eventExitBaseInventoryStation);
            Event::Trigger(eventExitInventoryStation);
        }
        else if($Station::AtDeployableInventoryStation)
        {
            Event::Trigger(eventExitDeployableInventoryStation);
            Event::Trigger(eventExitInventoryStation);
        }
        Event::Trigger(eventExitStation);

        $Station::AtStation =
        $Station::AtVehicleStation =
        $Station::AtBaseInventoryStation =
        $Station::AtDeployableInventoryStation =
        $Station::AtInventoryStation = false;

        if($Station::Mute::StationAccessOff)
            return mute;
    }
    else if(%msg == "Command Access On")
    {
        $Station::AtStation = 
        $Station::AtCommandStation = true;

        Event::Trigger(eventEnterStation);
        Event::Trigger(eventEnterCommandStation);

        if($PowerWasDown)
            Event::Trigger(eventPowerRestored);

        if($Station::Mute::CommandAccessOn)
            return mute;
    }
    else if(%msg == "Command Access Off")
    {
        Event::Trigger(eventExitCommandStation);
        Event::Trigger(eventExitStation);
        $Station::AtStation = 
        $Station::AtCommandStation = false;

        if($Station::Mute::CommandAccessOn)
            return mute;
    }
    else if(%msg == "Unit is disabled")
    {
        Event::Trigger(eventStationDisabled);

        if($Station::Mute::UnitIsDisabled)
            return mute;
    }
    else if(%msg == "Unit is not powered")
    {
        Event::Trigger(eventPowerIsDown);

        if($Station::Mute::UnitIsNotPowered)
            return mute;
    }
    else if(%msg == "Resupply Complete")
    {
        Event::Trigger(eventResupplyComplete);

        if($Station::Mute::ResupplyComplete)
            return mute;
    }
    else if(%msg == "--ACCESS DENIED-- Wrong Team")
    {
        Event::Trigger(eventEnemyStation);

        if($Station::Mute::AccessDenied)
            return mute;
    }

    return true;
}
Event::Attach(eventClientMessage, Station::onClientMessage);


//
// Determine whether we're at a Base Inventory, Deployable Inventory, or Vehicle station
//
function Station::onAccess()
{
    if($Station::AtStation)
    {
        if($Station::prevInventoryCount == $Station::InventoryCount)
        {
            if($pref::noEnterInvStation)
            {
                remoteEval(2048, ToggleInventoryMode);
                schedule("Ping::Wait(\"Station::onAccess();\");", 0.2);
                schedule("remoteEval(2048, PlayMode);", 0.2);
            }
            else
            {
                schedule("Ping::Wait(\"Station::onAccess();\");", 0.2);
            }
            if($Debug::echo)
                echo("Inventory Screen didn't pop up!");

            return;            
        }

        %buyableitems = CmdInventory::getVisibleSet(BuyList);

        if(%buyableitems != "")
        {
            $Station::onAccessCounter = 0;
        
            %i = 0;
            while( (%item = getWord(%buyableitems, %i)) != -1)
            {
                if(%item == $Inv::VehicleList[$Inv::VehicleCount])
                {
                    $Station::AtVehicleStation = true;
        
                    Event::Trigger(eventEnterVehicleStation);
                
                    if($PowerWasDown)
                        Event::Trigger(eventPowerRestored);
        
                    return;
                }
                if(%item == $Inv::Inventory_Station)
                {
                    $Station::AtBaseInventoryStation = $Station::AtInventoryStation = true;
        
                    Event::Trigger(eventEnterBaseInventoryStation); // thanks to Cowboy for the suggestion to use "Base" in this event name
                    Event::Trigger(eventEnterInventoryStation);
        
                    if($PowerWasDown)
                        Event::Trigger(eventPowerRestored);
        
                    return;
                }
                %i++;
            }
            $Station::AtDeployableInventoryStation = $Station::AtInventoryStation = true;
            Event::Trigger(eventEnterDeployableInventoryStation);
            Event::Trigger(eventEnterInventoryStation);
        }
    }
    return;
}


function Station::onGuiOpen(%gui)
{
    if(%gui == CmdInventoryGui)
    {
        $Station::InventoryMode = true;
        $Station::PlayMode = false;
        $Station::InventoryCount++;
        return;
    }

    if(%gui == CommandGui)
    {
        $Station::CommandMode = true;
        $Station::PlayMode = false;
        return;
    }

    if(%gui == PlayGui)
    {
        $Station::InventoryMode = 
        $Station::CommandMode = false;
        $Station::PlayMode = true;
    }
}
Event::Attach(eventGuiOpen, Station::onGuiOpen);


//
// Reset flags and/or loadout data
//
function Station::Reset()
{
    $PowerWasDown =
    $Station::InventoryMode =
    $Station::AtStation =
    $Station::AtVehicleStation =
    $Station::AtBaseInventoryStation =
    $Station::AtDeployableInventoryStation =
    $Station::AtInventoryStation = false;
    $Station::InventoryCount = 0;
}
Event::Attach(eventConnected, "Station::Reset();");
Event::Attach(eventChangeMission, "Station::Reset();");


//
// Get rid of Presto's Inventory::onClientMessage even if
// it gets attached after this script is called :)
//
function Station::Remove_Inventory::onClientMessage()
{
    Event::Detach(eventClientMessage, Inventory::onClientMessage);
    schedule("Event::Detach(eventConnected, Station::Remove_Inventory::onClientMessage);", 15);
}
Event::Attach(eventConnected, Station::Remove_Inventory::onClientMessage);


