// ---------------------------------------------------------------------------
// tap_throw.cs -- Version 1.7 -- May 5, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\tap_throw.cs", "1.7", "Lorne Laliberte", "- May 5, 1999 - throw all grenades/mines - www.planetstarsiege.com/lorne/");

include("writer\\whatif.cs");

//
// Tap key to throw all you're carrying of an item (such as all Grenades or Mines),
// press key and release to throw a single item (such as a single Grenade or Mine).
//
function tapThrow(%on, %item, %taptime)
{
    if(%on) // Key Pressed
    {
        if(!%taptime)
            %taptime = 0.100; // 0.100 seconds default
            
        if( $Throw::keepThrowing[%item] && (%item == $Throw::itemBeingThrown) ) // we're already throwing this item
        {
            // Stop throwing item
            Throw::stopThrowing(%item);
        }
        else // we're not throwing this item so start throwing it
        {
            if(getItemCount(%item))
            {
                // Start to throw
                throwStart();

                // Set flag to enable the power bar display
                $Throw::throwing[%item] = true;
    
                // Set flag to initialize our keytap timer
                $WithinThrowTapTime = 1;
                
                // Clear flag (stop keytap timer) in %taptime seconds
                schedule("$WithinThrowTapTime=0;", %taptime);

                // Show the power bar :)
                // (I start it after a display so it won't show up momentarily when we tap the key)
                schedule("Throw::powerDisplay("@ %item @");",%taptime);
            }
        }
    }
    else // Key Released
    {
        if($WithinThrowTapTime) // key was tapped!
        {
            // Clear flag to stop displaying the power bar
            $Throw::throwing[%item] = false;

            // Stop throwing previous item
            Throw::stopThrowing($Throw::itemBeingThrown);

            // Start throwing 'em all at full force
            Throw::startThrowing(%item);
        }
        else // key was held then released
        {
            // Key was pressed more than %taptime seconds ago
            if($Throw::throwing[%item])
            {
                // Clear flag to stop displaying the power bar
                $Throw::throwing[%item] = false;

                // Calculate how many of this item we'll have left...the item count
                // is not updated right after throwRelease(), so let's sidestep the delay
                %count = getItemCount(%item) - 1;

                // Throw it
                throwRelease(%item);
    
                // Show how many of this item are left
                remoteBP(2048, "<L5><f2>" @ wif(%count > 0, %count, "NO") @ "<f0> " @ %item @ wif(%count == 1, " left", "s left"), 3);
            }
        }
    }
}

//
// Show a handy little power bar to help guage the strength of the throw
//
function Throw::powerDisplay(%item)
{
    if( $Throw::throwing[%item] && ($Throw::powercount++  < 100) )
    {
        $Throw::powerbar = $Throw::powerbar @ "||";
        remoteBP(2048, "<L5>" @ %item @ "  <f2>" @ $Throw::powercount + 1 @ "% <f1><L25>" @ $Throw::powerbar);

        schedule("Throw::powerDisplay("@ %item @");", 0.01);
    }
    else
    {
        $Throw::powerbar = "";
        $Throw::powercount = 0;
    }
}


function Throw::startThrowing(%item)
{
    $Throw::itemBeingThrown = %item;
    $Throw::keepThrowing[%item] = true;
    Throw::thrower(%item);
}

function Throw::stopThrowing(%item)
{
    $Throw::keepThrowing[%item] = false;
}

$Throw::interval = 0.6;

function Throw::thrower(%item)
{
    if($Throw::keepThrowing[%item])
    {
        // Get number of items before and after throwing one
        %countafter = (%count = getItemCount(%item)) - 1;

        // Show how many of this item are remaining
    	remoteBP(2048, "<L5><f2>" @ wif(%countafter > 0, %countafter, "NO") @ "<f0> " @ %item @ wif(%countafter == 1, " left", "s left"), 3);

        if(%count) // we have some left to throw
        {
            // Set force to throw item with
        	remoteEval(2048, throwItem, getItemType(%item), 100);
        
            // Throw the item
            throwRelease(%item);

            // Throw next item after $Throw::interval seconds
    		schedule("Throw::thrower(" @ %item @ ");", $Throw::interval);
    	}
    	else // none left of this item
    	{
            // Not carrying any more of this item, so stop throwing them :)
    	    $Throw::keepThrowing[%item] = false;
    	}
    }
}


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae"); 
    
    // Tap key to throw all grenades, press key to throw one grenade
    bindCommand(keyboard0, make, "f", TO, "tapThrow(1, \"Grenade\");");
    bindCommand(keyboard0, break, "f", TO, "tapThrow(0, \"Grenade\");");
    
    // Tap key to throw all mines, press key to throw one mine
    bindCommand(keyboard0, make, shift, "f", TO, "tapThrow(1, \"Mine\");");
    bindCommand(keyboard0, break, shift, "f", TO, "tapThrow(0, \"Mine\");");
}
