// mHUD version 5.0
// 
// (c) 8/9/99 Cowboy, don't modify this without my permission
// -
// New in 5.0: NewOpts support! (see the NewOpts HELP for info, please!)
//
// Let me know of any BUGS, thanks. My email is cowboy@planetstarsiege.com
// -
// NOTE: Requires Presto Pack 0.93 or greater!
//
// Also, Zear's NewOpts is strongly recommended! Please use it! This *should*
// work without it installed, but NewOpts makes it SOOO much better, and I
// will not tell yuo how to edit this script manually if you ask. I will
// simply say "get NewOpts!" :)
// 
// My Page: http://www.planetstarsiege.com/cowboy/
// Presto Pack: http://www.planetstarsiege.com/presto/
// Zear's NewOpts: http://www.planetstarsiege.com/zear/
// Writer's page: http://www.planetstarsiege.com/lorne/
//
// Features (newest changes first):
//
// * Added support for a separate Scout reticle (when used in conjunction with
//   Writer's pilot_mode.cs script), and Writer sent me his reticle to include.
//   Also, added more flexability with Writer's zoom.cs keys binding!
// * I've included 'overlay' Reticles for Plasma Gun, Chaingun, Disc Launcher,
//   Laser Rifle, Targeting Laser, and Repair Gun (as well as Mortar & Grenade
//   rangefinders)
// * Completely fixed the bug where certain items in CmdHUD's inventory and
//   command map screens wouldn't be selectable! 
// * Supports different Mortar & Grenade Launcher rangefinders for each major
//   resolution (Presto did 640x480, I did 800x600, Mannkind did 1024x768) If
//   you use a different resolution, you can make your own!
// * Rebound the sniper zoom key (default 'e') to get rangefinders to disappear
//   if you were zooming in
// * I rebind the 1st/3rd person toggle key (default 'r') so that it'll turn
//   off the mHUD display when you are in 3rd person mode (fixed)
// * Bound 'alt-f12' to toggle Debug Mode, will echo to the console everything
//   that mHUD does, for troubleshooting or curiosity :)
// * Bound 'alt-q' to force the Mortar rangefinder on, use it if you're at a
//   commander station and using a Mortar Turret! (stays on until you change
//   Gui modes or change weapons)
// * Reticles are now 'overlays' and ADD to the default cursor! use your own
//   personal favorite default (or use mine) and any cursor you make ADDS to
//   your existing one! (if you want, you can set it up the old way, but I'm
//   not going to provide support for that anymore)
// * Different reticles possible for each base weapon, including definitions
//   for any mod weapons you want to add (I also did one for 'Repair Gun'!)
// * Supports resize-on-the-fly! (uses Presto's functions)
// * All reticle sizes are now 63 pixels wide! It turns out that larger sizes
//   would overlap CmdHUD commander and inventory panels! That's no good!
//
// also... FULLY COMPATIBLE with CmdHUD 1.0+
//
// Lots of help, code, and reticles from GrymReaper - Kick ass! Thanks!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// Installation notes:
// 
// Unzip file to your tribes directory! All the files will be put in the right
// places!
//
// (h_reticle.bmp goes into the tribes\base directory, all other files go into
// tribes\config\cowboy\ directory, and add line: Include("cowboy\\mHUD.cs"); to
// your autoexec.cs file somewhere AFTER the exec("presto\\install.cs"); line
// and after the Include("NewOpts\\install.cs"); line
//
// NOTE: This replaces the built-in crosshairs, and will overwrite your
//       crosshairs, so make a backup! I suggest trying my h_reticle.bmp first
//       to see how it works, although  you _can_ use your own h_reticle.bmp!
//
// This now supports resizing, and there are correct rangefinder bitmaps for
// 640x480, 800x600, and 1024x768! If you want to create an _accurate_ one
// for a different resolution, do it up using mHUD_*_unknown.bmp and mail it to
// me! If i use it here, you'll get the credit!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// 
// (c) 1999 Cowboy, whatever... I hope you enjoy this, and all that I ask is 
// that you give me (and GrymReaper) props for it.. enjoy!
//
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

Include("presto\\Install.cs");
Include("presto\\Event.cs");
Include("presto\\Inventory.cs");

// $mHUD::UpdateTime: how often we check for switching weapon status 

$mHUD::UpdateTime = 0.3;

$mHUD::DebugMode = false;

// need to define this here to allow adding weapons!
function mHUD::AddWeapon(%Weapon, %Reticle, %RangeFinder) {
	$mHUD::Reticle[%Weapon] = %Reticle;
	$mHUD::RangeFinder[%Weapon] = %RangeFinder;
	if ($mHUD::DebugMode) {
		echo("Weapon Added: " @ %weapon);
		if ($mHUD::Reticle[%Weapon] != "") echo(" w/Reticle: " @ $mHUD::Reticle[%Weapon]);
		if ($mHUD::RangeFinder[%Weapon] != "") echo(" w/Rangefinder: " @ $mHUD::RangeFinder[%Weapon]);
		}
	}

//
// Define weapon types!
//
// mHUD::AddWeapon("Weapon Name", ReticleBmp, RangeFinderBmp);
//
// NOTE: You can easily get "Weapon Name" by selecting the weapon in Tribes,
//       bringing up the console (~) and typing in this command:
//
//       echo($Inv::Name[getMountedItem(0)]);
//
//       This echoes the name of the selected weapon to the console!
//
//       NOTE: if it doesn't echo anything, then that Mod's weapons have not
//             been defined in writer's inventory_table.cs file! contact the
//             Mod author on info for how to update that! :)
//
// Each weapon can have its own combination of reticle & rangefinder. If the
// weapon doesn't need either a Reticle or RangeFinder, use a "". This way you
// can define ANY possible combination per weapon: use just a reticle, just a
// rangefinder, or use both reticle & rangefinder!
//
// (see my examples below!)
//
// Notice that the rangefinder bitmap ends in "_" because it's required that
// each rangefinder exist for all available resolutions. (for accuracy)
//
// for "cowboy\\mHUD_rangefinder_Mortar_", these files exist:
//
//    cowboy\\mHUD_rangefinder_Mortar_unknown.bmp
//    cowboy\\mHUD_rangefinder_Mortar_640.bmp
//    cowboy\\mHUD_rangefinder_Mortar_800.bmp
//    cowboy\\mHUD_rangefinder_Mortar_1024.bmp
//
// This script AUTOMATICALLY adds the current resolution's X value (ex: 1024)
// and ".bmp" to the end of the string!
//
// if you add your own bitmaps, keep in mind you have to also add the full file
// name of the bitmap in the 'ADD TAGS' section (below)

// Base
//
mHUD::AddWeapon("Repair Gun", "cowboy\\mHUD_reticle_Repairgun.bmp", "");
mHUD::AddWeapon("Plasma Gun", "cowboy\\mHUD_reticle_Plasma.bmp", "");
mHUD::AddWeapon("Chaingun", "cowboy\\mHUD_reticle_Chaingun.bmp", "");
mHUD::AddWeapon("Disc Launcher", "cowboy\\mHUD_reticle_Disc.bmp", "");
mHUD::AddWeapon("Grenade Launcher", "", "cowboy\\mHUD_rangefinder_Grenade_");
mHUD::AddWeapon("Laser Rifle", "cowboy\\mHUD_reticle_Laser.bmp", "");
mHUD::AddWeapon("ELF gun", "cowboy\\mHUD_reticle_ELF.bmp", "");
mHUD::AddWeapon("Mortar", "", "cowboy\\mHUD_rangefinder_Mortar_");
mHUD::AddWeapon("Targeting Laser", "cowboy\\mHUD_reticle_Target.bmp", "");
mHUD::AddWeapon("Scout", "cowboy\\mHUD_reticle_Scout.bmp", "");

// Asylum Mod - http://www.planetstarsiege.com/asylum/
//
mHUD::AddWeapon("Equalizer", "cowboy\\mHUD_reticle_Chaingun.bmp", "");
mHUD::AddWeapon("Shotgun", "cowboy\\mHUD_reticle_Chaingun.bmp", "");
mHUD::AddWeapon("Soul Stealer", "", "cowboy\\mHUD_rangefinder_Grenade_");
mHUD::AddWeapon("Blast Launcher", "", "cowboy\\mHUD_rangefinder_Grenade_");
mHUD::AddWeapon("Laser Shredder", "cowboy\\mHUD_reticle_Laser.bmp", "");
mHUD::AddWeapon("Sniper Rifle", "cowboy\\mHUD_reticle_Laser.bmp", "");
mHUD::AddWeapon("Earthquake Cannon", "cowboy\\mHUD_reticle_Disc.bmp", "");

// Insomniax Mod - http://www.insomniax.net/mods/
//
mHUD::AddWeapon("EMP Grenade launcher", "", "cowboy\\mHUD_rangefinder_Mortar_");
mHUD::AddWeapon("Rocket Launcher", "cowboy\\mHUD_reticle_Scout.bmp", "");
mHUD::AddWeapon("IX-2000 Sniper Rifle", "cowboy\\mHUD_reticle_Laser.bmp", "");
mHUD::AddWeapon("Shotgun", "cowboy\\mHUD_reticle_Chaingun.bmp", "");
mHUD::AddWeapon("Pyro-Torch", "cowboy\\mHUD_reticle_Plasma.bmp", "");
mHUD::AddWeapon("Phalanxx Cannon", "cowboy\\mHUD_reticle_Chaingun.bmp", "");
mHUD::AddWeapon("MAG Gun", "cowboy\\mHUD_reticle_ELF.bmp", "");

// Shifter Mod - http://www.dopplegangers.com/tribes/shifter/
//
mHUD::AddWeapon("Hyper Blaster", "cowboy\\mHUD_reticle_Plasma.bmp", "");
mHUD::AddWeapon("Rocket Launcher", "cowboy\\mHUD_reticle_Plasma.bmp", "");
mHUD::AddWeapon("Sniper Rifle", "cowboy\\mHUD_reticle_Laser.bmp", "");
mHUD::AddWeapon("Boom Stick","cowboy\\Shifter_reticle_boom.bmp", "");
mHUD::AddWeapon("Dart Rifle", "cowboy\\mHUD_reticle_Target.bmp", "");
mHUD::AddWeapon("Magnum", "cowboy\\mHUD_reticle_Plasma.bmp", "");
mHUD::AddWeapon("Shockwave Cannon", "cowboy\\mHUD_reticle_Plasma.bmp", "");
mHUD::AddWeapon("RailGun", "cowboy\\mHUD_reticle_Laser.bmp", "");
mHUD::AddWeapon("Vulcan", "cowboy\\mHUD_reticle_Chaingun.bmp", "");
mHUD::AddWeapon("Tactical Nuke", "", "cowboy\\mHUD_rangefinder_Mortar_");
mHUD::AddWeapon("Flame Thrower", "cowboy\\Shifter_reticle_boom", "");
mHUD::AddWeapon("Ion Rifle", "cowboy\\mHUD_reticle_Disc.bmp", "");
mHUD::AddWeapon("Volter", "", "cowboy\\mHUD_rangefinder_Grenade_");
mHUD::AddWeapon("Targeting Laser", "cowboy\\mHUD_reticle_Target.bmp", "");
mHUD::AddWeapon("Engineer Repair-Gun", "cowboy\\mHUD_reticle_Repairgun.bmp", "");
mHUD::AddWeapon("Grav Gun", "cowboy\\mHUD_reticle_Target.bmp", "");

//
// ADD TAGS, hopefully these id #'s will never be used by anyone else!
//

//don't use this one, sometimes it stays on ALL the time (???) weird...
IDBMP_MHUD_UNRELIABLE		= 00160950, ""; 

//base weapons
IDBMP_MHUD_RETICLE_BLASTER 	= 00160951, ""; 
IDBMP_MHUD_RETICLE_PLASMA 	= 00160952, "cowboy\\mHUD_reticle_Plasma.bmp"; 
IDBMP_MHUD_RETICLE_CHAINGUN	= 00160953, "cowboy\\mHUD_reticle_Chaingun.bmp"; 
IDBMP_MHUD_RETICLE_DISC 	= 00160954, "cowboy\\mHUD_reticle_Disc.bmp"; 
IDBMP_MHUD_RETICLE_GRENADE 	= 00160955, "";
IDBMP_MHUD_RETICLE_LASER 	= 00160956, "cowboy\\mHUD_reticle_Laser.bmp"; 
IDBMP_MHUD_RETICLE_ELF 		= 00160957, "cowboy\\mHUD_reticle_ELF.bmp"; 
IDBMP_MHUD_RETICLE_MORTAR 	= 00160958, "";
IDBMP_MHUD_RETICLE_TARGET 	= 00160959, "cowboy\\mHUD_reticle_Target.bmp"; 

//repair gun
IDBMP_MHUD_RETICLE_REPAIR	= 00160960, "cowboy\\mHUD_reticle_Repairgun.bmp";

//scout flier
IDBMP_MHUD_RETICLE_SCOUT	= 00160961, "cowboy\\mHUD_reticle_Scout.bmp";

//mod or additional weapons
IDBMP_MHUD_RETICLE_1		= 00160962, "";
IDBMP_MHUD_RETICLE_2		= 00160963, "";
IDBMP_MHUD_RETICLE_3		= 00160964, "";
IDBMP_MHUD_RETICLE_4		= 00160965, "";
IDBMP_MHUD_RETICLE_5		= 00160966, "";
IDBMP_MHUD_RETICLE_6		= 00160967, "";
IDBMP_MHUD_RETICLE_7		= 00160968, "";
IDBMP_MHUD_RETICLE_8		= 00160969, "";

//mortar rangefinder
IDBMP_MHUD_R000_MORTAR 		= 00160970, "cowboy\\mHUD_rangefinder_Mortar_unknown.bmp";
IDBMP_MHUD_R640_MORTAR		= 00160971, "cowboy\\mHUD_rangefinder_Mortar_640.bmp";
IDBMP_MHUD_R800_MORTAR		= 00160972, "cowboy\\mHUD_rangefinder_Mortar_800.bmp";
IDBMP_MHUD_R1024_MORTAR		= 00160973, "cowboy\\mHUD_rangefinder_Mortar_1024.bmp";

//grenade rangefinder
IDBMP_MHUD_R000_GRENADE		= 00160974, "cowboy\\mHUD_rangefinder_Grenade_unknown.bmp";
IDBMP_MHUD_R640_GRENADE		= 00160975, "cowboy\\mHUD_rangefinder_Grenade_640.bmp";
IDBMP_MHUD_R800_GRENADE		= 00160976, "cowboy\\mHUD_rangefinder_Grenade_800.bmp";
IDBMP_MHUD_R1024_GRENADE	= 00160977, "cowboy\\mHUD_rangefinder_Grenade_1024.bmp";

//mod rangefinder
IDBMP_MHUD_RMISC_0		= 00160978, "";
IDBMP_MHUD_RMISC_1		= 00160979, "";
IDBMP_MHUD_RMISC_2		= 00160980, "";
IDBMP_MHUD_RMISC_3		= 00160981, "";

//mod rangefinder
IDBMP_MHUD_RMISC_4		= 00160982, "";
IDBMP_MHUD_RMISC_5		= 00160983, "";
IDBMP_MHUD_RMISC_6		= 00160984, "";
IDBMP_MHUD_RMISC_7		= 00160985, "";

//mod rangefinder
IDBMP_MHUD_RMISC_8		= 00160986, "";
IDBMP_MHUD_RMISC_9		= 00160987, "";
IDBMP_MHUD_RMISC_10		= 00160988, "";
IDBMP_MHUD_RMISC_11		= 00160989, "";

//
// For Presto Pack 0.93+, this displays script info in a box on the main
// menu screen, kind of an 'Advertisement/Info Box' for installed scripts.
//
if ($Presto::version >= 0.93) {
	Presto::AddScriptBanner(mHUD, "<B3,4:mHUDPrestoBanner.bmp>");
	}

// load the .vol file
newObject(mHUD, SimVolume, "cowboy\\mHUD.vol");

//
// This constantly runs and checks to see if which weapon is loaded
//
// 'Safe' scheduling code from Presto! thanks!
//
function scheduled_mHUD::Timer(%id) {
   if (%id != $mHUD_scheduled_id)
      return;
   mHUD::Timer();
   schedule("scheduled_MHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
function schedule_mHUD::Timer() {
   $mHUD_scheduled_id++;
   schedule("scheduled_mHUD::Timer("@$mHUD_scheduled_id@");", $mHUD::UpdateTime);
   }
 
Event::Attach(eventConnected, schedule_MHUD::Timer);
 
function mHUD::Timer() {
	%weapon = mHUD::CurrentWeapon();
	
	if ($mHUD::LastResolution != Presto::ScreenSize())
		mHUD::UpdateResolution();

	if (!$mHUD::Initialized && %weapon != -1) {
		if (included("writer\\zoom.cs")) {
			Event::Attach(eventZoomOn, mHUD::ToggleSniperWriterOn);
			Event::Attach(eventZoomOff, mHUD::ToggleSniperWriterOff);
			}
		$mHUD::Initialized = true;
		mHUD::Init();
		}

	if ($mHUD::ForceMortar == $mHUD::ForceMortarOn)
		mHUD::UpdateReticle();
	
	if (%weapon != $mHUD::LastWeapon
		|| $mHUD::ToggleViewState != $mHUD::LastToggleViewState
		|| $mHUD::ToggleSniperState != $mHUD::LastToggleSniperState) {
		
		mHUD::ForceMortarToggle(false);
		mHUD::UpdateReticle();
		}

	if (included("cowboy\\CmdHUD.cs") && $CmdHUD::guiMode == 2 && $mHUD::CurrentGui == CommandGui) {
		if ($CmdHUD::MapState && !$mHUD::CmdHUD::ReticleState ) {
			$mHUD::CmdHUD::ReticleState = true;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		else if (!$CmdHUD::MapState && $mHUD::CmdHUD::ReticleState) {
			$mHUD::CmdHUD::ReticleState = false;
			mHUD::SetVisible(RangeFinder, $mHUD::CmdHUD::ReticleState);
			mHUD::SetVisible(Reticle, $mHUD::CmdHUD::ReticleState);
			}
		}
	}

function mHUD::UpdateResolution() {
	$mHUD::LastResolution = Presto::ScreenSize();
	$mHUD::X = getWord($mHUD::LastResolution, 0);
	$mHUD::Y = getWord($mHUD::LastResolution, 1);

	if ($mHUD::DebugMode) echo($mHUD::X @ ", " @ $mHUD::Y);
	
	if ($mHUD::X == 640)
		$mHUD::resX = "640";
	else if ($mHUD::X == 800)
		$mHUD::resX = "800";
	else if ($mHUD::X == 1024)
		$mHUD::resX = "1024";
	else
		$mHUD::resX = "unknown";
	}

function mHUD::isString(%string) {
	if (%string == "" || %string == -1)
		return false;
	else
		return true;
	}
	
function mHUD::UpdateReticle() {
	%weapon = mHUD::CurrentWeapon();

	if ($mHUD::ForceMortar)
		%weapon = "Mortar";

	$mHUD::CurrentReticle = $mHUD::Reticle[%weapon];
	$mHUD::ReticleVisible = mHUD::isString($mHUD::CurrentReticle);

	$mHUD::CurrentRangeFinder = $mHUD::RangeFinder[%weapon];
	$mHUD::RangeFinderVisible = mHUD::isString($mHUD::CurrentRangeFinder);

	if (!$mHUD::ForceMortar)
		$mHUD::LastWeapon = %weapon;
	$mHUD::ForceMortarOn = !$mHUD::ForceMortarOn;
	$mHUD::LastToggleViewState = $mHUD::ToggleViewState;
	$mHUD::LastToggleSniperState = $mHUD::ToggleSniperState;
	
	if ($mHUD::DebugMode) echo("Current Weapon: " @ %weapon);
	
	mHUD::LoadBitmaps();
	}

function mHUD::LoadBitmaps() {
	$mHUD::CmdHUD::ReticleState = true;
	
	if ($mHUD::ToggleViewState) {
		mHUD::SetVisible(Reticle, false);
		mHUD::SetVisible(RangeFinder, false);
		}
	else if ($mHUD::ToggleSniperState) {
		mHUD::SetVisible(Reticle, ($mHUD::ReticleVisible && $pref::mHUDreticles));
		mHUD::SetVisible(RangeFinder, false);
		}
	else {
		mHUD::SetVisible(Reticle, ($mHUD::ReticleVisible && $pref::mHUDreticles));
		mHUD::SetVisible(RangeFinder, ($mHUD::RangeFinderVisible && $pref::mHUDrangefinders));
		}
	
	mHUD::SetValue(Reticle, $mHUD::CurrentReticle);
	mHUD::SetValue(RangeFinder, $mHUD::CurrentRangeFinder @ $mHUD::resX @ ".bmp");

	if ($mHUD::DebugMode) { echo("Bitmaps Loaded"); echo(""); }
	}

function mHUD::SetVisible(%object, %state) {
	Control::SetVisible("mHUD::" @ %object @ "::" @ $mHUD::Counter, %state);
	if ($mHUD::DebugMode) echo("SetVisible: mHUD::" @ %object @ "::" @ $mHUD::Counter @ ", "@ %state);
	}

function mHUD::SetValue(%object, %value) {
	if (%object == Reticle && !$mHUD::ReticleVisible) return;
	else if (%object == RangeFinder && !$mHUD::RangeFinderVisible) return;
	else if ($mHUD::ToggleViewState) return;
	
	Control::SetValue("mHUD::" @ %object @ "::" @ $mHUD::Counter, "<B0,0:" @ %value @ ">");
	if ($mHUD::DebugMode) echo("SetValue: mHUD::" @ %object @ "::" @ $mHUD::Counter @ ", <B0,0:" @ %value @ ">");
	}

function mHUD::CreateBitmap(%frame, %name) {
	%var = newobject(%name, FearGuiFormattedText, 0, 0, 255, 255);
	addToSet(%frame, %var);
	if ($mHUD::DebugMode) echo(%name @ "\(" @ %var @ "\) Created in " @ %frame);
	return %var;
	}	

function mHUD::CreateRangeFinderFrame(%gui) {
	%frame = newobject("mHUD::Frame::RangeFinder::" @ $mHUD::Counter, SimGui::Control, $mHUD::X / 2 - 31, $mHUD::Y / 2 + 35, 63, 255);
	addToSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %frame;
	}

function mHUD::CreateReticleFrame(%gui) {
	%frame = newobject("mHUD::Frame::Reticle::" @ $mHUD::Counter, SimGui::Control, $mHUD::X / 2 - 31, $mHUD::Y / 2 - 31, 63, 63);
	addToSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Created in " @ %gui);
	return %frame;
	}

function mHUD::DeleteRangeFinderFrame(%gui, %frame) {
	removeFromSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::RangeFinder::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %frame;
	}

function mHUD::DeleteReticleFrame(%gui, %frame) {
	removeFromSet(%gui, %frame);
	if ($mHUD::DebugMode) echo("mHUD::Frame::Reticle::" @ $mHUD::Counter @ " Deleted from " @ %gui);
	return %frame;
	}
	
//
// Initialize the objects: load the gui, get the IDs, move stuff around
//
function mHUD::Init() {
	Event::Attach(eventConnected, mHUD::Reset);
	Event::Attach(eventChangeMission, mHUD::Reset);
	if ($mHUD::DebugMode) echo("mHUD Initialized");
	}

function mHUD::LoadGui() {
	guiPushDialog(MainWindow, "mHUD.gui");
	guiPopDialog(MainWindow, "mHUD.gui");
	if ($mHUD::DebugMode) echo("mHUD Gui Initialized (Transparent Bitmaps)");
	}
	
//
// Detect what gui you are in, if you use CmdHUD
//
function mHUD::GuiOpen(%gui) {
	mHUD::LoadGui();
	$mHUD::CurrentGui = %gui;
	if ($mHUD::DebugMode) echo("GuiOpen: " @ %gui);
	if (included("cowboy\\CmdHUD.cs") || %gui == "playGui") {
 		if (%gui == "playGui" || %gui == "CommandGui" || %gui == "CmdInventoryGui") {
			$mHUD::Counter++;
			$mHUD::RangeFinderFrame = mHUD::CreateRangeFinderFrame(%gui);
			$mHUD::RangeFinderBitmap = mHUD::CreateBitmap($mHUD::RangeFinderFrame, "mHUD::RangeFinder::" @ $mHUD::Counter);
			$mHUD::ReticleFrame = mHUD::CreateReticleFrame(%gui);
			$mHUD::ReticleBitmap = mHUD::CreateBitmap($mHUD::ReticleFrame, "mHUD::Reticle::" @ $mHUD::Counter);
			mHUD::LoadBitmaps();
		}
	}
	if (%gui == "LobbyGui") {
		echo("booboobooboobooboo");
		mHUD::ToggleSniper(0);
	}

}

//
// Detect what gui you just left, if you use CmdHUD
//
function mHUD::GuiClose(%gui) {
	if ($mHUD::DebugMode) echo("GuiClose: " @ %gui);
	if (included("cowboy\\CmdHUD.cs") || %gui == "playGui") {
		mHUD::DeleteRangeFinderFrame(%gui, $mHUD::RangeFinderFrame);
		mHUD::DeleteReticleFrame(%gui, $mHUD::ReticleFrame);
		}
	mHUD::ForceMortarToggle(false);
	}

//
// toggle 1st person/3rd person views
//
function mHUD::ToggleView() {
	$mHUD::ToggleViewState = !$mHUD::ToggleViewState;
	postAction(2048, IDACTION_VIEW, 1);
	if ($mHUD::DebugMode) echo("View State: " @ $mHUD::ToggleViewState);
	}

//
// toggle sniper zoom
//
function mHUD::ToggleSniper(%state) {
	postAction(2048, IDACTION_SNIPER_FOV, %state);
	mHUD::ToggleSniperWriter(%state);
	}

//
// if Writer's zoom.cs is installed, use his eventZoomOn and eventZoomOff
// triggers 
//
function mHUD::ToggleSniperWriter(%state) {
//	$mHUD::ToggleSniperState = !$mHUD::ToggleSniperState;
	$mHUD::ToggleSniperState = %state;

	if (%state && $mHUD::ForceMortar) {
		$mHUD::SnipeAndMortar = true;
		$mHUD::SnipeWeapon = mHUD::CurrentWeapon();
		}
	else if (!%state && $mHUD::SnipeAndMortar && !$mHUD::ForceMortar) {
		$mHUD::ForceMortar = true;
		$mHUD::SnipeAndMortar = false;
		}
		
	if ($mHUD::SnipeWeapon != mHUD::CurrentWeapon())
		$mHUD::ForceMortar = false;

	if ($mHUD::DebugMode) echo("Sniper State: " @ $mHUD::ToggleSniperState);
	}

function mHUD::ToggleSniperWriterOn() {
	mHUD::ToggleSniperWriter(true);
	if ($mHUD::DebugMode) echo("mHUD::ToggleSniperWriter(true)");
	}

function mHUD::ToggleSniperWriterOff() {
	mHUD::ToggleSniperWriter(false);
	if ($mHUD::DebugMode) echo("mHUD::ToggleSniperWriter(false)");
	}

//
// force the mortar rangefinder on (toggle)
//	
function mHUD::ForceMortarToggle(%state) {
	if (%state == "")
		$mHUD::ForceMortar = !$mHUD::ForceMortar;
	else
		$mHUD::ForceMortar = (%state && $mHUD::ForceMortar);
		
	$mHUD::ForceMortarOn = $mHUD::ForceMortar;
	
	if ($mHUD::DebugMode) echo("Force Mortar Toggle: " @ $mHUD::ForceMortar);
	}

function mHUD::CurrentWeapon() {
	%weapon = getMountedItem(0);
	%weaponName = $Inv::Name[%weapon];
	
	if (%weapon == -1) {
		if ($Pilotmode != 0 )
			%value = "Scout";
		else
			%value = -1;
		}
	else
		%value = %weaponName;
		
	if ($mHUD::DebugMode) echo("mHUD::CurrentWeapon(): " @ %value);
	return %value;
	}

//
// Reset all objects and variables
//
function mHUD::Reset() {
	$mHUD::LastWeapon = "";
	$mHUD::ForceMortar = false;
	$mHUD::ForceMortarOn = false;
	if ($mHUD::DebugMode) echo("mHUD Reset");
	}

function mHUD::InitViewState() {
	$mHUD::ToggleViewState = false;
	$mHUD::ToggleSniperState = false;
	}

$mHUD::Counter = 0;
$mHUD::Initialized = false;
$mHUD::InventoryInitialized = false;

Event::Attach(eventConnected, mHUD::Timer);
Event::Attach(eventConnected, mHUD::InitViewState);

Event::Attach(eventGuiOpen, mHUD::GuiOpen);
Event::Attach(eventGuiClose, mHUD::GuiClose);

Event::Attach(eventConnected, "schedule(\"mHUD::LoadGui();\", 3);");
Event::Attach(eventConnected, "schedule(\"mHUD::LoadGui();\", 6);");

// if these vars aren't set, default to 'TRUE' for both
function mHUD::CheckSettings() {
	if ($pref::mHUDrangefinders != "TRUE" && $pref::mHUDrangefinders != "FALSE")
		$pref::mHUDrangefinders = "TRUE";
		
	if ($pref::mHUDreticles != "TRUE" && $pref::mHUDreticles != "FALSE")
		$pref::mHUDreticles = "TRUE";
}

// Setup NewOpts options page
function mHUD::NewOptsOpen() {
	mHUD::CheckSettings();
	
	Control::SetValue("mHUD::NO1", "<b0,0:mHUDNO1.bmp>");
	Control::SetValue("mHUD::NO2", "<b0,0:mHUDNO2.bmp>");
	Control::SetValue("mHUD::NO3", "<b0,0:mHUDNO3.bmp>");
	Control::SetValue("mHUD::NO4", "<b0,0:mHUDNO4.bmp>");
	
	if (included("writer\\zoom.cs"))
		Control::setActive(mHUD::zoomKeyConfig, FALSE);
}

// If NewOpts is NOT installed, set default keys 
function mHUD::CheckNewOpts() {
	if (included("newopts\\newopts.cs")) {
		NewOpts::registerHelp("mHUD",	"<jc>What it does\n",
						"<jl>Well... it changes your reticles <f2>automatically <f1>during the game, based on what weapon you have " @
						"selected! There is a custom reticle for most of the base weapons, and rangefinders for the Mortar and " @
						"Grenade Launchers! You can choose to <f2>disable <f1>the reticles or rangefinders if you'd like, as well as set " @
						"up your key preferences in the <f2>NewOpts <f1>page.");

		NewOpts::registerHelp("mHUD",	"<jc>How to set it up\n",
						"<jl>Bind your <f2>1st/3rd Person <f1>key. That's simple. You want to bind it in mHUD so that it shuts off any " @
						"reticles / rangefinders while in 3rd person mode. The <f2>Force Mortar <f1>key is for those times " @
						"when you're in a mortar turret.. and want the rangefinder! (there is currently no way to detect if you " @
						"are in a mortar turret). If the <f2>Zoom <f1>key is greyed out, you have Writer's zoom.cs installed, use his " @
						"key binding instead.. otherwise use mHUD's (it shuts off the rangefinders while zoomed in, as they are " @
						"not accurate)");
						
		NewOpts::registerHelp("mHUD",	"<jc>How it works\n",
						"<jl>There is one base reticle. It is either Tribes' built-in reticle or the file tribes\\base\\h_reticle.bmp. " @
						"All the other custom reticles you see are actually <f2>overlays. <f1>They are overlayed over the default reticle, to " @
						"display <f2>in addition to <f1>the default reticle! The rangefinders are displayed below the reticle. Also, there is a " @
						"schedule() loop running at all times to check the current weapon, display the correct overlay or rangefinder, etc..");

		NewOpts::registerHelp("mHUD",	"<jc>Extra, extra!\n",
						"<jl>If you have Writer's <f2>pilot_mode.cs <f1>installed, when you enter a scout, and go into pilot-mode, a custom reticle " @
						"is loaded for the flier! Another thing, if you are using a repair pack/gun, a custom bitmap is loaded for that too!");

		NewOpts::registerHelp("mHUD",	"<jc>Customization / Mods\n",
						"<jl>if you want to modify the bitmaps, to customize them, go right ahead! The files are all named <f2>mHUD_reticle_*.bmp " @
						"<f1>in the tribes\\config\\cowboy\\ directory. Just make sure you use the correct palette, and use black as the transparent " @
						"color. There are <f2>complete instructions <f1>in mHUD.cs for adding different weapons / reticles / rangefinders to your setup. " @
						"Just edit in there.. (note, you're going to need some programming experience for this)\n\nI sent out email to all " @
						"the major Mod authors requesting that they add their weapon definitions for reticles / rangefinders - but I only " @
						"got responses from the authors of Insomniax, Asylum, and Shifter.. It's ok, I put theirs in.. If you want to add " @
						"the Renegades ones, or others I haven't mentioned... or even change the ones in there around, just look in the mHUD.cs " @
						"file.");

		NewOpts::registerHelp("mHUD",	"<jc>There you go...\n",
						"<jl>I hope you enjoy mHUD... I can't really think of anything else I need to do to it at this point, " @
						"so... this may be the last release (I said that last time, heh) If you have questions, you can send email to " @
						"<f2>cowboy@planetstarsiege.com<f1>\n\n" @
						"<jc>Or visit my web page at <f2>http://www.planetstarsiege.com/cowboy/<f1>\n\n" @
						"Thanks, Cowboy - 8/9/99");
			
		
		NewOpts::Register("mHUD", "mHUDno.gui", "mHUD::NewOptsOpen();", "", true);
		
	}
	else {
		echo("NewOpts not installed! Setting default mHUD keys/settings via script!");
		echo("If you DID install NewOpts, make sure mHUD.cs is loaded AFTER NewOpts in Autoexec.cs!");

		$pref::mHUDrangefinders = "TRUE";
		$pref::mHUDreticles = "TRUE";

		bindkey(play, "r", "mHUD::ToggleView();");
		bindkey(play, "alt q", "mHUD::ForceMortarToggle();");
		if (!included("writer\\zoom.cs"))
			bindkey(play, "e", "mHUD::ToggleSniper(1);", "mHUD::ToggleSniper(0);");
	}
}

mHUD::CheckSettings();
mHUD::CheckNewOpts();
