//
//  DialogOpts 1.0
//  Written by Tim 'Zear' Hammock
//

//  DialogOpts provides default dialogs for other scripts. These are modal
//  dialogs, and only one may be shown at a time. There are three pre-designed
//  dialogs and a general purpose dialog.
//
//  To create a general purpose dialog, call
//
//      DialogOpts::pushDialog(%title, %text, %color, %size, %type, %result);
//
//  where the parameters are as follows:
//
//  %title
//  The title string for the dialog. This text will be put into a
//  FearGuiFormattedText component, so you may use the following tags:
//      <f0>            brown text
//      <f1>            beige text
//      <f2>            white text
//      <jl>            left justify
//      <jc>            center justify
//      <jr>            right justify
//      <bx,y:bitmap>   display a bitmap
//      <l#> and <r#>   indent # columns from left or right
//      \n              carriage return
//      \t              tab
//  While you may use a \n character, I reccommend against it as the title
//  field is sized for one line of text only.
//
//  %text
//  The body text of the dialog. This text is also put into a
//  FearGuiFormattedText, so the above tags apply here too. The text area is
//  scrollable.
//
//  %color
//  I have provided 24 colors for the title bar, plus a black-with-white-border
//  version for a total of 25. The colors are:
//        B_&_W (black with white frame)
//        BLACK
//        DK_GRAY
//        MED_GRAY
//        LT_GRAY
//        WHITE
//        RED
//        PALE_RED
//        DK_RED
//        GREEN
//        LT_GREEN
//        DK_GREEN
//        DLG_GREEN (dialog green - matches the rest of the dialog)
//        BLUE
//        CYAN
//        AQUA
//        BLUE_GRAY
//        CORN_BLUE
//        DK_BLUE
//        YELLOW
//        PALE_YELLOW
//        PURPLE
//        DK_PURPLE
//        BROWN
//        BEIGE
//  To specify the color, pass in one of the above all-caps color names. If
//  you do not specify a color, it will default to B_&_W. You may want to
//  consider altering the color of your title text above to contrast better in
//  some cases.
//
//  %size
//  DialogOpts dialogs come in two sizes: SMALL and LARGE. Specify one of those
//  two all-caps strings to choose a size. If you do not specify a size, it
//  will default to SMALL. Both dialogs are identical except for the height of
//  the body text area. A SMALL dialog provides about 4 2/3 lines. A LARGE
//  dialog provides about 13 lines. There is, of course, a vertical scroll bar
//  in case your text exceeds the number of displayable lines.
//
//  %type
//  This parameter can be one of:
//      OK -
//      This is the default where no type is specified. There will be a
//      single, active OK button at the bottom. Clicking the button will close
//      the dialog.
//      DONE -
//      Provides two buttons, DONE and CANCEL, at the bottom of the dialog, and
//      both buttons will be active.
//      DONECHECK -
//      Provides both DONE and CANCEL, but DONE is inactive (grayed out) until
//      a call is made to DialogOpts::activateDialogDone(). This allows you to
//      add components to the dialog, and by setting the Console Command field
//      of your components to call a function you create, you can validate the
//      data the user has entered before enabling the DONE button. When the
//      call to DialogOpts::pushDialog() completes, it will return a handle to
//      the dialog panel. If you do not pass text for the dialog body, you can
//      use this handle to construct a custom dialog.
//
//  Note that you should get any values from the components in a custom dialog
//  immediately and then make a call to DialogOpts::closeDialog(), as the
//  dialog will remain open until you do. This is not neccessary with the OK
//  type dialog, which will be immediately desroyed when the OK button is
//  pressed.
//
//  %result
//  By passing the name of a function in this parameter, you can recieve a
//  token indicating which button was pressed to close the dialog. The three
//  possible values returned are OK, CANCEL, and DONE. The name of the
//  function should be passed without parens or semicolon - when called, the
//  function will be passed the result token as a single argument.
//
//  --------------------------------------------------------------------------
//
//  The three pre-designed dialogs are the Error dialog, the Info dialog, and
//  the Help dialog. All three are OK-style dialogs. The Error and Info
//  dialogs are SMALL and the Help dialog is LARGE.
//
//  -The Error dialog has a red title area with the title "Error" centered in
//  white. To create an Error dialog, call
//
//      ErrorDlg(%text);
//
//  passing the text of the error.
//
//  -The Info dialog has a blue title area with the title "Attention" centered
//  in white. To create an Info dialog, call
//
//      InfoDlg(%text);
//
//  passing the text of the error.
//
//  -The Help dialog has a dialog-green title area with the supplied title
//  centered in white. As mentioned above, this dialog is the LARGE size. To
//  create a Help dialog, call
//
//      HelpDlg(%topic, %text);
//
//  passing the topic name for the title, and the text of the error.
//

$DialogOpts::dialogActive = FALSE;

function ErrorDlg(%text)
{
    return DialogOpts::pushDialog("<jc><f2>ERROR", "<f2>"@%text, RED);
}

function InfoDlg(%text)
{
    return DialogOpts::pushDialog("<jc><f2>Attention", "<f2>"@%text, BLUE);
}

function HelpDlg(%topic, %text)
{
    return DialogOpts::pushDialog("<jc><f2>"@%topic, "<r4><f1>"@%text, DLG_GREEN, LARGE);
}

function DialogOpts::pushDialog(%title, %text, %color, %size, %type, %result)
{
    if($DialogOpts::dialogActive)
        return -1;
        
    $DialogOpts::dialogResult = %result;
    $DialogOpts::dialogActive = TRUE;
    %colorboxes = loadObject("DialogOpts::Colorboxes", "NewOpts\\Gui\\ColorBox.gui");
    %color = DialogOpts::getBoxColor(%color);
    %box = NewOpts::getIdFromSet("DialogOpts::Colorboxes", "DynOptsColorBox"@%color);
    if(String::ICompare(%size, "LARGE") == 0)
        GuiPushDialog(MainWindow, "NewOpts\\Gui\\LgDialog.gui");
    else
        GuiPushDialog(MainWindow, "NewOpts\\Gui\\SmDialog.gui");
    %dlg = NewOpts::getIdFromSet(NamedGuiSet, "DialogOptsDlgBox");
    addToSet(%dlg, %box);
    %fgtext = newObject(DialogOpts::dlgTitle, FearGuiFormattedText, 0, 11, 274, 17);
    addToSet(%box, %fgtext);
    Control::setValue(DialogOpts::dlgTitle, %title);
    Control::setValue(DialogOpts::dlgText, %text);
    deleteObject("DialogOpts::Colorboxes");
    if(%type == "DONE")
    {
        Control::setVisible(DialogOpts::dlgOK, FALSE);
        Control::setVisible(DialogOpts::dlgDone, TRUE);
        Control::setVisible(DialogOpts::dlgCancel, TRUE);
    }
    else
        if(%type == "DONECHECK")
        {
            Control::setVisible(DialogOpts::dlgOK, FALSE);
            Control::setActive(DialogOpts::dlgDone, FALSE);
            Control::setVisible(DialogOpts::dlgDone, TRUE);
            Control::setVisible(DialogOpts::dlgCancel, TRUE);
        }
        else    // %type = "OK"
        {
            Control::setVisible(DialogOpts::dlgOK, TRUE);
        }
    return NewOpts::getIdFromSet(NamedGuiSet, DialogOptsDlgBox);
}

function DialogOpts::activateDialogDone()
{
    Control::setActive(DialogOpts::dlgDone, TRUE);
}

function DialogOpts::dialogResult(%result)
{
    if($DialogOpts::dialogResult != "")
        eval($DialogOpts::dialogResult@"("@%result@");");
    if(%result == OK)
        DialogOpts::closeDialog();
}

function DialogOpts::closeDialog()
{
    GuiPopDialog(MainWindow, 0);
    $DialogOpts::dialogActive = FALSE;
}

function DialogOpts::getBoxColor(%color)
{
    for(%i = 0; %i < 25; %i++)
    {
        %c = getWord($DialogOpts::cset[%i], 1);
        if(getWord($DialogOpts::cset[%i], 0) == %color || %c == %color)
            return %c;
    }
    return "BnW";
}

function DialogOpts::dialogColorTest()
{
    function DialogOpts::_dialogColorTest()
    {
        if($DialogOpts::dialogColorTestCurrentVal < 25)
        {
            %color = getWord($DialogOpts::cset[$DialogOpts::dialogColorTestCurrentVal], 0);
            if($DialogOpts::dialogColorTestCurrentVal == 5)
                DialogOpts::pushDialog("   DialogColorTest: "@%color, "<f2>DialogColorTest: "@%color, %color, "", "", "DialogOpts::_dialogColorTest");
            else
                DialogOpts::pushDialog("   <f2>DialogColorTest: "@%color, "<f2>DialogColorTest: "@%color, %color, "", "", "DialogOpts::_dialogColorTest");
            $DialogOpts::dialogColorTestCurrentVal++;
        }
    }
    $DialogOpts::dialogColorTestCurrentVal = 0;
    DialogOpts::_dialogColorTest();
}


$DialogOpts::cset[0] =  "B_&_W         BnW";

$DialogOpts::cset[1] =  "BLACK         0  ";
$DialogOpts::cset[2] =  "DK_GRAY       232";
$DialogOpts::cset[3] =  "MED_GRAY      233";
$DialogOpts::cset[4] =  "LT_GRAY       250";
$DialogOpts::cset[5] =  "WHITE         2  ";

$DialogOpts::cset[6] =  "RED           41 ";
$DialogOpts::cset[7] =  "PALE_RED      39 ";
$DialogOpts::cset[8] =  "DK_RED        189";

$DialogOpts::cset[9] =  "GREEN         228";
$DialogOpts::cset[10] = "LT_GREEN      12 ";
$DialogOpts::cset[11] = "DK_GREEN      99 ";
$DialogOpts::cset[12] = "DLG_GREEN     199";

$DialogOpts::cset[13] = "BLUE          216";
$DialogOpts::cset[14] = "CYAN          151";
$DialogOpts::cset[15] = "AQUA          215";
$DialogOpts::cset[16] = "BLUE_GRAY     231";
$DialogOpts::cset[17] = "CORN_BLUE     81 ";
$DialogOpts::cset[18] = "DK_BLUE       181";

$DialogOpts::cset[19] = "YELLOW        158";
$DialogOpts::cset[20] = "PALE_YELLOW   154";

$DialogOpts::cset[21] = "PURPLE        187";
$DialogOpts::cset[22] = "DK_PURPLE     108";

$DialogOpts::cset[23] = "BROWN         22 ";
$DialogOpts::cset[24] = "BEIGE         201";
