//
//  HudMover 1.0
//  By Tim 'Zear' Hammock
//
//  New events introduced:
//      eventHudMoved           when HudMover changes the position of a hud in any way
//      eventCenterPrint        when remoteCP, remoteBP or remoteTP is called
//      eventClearCenterPrint   when a centerprinted message is cleared
//

function HudMover::moveHud(%hud, %callback)
{
    if($HudMover::gui == "")
        return;
        
    $HudMover::callback = %callback;
    $HudMover::delList = "";
    $HudMover::showAll = TRUE;
    
    %numHUDs = $HUD::numHUDs;
    if (%numHUDs == "")
	    %numHUDs = 0;

    %availableHuds = 0;
    for (%i = 0; %i < %numHUDs; %i++)
    {
	    %name = $HUD::name[%i];
	    
	    if($HudMover::constraints[%name] < 15)
	    {
	        %availableHuds++;
	        if($HudMover::constraints[%name] == "")
	            $HudMover::constraints[%name] = 0;
        	
    	    if($Hud::prefs::default::[%name] == "")
    	        $Hud::prefs::default::[%name] = HUD::GetPosition(%name);
        	
    	    $Hud::prefs::last::[%name] = HUD::GetPosition(%name);

	        if($HudMover::gui == HUD::GetGui(%name))
    	    {
    	        $HudMover::visible[%name] = HUD::GetDisplayed(%name);
    	        HUD::Display(%name, TRUE);
    	        $HudMover::update[%name] = HUD::GetUpdateFunc(%name);
    	        if($HudMover::update[%name] != "")
    	        {
    	            HUD::SetUpdateFunc(%name, "HudMover::tempUpdate");
    	            HudMover::tempUpdate(%name);
    	        }
    	    }
    	}
    }
    if(%availableHuds == 0)
    {
        remoteCP(2048, "No Presto HUDs active on this screen", 5);
        return;
    }
    
    $HudMover::moving = "moving";
    cursorOn(MainWindow);
    schedule("HudMover::flashFrame();", 0.5);

    if(%hud == "")
        HudMover::tabSelect(TRUE);
    else
        HudMover::hudSelect(%hud);
    
    // save current action maps and redefine keys for mover
    saveActionMap("config\\config.cs", "actionMap.sae", "playMap.sae", "pdaMap.sae");
    exec("NewOpts\\HudMoverConfig.cs");
}

//HudMover::constrainHud(hudDyn, 0);
function HudMover::constrainHud(%hud, %constraints)
{
    // Only the individual letter settings retain state for the other coords.
    // All other settings will reset the mask to no constraints, then apply
    // those specified.
    
    if(String::ICompare(%constraints, "x") == 0)
        $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 1;
    else if(String::ICompare(%constraints, "y") == 0)
        $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 2;
    else if(String::ICompare(%constraints, "w") == 0)
        $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 4;
    else if(String::ICompare(%constraints, "h") == 0)
        $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 8;
    else
    {
        $HudMover::constraints[%hud] = 0;

        if(String::ICompare(%constraints, "all") == 0)
            $HudMover::constraints[%hud] = 15;
        else if(String::ICompare(%constraints, "position") == 0)
            $HudMover::constraints[%hud] = 3;
        else if(String::ICompare(%constraints, "size") == 0)
            $HudMover::constraints[%hud] = 12;
        else if(NewOpts::isValidString(%constraints, "xywh"))
        {
            if(String::findSubStr(%constraints, "x") > -1)
                $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 1;
            if(String::findSubStr(%constraints, "y") > -1)
                $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 2;
            if(String::findSubStr(%constraints, "w") > -1)
                $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 4;
            if(String::findSubStr(%constraints, "h") > -1)
                $HudMover::constraints[%hud] = $HudMover::constraints[%hud] | 8;
        }
        else if(NewOpts::isValidString(%constraints, "0123456789"))
            $HudMover::constraints[%hud] = %constraints & 15;
    }
}

function HudMover::tempUpdate(%hud)
{
    HUD::Display(%hud, true);
    HUD::AddTextLine(%hud, "<f2>"@%hud);
    return 0.1;
}

function HudMover::setStatus()
{
    %pos = HUD::GetPosition($HudMover::selected);

    for(%i = 0; %i < 4; %i++)
    {
        %type[%i] = getWord($HudMover::selectedTypes, %i);
        if(%type[%i] == "pixel")
            %type[%i] = "Pixel";
        else if(%type[%i] == "relative")
            %type[%i] = "Adaptive (%)";
        else if(%type[%i] == "offsetrel")
            %type[%i] = "Adaptive (%) w/ offset";
        else if(%type[%i] == "custom")
            %type[%i] = "Complex";
        else    // hudrel
            %type[%i] = "Relative to HUD";

        if($HudMover::constraints[$HudMover::selected] != 0)
        {
            %constraints = $HudMover::constraints[$HudMover::selected] >> %i;
            if((%constraints & 1) > 0)
                %type[%i] = "hide";
        }
    }
    %status = "<f2> HudMover (by Tim 'Zear' Hammock)";
    %status = %status@"\n\n     Selected: "@$HudMover::selected;
    if(%type[0] != "hide")
        %status = %status@"\n                x: "@getWord(%pos, 0)@"  (<f1>"@%type[0]@"<f2>)";
    if(%type[1] != "hide")
        %status = %status@"\n                y: "@getWord(%pos, 1)@"  (<f1>"@%type[1]@"<f2>)";
    if(%type[2] != "hide")
        %status = %status@"\n                w: "@getWord(%pos, 2)@"  (<f1>"@%type[2]@"<f2>)";
    if(%type[3] != "hide")
        %status = %status@"\n                h: "@getWord(%pos, 3)@"  (<f1>"@%type[3]@"<f2>)";
    %status = %status@"\n\n 'i' key to toggle instructions.";

    if($HudMover::showInstruct)
    {    
        %status = %status@"\n\n Click on a HUD to select it.";
        %status = %status@"\n Tab & shift-tab to cycle the selection through the HUDs.";
        %status = %status@"\n Up, down, left & right arrow keys to move the selected HUD.";
        %status = %status@"\n Number pad keys 5, 2, 1 & 3 to resize the seleceted HUD.";
        %status = %status@"\n Holding 'shift' while moving or resizing increases the speed of change.";
        %status = %status@"\n 'r' key to reset the selected HUD to its last position.";
        %status = %status@"\n shift-'r' key to reset all HUDs to their last positions.";
        %status = %status@"\n 'd' key to reset the selected HUD to its default position.";
        %status = %status@"\n shift-'d' key to reset all HUDs to their default positions.";
        %status = %status@"\n Spacebar to open the positioning dialog for the selected HUD.";
        %status = %status@"\n 's' key to shift the status bar position (this window).";
        %status = %status@"\n 'h' key to hide/show the selected hud (while in HudMover).";
        %status = %status@"\n shift-'h' key to hide/show all huds (while in HudMover).";
        %status = %status@"\n ESC or 'q' key to quit HudMover.";
    }
    Client::centerPrint(%status, $HudMover::statusPos);
}

function HudMover::toggleInstruct()
{
    $HudMover::showInstruct = !$HudMover::showInstruct;
    HudMover::setStatus();
}

function HudMover::newStatusPos()
{
    Client::centerPrint("", $HudMover::statusPos);
    $HudMover::statusPos++;
    if($HudMover::statusPos > 2)
        $HudMover::statusPos = 0;
    HudMover::setStatus();
}

function HudMover::quit(%gui)
{
    if(%gui != "PlayGui" && %gui != "")
        return;
        
    echo("in quit()");
    if($HudMover::moving == "moving")   // only if we're in the middle of move mode at quit
    {
        echo("quitting");
        $HudMover::selected = "";
        if($HudPos::active)
            HudPos::onCancel();
	    HudMover::deleteControls(); // clean up
        exec("config.cs");          // reset keys to user defined
        cursorOff(MainWindow);

        %numHUDs = $HUD::numHUDs;
        if (%numHUDs == "")
	        %numHUDs = 0;

        for (%i = 0; %i < %numHUDs; %i++)
        {
	        %name = $HUD::name[%i];
	        $Hud::prefs::last::[%name] = HUD::GetPosition(%name);
	        if($HudMover::gui == HUD::GetGui(%name))
	        {
    	        HUD::Display(%name, $HudMover::visible[%name]);
    	        if($HudMover::update[%name] != "")
    	        {
    	            HUD::SetUpdateFunc(%name, $HudMover::update[%name]);
    	            HUD::Update(%name);
    	        }
    	    }
        }
        Client::centerPrint("", 1);
        $HudMover::moving = "";     // move mode is over
        if($HudMover::callback != "")
            eval($HudMover::callback);
        echo("quit() done");
    }
}
Event::Attach(eventExit, "HudMover::quit();");

function HudMover::deleteControls()
{
    // delete all HudMover buttons and the select frame
	if($HudMover::delList != "")
	{
	    for(%i = 0; %i < String::getWordCount($HudMover::delList); %i++)
            deleteObject(getWord($HudMover::delList, %i)+0);

        $HudMover::delList = "";
    }
}    

function HudMover::hudSelect(%hud, %ignoretypes)
{
    if(%hud != "" && $HudMover::constraints[%hud] > 14)
        return -1;
    
    %numHUDs = $HUD::numHUDs;
    if (%numHUDs == "")
	    %numHUDs = 0;

    HudMover::deleteControls(); // remove stuff from last time around
    
    for (%i = 0; %i < %numHUDs; %i++)
    {
	    %name = $HUD::name[%i];
	    
	    if($HudMover::gui != HUD::GetGui(%name))
	        continue;
	    
	    if($HudMover::constraints[%name] < 15)
	    {
	        %x = HUD::GetCoordValue(%name, 0);
	        %y = HUD::GetCoordValue(%name, 1);
	        %w = HUD::GetCoordValue(%name, 2);
	        %h = HUD::GetCoordValue(%name, 3);
    	    
	        if(%name == %hud)   // hud to select
	        {
	            %obj = newObject(%hud@"::box", FearGui::FearGuiBox, %x-5, %y-5, %w+10, %h+10);
	            $HudMover::delList = $HudMover::delList@%obj@" ";
	            addToSet(playGui, %obj);

	            $HudMover::selected = %hud;
	            if(%ignoretypes != TRUE)
	                $HudMover::selectedTypes = HudMover::getType(HUD::GetPosition($HudMover::selected));
            }
	        else
	        {
	            %obj = newObject(%name@"::selector", FearGui::FGUniversalButton, %x, %y, %w, %h, "", "HudMover::hudSelect("@%name@");");
	            $HudMover::delList = $HudMover::delList@%obj@" ";
	            addToSet(playGui, %obj);
	        }
	    }
	}
	HudMover::setStatus();
	return %hud;
}

function HudMover::tabSelect(%selectNext)
{
    %tabListLast = -1;
    %current = -1;
    
    %numHUDs = $HUD::numHUDs;
    if (%numHUDs == "")
	    %numHUDs = 0;

    for (%i = 0; %i < %numHUDs; %i++)
    {
        %name = $HUD::name[%i];
        if($HudMover::gui == HUD::GetGui(%name) && $HudMover::constraints[%hud] < 15)
    	{
            %tabListLast++;
            %tablist[%tabListLast] = %name;
            if(%name == $HudMover::selected)
                %current = %tabListLast;
        }
    }
    
    %newSelect = %tablist[0];   // assume current selection not found, select first valid
    
    if(%current > -1)  // current selection WAS found, select correct one
    {
        if(%selectNext) // go to next in list
        {
            if(%current != %tabListLast)
                %newSelect = %tablist[%current + 1];
        }
        else            // go to prev in list
        {
            if(%current == 0)
                %newSelect = %tablist[%tabListLast];
            else
                %newSelect = %tablist[%current - 1];
        }
    }
    HudMover::hudSelect(%newSelect);
}

function HudMover::flashFrame()
{
    if($HudMover::moving == "moving")
    {
        if($HudMover::selected != "")
        {
            %frame = $HudMover::selected@"::Box";
            Control::setVisible(%frame, !Control::getVisible(%frame));
        }
        schedule("HudMover::flashFrame();", 0.4);
    }
}

function HudMover::reposition(%dim, %inc)
{
    if($HudMover::constraints[$HudMover::selected] != "")
    {
        %constraints = $HudMover::constraints[$HudMover::selected] >> %dim;
        if((%constraints & 1) > 0)
            return;
    }
    
    %type = getWord($HudMover::selectedTypes, %dim);
    %val = getWord(HUD::GetPosition($HudMover::selected), %dim);
    
    if(%type == "pixel")
    {
        if(%inc < -1 || %inc > 1)
            %inc = %inc * 5;
	    %newval = %val + %inc;
	    if(%dim > 1 && %newval < 1)    // resizing
	        %newval = 1;
    }
    else if(%type == "relative")
    {
        Match::String(%val, "*%");
        %newval = Match::Result(0) + %inc;
	    if(%dim > 1 && %newval < 1)    // resizing
	        %newval = 1;
	    %newval = %newval@"%";
    }
    else    // %type == "offsetrel" || %type == "custom" || %type == "hudrel"
    {
        if(%inc < -1 || %inc > 1)
            %inc = %inc * 5;
        %tokenized = HudMover::tokenizeCoord(%val);
        %numtokens = String::getWordCount(%tokenized);
        %op = getWord(%tokenized, %numtokens-2);
        %offset = getWord(%tokenized, %numtokens-1);
        if((%op == "+" || %op == "-") &&  NewOpts::validateAlphaText(%offset, "0123456789") == %offset)
        {
            if(%op == "-")
                %offset = %op@%offset;
            
            %offset += %inc;
            
            if(%offset > 0)
                %op = "+";
            else
                %op = "";

            if(%offset == 0)
                %offset = "";
                
            for(%i = 0; %i < (%numtokens-2); %i++)
                %newval = %newval@getWord(%tokenized, %i);
            
            %newval = %newval@%op@%offset;
        }
        else
        {
            %offset = %inc;

            if(%offset > 0)
                %op = "+";
            else
                %op = "";

            if(%offset == 0)
                %offset = "";

            %newval = %val@%op@%offset;
        }
    }
    
    for(%i = 0; %i < 4; %i++)
    {
        if(%i == %dim)
        {
            %newtypes = %newtypes@%type@" ";
            %newpos = %newpos@%newval@" ";
        }
        else
        {
            %newtypes = %newtypes@getWord($HudMover::selectedTypes, %i)@" ";
            %newpos = %newpos@getWord(HUD::GetPosition($HudMover::selected), %i)@" ";
        }
    }
    $HudMover::selectedTypes = %newtypes;
   	HUD::move($HudMover::selected, %newpos);
   	HudMover::moveDependents();
   	HudMover::hudSelect($HudMover::selected, TRUE);
}

function HudMover::moveDependents()
{
    %numHUDs = $HUD::numHUDs;
    if (%numHUDs == "")
	    %numHUDs = 0;
    for (%i = 0; %i < %numHUDs; %i++)
    {
	    %name = $HUD::name[%i];
	    HUD::move(%name, HUD::GetPosition(%name));
	}
}

function HudMover::getType(%position, %coord)
{
    if(%coord != "" && (%coord < 0 || %coord > 3))
        return -1;

    %init = 0;
    %limit = 4;

    if(%coord != "")
    {
        %init = %limit = %coord;
        %limit++;
        %sep = "";
    }
    else
        %sep = " ";
        
    %typelist = "";
    
    for(%i = %init; %i < %limit; %i++)
    {
        if(getWord($HudMover::selectedTypes, %i) == "custom")
            %thistype = "custom";
        else
        {
            %coord = getWord(%position, %i);
            
            if(%coord == NewOpts::validateAlphaText(%coord, "0123456789")) // pixel only
                %thistype = "pixel";
            else if(%coord == NewOpts::validateAlphaText(%coord, "0123456789+-")) // offset pixel
                %thistype = "pixel";
            else if(%coord == NewOpts::validateAlphaText(%coord, "0123456789%")) // relative
                %thistype = "relative";
            else if(%coord == NewOpts::validateAlphaText(%coord, "0123456789%+-")) // offset relative
                %thistype = "offsetrel";
            else
            {
                %tokenized = HudMover::tokenizeCoord(%coord);
                %words = String::getWordCount(%tokenized);
                for(%j = 0; %j < %words; %j++)
                {
                    %thistype = getWord(%tokenized, %j);
                    if (Match::ParamString(%thistype,"%m(%h)"))    // hudrel
                    {
	                    %thistype = Match::Result(m)@"("@Match::Result(h)@")";
	                    break;
                    }
                }
                if(%thistype == "" || %thistype == -1)
                    %thistype = "custom";
            }
        }
        %type = %type@%thistype@%sep;
    }
    return %type;
}    

function HudMover::tokenizeCoord(%str)
{
	if (Match::ParamString(%str,"%a+%b"))
	{
		%a = Match::Result(a);
		%b = Match::Result(b);
		%str = HudMover::tokenizeCoord(%a)@" + "@HudMover::tokenizeCoord(%b);
	}
	else if (Match::ParamString(%str,"%a-%b"))
	{
		%a = Match::Result(a);
		%b = Match::Result(b);
		%str = HudMover::tokenizeCoord(%a)@" - "@HudMover::tokenizeCoord(%b);
	}
	else if (Match::ParamString(%str,"%a/%b"))
	{
		%a = Match::Result(a);
		%b = Match::Result(b);
		%str = HudMover::tokenizeCoord(%a)@" / "@HudMover::tokenizeCoord(%b);
	}
	else if (Match::ParamString(%str,"%a*%b"))
	{
		%a = Match::Result(a);
		%b = Match::Result(b);
		%str = HudMover::tokenizeCoord(%a)@" * "@HudMover::tokenizeCoord(%b);
	}
    return %str;
}

function HudMover::resetPos()
{
    HUD::Move($HudMover::selected, $Hud::prefs::last::[$HudMover::selected]);
    HudMover::moveDependents();
   	HudMover::hudSelect($HudMover::selected);
}

function HudMover::defaultPos()
{
    HUD::Move($HudMover::selected, $Hud::prefs::default::[$HudMover::selected]);
    HudMover::moveDependents();
   	HudMover::hudSelect($HudMover::selected);
}

function HudMover::hide()
{
    HUD::Display($HudMover::selected, !HUD::GetDisplayed($HudMover::selected));
}

function HudMover::hideAll()
{
    %numHUDs = $HUD::numHUDs;
    if (%numHUDs == "")
	    %numHUDs = 0;

    $HudMover::showAll = !$HudMover::showAll;
    for (%i = 0; %i < %numHUDs; %i++)
    {
	    %name = $HUD::name[%i];
	    if($HudMover::gui == HUD::GetGui(%name))
            HUD::Display(%name, $HudMover::showAll);
    }
}

function HudMover::resetAll(%last)
{
    %numHUDs = $HUD::numHUDs;
    if (%numHUDs == "")
	    %numHUDs = 0;

    for (%i = 0; %i < %numHUDs; %i++)
    {
	    %name = $HUD::name[%i];
	    if($HudMover::gui == HUD::GetGui(%name))
	    {
	        if(%last)
	            HUD::Move(%name, $Hud::prefs::last::[%name]);
	        else
	            HUD::Move(%name, $Hud::prefs::default::[%name]);
    	}
    }
   	HudMover::hudSelect($HudMover::selected);
}

function HudMover::onGuiOpen(%gui)
{
    $HudMover::gui = %gui;
}
Event::Attach(eventGuiOpen, HudMover::onGuiOpen);

function HudMover::onGuiClose(%gui)
{
    $HudMover::gui = "";
}
Event::Attach(eventGuiClose, HudMover::onGuiClose);

if(isFile("config\\HudPrefs.cs"))
    exec("HudPrefs.cs");
$HudMover::statusPos = 1;
$HudMover::showInstruct = false;

Presto::AddScriptBanner(HudMover, "\n<f2><jc>HudMover!\n\n<f0><jc>(ver. 1.0)\n\n<f1><jc>By Tim \"Zear\" Hammock\n\n<f0><jc>zear@planetstarsiege.com");

if ($Presto::version < 0.94)
{
//////////////////////////////////////////////////////////////////////////////
// From Presto's HUD.cs
    
function HUD::OnGuiOpen(%gui) {
	%res = Presto::ScreenSize();
	if ($HUD::lastRes[%gui] != %res) {
		if ($HUD::lastRes[%gui] != "")
			for (%i = 0; %i < $HUD::numHUDs; %i++) {
				%hud = $HUD::name[%i];
				HUD::SetCoord(%hud,none,0);	// cheap way to resize to same dim
				Event::Trigger(eventHUDResized, %hud);
				}
		$HUD::lastRes[%gui] = %res;
		}
	if ($HUD::pendingAttach[%gui]) {
		for (%i = 0; %i < $HUD::numHUDs; %i++) {
			%hud = $HUD::name[%i];
			%guiHUD = HUD::GetGui(%hud);
			if (%guiHUD == %gui && !HUD::GetAttached(%hud)) {

	            /////////////////////////////////////
	            // begin inserted by Zear
            	
                $Hud::prefs::default::[%hud] = HUD::GetPosition(%hud);
            	
	            // end inserted by Zear
	            /////////////////////////////////////
	
				addToSet(%gui, HUD::GetGuiObject(%hud, frame));
				HUD::SetAttached(%hud, true);

	            /////////////////////////////////////
	            // begin inserted by Zear
            	
                if($Hud::prefs::last::[%hud] != "")
                    HUD::Move(%hud, $Hud::prefs::last::[%hud]);
            	
	            // end inserted by Zear
	            /////////////////////////////////////
	
				HUD::Update(%hud);
				}
			}
		$HUD::pendingAttach[%gui] = "";
		}
	}

// End of stuff from Presto's HUD.cs
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
// To be added to Presto's HUD.cs
    
function HUD::onClose() {
    for (%i = 0; %i < %numHUDs; %i++) {
	    %name = $HUD::name[%i];
   	    $Hud::prefs::last::[%name] = HUD::GetPosition(%name);
        }
    
    export("$Hud::pref*", "config\\HudPrefs.cs");
    HUD::DeleteAll();
    }
Event::Detach(eventExit, HUD::DeleteAll);   // on integration w/ HUD.cs this should be unnecessary as long as the original Attach is removed
Event::Attach(eventExit, "HUD::onClose");

// End of stuff to be added to Presto's HUD.cs
//////////////////////////////////////////////////////////////////////////////
}

function HudPos::clearCenterPrint(%msgId, %timeout)
{
    if (!Event::Returned(Event::Trigger(eventClearCenterPrint, %msgId, %timeout), mute))
    {
        clearCenterPrint(%msgId, %timeout);
    }
}

function HudMover::onCenterPrint(%msg, %timeout)
{
   if ($HudMover::moving == "moving")
      return mute;
}
Event::Attach(eventCenterPrint, HudMover::onCenterPrint);
Event::Attach(eventClearCenterPrint, HudMover::onCenterPrint);

//////////////////////////////////////////////////////////////////////////////
// From client.cs

function remoteCP(%manager, %msg, %timeout)
{
   if (%manager == 2048)
   {
      if (!Event::Returned(Event::Trigger(eventCenterPrint, %msg, %timeout), mute))
      {
         $centerPrintId++;
         if(%timeout)
            schedule("HudPos::clearCenterPrint(" @ $centerPrintId @ ");", %timeout);
         Client::centerPrint(%msg, 0);
      }
   }
}

function remoteBP(%manager, %msg, %timeout)
{
   if (%manager == 2048)
   {
      if (!Event::Returned(Event::Trigger(eventCenterPrint, %msg, %timeout), mute))
      {
         $centerPrintId++;
         if(%timeout)
            schedule("HudPos::clearCenterPrint(" @ $centerPrintId @ ");", %timeout);
         Client::centerPrint(%msg, 1);
      }
   }
}

function remoteTP(%manager, %msg, %timeout)
{
   if (%manager == 2048)
   {
      if (!Event::Returned(Event::Trigger(eventCenterPrint, %msg, %timeout), mute))
      {
         $centerPrintId++;
         if(%timeout)
            schedule("HudPos::clearCenterPrint(" @ $centerPrintId @ ");", %timeout);
         Client::centerPrint(%msg, 2);
      }
   }
}

// End of stuff from client.cs
//////////////////////////////////////////////////////////////////////////////
