// --	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	-----	------
// Install.CS								EnablePresto, March '99 
//
//	This script contains the functions I use to install the pack on
//	your machine.  So I'm not really going to document it very well,
//	because no one else need to use it.
//
//	Two important variables to mention:
//		$Presto::installed is set to true when my script is installed.
//		$Presto::version is set to the current version number...
//
//	Also script writers might want to add banners to their scripts.  I will
//	rotate through them on the main page (starting at a random one to even
//	the playing field ;) ).  Use the call
//		Presto::AddScriptBanner(<tag>, <message>);
//	where <tag> is a unique tag (you could use the name of your script, or
//	your own name, or whatever.)  If you re-run the function with the same
//	tag, the text will be replaced!
//	You have about 9 lines of text to work with, and maybe 30 characters
//	across each line.
//
//	Script banners are formatted text, so you can use font changes, bitmaps,
//	etc.  But keep in mind that the GUI pallette is different than the play
//	pallette so in-game bitmaps won't look right.
//
// ---------------------------------------------------------------------------
if (!$dedicated) {	// DEDICATED SERVER

exec("presto\\Include.cs");
Include("presto\\Event.cs");

// Load previous prefs, so we can notice changes later.

function UninstallPrestoPack() {
	$PrestoPref::installStage = uninstall;
	exec("presto\\install.cs");
	}
function UninstallPrestoPak () { UninstallPrestoPack(); }

function InstallStage(%stage) {
	return $PrestoPref::installStage == %stage;
	}
$Presto::notice = "";
function Presto::AddNoticeLine(%line) {
	$Presto::notice = $Presto::notice @ " " @ %line @ "\n";
	}
$Presto::status = "";
function Presto::AddStatusLine(%line) {
	$Presto::status = $Presto::status @ " " @ %line @ "\n";
	}
function Presto::AddOptionStatusLine(%option, %line) {
	if (String::FindSubStr($Presto::InterestingOptions, " "@%option@" ") != -1)
		Presto::AddStatusLine(%line);
	}

$Presto::screenSize["320x240(V)"] = "320 240";
$Presto::screenSize["400x300(V)"] = "400 300";
$Presto::screenSize["480x360(V)"] = "480 360";
$Presto::screenSize["512x384"] = "512 384";
$Presto::screenSize["640x400"] = "640 400";
$Presto::screenSize["640x480"] = "640 480";
$Presto::screenSize["800x600"] = "800 600";
$Presto::screenSize["960x720"] = "960 720";
$Presto::screenSize["1024x768"] = "1024 768";
$Presto::screenSize["1152x864"] = "1152 864";
$Presto::screenSize["1280x960"] = "1280 960";
$Presto::screenSize["1280x1024"] = "1280 1024";
$Presto::screenSize["1600x1024"] = "1600 1024";
$Presto::screenSize["1600x1200"] = "1600 1200";


function Presto::ScreenSize() {
	%res = $pref::videoFullScreenRes;
	if ($pref::VideoFullScreen) {
		%posRes = $Presto::screenSize[%res];
		if (%posRes != "")
			return %posRes;
		}
	return $Presto::screenSize["640x480"];
	}

EvalSearchPath();
if (!InstallStage(uninstall)) {
	if (isFile("config\\_lastPrestoPrefs.cs"))
		exec("_lastPrestoPrefs.cs");
	}

if (InstallStage("")) {
	$PrestoPref::ShowPackStatus = true;	// don't let them turn it off yet, in case of errors.

	if (isFile("config\\config.cs"))
		File::copy("config\\config.cs", "config\\config.pre");
	if (isFile("config\\autoexec.cs"))
		File::copy("config\\autoexec.cs", "config\\autoexec.pre");
	$Presto::FirstTime = true;

	Presto::AddNoticeLine("<f2>Welcome to the Presto Pack!<f0>");
	Presto::AddNoticeLine("See <f1>README.TXT<f0> for info if");
	Presto::AddNoticeLine("you're having trouble with");
	Presto::AddNoticeLine("installation or config.\n");
	Presto::AddNoticeLine("If you haven't already, why");
	Presto::AddNoticeLine("not go set your preferences?");
	Presto::AddNoticeLine("(config\\presto\\PrestoPrefs.cs)");

	$PrestoPref::installStage = errorcheck;
	}

if (InstallStage(errorcheck)) {
// Maybe someday I can do error checking - but I'm not sure
// what to check for right now.
//	Presto::AddNoticeLine("<f1>Everything seems to be");
//	Presto::AddNoticeLine("installed correctly...<f0>");
	$PrestoPref::installStage = installed;
	}

if (InstallStage(installed)) {
	$Presto::installed = true;
	$Presto::version = "0.93";	// numbers have to be quoted.  otherwise, they get
		//	weird values like 0.9299999999 because of stupid float inaccuracy. :(

	function Presto::Enabled(%option) {
		if ($PrestoPref::[%option] == "")
			$PrestoPref::[%option] = false;
		if ($PrestoPref::[%option] != false)
			return true;
		return false;
		}
	function bindkey(%map, %key, %functionMake, %functionBreak) {
		editActionMap(%map@"Map.sae");
	
		%i = 0;
		while (getWord(%key, %i) != -1) {
			%p[%i] = getWord(%key, %i);
			%i++;
			}
		%p[%i] = "TO";
		%p[%i + 1] = %functionMake;
		bindCommand(keyboard0, make, %p0,%p1,%p2,%p3,%p4,%p5,%p6,%p7,%p8);
		%p[%i + 1] = %functionBreak;
		bindCommand(keyboard0, break, %p0,%p1,%p2,%p3,%p4,%p5,%p6,%p7,%p8);
		return true;
		}
	function PrestoKeyChanged(%option) {
		if ($PrestoPref::[%option,was] != "" &&
		    $PrestoPref::[%option,was] != false &&
		    $PrestoPref::[%option,was] != $PrestoPref::[%option]) {
			return true;
			}
		return false;
		}
	function Presto::EnableOption(%option) {
		if (Presto::Enabled(%option)) {
			Presto::AddOptionStatusLine(%option, " <f1>"@%option@"<f0> is <f1>enabled<f0>.");
			return true;
			}
		Presto::AddOptionStatusLine(%option, " <f1>"@%option@"<f0> is disabled.");
		return false;
		}
	function Presto::EnableKey(%option, %map, %functionMake, %functionBreak) {
		%key = $PrestoPref::[%option];
	
		if (PrestoKeyChanged(%option)) {
			// They changed a key.  Unbind the old one.
			Presto::AddNoticeLine("Unbound old <f1>"@%option@"<f0> key.");
			bindKey(%map, $PrestoPref::[%option,was]);
			}
		$PrestoPref::[%option,was] = %key;
	
		if (Presto::Enabled(%option)) {
			Presto::AddOptionStatusLine(%option, " <f1>"@%option@"<f0> is on <f1>"@%key@"<f0>.");
			bindKey(%map, %key, %functionMake, %functionBreak);
			return true;
			}
		Presto::AddOptionStatusLine(%option, " <f1>"@%option@"<f0> is disabled.");
		return false;
		}
	function Presto::OptionDisplay(%option,%label) {
		if (Presto::EnableOption(%option))
			return "<f1>"@%label;
		return "<f0>"@%label;
		}

	exec("presto\\PrestoPrefs.cs");
	$Presto::InterestingOptions = " InvCamera DynHud OldChat NewChat DropMenu JobMenu TeamHud MuteMenu ";

	if (Presto::EnableOption(InvCamera)) {
		Include("presto\\CamHud.cs");
		Presto::EnableKey(CamHudFreeLook, pda, "CamHUD::FreeLook(true);", "CamHUD::FreeLook(false);");
		}
	
	if (Presto::EnableKey(DynHud, play, "HUD::ToggleDisplay(hudDyn);"))
		Include("presto\\DynHud.cs");
	
	Presto::EnableKey(OldChat, play, "Menu::DisplayDefault();");
	if (Presto::EnableKey(NewChat, play, "Menu::Display(menuChat);"))
		Include("presto\\Chat.cs");
	
	if (Presto::EnableKey(DropMenu, play, "Menu::Display(menuDrop);"))
		Include("presto\\Drop.cs");
	
	if (Presto::EnableKey(JobMenu, play, "Job::Start();"))
		Include("presto\\Chores.cs");
	
	if (Presto::EnableKey(TeamHud, play, "TeamHUD::ToggleDisplay();"))
		Include("presto\\TeamHud.cs");

	if (Presto::EnableKey(MuteMenu, play, "Menu::Display(menuMute);"))
		Include("presto\\MuteMenu.cs");
	}

// Save these current keys so we can recognize edits later.
export("$PrestoPref::*", "config\\_lastPrestoPrefs.cs", false);

function CycleScriptBanner(%crc, %update) {
	// cancel the schedule if we closed the main menu
	if (%crc != $Presto::mainMenuCrc)
		return;

	if (($Presto::banners+0)==0)
		return;

	%favorite = $Presto::bannerNum[$PrestoPref::FavoriteBanner];
	if (%favorite != "") {
		$Presto::currentBanner = %favorite;
		return;
		}

	if ($Presto::currentBanner == "")
		$Presto::currentBanner = floor(getRandom * $Presto::banners);
	else	{
		$Presto::currentBanner++;
		if ($Presto::currentBanner == $Presto::banners)
			$Presto::currentBanner=0;
		}

	if (%update)
		Control::Setvalue(PrestoNoticeText, $Presto::banner[$Presto::currentBanner]);
	schedule("CycleScriptBanner("@%crc@", true);", $PrestoPref::BannerCycleTime);
	}
function MainMenuGui::onOpen() {
	if ($PrestoPrefs::ShowPackStatus == false)
		return;

	%screenSize = Presto::ScreenSize();
	%width = getWord(%screenSize,0);
	%height = getWord(%screenSize, 1);

	%boxHeight = 125;

	if (!isObject(PrestoStatus))
		newObject(PrestoStatus, FearGui::FearGuiBox, 50,%height-45 - %boxHeight, 200,%boxHeight);
	if (!isObject(PrestoStatusText))
		newObject(PrestoStatusText, FearGuiFormattedText, 1,0,190,400);
	AddToSet(PrestoStatus, PrestoStatusText);
	AddToSet(MainMenuGui, PrestoStatus);

	Control::SetValue(PrestoStatusText, 
		" <f2>Presto Pack<jr><f0>version "@ $Presto::version @" <jl>\n" @ $Presto::status);

	$Presto::mainMenuCrc++;
	CycleScriptBanner($Presto::mainMenuCrc,false);
	if ($Presto::notice != "" || $Presto::currentBanner != "") {
		if (!isObject(PrestoNotice))
			newObject(PrestoNotice, FearGui::FearGuiBox, %width - 250,%height-45 - %boxHeight, 200,%boxHeight);
		if (!isObject(PrestoNoticeText))
			newObject(PrestoNoticeText, FearGuiFormattedText, 1,0,190,400);
		AddToSet(PrestoNotice, PrestoNoticeText);
		AddToSet(MainMenuGui, PrestoNotice);

		if ($Presto::notice != "")
			Control::SetValue(PrestoNoticeText, $Presto::notice);
		else	Control::Setvalue(PrestoNoticeText, $Presto::banner[$Presto::currentBanner]);
		}
	}
function MainMenuGui::OnClose() {
	$Presto::mainMenuCrc++;
	}

if (InstallStage(uninstall)) {
	if (isFile("config\\config.pre")) {
		File::copy("config\\config.pre", "config\\config.cs");
		File::delete("config\\config.pre");
		}
	if (isFile("config\\autoexec.pre")) {
		File::copy("config\\autoexec.pre", "config\\autoexec.cs");
		File::delete("config\\autoexec.pre");
		}
	if (isFile("config\\_lastPrestoPrefs.cs"))
		File::delete("config\\_lastPrestoPrefs.cs");
	if (isFile("temp\\tempCFG.cs"))
		File::delete("temp\\tempCFG.cs");
	function onExit() { }
	quit();
	}

}	// DEDICATED SERVER