//----------------------------------------------------------------------------------
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! SixPak Script Pack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
//----------------------------------------------------------------------------------
// FILE NAME    | SixHUD.cs  (HyperHUD)
// AUTHOR       | DarkNinja w/ modifications by SixStringz  
// AUTHOR EMAIL | mccleans@inreach.com
// VERSION      | 3.1b.sixpak.1.5
// RELEASE DATE | 08/12/99
// REQUIREMENTS | Presto Pack .93+
// DESCRIPTION  | This script is 100% DarkNinja's HyperHUD and he deserves all the 
// DESCRIPTION  | credit. Including major credit for the great updates he has done 
// DESCRIPTION  | on this already great HUD. Unfortunately to make it work properly 
// DESCRIPTION  | with HUDSets I have had to make modifications to great work he
// DESCRIPTION  | has done. If you want to check out the original version of
// DESCRIPTION  | HyperHUD then head over to DarkNinja's site and pick it up. 
// DESCRIPTION  | However replacing this version with any other version of HyperHUD
// DESCRIPTION  | may get messy :p
//----------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------
//  DarkNinja
//  http://www.zianet.com/mjaecks/hyperhud/
// ===============================================================================================
//  This is another HUD script file for Starsiege TRIBES.  It is a variant of DynHUD by Presto,
//  which in turn is a modification of the original DynHUD by KillerBunny.
//
//  So what?  Well, I've tried to venture down a different path by making the HUD totally
//  configurable.  There are many separate HUDs available.  I've also designed some custom icons
//  for the General HUDs.  These will be located in your "Tribes\base" directory and filenames
//  will start with "HyperHUD_...".
//
//	NOTE: These can be placed on any four sides of the screen.
//
//	- CTF HUDs for your team's flag status and the enemy's flag status.
//	- Flag Capture HUD shows how many times your team, the enemy team and you personally have captured the flag.
//	  Optional display of your personal lifetime captures.
//	- Kills HUD shows how many kills you've made so far.
//	  Optional display of your lifetime kills.
//	- Deaths HUD shows how many times you've died.
//	  Optional display of your lifetime deaths.
//	- Mines HUD shows how many mines you have.
//	- Grenades HUD shows how many grenades you have.
//	- Repair Kit HUD shows if you have a repair kit.
//	- Beacon HUD shows how many beacons you have.
//	- Player Count HUD for showing how many players are on each team.
//	  Optional display of how many observers there are too.
//	- Play time HUD shows how long you have been playing the current session of TRIBES.
//	  Optional display of your lifetime play time.
//	- Backpack HUD shows you what you are carrying on your back.
//
//	Extras (non-HUD):
//
//	- Show who you have killed along with the weapon you used.
//	- Show who killed you along with the weapon they used.
//	- Notify all players when there is team unbalance.
//
//	Other beneficial scripts:
//
//	- Objective HUD by |HH|Crunchy.  (Link is on my links page.)
//	  This cool HUD shows the objectives currently being held by your team or the enemy.  It
//	  shows objectives for Find & Retrieve, Defend & Destroy, Capture & Hold, etc.  And it
//	  touts the ability to learn objectives on NEW maps. :)
//
//  There are now three styles of HUD screens available.  Hitting "Control-H" will cycle through
//  these accordingly.
//
//	1) Capture the Flag - Shows your team and enemy team flag status HUDs.  Also, shows your
//	   general HUDs.
//	2) Multiple Team CTF - Shows your team's flag status along with the general HUDs.  Right
//	   now HyperHUD can only handle two teams at most in CTF, so there is no sense in
//	   showing the enemy's flag status if there are three or more teams playing.
//	3) General Gameplay - Shows only the general HUDs.  This option is useful for other
//	   gameplay, such as Defend & Destroy, Deathmatch, etc.
//
//  NOTE: For more detailed information, please read the descriptions for each function in the
//  script.  The HUD update function descriptions will tell you what the HUDs look like and how
//  they work.
// ===============================================================================================
//  History:
//	- 3.1b, June 21, 1999
//	  It appears I've finally fixed that nagging problem with kill/death tracking and the
//	  kills/deaths general HUDs not working right for some users.  Sorry it took so long!
//
//	  Fixed bug where Backpack HUD wouldn't reappear after you toggled HyperHUD through its
//	  various HUD screens via Control-h.
//
//	- 3.1a, June 20, 1999
//	  Boy!  Did the debug mode help out here.  I left out two parenthesis that prevented
//	  updates of some of the general HUDs.
//
//	- 3.1, June 20, 1999
//	  Added a debug mode.  When debug is switched on (via Miscellaneous config menu),
//	  tracing of HyperHUD execution is echoed to the console (~) and also written to a debug
//	  file named "HH-DEBUG.CS".  NOTE:  Do not play online constantly with debug on, because
//	  it does take up much more resources than normal.  Remember, this is for use in
//	  tracking down errors.
//
//	  If you are having problems that you cannot find in the debug file yourself, you can go
//	  ahead and email it to me along with a description of what seems to be wrong in
//	  general.
//
//	  Added a separate Backpack HUD.  This will show you what you are carrying on your back,
//	  if anything at all.  NOTE:  You should get the latest "inventory_table.cs" script by
//	  Writer.  You can get it via my links page.  This script goes in your
//	  "TRIBES\config\Presto\writer\" directory.  It adds support for mods, such as
//	  Renegades.
//
//	  Prefs/Stats files are now backed up when loaded.  The backup filenames are
//	  "HHPrefs-'YOUR NICKNAME'.bak" and "HHStats-'YOUR NICKNAME'.bak".
//
//	  To help combat problems arising from use of odd characters in your nickname, HyperHUD
//	  now only uses the following valid characters in the Prefs/Stats filename:
//
//		space
//		-
//		0-9
//		a-z
//		A-Z
//
//	  NOTE:  This only affects the filename and not your nickname.  Thus, if your nickname
//	  is "[RF] TinyTerror!@!", the filenames will be "HHPrefs-RF TinyTerror.cs" and
//	  "HHPrefs-RF TinyTerror.cs" respectively.
//
//	  Using the "MoreString.cs" script from Zear now.  This is included in NewOpts, also by
//	  Zear.  You can get NewOpts via my links page.
//
//	- 3.0, June 14, 1999
//	  This version had more bugs than previous versions.  One of the biggest (caused TRIBES
//	  to crash after a while everytime) was the upgrade to V1.5.  I reinstalled V1.4 and it
//	  doesn't crash anymore. :)
//
//	  Finally!  You can now choose HyperHUD Preferences via a chat-like menu.  No, I still
//	  haven't figured out NewOpts. :(  Of course, I've been trying to get this version out
//	  as soon as possible. :)
//
//	  As a default, you can choose the Preferences menu on the gameplay screen with ALT-k.
//	  Preferences are saved to a file named "HHPrefs-'YOUR NICKNAME'.cs" in the
//	  "TRIBES\config\" directory.
//
//	  Also added stats tracking for total personal flag captures, kills, deaths and play
//	  time.  Stats are saved to a file named "HHStats-'YOUR NICKNAME'.cs" in the
//	  "TRIBES\config\" directory.
//
//	  Changed the team player count HUD a bit.  It now has the ability to show both team's
//	  player count along with how many observers there are.  If you become an observer, then
//	  the player count icon arrows (green/red) hollow out, indicating that team 0 is to the
//	  left and team 1 is to the right and that you are currently observing.
//
//	  There are now separate general HUDs for the repair kit and beacons.
//
//	  Changed the display of general HUDs when an item does not exist.  The icons are shown
//	  as a dark green, instead of the bright green.
//
//	- 2.0g, May 29, 1999
//	  Damn!  The flag capture HUD might not disappear now, but it sure isn't tracking flag
//	  captures in General Gameplay mode.  Fixed that hopefully. :(  Thanks again CyberWolf!
//
//	- 2.0f, May 29, 1999
//	  Flag capture HUD no longer disappears in the General Gameplay HUD screen.  This is so
//	  users opting for CTF flag status tracking via Objective HUD can still keep track of
//	  captures.  Thanks CyberWolf!
//
//	  Fixed a bug where team unbalance is true when you switch to observer mode after having
//	  joined a team previously.  Upon server connection, you are assigned to a team, but
//	  when switching to observer mode from a team, you are not assigned anymore.  After
//	  having switched to observer mode, the player count HUD will show how many observers
//	  there are to the left of the green arrow and how many ACTIVE players there are to the
//	  right of the red arrow.  Thanks Moby!
//
//	- 2.0e, May 23, 1999
//	  I scrapped the objectives HUD.  I normally don't endorse other author's scripts, but
//	  Objective HUD by |HH|Crunchy is too good to pass up.  I could try implementing his
//	  objective tracking script into HyperHUD, but really don't see any improvement to his
//	  HUD, so I'll leave it at that.  There is now a link to the Objective HUD web page on
//	  my links page (http://www.zianet.com/mjaecks/hyperhud/links.html).
//
//	- 2.0d, May 17, 1999
//	  Ahhh crap!  Fixed a bug where if "$HyperPref::GenStart" equals true, it would still show
//	  the flag status HUDs.  Thanks UberGuy!
//
//	- 2.0c, May 15, 1999
//	  Added a team unbalance notification routine, tied in with the player count HUD.  This
//	  includes two new variables in "HyperHUD Preferences".  "$HyperPref::BalanceNotify" let's
//	  you turn on/off this new function.  "$HyperPref::Outnumber" equals the number of extra
//	  players that are considered to cause team unbalance.  That is, if a team outnumbers
//	  the other team by at least this amount, then our team unbalance routine will notify
//	  everyone.  By default, teams are unbalanced when a team has five or more extra
//	  players on their side.  Upon team unbalance, the phrase "Teams are unbalanced!!!" will
//	  be sent to all players along with a random colorful verbal remark for added emphasis.
//	  :)
//
//	  OK!  Now you say I'm a whiner.  That may be true, but some players don't really take
//	  a good look at team unbalance.  For example, let's say team A is outnumbered by team B
//	  by a factor of five players.  In a man-to-man combat situation, team B has five free
//	  players to either defend or attack team A.  This can make for a frustrating game and
//	  cause some players to just drop from the server, thus causing a greater team
//	  unbalance.  Granted there are some good players that can handle two or even three
//	  players by themselves, but for most, one-on-one is the easiest way to go.  Had to get
//	  my two-cents worth in here! :)
//
//	  Added a banner to the TRIBES main screen.  Thanks to [RL]Prey for the code submission!
//
//	- 2.0b, May 9, 1999
//	  Fixed incompatibility bug with timeHUD by Shots.
//
//	  Resized the flag capture HUD icon so that the HUD can accommodate team capture totals
//	  greater than nine. :)
//
//	- 2.0a, May 9, 1999
//	  Damn I suck as a beta tester! :(  Fixed bug where flag capture HUD wasn't updating
//	  upon the enemy's capture of your flag.  Had to move one line of code to fix it too. :)
//
//	- 2.0, May 8, 1999
//	  Finally, you can now place the general HUDs in any order you like.  Just CUT & PASTE
//	  the general HUD lines above in "HyperHUD Preferences" to your liking.  Also changed
//	  the way you turn them on or off.  Comment the lines with "//" at the beginning to turn
//	  that particular general HUD off.
//
//	  Fixed the general HUD limit of four in the "top", "topchat" and "bottom" positions for
//	  512x384 users.
//
//	  You can now place BOTH the flag status HUDs and general HUDs on the same side of the
//	  screen (left or right).  The general HUDs will always be placed at the edge of the
//	  screen, with the flag status HUDs on the inside towards the center of the screen.
//	  This is due to the variable display widths of the flag status HUDs.  Thanks Jacknife!
//
//	  Changed the flag capture HUD again:
//
//		CTF HUD screen - The HUD will have your team's flag capture total to the left
//		of the capture icon and the enemy total to the right.  If there are no capture
//		totals, they will be left blank.  Upon a capture by YOU, the HUD will blink
//		(alternate) between the normal display and a display just showing your
//		personal capture count.  This will continue for a few seconds.
//
//		Multiple Team HUD screen - The HUD will have your personal capture total to
//		the left of the icon and your team's capture total to the right.  If there are
//		no personal captures or team captures, they will be left blank.  
//
//	- 1.9, May 2, 1999
//	  Added another HUD to keep track of how long you've been playing the current session of
//	  TRIBES.  The time is updated every minute.  The counter begins upon a server
//	  connection.  It basically keeps a counter incremented every 60 seconds using the
//	  "schedule" function.
//
//	  Fixed a bug that did not reset the flag capture HUD upon a team change.  Flag captures
//	  are now tracked for all teams.  Your personal captures are tracked for each team you
//	  join.  So during a game, you capture the flag twice for team A.  You decide to switch
//	  to team B.  If for some reason you were to join team A again, you will still retain
//	  the two personal flag captures and team A's total flag capture amount.
//
//	- 1.8b, May 1, 1999
//	  Minor change to the flag capture HUD.  It now monitors both how many times you
//	  personally have captured the enemy flag and how many times your team has captured the
//	  enemy flag.  Your personal total is displayed to the left of the flag capture icon and
//	  the team total is on the right side of the icon.  If there are no totals, then they
//	  will be left blank.  Also, if you don't have any personal captures, the icon will be
//	  left justified.
//
//	  NOTE: If you join a game in progress, the flag capture amount may be incorrect.  This
//	        will be corrected once the server begins a new mission.
//
//	- 1.8a, April 27, 1999
//	  Fixed bug that would display both flag status HUDs when you were in Multiple Team HUD
//	  screen or General Gameplay HUD screen.  This was due to redesign of compact flag
//	  status HUDs in V1.7.
//
//	- 1.8, April 25, 1999
//	  Added another HUD to keep track of how many objectives your team currently holds.
//
//	  NOTE:
//		- Objectives are defined as tower switches for now.  So destroying enemy
//		  generators in D&D does not count.
//		- Upon joining a server, the amount is set to zero, since we do not know how
//		  many objectives are currently held by our team.
//		- The amount is also set to zero when you switch teams.  At the moment, we
//		  cannot track the enemy's objective count, because no client messages tell us
//		  if the objective we just took was open are previously held by the enemy.
//
//	- 1.7a, April 25, 1999
//	  Removed the "$Hyper::MaxPlayers" preference.  HyperHUD now determines the last known
//	  client for use with the team player count HUD.
//
//	- 1.7, April 24, 1999
//	  Changed flag status HUDs so now they are more compact when a flag is not being carried
//	  by a player.
//
//	  Also, when YOU are in possession of the enemy flag, the text will blink on and off to
//	  show that you have it.  This comes in handy during a battle and you unknowingly pick
//	  up the enemy flag from a teammate who was just killed.  In the heat of battle, I
//	  sometimes forget to check the HUDs. :)
//
//	- 1.6a, April 22, 1999
//	  Fixed bug where HyperHUD would advance (simulate hitting Control-H) everytime you
//	  would connect/reconnect to a server without actually quitting TRIBES and restarting
//	  each time.  This basically deals with the use of the built-in server locater.  I
//	  use GameSpy, so I didn't notice this problem. :(  Thanks Razor!
//
//	- 1.6, April 16, 1999
//	  Added user preference to start HyperHUD in the General Gameplay screen (no flag status
//	  HUDs shown).  Hitting Control-H will toggle HyperHUD normally thereafter.
//
//	- 1.5, April 11, 1999
//	  Added another HUD to keep track of how many players are on each team.  Now you'll know
//	  when team balance is unfair. :)  Now that there are seven HUDs available at once, I
//	  have gone ahead and designed HyperHUD to put any HUDs after the sixth one on the next
//	  line.  This applies only when you have $HyperPref::GenHUDLoc set to "top", "topchat" or
//	  "bottom".  Also introduced a new related preference $Hyper::MaxPlayers.  This refers
//	  to the server's maximum number of players allowed.  HyperHUD's default is 32, but if
//	  you play on servers that allow more than 32 players, you will need to change this
//	  accordingly.  Otherwise, the player count HUD won't function correctly.  Don't forget
//	  you are assigned to a team in "Observer" mode, even though the score menu (TAB) will
//	  leave your team name blank.  NOTE: 512x384 users are still limited to four HUDs in the
//	  "top", "topchat" or "bottom" areas.  Will try and fix this restriction in the future.
//
//	  Also added an auto-start option in HyperHUD Preferences.  This lets HyperHUD activate
//	  automatically upon a server connection, instead of you having to hit Control-H for the
//	  first time.  I should have done this a long time ago.
//
//	  Fixed CTF HUD bug when player switched teams, the flag status would not switch also.
//
//	- 1.4, April 3, 1999
//	  Multiple HUD placements available now in the HyperHUD Preferences.  Flag status HUDs
//	  can be placed on the left, right, top and bottom of the screen.  You can also place
//	  them beneath the chat window.  The same goes for the general HUDs.  You cannot have
//	  conflicts though.  Don't place the flag status HUDs and general HUDs in the same
//	  place.  The only exception to this is placing them both on the bottom of the screen.
//	  Flag status HUDs are put in opposite corners and the general HUDs would be between
//	  them.
//
//	  NOTE: For 512x384 users, you can only have up to four general HUDs showing if you want
//	        them in the "top" position, "topchat" position or in the "bottom" position with
//	        the flag status HUDs in the "bottom" position also.
//
//	  Also fixed a bug when you switched teams during gameplay, general HUDs would not be
//	  updated properly.
//
//	- 1.3a, March 29, 1999
//	  Double DOH!  Mines, grenades, repair/beacon HUDs do not reset upon mission change.
//	  Fixed that.  Resets about a second after you get the "Match started." message.
//
//	- 1.3, March 29, 1999
//	  DOH!  Added back in the preference to display the victim and weapon used upon a
//	  verified kill by you.  Also added the preference to display the killer and weapon he
//	  used to kill you.  Both messages are displayed at the bottom center of your screen for
//	  about four seconds, upon a kill or death.
//
//	  Hoorah!!!  Mines, grenades and repair kit/beacon HUDs are no longer updated every two
//	  seconds.  Updates now occur only when a station is accessed for supplies, an item is
//	  thrown (grenade, etc.), an item is used (repair kit, etc.), after you have died or if
//	  you pick something up.
//
//	  Shazbot!  Two problems with the new update system though:
//		1) When accessing an AMMO station, you must wait until "Resupply Complete".
//		2) When you die, you must respawn within 30 seconds.  If you wait any longer,
//		   the HUDs will not be reset properly and you'll still see how many mines,
//		   grenades, etc. you had before death.
//
//	- 1.2, March 28, 1999
//	  Reworked attached events.  Events concerning HUDs are now only active when the HUD is
//	  displayed.  This applies to the flag capture, kills and deaths HUDs.  Tried to improve
//	  on reported slowdown of computer during gameplay.
//
//	  Added option in HyperHUD Preferences above to modify how far from the top of the
//	  screen you want the HUDs to appear.
//
//	- 1.1, March 27, 1999
//	  Added a flag capture HUD for counting how many times you have captured the enemy flag.
//
//	- 1.0, March 27, 1999
//	  First public release.
// ===============================================================================================
//  Requirements:
//	- Presto's ScriptPak V0.93 or higher.
//	  (http://www.planetstarsiege.com/presto/)
//	- "MoreString.cs" by Zear (included in NewOpts, also by Zear).
//	  (http://www.cetisp.com/~thammock/scripts/script/NewOpts.html)
//	- Backpack HUD works best with latest "inventory_table.cs" script by Writer.
//	  (http://www.planetstarsiege.com/lorne/scripts/inventory_table.cs)
//	- "autoexec.cs" in your "Tribes\config" directory.  If you don't have this file, just
//	  copy the one supplied with Presto's ScriptPak.
//	- A screen width of at least 512 works best.  Anything smaller isn't worthwhile.
// ===============================================================================================
//  Installation:
//	- After installing Presto's ScriptPak, you should have in your
//	  "Tribes\config\autoexec.cs" file the following, if you don't already have it:
//
//		exec("Presto\\install.cs");
//
//	- If you followed the installation instructions from Presto, then add this next:
//
//		exec("HyperHUD.cs");
//
//	- HyperHUD's default control is currently set to "Control-H".  You can change this at
//	  the top of the script under "HyperHUD Control".
//
//	- At the beginning of this script is the "HyperHUD Preferences" section.  Make sure you
//	  read that.  This is where the user can determine what HUDs to display.
//
//	- If you're not using Presto's DynHUD, edit "Tribes\config\Presto\PrestoPrefs.cs" and
//	  change the line:
//
//	  $PrestoPref::DynHud = "control h";
//
//	  to
//
//	  $PrestoPref::DynHud = false;
// ===============================================================================================
//  Bugs:
//	- After you've installed everything correctly and have run TRIBES, HyperHUD may not
//	  activate when you press "Control-H".
//
//	  Solution:
//		- Edit your "Tribes\config\config.cs" file and make sure that there are only
//		  two references to the "Control-H" bind.  The first line is the "make" bind
//		  referring to "Hyper::Toggle();".  The second line will be the "break" bind
//		  referring to "".  If you see any other lines with something like
//		  "control, "h"", then delete them.
//
//	- Player names will wrap in the flag status HUDs if they are very long. This has to do
//	  with Presto's ScriptPak, but I really don't think it's that bad.  I've left three
//	  lines for a player's name, in case there are some out there who insist on long names
//	  with meaningless symbols in them. :)
//
//	- For more help, check out:
//
//	  http://www.zianet.com/mjaecks/hyperhud/help.html
// ===============================================================================================
//  Future:
//	- Working on selecting HyperHUD Preferences via menus instead of manually editing the
//	  script file.
//	- Add team score tracking perhaps.
//	- Clean up the code some.
// ===============================================================================================
//  Thanks to:
//	- Presto: Without his ScriptPak, life would be a little bit harder. :)
//	- KillerBunny: For starting a revolution with the release of the original DynHUD.
//	- Starsiege Team: Great game!  Can't wait to get Starsiege.
//	- Scripters: Keep up the good work.
// ===============================================================================================
//  Contact:
//	- Comments and suggestions are welcome.
//	- Permission is granted to use parts of my HyperHUD.cs script in helping you develop a
//	  cool HUD of your own. All I ask is for some mention/credit of my script name and/or
//	  nickname.  References to DynHUD, Presto and KillerBunny would be welcome too.
//	- Permission is granted to use my custom icons in your HUD development as long as some
//	  mention/credit of my script name and/or nickname is given.
//	- PLEASE do not contact me about any problems installing or using Presto's ScriptPak.
//	  Instead, take a stroll over to PlanetStarsiege and check out their Scripting Forum.
//	  Presto is very good at replying to messages there.
//	  (http://www.planetstarsiege.com/)
//	- PLEASE do not ask me to add any third party scripts to my HUD. By this I mean scripts
//	  that execute messages, like a "I'm repairing ..." when you're repairing a generator or
//	  something.  Also, a script that makes you super jump or such. These scripts can be
//	  executed from your Tribes\config\autoexec.cs file. They can function perfectly as a
//	  separate entity most of the time.
//
//  DarkNinja
//  mjaecks@zianet.com
// ===============================================================================================

// Presto ScriptPak functions needed.
Include("presto\\Event.cs");
Include("presto\\HUD.cs");
Include("presto\\TeamTrak.cs");
Include("presto\\KillTrak.cs");
Include("NewOpts\\MoreString.cs");

// Lets add a banner on the main screen.
Presto::AddScriptBanner(HyperHUD,
	"\n" @   
	"<f2><jc>HyperHUD\n" @
	"<f1>Version 3.1b\n" @
	"<f0><jc>June 21, 1999\n" @
	"\n" @
	"<f0>Written by: <f2>DarkNinja<f0>\n" @
	"\n" @
	"<f0>The HUD of champions!\n");


$Hyper::c = -1;	// DO NOT MODIFY THIS LINE!!!

function Hyper::DefaultPrefs(%type)
{

if ((%type == "keys") || (%type == "all"))
{
$HyperPref::Toggle = "control h";
$HyperPref::PrefToggle = "alt k";
}

if ((%type == "flagloc") || (%type == "all"))
{
// Where do you want the flag status HUDs to appear?  Options are:
//
//	   "left" - Appear vertically on the left side of the screen, between the power/health
//		  meters and the weapon icons.  If you have the general HUDs below set to
//		  "left" also, then the flag status HUDs will appear to the right of the
//		  general HUDs.
//	  "right" - Appear vertically on the right side of the screen, just under the compass.
//		  If you have the general HUDs below set to "right" also, then the flag status
//		  HUDs will appear to the left of the general HUDs.
//	    "top" - Appear horizontally at the top center of the screen.  Use this option only
//		  if you have turned off the chat window.  You can do this during gameplay
//		  via the prefs menu, default key is "k".
//	 "bottom" - Appear horizontally at the bottom of the screen.  If you choose this option,
//		  your team's flag status HUD will appear in bottom left corner and the
//		  enemy's will appear in the bottom right corner.
$HyperPref::FlagHUDLoc = "left";

// Starting Y position of our flag HUDs.  This is how many pixels from top of screen the flag HUDs
// will be displayed.  Good values are 65 for 512x384, 70 for 640x480, 80 for 800x600 and 90 for
// 1024x768.  This value only applies if $HyperPref::FlagHUDLoc equals "left", "right" or "topchat".
// You can modify this to your own liking.
$HyperPref::FlagPos = "82";
}

if ((%type == "genloc") || (%type == "all"))
{
// Where do you want the general HUDs to appear?  Options are:
//
//	   "left" - Appear vertically on the left side of the screen, between the power/health
//		  meters and the weapon icons.
//	  "right" - Appear vertically on the right side of the screen, just under the compass.
//	    "top" - Appear horizontally at the top center of the screen.  Use this only if you
//		  do not like having the chat message window open.  You can turn the chat
//		  window on/off via prefs menu during gameplay, default key is "k".
//	 "bottom" - Appear horizontally at bottom center of screen.
//
$HyperPref::GenHUDLoc = "right";

// Starting Y position of our general HUDs (caps/kills/deaths/etc.).  This is how many pixels from
// top of screen the HUDs will be displayed.  This value only applies if $HyperPref::GenHUDLoc equals
// "left", "right" or "topchat".  Good values are the same as for $HyperPref::FlagPos.  Modify to
// your liking.
$HyperPref::GenPos = "66";
}

if ((%type == "perline") || (%type == "all"))
{
// This is how many general HUDs to display per line ONLY IF $HyperPref::GenHUDLoc equals "top",
// "topchat" or "bottom".  Good values are 4 for a screen width of 512, 6 for 640 and 9 for 800+.
$HyperPref::HUDsPerLine = 9;
}

// For the following, true = uncommented line and false = commented line.  Commented lines
// begin with "//", so '//$HyperPref::Gen[%c++] = "Caps";' would turn off the flag capture HUD.
//
// Also, you can reorder the General HUDs to your liking.  All you have to do is CUT & PASTE the
// lines below in the order you want the HUDs to appear.

if ((%type == "gencfg") || (%type == "all"))
{
// General HUDs.
$HyperPref::Gen[$Hyper::c++] = "Caps";		// Show how many times you and/or your team have captured the enemy flag?
$HyperPref::Gen[$Hyper::c++] = "Kills";		// Show how many kills you've made?
$HyperPref::Gen[$Hyper::c++] = "Deaths";	// Show how many times you have been killed?
$HyperPref::Gen[$Hyper::c++] = "Mines";		// Show how many mines you have?
$HyperPref::Gen[$Hyper::c++] = "Grenades";	// Show how many grenades you have?
$HyperPref::Gen[$Hyper::c++] = "Repair";	// Show if you have a repair kit?
$HyperPref::Gen[$Hyper::c++] = "Beacon";	// Show beacons if you have them?
$HyperPref::Gen[$Hyper::c++] = "Players";	// Show how many players are on each team?
//$HyperPref::Gen[$Hyper::c++] = "PlayTime";	// Show how long you've been playing?

// For the following, true = on and false = off.

$HyperPref::ShowTC = true;
$HyperPref::ShowTK = true;
$HyperPref::ShowTD = true;
$HyperPref::ShowObserver = true;
$HyperPref::ShowTT = true;

$HyperPref::NumGenHUDs = $Hyper::c + 1;	// How many General HUDs do we have?
}

if ((%type == "misc") || (%type == "all"))
{
// For the following, true = on and false = off.

$HyperPref::ShowVictim = true;	// Upon a kill, do you want the victim and weapon used shown
				// temporarily onscreen?
$HyperPref::ShowKiller = true;	// Upon your death, do you want to view the killer and weapon used
				// temporarily onscreen?

$HyperPref::AutoStart = true;		// Do you want HyperHUD to automatically run on startup?

$HyperPref::GenStart = false;		// Do you want HyperHUD to start up in the General Gameplay screen?  (No flag status HUDs.)

$HyperPref::BalanceNotify = false;	// Notify everyone when teams are unbalanced?  NOTE: You must have
				// the player count HUD active above ("Players"), otherwise this
				// is useless.
}


if ((%type == "outnumber") || (%type == "all"))
$HyperPref::Outnumber = 5;		// By how many players do you consider a team outnumbered?

if ((%type == "pack") || (%type == "all"))
{
$HyperPref::ShowPack = false;
$HyperPref::PackPos = "100% 100%";
}

}

function Hyper::ProcessArray(%value)
{
	$HyperPref::Gen[$Hyper::c++] = %value;
}

function Hyper::ProcessName(%in)
{
	%strlen = String::len(%in);
	%name = "";

	for (%i = 0; %i < %strlen; %i++)
	{
		%ascii = String::ascii($PCFG::Name, %i);
		if ((%ascii == 32) || (%ascii == 45) || ((%ascii > 47) && (%ascii < 58)) ||
		    ((%ascii > 64) && (%ascii < 91)) || ((%ascii > 96) && (%ascii < 123)))
			%name = %name @ String::char(%ascii);
	}

	%name = %name @ "";

	return %name;
}


function Hyper::UpdatePrefs(%type, %i, %res)
{
   %filename = "config\\SixHUDPrefs_"@%i;
   if (%type == "normal")
      %filename = %filename @ ".cs";
   else
	%filename = %filename @ ".bak";

   $SixHudPref::[%i, %res, AutoStart] = $HyperPref::AutoStart;
   $SixHudPref::[%i, %res, BalanceNotify] = $HyperPref::BalanceNotify;
   $SixHudPref::[%i, %res, FlagHUDLoc] = $HyperPref::FlagHUDLoc;
   $SixHudPref::[%i, %res, FlagPos] = $HyperPref::FlagPos;
   $SixHudPref::[%i, %res, Gen0] = $HyperPref::Gen0;
   $SixHudPref::[%i, %res, Gen1] = $HyperPref::Gen1;
   $SixHudPref::[%i, %res, Gen2] = $HyperPref::Gen2;
   $SixHudPref::[%i, %res, Gen3] = $HyperPref::Gen3;
   $SixHudPref::[%i, %res, Gen4] = $HyperPref::Gen4; 
   $SixHudPref::[%i, %res, Gen5] = $HyperPref::Gen5;
   $SixHudPref::[%i, %res, Gen6] = $HyperPref::Gen6;
   $SixHudPref::[%i, %res, Gen7] = $HyperPref::Gen7;
   $SixHudPref::[%i, %res, GenHUDLoc] = $HyperPref::GenHUDLoc;
   $SixHudPref::[%i, %res, GenPos] = $HyperPref::GenPos;
   $SixHudPref::[%i, %res, GenStart] = $HyperPref::GenStart;
   $SixHudPref::[%i, %res, HUDsPerLine] = $HyperPref::HUDsPerLine ;
   $SixHudPref::[%i, %res, NumGenHUDS] = $HyperPref::NumGenHUDs;
   $SixHudPref::[%i, %res, OutNumber] = $HyperPref::Outnumber;
   $SixHudPref::[%i, %res, PrefToggle] = $HyperPref::PrefToggle;
   $SixHudPref::[%i, %res, ShowKiller] = $HyperPref::ShowKiller;
   $SixHudPref::[%i, %res, ShowObserver] = $HyperPref::ShowObserver;
   $SixHudPref::[%i, %res, ShowPack] = $HyperPref::ShowPack;
   $SixHudPref::[%i, %res, ShowTC] = $HyperPref::ShowTC;
   $SixHudPref::[%i, %res, ShowTD] = $HyperPref::ShowTD;
   $SixHudPref::[%i, %res, ShowTK] = $HyperPref::ShowTK;
   $SixHudPref::[%i, %res, ShowTT] = $HyperPref::ShowTT;
   $SixHudPref::[%i, %res, ShowVictim] = $HyperPref::ShowVictim;
   $SixHudPref::[%i, %res, ShowPack] = $HyperPref::ShowPack;
   $SixHudPref::[%i, %res, Toggle] = $HyperPref::Toggle;

   export("$SixHUDPref::*", %filename, false);

   %txt = "SixHUD Preferences ";

   if (%type == "normal")
      %txt = %txt @ "Updated!";
   else
	%txt = %txt @ "Backup Made!";

   echo(%txt);
}

function Hyper::LoadPrefs(%i, %res) 
{
   %filename = "SixHUDPrefs_"@%i@".cs";

   if (isFile("config\\" @ %filename))
   {
      exec(%filename);
      echo("SixHUD loading prefs for HUDSet #"@%i@" Resolution: "@%res);

      $HyperPref::AutoStart = $SixHudPref::[%i, %res, AutoStart];
      $HyperPref::BalanceNotify = $SixHudPref::[%i, %res, BalanceNotify];
      $HyperPref::FlagHUDLoc = $SixHudPref::[%i, %res, FlagHUDLoc];
	$HyperPref::FlagPos = $SixHudPref::[%i, %res, FlagPos];
	$HyperPref::Gen0 = $SixHudPref::[%i, %res, Gen0];
	$HyperPref::Gen1 = $SixHudPref::[%i, %res, Gen1];
	$HyperPref::Gen2 = $SixHudPref::[%i, %res, Gen2];
	$HyperPref::Gen3 = $SixHudPref::[%i, %res, Gen3];
	$HyperPref::Gen4 = $SixHudPref::[%i, %res, Gen4];
	$HyperPref::Gen5 = $SixHudPref::[%i, %res, Gen5];
	$HyperPref::Gen6 = $SixHudPref::[%i, %res, Gen6];
      $HyperPref::Gen7 = $SixHudPref::[%i, %res, Gen7];
	$HyperPref::GenHUDLoc = $SixHudPref::[%i, %res, GenHUDLoc];
	$HyperPref::GenPos = $SixHudPref::[%i, %res, GenPos];
	$HyperPref::GenStart = $SixHudPref::[%i, %res, GenStart];
	$HyperPref::HUDsPerLine = $SixHudPref::[%i, %res, HUDsPerLine];
	$HyperPref::NumGenHUDs = $SixHudPref::[%i, %res, NumGenHUDS];
	$HyperPref::Outnumber = $SixHudPref::[%i, %res, OutNumber];
	$HyperPref::PrefToggle = $SixHudPref::[%i, %res, PrefToggle];
	$HyperPref::ShowKiller = $SixHudPref::[%i, %res, ShowKiller];
	$HyperPref::ShowObserver = $SixHudPref::[%i, %res, ShowObserver];
	$HyperPref::ShowPack = $SixHudPref::[%i, %res, ShowPack];
	$HyperPref::ShowTC = $SixHudPref::[%i, %res, ShowTC];
	$HyperPref::ShowTD = $SixHudPref::[%i, %res, ShowTD];
	$HyperPref::ShowTK = $SixHudPref::[%i, %res, ShowTK];
	$HyperPref::ShowTT = $SixHudPref::[%i, %res, ShowTT];
	$HyperPref::ShowVictim = $SixHudPref::[%i, %res, ShowVictim];
	$HyperPref::ShowPack = $SixHudPref::[%i, %res, ShowPack];
	$HyperPref::Toggle = $SixHudPref::[%i, %res, Toggle];

      for (%i1 = 0; %i1 < $HyperPref::NumGenHUDs; %i1++)
      {
         %txt = "Hyper::ProcessArray($HyperPref::Gen" @ %i1 @ ");";
         eval(%txt);
      }
      echo("SixHUD Preferences Loaded!");
      Hyper::UpdatePrefs("backup", %i, %res);
   }
   else
   {
      Hyper::DefaultPrefs("all");
      Hyper::UpdatePrefs("normal", %i, %res);
      echo("SixHUD Defaults Saved!");
   }
}

Hyper::LoadPrefs($SixPref::HUDConfig,$SixVar::Res);

function Hyper::UpdateStats(%type)
{

	%filename = "config\\SixHUDStats-" @ Hyper::ProcessName($PCFG::Name);

	if (%type == "normal")
		%filename = %filename @ ".cs";
	else
		%filename = %filename @ ".bak";

	export("$HyperStat::*", %filename, false);

	%txt = "SixHUD Statistics ";

	if (%type == "normal")
		%txt = %txt @ "Updated!";
	else
		%txt = %txt @ "Backup Made!";

	echo(%txt);
}

function Hyper::LoadStats()
{
	%filename = "SixHUDStats-" @ Hyper::ProcessName($PCFG::Name) @ ".cs";

	if (isFile("config\\" @ %filename))
	{
		Include(%filename);

		echo("SixHUD Statistics Loaded!");
		Hyper::UpdateStats("backup");
	}
}

$HyperStat::TotalTime = "0 0 0";
Hyper::LoadStats();
$Hyper::StatDay = getWord($HyperStat::TotalTime, 0);
$Hyper::StatHour = getWord($HyperStat::TotalTime, 1);
$Hyper::StatMin = getWord($HyperStat::TotalTime, 2);

// ===============================================================================================
//  Function: UpdateHomeHUD
//
//  Purpose: Update our team's flag status.
//
//	Flag status updates:
//
//	- Green flag indicates our team's flag is safe at home.
//	- Grey flag with a eagle (bird) symbol indicates that the flag is currently being
//	  carried by an enemy player.  If so, a message will appear next to the flag symbol
//	  informing you who currently holds the flag.
//	- A flag with a question mark can indicate two possibilities:
//
//	  1) When you CONNECT for the first time to a server, the flag status will be unknown.
//	     Therefore, we will initially start with the ? flag.
//	  2) After a capture, the flag status will be correct.  From this point, a ? flag will
//	     indicate that the team's flag has been dropped in the field.  This is usually due
//	     to the carrier's death.
// ===============================================================================================
function Hyper::UpdateHomeHUD()
{
	%teamFlag = Team::GetFlagLocation(Team::Friendly());	// Status of our flag.

	if (%teamFlag == $Trak::locationHome)
		HUD::AddText(hudCTFHomeSmall, "<B4,2:flag_atbase.bmp>");		// Our flag is safe at home.
	else if (%teamFlag == $Trak::locationField)
		HUD::AddText(hudCTFHomeSmall, "<B4,2:flag_notatbase.bmp>");	// Our flag was dropped in the field.
	else if (%teamFlag == "")
		HUD::AddText(hudCTFHomeSmall, "<B4,2:flag_notatbase.bmp>");	// Upon first-time connection, our flag status is unknown.
	else
		HUD::AddText(hudCTFHome, "<B4,2:flag_neutral.bmp><f1>ATTACK:\n<f2>" @ %teamFlag @ "\n\n\n");	// Enemy has our flag!

	return 0;
}

// ===============================================================================================
//  Function: UpdateEnemyHUD
//
//  Purpose: Update enemy team's flag status.
//
//	Flag status updates:
//
//	- Red flag indicates enemy team's flag is safe at home.
//	- Grey flag with a eagle (bird) symbol indicates that the flag is currently being
//	  carried by a teammate.  If so, a message will appear next to the flag symbol informing
//	  you who currently holds the flag.  If you are carrying the flag, the text will blink
//	  in the HUD to notify you.
//	- A flag with a question mark can indicate two possibilities:
//
//	  1) When you CONNECT for the first time to a server, the flag status will be unknown.
//	     Therefore, we will initially start with the ? flag.
//	  2) After a capture, the flag status will be correct.  From this point, a ? flag will
//	     indicate that the team's flag has been dropped in the field.  This is usually due
//	     to the carrier's death.
// ===============================================================================================
function Hyper::UpdateEnemyHUD()
{
	%enemyFlag = Team::GetFlagLocation(Team::Enemy());	// Status of the enemy's flag.

	if (%enemyFlag == $Trak::locationHome)
		HUD::AddText(hudCTFEnemySmall, "<B4,2:flag_enemycaptured.bmp>");	// Enemy flag is safe at home.
	else if (%enemyFlag == $Trak::locationField)
		HUD::AddText(hudCTFEnemySmall, "<B4,2:flag_notatbase.bmp>");	// Enemy flag was dropped in the field.
	else if (%enemyFlag == "")
		HUD::AddText(hudCTFEnemySmall, "<B4,2:flag_notatbase.bmp>");	// Upon first-time connection, enemy flag status is unknown.
	else if (%enemyFlag == client::getname(getManagerId()))
	{
		if ($Hyper::BlinkToggle == 0)
		{
			HUD::AddText(hudCTFEnemy, "<B4,2:flag_neutral.bmp><f2>YOU <f1>have\nthe enemy\nflag!");	// YOU are carrying the enemy flag.
			$Hyper::BlinkToggle++;
		}
		else
		{
			HUD::AddText(hudCTFEnemy, "<B4,2:flag_neutral.bmp>");	// Blink the text off in the HUD.
			$Hyper::BlinkToggle = 0;
		}

		return 1;	// If you are carrying the flag, schedule an update in one second so we can blink the text.
	}
	else
		HUD::AddText(hudCTFEnemy, "<B4,2:flag_neutral.bmp><f1>ESCORT:\n<f2>" @ %enemyFlag);	// A teammate has the enemy flag.

	return 0;
}

function Hyper::CenterPrint(%value, %fieldsize)
{
	for (%i = 0; String::getSubStr(%value, %i, 1) != ""; %i++) {}

	%j = floor((%fieldsize - %i) / 2);

	if (%j < 3)
		%j++;

	for (%i = 0; %i < %j; %i++)
		%value = " " @ %value;

	return %value;
}

// ===============================================================================================
//  Function: UpdateCapsHUD
//
//  Purpose: Update how many times your team, the enemy team and you personally have captured the
//	   flag.  The HUD will have a small TRIBES-like flag with a "C" in it.  There are two
//	   different displays available, depending on which HUD screen you have chosen by
//	   hitting "Control-H".
//
//	   CTF HUD screen - Your team's flag capture total will be displayed to the left of the
//	   icon and the enemy flag capture total will be on the right of the icon.  If your team
//	   has no captures yet, then the icon will be left justified.  If there are no enemy
//	   captures yet, the right will be left blank.  Upon a flag capture by YOU, the HUD will
//	   blink (alternate) between the normal display and a display just showing how many
//	   times you have captured the enemy flag personally so far.
//
//	   Multiple Team HUD screen - Your personal flag capture count will be displayed on the
//	   left side of the icon and your team's total flag capture amount is on the right side.
//	   If you have no personal captures, the icon will be left justified.  If your team has
//	   no captures, it will be left blank to the right of the icon.
//
//	   NOTE: The flag capture HUD display will be turned off automatically if you choose the
//	   General Gameplay HUD screen.  If you're not going to show the flag status, no sense
//	   in showing your captures. :)
// ===============================================================================================
function Hyper::UpdateCapsHUD()
{
	%myteam = Client::getTeam(getManagerId());	// Get which team I'm on.
	%mycaps = $Hyper::YourCaps[%myteam];		// Get how many captures I have so far.
	%teamcaps = $Hyper::caps[%myteam];		// Get how many captures my team has.
	%enemycaps = $Hyper::caps[1 - %myteam];		// Get how many captures the enemy team has.

	if ($Hyper::YouCapped)	// If you captured the flag, then let's blink the flag capture HUD.
	{
		if ($Hyper::capBlinkCnt++ > 11)
		{
			$Hyper::capBlinkCnt = 0;
			$Hyper::capBlink = 0;
			$Hyper::YouCapped = false;
		}

		if ($Hyper::capBlink == 1)	// Show your capture count every other second.
		{
			if (%mycaps < 10)
				HUD::AddText(hudCaps, " ");

			HUD::AddText(hudCaps, "   <f1>" @ %mycaps);	// If we have some captures, let's show them.

			if ($HyperPref::ShowTC)
			{
				HUD::AddText(hudCaps, "\n\n<B0,0:HyperHUD_totcaps.bmp><f1>" @ Hyper::CenterPrint($HyperStat::TotalCaps, 5));
			}

			$Hyper::capBlink = 0;

			return 1;
		}
	}

	if (($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen"))
	{
		if (%teamcaps > 0)
		{
			if (%teamcaps < 10)
			{
				HUD::AddText(hudCaps, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

				if (%enemycaps == 0)
					HUD::AddText(hudCaps, " ");	// Put the amount over one space for a nicer appearance.
			}

			HUD::AddText(hudCaps, "<f2>" @ %teamcaps);	// If we have some team captures, let's show them.
		}
		else if (%enemycaps > 0)
		{
			HUD::AddText(hudCaps, " ");

			if (%enemycaps < 10)
				HUD::AddText(hudCaps, " ");
		}
	}
	else
	{
		if (%mycaps > 0)
		{
			if ((%mycaps < 10) && (%teamcaps < 10))
				HUD::AddText(hudCaps, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

			HUD::AddText(hudCaps, "<f1>" @ %mycaps);	// If we have some captures, let's show them.
		}
	}

	if (((($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen")) && ((%teamcaps > 0) || (%enemycaps > 0))) ||
	    (($Hyper::Mode == "MT") && ((%mycaps >0) || (%teamcaps > 0))))
	{
		if ((%mycaps > 0) || (%teamcaps > 0) || (%enemycaps > 0))
			HUD::AddText(hudCaps, "<B4,2:HyperHUD_cap.bmp>");		// Show our flag capture icon.
		else
			HUD::AddText(hudCaps, "<B4,2:HyperHUD_nocap.bmp>");
	}
	else
	{
		if ((%mycaps > 0) || (%teamcaps > 0) || (%enemycaps > 0))
			HUD::AddText(hudCaps, "<B17,2:HyperHUD_cap.bmp>");
		else
			HUD::AddText(hudCaps, "<B17,2:HyperHUD_nocap.bmp>");
	}
	if (($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen"))
	{
		if (%enemycaps > 0)
			HUD::AddText(hudCaps, "<f0>" @ %enemycaps);	// If the enemy has some captures, let's show them.
	}
	else if (%teamcaps > 0)
			HUD::AddText(hudCaps, "<f2>" @ %teamcaps);	// If we have some team captures, let's show them.

	if ($HyperPref::ShowTC)
	{
		if ($HyperStat::TotalCaps > 0)
			HUD::AddText(hudCaps, "\n\n<B0,0:HyperHUD_totcaps.bmp><f1>" @ Hyper::CenterPrint($HyperStat::TotalCaps, 5));
		else
			HUD::AddText(hudCaps, "\n\n<B0,0:HyperHUD_nototcaps.bmp>");
	}

	if ($Hyper::YouCapped)	// Set our blink toggle for our next call to this function.
	{
		$Hyper::capBlink = 1;
		return 1;
	}
	else
		return 0;
}

// ===============================================================================================
//  Function: UpdateKillsHUD
//
//  Purpose: Update our verified kills.  This HUD will show a SKULL & CROSSBONES icon.  To the
//	   right will be shown the amount of kills you have so far.  If you don't have any, then
//	   the number will be left blank.
// ===============================================================================================
function Hyper::UpdateKillsHUD()
{
	if ($Hyper::Kills > 0)
	{
		HUD::AddText(hudKills, "<B4,2:HyperHUD_kills.bmp><f2>");	// Show our Kills icon.

		if ($Hyper::Kills < 10)
			HUD::AddText(hudKills, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudKills, $Hyper::Kills);	// If we have some kills, let's show them.
	}
	else
		HUD::AddText(hudKills, "<B4,2:HyperHUD_nokills.bmp>");

	if ($HyperPref::ShowTK)
	{
		if ($HyperStat::TotalKills > 0)
			HUD::AddText(hudKills, "\n\n<B0,0:HyperHUD_totkills.bmp><f1>" @ Hyper::CenterPrint($HyperStat::TotalKills, 5));
		else
			HUD::AddText(hudKills, "\n\n<B0,0:HyperHUD_nototkills.bmp>");
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateDeathsHUD
//
//  Purpose: Update how many times we have been killed. :(  This HUD will have a CROSS icon along
//	   with how many times you have been killed.  If there are no deaths, then the number
//	   will be left blank.
// ===============================================================================================
function Hyper::UpdateDeathsHUD()
{
	if ($Hyper::Deaths > 0)
	{
		HUD::AddText(hudDeaths, "<B4,2:HyperHUD_deaths.bmp><f2>");	// Show our Deaths icon.

		if ($Hyper::Deaths < 10)
			HUD::AddText(hudDeaths, " ");		// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudDeaths, $Hyper::Deaths);	// If we have some deaths, let's show them.
	}
	else
		HUD::AddText(hudDeaths, "<B4,2:HyperHUD_nodeaths.bmp>");	// Show our Deaths icon.

	if ($HyperPref::ShowTD)
	{
		if ($HyperStat::TotalDeaths > 0)
			HUD::AddText(hudDeaths, "\n\n<B0,0:HyperHUD_totdeaths.bmp><f1>" @ Hyper::CenterPrint($HyperStat::TotalDeaths, 5));
		else
			HUD::AddText(hudDeaths, "\n\n<B0,0:HyperHUD_nototdeaths.bmp>");
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdateMinesHUD
//
//  Purpose: Update how many mines we have.  This HUD will have a MINE icon along with how many
//	   mines we have.  If there are no mines, then the number will be left blank.
// ===============================================================================================
function Hyper::UpdateMinesHUD()
{
	%mines = getItemCount("Mine");

	if (%mines > 0)
	{
		HUD::AddText(hudMines, "<B4,2:HyperHUD_mine.bmp><f2>");	// Show our Mine icon.

		if (%mines < 10)
			HUD::AddText(hudMines, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudMines, %mines);	// If we have some mines, show them.
	}
	else
		HUD::AddText(hudMines, "<B4,2:HyperHUD_nomine.bmp>");	// Show our Mine icon.

	return 0;
}

// ===============================================================================================
//  Function: UpdateGrenadesHUD
//
//  Purpose: Update how many grenades we have.  This HUD will have a GRENADE icon along with how
//	   many grenades we have.  If there are no mines, then the number will be left blank.
// ===============================================================================================
function Hyper::UpdateGrenadesHUD()
{
	%grenades = getItemCount("Grenade");

	if (%grenades > 0)
	{
		HUD::AddText(hudGrenades, "<B4,2:HyperHUD_grenade.bmp><f2>");	// Show our Grenade icon.

		if (%grenades < 10)
			HUD::AddText(hudGrenades, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudGrenades, %grenades);		// If we have some grenades, show them.
	}
	else
		HUD::AddText(hudGrenades, "<B4,2:HyperHUD_nogrenade.bmp>");	// Show our Grenade icon.

	return 0;
}

// ===============================================================================================
//  Function: UpdateRepairHUD
//
//  Purpose: Update inventory of a repair kit and beacons.  This HUD will show a REPAIR icon if
//	   you currently have a repair kit.  A BEACON icon will be shown if you have a beacon.
//	   If you do not have the item, then the HUD will be blank.
// ===============================================================================================
function Hyper::UpdateRepairHUD()
{
	if (getItemCount("Repair Kit") > 0)
	{
		HUD::AddText(hudRepair, "<B14,2:HyperHUD_repair.bmp>");
	}
	else
	{
		HUD::AddText(hudRepair, "<B14,2:HyperHUD_norepair.bmp>");
	}

	return 0;
}

function Hyper::UpdateBeaconHUD()
{
	%beacons = getItemCount("Beacon");

	if (%beacons > 0)
	{
		HUD::AddText(hudBeacon, "<B4,2:HyperHUD_beacon.bmp><f2>");	// Show our Grenade icon.

		if (%beacons < 10)
			HUD::AddText(hudBeacon, " ");	// Put the amount over one space if less than 10 for a nicer appearance.

		HUD::AddText(hudBeacon, %beacons);		// If we have some grenades, show them.
	}
	else
		HUD::AddText(hudBeacon, "<B4,2:HyperHUD_nobeacon.bmp>");	// Show our Grenade icon.

	return 0;
}

// DO NOT MODIFY THESE THREE LINES!!!
// They are used in the UpdatePlayersHUD function below for team unbalance notification.
$Hyper::comSay[0] = "color2";	// Yell Shazbot!
$Hyper::comSay[1] = "color6";	// Yell Dammit!
$Hyper::comSay[2] = "color7";	// Yell Ahhh crap!

// ===============================================================================================
//  Function: UpdatePlayersHUD
//
//  Purpose: Check how many players are on each team.  In the center of the HUD, you will see an
//	   icon with a green arrow on the left and a red arrow on the right.  The number of
//	   players on your team will appear on the left (green arrow pointing to your team) and
//	   the enemy player count will appear on the right (red arrow pointing to enemy team).
//	   If there are no players on a team, then it will be left blank.  Also added a team
//	   unbalance notification routine.  Everyone will be sent the phrase "Teams are
//	   unbalanced!!!" when a team is outnumbered along with a random colorful verbal remark.
//	   Also, upon switching to observer mode, the number of currect observers will be shown
//	   to the left of the green arrow and the number of ACTIVE players will be shown to the
//	   right of the red arrow.
// ===============================================================================================
function Hyper::UpdatePlayersHUD()
{
	%clientteam = Client::getTeam(getManagerId());	// Find out which team you are on.

	for (%i = -1; %i < 4; %i++)
		%players[%i] = 0;

	for (%i = $Hyper::LastClient; %i > 2048; %i--)	// Check all valid players up to the last known client.
	{
		%team = Client::getTeam(%i);		// Find out which team this player is on.

		if (Client::getName(%i) != "")	// Is it a valid player?
		{
			%players[%team]++;	// Increment our player count for each team.
		}
	}

	if (%clientteam >= 0)
	{
		%teamplayers = %players[%clientteam];
		%enemyplayers = %players[1 - %clientteam];
	}
	else
	{
		%teamplayers = %players[0];
		%enemyplayers = %players[1];
	}

	if ((%teamplayers < 10) || ((%teamplayers < 20) && (%enemyplayers < 20)))	// Alphanumeric characters are not fixed-width.  So let's add a
	{
		HUD::AddText(hudPlayers, " ");				// space if the number is small to try and center the display.

		if (%enemyplayers == 0)
			HUD::AddText(hudPlayers, " ");
	}

	HUD::AddText(hudPlayers, "<f2>" @ %teamplayers);	// Display our team count and the icon in the HUD.

	if (%clientteam >= 0)
		HUD::AddText(hudPlayers, "<BHyperHUD_players.bmp>");
	else
		HUD::AddText(hudPlayers, "<BHyperHUD_noteam.bmp>");

	if (%enemyplayers > 0)
		HUD::AddText(hudPlayers, %enemyplayers);	// Display the enemy count.  If none, then leave it blank.

	if ($HyperPref::BalanceNotify)	// Do you want to notify everyone when there is team unbalance?
	{
		%balance = %teamplayers - %enemyplayers;	// Determine by how many players teams are unbalanced.

		if ((%balance != 0) && (%clientteam > -1))
		{
			if (%balance < 0)
				%balance = -(%balance);	// If it is a negative number, let's make it positive.

			if ((%balance >= $HyperPref::Outnumber) && ($Hyper::BalanceToggle == 0) &&
			    ($Hyper::LastMsg != "Teams are unbalanced!!!") &&
			    ($Hyper::Next2LastMsg != "Teams are unbalanced!!!"))
			{
				remoteEval(2048, say, 0, "Teams are unbalanced!!!~w" @ $Hyper::comSay[floor(getRandom() * 3)]);	// Tell everyone about team unbalance and yell a random remark.
				$Hyper::BalanceToggle = 1;	// Toggle our team balance variable so we don't say this repeatedly.
			}
			else if (%balance < 3)
				$Hyper::BalanceToggle = 0;	// If team unbalance drops below three, then reset our variable, so we can say it the next time there is team unbalance.
		}
	}

	if ($HyperPref::ShowObserver)
	{
		if (%players[-1] > 0)
			HUD::AddText(hudPlayers, "\n\n<B0,-3:HyperHUD_observer.bmp><f1>" @ Hyper::CenterPrint(%players[-1], 4));
		else
			HUD::AddText(hudPlayers, "\n\n<B0,-3:HyperHUD_noobserver.bmp>");
	}

	return 0;
}

// ===============================================================================================
//  Function: UpdatePlayTimeHUD
//
//  Purpose: Update how long you have been playing online so far for this session.  
// ===============================================================================================
function Hyper::UpdatePlayTimeHUD()
{
	%time = "";
	if ($Hyper::TimeHour > 0)
		%time = $Hyper::TimeHour;
	%time = %time @ ":";
	if ($Hyper::TimeMin < 10)
		%time = %time @ "0";
	%time = %time @ $Hyper::TimeMin;
	HUD::AddText(hudPlayTime, "<f2>" @ Hyper::CenterPrint(%time, 8));

	if ($HyperPref::ShowTT)
	{
		HUD::AddText(hudPlayTime, "<f1>\n");
		%time = "";
		if ($Hyper::StatDay > 0)
		{
			%time = $Hyper::StatDay @ " D";
			HUD::AddText(hudPlayTime, Hyper::CenterPrint(%time, 8));
		}
		HUD::AddText(hudPlayTime, "\n");
		%time = "";
		if ($Hyper::StatHour > 0)
			%time = $Hyper::StatHour;
		%time = %time @ ":";
		if ($Hyper::StatMin < 10)
			%time = %time @ "0";
		%time = %time @ $Hyper::StatMin;
		HUD::AddText(hudPlayTime, Hyper::CenterPrint(%time, 8));
	}

	return 0;
}

function Hyper::UpdatePackHUD()
{
	HUD::AddText(hudPack, "<B0,2:HyperHUD_pack.bmp> " @ $Inv::Name[getMountedItem(1)] @ "<jr><B7,2:HyperHUD_pack.bmp>");

	return 0;
}

function Hyper::UpdateBackpack()
{
	%pack = getMountedItem(1);
	%item = $Inv::Name[%pack];

	if ((%pack != -1) && (%item != ""))
	{
		if ($Hyper::NewPackPos != "")
		{
			%x = getWord($Hyper::NewPackPos, 0);
			%y = getWord($Hyper::NewPackPos, 1);
		}
		else
		{
			%x = getWord($HyperPref::PackPos, 0);
			%y = getWord($HyperPref::PackPos, 1);
		}

		HUD::Move(hudPack, %x, %y, String::pixels(%item) + 67, 20);

		if (!(HUD::GetDisplayed(hudPack)))
			HUD::Display(hudPack);
		HUD::Update(hudPack);
	}
	else if (HUD::GetDisplayed(hudPack))
		HUD::Display(hudPack, false);
}

// ===============================================================================================
//  Function: UpdateItemHUDs
//
//  Purpose: Here we update our mines, grenades and repair kit/beacon HUDs when certain events
//	   have occurred, such as throwing of an item or the use of an item.
// ===============================================================================================
function Hyper::UpdateItemHUDs()
{
	if ($Hyper::ItemToggle == 0)
	{
		schedule("Hyper::UpdateItemHUDs();", 1);	// Update our HUDs in one second if an event has
		$Hyper::ItemToggle++;			// occurred.  This allows time for the inventory

		return;					// count to catch up after event has ended.
	}

	if (Hyper::CheckGenHUDs("Mines"))
		HUD::Update(hudMines);	// Update our mines HUD.
	if (Hyper::CheckGenHUDs("Grenades"))
		HUD::Update(hudGrenades);	// Update our grenades HUD.
	if (Hyper::CheckGenHUDs("Repair"))
		HUD::Update(hudRepair);	// Update our repair kit HUD.
	if (Hyper::CheckGenHUDs("Beacon"))
		HUD::Update(hudBeacon);	// Update our beacon HUD.

	if ($HyperPref::ShowPack && ($Hyper::Mode != ""))
		Hyper::UpdateBackpack();

	$Hyper::ItemToggle = 0;		// Reset our timer toggle.
}

// ===============================================================================================
//  Function: UpdateCTF
//
//  Purpose: Update our flag status HUDs from this one function instead of having to monitor two
//	   separate flag events, one for our flag and one for the enemy's.
// ===============================================================================================
function Hyper::UpdateCTF()
{
	if (($Hyper::Mode == "Gen") || ($Hyper::Mode == "") || ($HyperPref::GenStart))
	{
		return;
	}

	%teamFlag = Team::GetFlagLocation(Team::Friendly());	// Status of our flag.

	if ((%teamFlag == $Trak::locationHome) || (%teamFlag == $Trak::locationField) ||
	    (%teamFlag == ""))
	{
		HUD::Display(hudCTFHome, false);
		HUD::Display(hudCTFHomeSmall);
		HUD::Update(hudCTFHomeSmall);	// Upon a flag event, update our team's flag HUD.
	}
	else
	{
		HUD::Display(hudCTFHomeSmall, false);
		HUD::Display(hudCTFHome);
		HUD::Update(hudCTFHome);	// Upon a flag event, update our team's flag HUD.
	}

	if ($Hyper::Mode != "CTF")
	{
		return;
	}

	%enemyFlag = Team::GetFlagLocation(Team::Enemy());	// Status of the enemy's flag.

	if ((%enemyFlag == $Trak::locationHome) || (%enemyFlag == $Trak::locationField) ||
	    (%enemyFlag == ""))
	{
		HUD::Display(hudCTFEnemy, false);
		HUD::Display(hudCTFEnemySmall);
		HUD::Update(hudCTFEnemySmall);	// Upon a flag event, update our team's flag HUD.
	}
	else
	{
		HUD::Display(hudCTFEnemySmall, false);
		HUD::Display(hudCTFEnemy);
		HUD::Update(hudCTFEnemy);	// Upon a flag event, update our team's flag HUD.
	}

}

// ===============================================================================================
//  Function: UpdatePlayers
//
//  Purpose: Update our team player count HUD using a short delay.
// ===============================================================================================
function Hyper::UpdatePlayers()
{
	if ($Hyper::PlayerToggle == 0)
	{
		schedule("Hyper::UpdatePlayers();", 1);		// Update our player HUD in one second if someone has
		$Hyper::PlayerToggle++;			// joined or dropped.  This allows time for the player
		return;					// count to catch up after event has ended.
	}

	HUD::Update(hudPlayers);	// Update the HUD.

	$Hyper::PlayerToggle = 0;	// Reset our timer toggle.
}

// ===============================================================================================
//  Function: UpdateMinutes
//
//  Purpose: Increment our minutes counter every 60 seconds, then update our play time HUD.
// ===============================================================================================
function Hyper::UpdateMinutes()
{
	schedule("Hyper::UpdateMinutes();", 60);	// Call back in a minute.

	$Hyper::TimeMin++;				// Increment our minutes counter.
	$Hyper::StatMin++;

	if ($Hyper::TimeMin > 59)			// Are our minutes over an hour?
	{
		$Hyper::TimeMin = 0;		// If so, reset our minutes and
		$Hyper::TimeHour++;			// increment our hour counter.
	}

	if ($Hyper::TimeHour > 23)
	{
		$Hyper::TimeHour = 0;
		$Hyper::TimeDay++;
	}

	if ($Hyper::StatMin > 59)
	{
		$Hyper::StatMin = 0;
		$Hyper::StatHour++;
	}

	if ($Hyper::StatHour > 23)
	{
		$Hyper::StatHour = 0;
		$Hyper::StatDay++;
	}

	HUD::Update(hudPlayTime);			// Update our play time HUD.
}

function Hyper::ProcessTotalTime()
{
	if ($Hyper::StatDay < 0)
		$Hyper::StatDay = 0;
	if ($Hyper::StatHour < 0)
		$Hyper::StatHour = 0;
	if ($Hyper::StatMin < 0)
		$Hyper::StatMin = 0;
	$HyperStat::TotalTime = $Hyper::StatDay @ " " @ $Hyper::StatHour @ " " @ $Hyper::StatMin;

	Hyper::UpdateStats("normal");
}

function Hyper::GetHUDInfo(%hudtype, %retrieve)
{
	if (%retrieve == "label")
		%return = "hud" @ %hudtype;
	else if (%retrieve == "func")
		%return = "Hyper::Update" @ %hudtype @ "HUD";
	else
		%return = "";

	return %return;
}

// ===============================================================================================
//  Function: MakeNewHUDs
//
//  Purpose: This is where we initially create our various HUDs.  This function is only called
//	   once during a server connection.  Depending on your selected preferences, the flag
//	   status HUDs and general HUDs will be created.
// ===============================================================================================
function Hyper::MakeNewHUDs(%make, %type, %newx, %newy)
{
	%ScreenDim = Presto::ScreenSize();
	%ScreenWidth = getWord(%ScreenDim, 0);
	%ScreenHeight = getWord(%ScreenDim, 1);

	if ((%type == "pack") && !make)
	{
		HUD::Move(hudPack, %newx, %newy, HUD::Width(hudPack), 20);
		return;
	}
	else if (($HyperPref::ShowPack) && !(HUD::Exists(hudPack)) && %make)
	{
		HUD::New(hudPack, Hyper::UpdatePackHUD, getWord($HyperPref::PackPos, 0), getWord($HyperPref::PackPos, 1), "25%", 20);
	}

	if (%make)
	{
		%FlagXPos = getWord($HyperPref::FlagPos, 0);	// By default, flag status HUDs are placed on the left side of the screen.
		%FlagYPos = getWord($HyperPref::FlagPos, 1);	// Initialize how far down we want them displayed from the top of the screen.
	}
	else if (%type == "ctf")
	{
		%FlagXPos = %newx;
		%FlagYPos = %newy;
	}

	$Hyper::FlagXPos = %FlagXPos;
	$Hyper::FlagYPos = %FlagYPos;

	if (($HyperPref::FlagHUDLoc == "top") && (%FlagXPos == "50%"))
		%FlagXPos = floor((%ScreenWidth - 250) / 2);

	if (%make && !(HUD::Exists(hudCTFHome)))
	{
		HUD::New(hudCTFHome, Hyper::UpdateHomeHUD, %FlagXPos, %FlagYPos, 125, 57);						// Our flag HUD.
	}
	else if (%type == "ctf")
	{
		HUD::Move(hudCTFHome, %FlagXPos, %FlagYPos, 125, 57);						// Our flag HUD.
	}

	if (($HyperPref::FlagHUDLoc == "right") || ($HyperPref::FlagHUDLoc == "top"))
		%FlagXPos = "right(hudCTFHome)-56";

	if (%make && !HUD::Exists(hudCTFHomeSmall))
	{
		HUD::New(hudCTFHomeSmall, Hyper::UpdateHomeHUD, %FlagXPos, %FlagYPos, 56, 57);						// Our small flag HUD.
	}
	else if (%type == "ctf")
	{
		HUD::Move(hudCTFHomeSmall, %FlagXPos, %FlagYPos, 56, 57);						// Our small flag HUD.
	}

	%FlagXPos = "left(hudCTFHome)";
	%FlagYPos = "bottom(hudCTFHome)";

	if (($HyperPref::FlagHUDLoc == "top") || ($HyperPref::FlagHUDLoc == "bottom"))
	{
		%FlagYPos = getWord(HUD::GetPosition(hudCTFHome), 1);
		if ($HyperPref::FlagHUDLoc == "top")
			%FlagXPos = "right(hudCTFHome)-1";
		else if ($HyperPref::FlagHUDLoc == "bottom")
			%FlagXPos = "100%";
	}

	if (%make && !HUD::Exists(hudCTFEnemy))
	{
		HUD::New(hudCTFEnemy, Hyper::UpdateEnemyHUD, %FlagXPos, %FlagYPos, 125, 57);		// Enemy flag HUD.
	}
	else  if (%type == "ctf")
	{
		HUD::Move(hudCTFEnemy, %FlagXPos, %FlagYPos, 125, 57);		// Enemy flag HUD.
	}

	if ($HyperPref::FlagHUDLoc == "right")
		%FlagXPos = "right(hudCTFEnemy)-56";

	if (%make && !HUD::Exists(hudCTFEnemySmall))
	{
		HUD::New(hudCTFEnemySmall, Hyper::UpdateEnemyHUD, %FlagXPos, %FlagYPos, 56, 57);	// Small enemy flag HUD.
	}
	else  if (%type == "ctf")
	{
		HUD::Move(hudCTFEnemySmall, %FlagXPos, %FlagYPos, 56, 57);	// Small enemy flag HUD.
	}

	if ((!make && (%type == "ctf")) || ($HyperPref::NumGenHUDs == 0))
	{
		return;
	}

	if (%make)
	{
		%GenXPos = getWord($HyperPref::GenPos, 0);	// By default, our general HUDs are placed on the right side of the screen.
		%GenYPos = getWord($HyperPref::GenPos, 1);	// Initialize our general HUD position from top of screen.
	}
	else if (%type == "gen")
	{
		%GenXPos = %newx;
		%GenYPos = %newy;
	}

	$Hyper::GenXPos = %GenXPos;
	$Hyper::GenYPos = %GenYPos;

	if ((($HyperPref::GenHUDLoc == "top") || ($HyperPref::GenHUDLoc == "bottom")) &&	// Or are they to be centered?
	    (%GenXPos == "50%"))
		if ($HyperPref::NumGenHUDs < $HyperPref::HUDsPerLine)
			%GenXPos = floor((%ScreenWidth - ($HyperPref::NumGenHUDs * 60)) / 2);	// Calculate the center starting point.
		else
			%GenXPos = floor((%ScreenWidth - ($HyperPref::HUDsPerLine * 60)) / 2);

	if (($HyperPref::GenHUDLoc == "bottom") && (%GenYPos == "100%"))	// Are they to be displayed at the bottom of the screen?
	{
		%i = $HyperPref::NumGenHUDs / $HyperPref::HUDsPerLine;
		%j = floor(%i);

		if (%i > %j)
			%j++;

		if ($HyperPref::ShowTC || $HyperPref::ShowTK || $HyperPref::ShowTD || $HyperPref::ShowTT || $HyperPref::ShowObserver)
			%mul = 41;
		else
			%mul = 21;

		%GenYPos = %ScreenHeight - (%j * %mul) - 3;
	}

	%mulcnt = 1;
	if (!$Hyper::ItemUse)
		$Hyper::ItemUse = false;
	%bigheight = 0;
	%owner = 0;

	for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
	{
		%h = eval("HUD::Height(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");");

		if (%h > %bigheight)
		{
			%bigheight = %h;
			%owner = %i;
		}
		if ((%i == ($HyperPref::HUDsPerLine * %mulcnt)) && ($HyperPref::GenHUDLoc != "left") && ($HyperPref::GenHUDLoc != "right"))
		{
			%GenYPos = "bottom(" @ Hyper::GetHUDInfo($HyperPref::Gen[%owner], "label") @ ")";
			%GenXPos = "left(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ")";
			%mulcnt++;
			%owner = 0;
			%bigheight = 0;
		}

		if ((($HyperPref::Gen[%i] == "Caps") && ($HyperPref::ShowTC)) ||
		    (($HyperPref::Gen[%i] == "Kills") && ($HyperPref::ShowTK)) ||
		    (($HyperPref::Gen[%i] == "Deaths") && ($HyperPref::ShowTD)) ||
		    (($HyperPref::Gen[%i] == "Players") && ($HyperPref::ShowObserver)) ||
		    (($HyperPref::Gen[%i] == "PlayTime") && ($HyperPref::ShowTT)))
			%hudheight = 42;
		else
			%hudheight = 21;

		if (%make && !(eval("HUD::Exists(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");")))
		{
			eval("HUD::New(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", " @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "func") @ ", %GenXPos, %GenYPos, 60, %hudheight);");	// Create a HUD.
		}
		else if (%type == "gen")
		{
			eval("HUD::Move(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", %GenXPos, %GenYPos, 60, %hudheight);");	// Create a HUD.
		}

		if (!$Hyper::ItemUse)
			if ((($HyperPref::Gen[%i] == "Mines") || ($HyperPref::Gen[%i] == "Grenades") ||
			    ($HyperPref::Gen[%i] == "Repair") || ($HyperPref::Gen[%i] == "Beacon") ||
			     ($HyperPref::ShowPack)) && (%make))
				$Hyper::ItemUse = true;

		if (($HyperPref::GenHUDLoc == "left") || ($HyperPref::GenHUDLoc == "right"))
			%GenYPos = "bottom(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ")";	// Skip down for next HUD display.
		else
			%GenXPos = "right(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ")-1";	// Skip over to the right for next HUD display.
	}
}

// ===============================================================================================
//  Function: Toggle
//
//  Purpose: Since we have designed three different HUD screens, we must offer the ability to
//	   switch between them.  As a default, Control-H is our toggle switch.  NOTE:  By HUD
//	   screens, I mean we work with TRIBES' default HUD display and add to that.  The three
//	   screens are:
//
//	   1) Our first HUD screen consists of the CTF flag status HUDs for each team.  These
//	      are located on the left, right, top or bottom of the screen, depending on your
//	      preferences.  Our general HUDs are located on one of the four sides of the screen
//	      also.
//
//	   2) The second HUD screen is basically just for Multiple Team CTF.  Your team's flag
//	      status HUD and the general HUDs are displayed.
//
//	   3) Our last HUD screen is for any other type of game (i.e. Defend & Destroy,
//	      Deathmatch, etc.).  This screen will only show your general HUDs.
// ===============================================================================================
function Hyper::Toggle()
{

	if ($Hyper::HUDTypeToggle == 0)	// Setup our HUDs.  Done on first call to HyperHUD only.
	{

		$Hyper::NewFlagPos = "";
		$Hyper::NewGenPos = "";
		$Hyper::NewPackPos = "";

		Hyper::MakeNewHUDs(true);		// Call our HUD creation function.

		Hyper::MakeMenus();

		$Hyper::HUDTypeToggle++;		// Point our toggle counter to the CTF HUD screen layout.
	}

	if ($Hyper::HUDTypeToggle == 1)	// Capture the Flag HUD screen.
	{
		$Hyper::Mode = "CTF";

		Hyper::UpdateCTF();
		if ($HyperPref::ShowPack)
			Hyper::UpdateBackpack();

		Event::Attach(eventFlagsUpdated, Hyper::UpdateCTF, flagcheck);	// Update our flag Status HUDs upon a flag event.
		Event::Attach(eventClientMessage, Hyper::onClientMessage, msgcheck);	// Check if we have accessed a station for supplies, picked up an item
									// or server went through a mission change.
		for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
		{
			eval("HUD::Display(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");");

			if ($HyperPref::Gen[%i] == "Caps")
			{
				Event::Attach(eventFlagCaptured, Hyper::Capture, capflag);	// If a flag is captured, check to see if it was you.
			}
			else if (($HyperPref::Gen[%i] == "Kills") || ($HyperPref::Gen[%i] == "Deaths"))
			{
				Event::Attach(eventKillTrak, Hyper::VerifiedKill, killcheck);	// Execute our VerifiedKill function upon a kill event.
			}
			else if (($HyperPref::Gen[%i] == "Mines") || ($HyperPref::Gen[%i] == "Grenades"))
			{
				Event::Attach(eventThrowRelease, Hyper::UpdateItemHUDs, throwcheck);	// Upon the throwing of an object (grenade, mine, etc.), update our HUDs.
				Event::Attach(eventDrop, Hyper::UpdateItemHUDs, dropcheck);		// Upon dropping an object (grenade, mine, etc.), update our HUDs.
			}
			else if (($HyperPref::Gen[%i] == "Repair") || ($HyperPref::Gen[%i] == "Beacon"))
			{
				Event::Attach(eventUse, Hyper::UpdateItemHUDs, usecheck);	// Upon the use of an item (repair kit, beacon, etc.), update our
				Event::Attach(eventDrop, Hyper::UpdateItemHUDs, dropcheck);		// Upon dropping an object (grenade, mine, etc.), update our HUDs.
			}
			else if ($HyperPref::Gen[%i] == "Players")
			{
				Event::Attach(eventClientJoin, Hyper::onClientJoin, joincheck);			// Update the HUD upon a player joining a team.
				Event::Attach(eventClientDrop, Hyper::onClientDrop, dropcheck);			// Update the HUD upon a player leaving the game.
				Event::Attach(eventClientChangeTeam, Hyper::onClientChangeTeam, changecheck);	// Update the HUD upon a player switching teams.
			}
		}

		$Hyper::HUDTypeToggle++;	// Increment our toggle counter to point to Multiple Team CTF HUD next.
		if ($HyperPref::GenStart)
		{
			Hyper::Toggle();	// If user wants to start in General Gameplay HUD screen, advance our HyperHUD toggle.
		}
	}
	else if ($Hyper::HUDTypeToggle == 2)	// Multiple Team CTF HUD screen.
	{
		$Hyper::Mode = "MT";
		HUD::Display(hudCTFEnemy, false);	// Turn off enemy flag HUD.
		HUD::Display(hudCTFEnemySmall, false);
		if (Hyper::CheckGenHUDs("Caps"))
			HUD::Update(hudCaps);
		$Hyper::HUDTypeToggle++;		// Increment our toggle counter to point to the General Gameplay HUD.
		if ($HyperPref::GenStart)
		{
			Hyper::Toggle();	// If user wants to start in General Gameplay HUD screen, advance our HyperHUD toggle.
		}
	}
	else if ($Hyper::HUDTypeToggle == 3)	// General Gameplay HUD screen.
	{
		$Hyper::Mode = "Gen";
		HUD::Display(hudCTFHome, false);	// Turn off our team's flag HUD.
		HUD::Display(hudCTFHomeSmall, false);
		Event::Detach(eventFlagsUpdated, flagcheck);	// Disable flag status HUD updates on a flag event.
		if (Hyper::CheckGenHUDs("Caps"))
			HUD::Update(hudCaps);
		$Hyper::HUDTypeToggle++;	// Increment our toggle counter to point to our last choice of no HUDs at all.
	}
	else	// No HUDs at all.
	{
		$Hyper::Mode = "";

		Event::Detach(eventClientMessage, msgcheck);	// Disable event check for station access, pickups and mission changes.

		if ($HyperPref::ShowPack && HUD::GetDisplayed(hudPack))
		{
			HUD::Display(hudPack, false);
		}

		for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
		{

			eval("HUD::Display(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ", false);");

			if ($HyperPref::Gen[%i] == "Caps")
			{
				if (Event::Exists(eventFlagCaptured))
				{
					Event::Detach(eventFlagCaptured, capflag);	// Disable detection for the flag capture HUD.
				}
			}
			else if (($HyperPref::Gen[%i] == "Kills") || ($HyperPref::Gen[%i] == "Deaths"))
			{
				if (Event::Exists(eventKillTrak))
				{
					Event::Detach(eventKillTrak, killcheck);	// Disable our VerifiedKill function upon a kill event.
				}
			}
			else if (($HyperPref::Gen[%i] == "Mines") || ($HyperPref::Gen[%i] == "Grenades"))
			{
				if (Event::Exists(eventThrowRelease))
				{
					Event::Detach(eventThrowRelease, throwcheck);	// Disable checking of the throwing of an object.
				}
			}
			else if (($HyperPref::Gen[%i] == "Repair") || ($HyperPref::Gen[%i] == "Beacon"))
			{
				if (Event::Exists(eventUse))
				{
					Event::Detach(eventUse, usecheck);	// Disable the USE event up an item's use.
				}
			}
			else if ($HyperPref::Gen[%i] == "Players")
			{
				if (Event::Exists(eventClientJoin))
				{
					Event::Detach(eventClientJoin, joincheck);		// Disable client joining event.
				}
				if (Event::Exists(eventClientDrop))
				{
					Event::Detach(eventClientDrop, dropcheck);		// Disable client dropping event.
				}
				if (Event::Exists(eventClientChangeTeam))
				{
					Event::Detach(eventClientChangeTeam, changecheck);	// Disable client changin teams event.
				}
			}
		}

		$Hyper::HUDTypeToggle = 1;	// Reset our toggle counter to point to the CTF HUD again.

		$HyperPref::GenStart = false;	// Turn off our General Gameplay screen startup preference, so we can toggle HyperHUD normally again.
	}

}

// ===============================================================================================
//  Function: ResetHUDs
//
//  Purpose: Call our update functions for each HUD.
// ===============================================================================================
function Hyper::ResetHUDs()
{
	Hyper::UpdateCTF();		// Update
	HUD::Update(hudCaps);
	HUD::Update(hudKills);	// our
	HUD::Update(hudDeaths);
	Hyper::UpdateItemHUDs();	// HUDs.
	Hyper::UpdatePlayers();
	HUD::Update(hudPlayTime);
	Hyper::UpdateBackpack();

}

$Hyper::TimeMin = -1;	// DO NOT MODIFY THIS LINE!

// ===============================================================================================
//  Function: Reset
//
//  Purpose: Reset variables and update flag HUDs.
// ===============================================================================================
function Hyper::Reset()
{
	for (%i = 0; %i < 4; %i++)
	{
		$Hyper::caps[%i] = 0;	// Reset all teams capture totals.
		$Hyper::YourCaps[%i] = 0;	// Reset your personal captures.
	}

	$Hyper::Kills = 0;		// Reset how many kills we have made.
	$Hyper::Deaths = 0;		// Reset how times we have been killed.
	$Hyper::ItemToggle = 0;	// Reset our timer toggle for use with UpdateItemHUDs.
	$Hyper::PlayerToggle = 0;	// Reset our timer toggle for use with UpdatePlayers.
	$Hyper::BlinkToggle = 0;	// Reset our flag toggle to blink enemy flag status when you have the flag.
	$Hyper::YouCapped = false;	// Reset our capture toggle.
	$Hyper::capBlink = 0;	// Reset our blink toggle for personal captures displayed in the flag capture HUD.
	$Hyper::capBlinkCnt = 0;	// Reset our blink counter.
	$Hyper::BalanceToggle = 0;	// Reset our team balance toggle.

	Hyper::ResetHUDs();		// Update our HUDs.

	if (Hyper::CheckGenHUDs("PlayTime") && ($Hyper::TimeMin < 0))
	{
		$Hyper::TimeMin = 0;

		schedule("Hyper::UpdateMinutes();", 60);	// Start our play timer in a minute.
	}
}

// ===============================================================================================
//  Function: Capture
//
//  Purpose: Keep track of which team has captured the flag along with your personal captures for
//	   the each team you are a member of during a mission.
// ===============================================================================================
function Hyper::Capture(%team, %client)
{
	%whichteam = Client::getTeam(%client);

	$Hyper::caps[%whichteam]++;			// Increment the team that captured the flag counter.

	if (%client == getManagerId())		// Did you capture?
	{
		$Hyper::YourCaps[%whichteam]++;	// Increment your capture total.
		$HyperStat::TotalCaps++;

		Hyper::UpdateStats("normal");

		if (($Hyper::Mode == "CTF") || ($Hyper::Mode == "Gen"))
			$Hyper::YouCapped = true;	// If in CTF mode, blink our flag capture HUD.
	}

	HUD::Update(hudCaps);			// Update our flag capture HUD.
}

// ===============================================================================================
//  Function: VerifiedKill
//
//  Purpose: Determine if we have killed someone or if we have been killed.
// ===============================================================================================
function Hyper::VerifiedKill(%killer, %victim, %weapon)
{
	%me = getManagerId();	// Get our client ID.

	if (%victim == %me)	// I've been killed. :(
	{
		if ($HyperPref::ShowKiller)
		{
			if (%killer != %victim)
			{
                        schedule::Add("THGoAway();",0);                  //SIX
				Client::centerPrint("<jc><f1>You died!\n<f0>Killed by: <f2>" @ Client::getName(%killer) @"\n <f0>Weapon: <f2>" @ %weapon, 1); 
      	    		schedule("Client::centerPrint(\"\", 1);", 5);

			}
		}

		$Hyper::Deaths++;		// Increment our deaths counter.
		$HyperStat::TotalDeaths++;
		Hyper::UpdateStats("normal");
		HUD::Update(hudDeaths);	// Update our Deaths HUD.
		for (%i = 1; %i < 7; %i++)				// If we die, update our item HUDs every five seconds for 30 seconds.
			schedule("Hyper::UpdateItemHUDs();", 5 * %i);	// If you respawn after that, HUDs won't be updated correctly and you
								// will still be shown item count from before death.  Remember, the
								// item count is not reset until you respawn alive.
	}
	else if (%killer == %me)	// I've killed someone. :)
	{
		if ($HyperPref::ShowVictim)
		{
                  schedule::Add("THGoAway();",0);                  //SIX
			Client::centerPrint("<jc><f1>Kill Added\n<f0>Killed: <f2>" @ Client::getName(%victim) @"\n <f0>Weapon: <f2>" @ %weapon, 1); 
		    	schedule("Client::centerPrint(\"\", 1);", 5);
		}

		$Hyper::Kills++;		// Increment our kills counter.
		$HyperStat::TotalKills++;
		Hyper::UpdateStats("normal");
		HUD::Update(hudKills);	// Update our Kills HUD.
	}

}

// ===============================================================================================
//  Function: onClientMessage
//
//  Purpose: Determine if we have accessed a station for supplies, picked up an item, went through
//	   a server mission change.  If so, we will update our HUDs.
// ===============================================================================================
function Hyper::onClientMessage(%client, %msg)
{
	$Hyper::Next2LastMsg = $Hyper::LastMsg;
	$Hyper::LastMsg = %msg;

	if (%client != 0)
	{
		return;
	}

	if ($Hyper::ItemUse)
		if ((%msg == "Station Access Off") || (%msg == "Resupply Complete") ||
		    (String::starts(%msg, "You received")) || (%msg == "Match started."))
			Hyper::UpdateItemHUDs();	// Update our mines, grenades and repair kit/beacon HUDs.  NOTE: If you use an ammo
						// station, you must wait until "Resupply Complete", otherwise the HUDs will not be
						// updated correctly.

	if (%msg == "Match started.")
		Hyper::UpdateCTF();

}

// ===============================================================================================
//  Function: onClientJoin
//
//  Purpose: Update our team player count HUD when someone joins.
// ===============================================================================================
function Hyper::onClientJoin(%client)
{
	if (%client > $Hyper::LastClient)	// If the new client that joined is greater than our last known client,
		$Hyper::LastClient = %client;	// then set our last known client equal to the newly joined client.

	Hyper::UpdatePlayers();		// Update the team player count HUD.

	if (%client == getManagerId())
	{
		Hyper::UpdateItemHUDs();	// Update our item HUDs.
	}
}

// ===============================================================================================
//  Function: onClientDrop
//
//  Purpose: Update our team player count HUD when someone drops.
// ===============================================================================================
function Hyper::onClientDrop(%client)
{
	if (%client == $Hyper::LastClient)	// If our last known client dropped,
	{
		Hyper::GetLastClient();	// then find a new last known client.
	}

	Hyper::UpdatePlayers();		// Update the team player count HUD.

}

// ===============================================================================================
//  Function: onClientChangeTeam
//
//  Purpose: Update ALL HUDs if you changed teams.  Otherwise, just update the team player count
//	   HUD.
// ===============================================================================================
function Hyper::onClientChangeTeam(%client, %team)
{
	if (%client == getManagerId())	// Did you change teams?
	{
		Hyper::ResetHUDs();		// update ALL the HUDs.
	}
	else if (Hyper::CheckGenHUDs("Players"))
	{
		Hyper::UpdatePlayers();	// Otherwise, update the team player count HUD.
	}
}

// ===============================================================================================
//  Function: GetLastClient
//
//  Purpose: Determine who is the last known client currently on the server.  This helps in the
//	   scanning phase for our team player count HUD.
// ===============================================================================================
function Hyper::GetLastClient()
{
	for (%i = $Hyper::LastClient; %i > 2048; %i--)	// Check all valid players up to the last known client.
		if (Client::getName(%i) != "")	// Is it a valid player?
		{
			$Hyper::LastClient = %i;	// If so, this is our new last known client.
			return;
		}

	if ($Hyper::LastClient == 2176)
		schedule("Hyper::GetLastClient();", 3);	// Execute GetLastClient until we find the last known client.
}

// ===============================================================================================
//  Function: FindClient
//
//  Purpose: Simple function to initialize our last known client variable and to call the function
//	   for determining the last known client.  This is the function to be called upon on a
//	   accepted server connection.
// ===============================================================================================
function Hyper::FindClient()
{
	$Hyper::LastClient = 2176;	// Initialize our last client to the 128th player (2048 + 128).

	Hyper::GetLastClient();	// Find the last known client.
}

// ===============================================================================================
//  Function: CheckGenHUDs
//
//  Purpose: Check to see if our preference (%pref) is turned on according to the user.  Return
//	   "true" if it is, otherwise return "false".
// ===============================================================================================
function Hyper::CheckGenHUDs(%pref)
{
	%result = false;

	for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
		if ($HyperPref::Gen[%i] == %pref)
		{
			%result = true;
			$Hyper::index = %i;
			%i = $Hyper::c;
		}

	return %result;
}

function Hyper::GetMode(%value)
{
	if (%value)
		%return = "ON";
	else
		%return = "OFF";

	return %return;
}

function Hyper::ProcessMenu(%type, %value, %choice, %txt)
{
	%ScreenDim = Presto::ScreenSize();
	%ScreenWidth = getWord(%ScreenDim, 0);
	%ScreenHeight = getWord(%ScreenDim, 1);

	if (%value == "exit")
	{
		if ((%type == "ctfloc") || (%type == "ctfxy"))
		{
			$HyperPref::FlagPos = $Hyper::NewFlagPos;
			$Hyper::NewFlagPos = "";
		}
		else if ((%type == "genloc") || (%type == "genxy"))
		{
			$HyperPref::GenPos = $Hyper::NewGenPos;
			$Hyper::NewGenPos = "";
		}
		else if (%type == "pack")
		{
			$HyperPref::PackPos = $Hyper::NewPackPos;
			$Hyper::NewPackPos = "";
		}

		Hyper::UpdatePrefs("normal", $SixPref::HUDConfig, $SixVar::Res);

		return;
	}
	else if (%type == "ctfxy")
	{
		if (getWord(%value, 0) == "x")
			%FlagXPos = getWord(%value, 1);
		else if (getWord(%value, 0) == "y")
			%FlagYPos = getWord(%value, 1);
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("flagloc");
			%FlagXPos = getWord($HyperPref::FlagPos, 0);
			%FlagYPos = getWord($HyperPref::FlagPos, 1);
		}
		else
		{
			return;
		}

		if (%value != "default")
		{
			%HUD1x = HUD::GetCoordValue(hudCTFHome, 0);
			%HUD1y = HUD::GetCoordValue(hudCTFHome, 1);
			%HUD2x = HUD::GetCoordValue(hudCTFEnemy, 0);
			%HUD2y = HUD::GetCoordValue(hudCTFEnemy, 1);

			if (((%FlagXPos + %HUD1x) < 0) || ((%FlagXPos + %HUD2x) > (%ScreenWidth - HUD::Width(hudCTFEnemy))))
				%FlagXPos = 0;

			%FlagXPos += %HUD1x;

			if (((%FlagYPos + %HUD1y) < 0) || ((%FlagYPos + %HUD2y) > (%ScreenHeight - HUD::Height(hudCTFEnemy))))
				%FlagYPos = 0;

			%FlagYPos += %HUD1y;
		}

		$Hyper::NewFlagPos = %FlagXPos @ " " @ %FlagYPos;

		Hyper::MakeNewHUDs(false, "ctf", %FlagXPos, %FlagYPos);
		Menu::SetTitle(menuHHCTFxy, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
		Menu::Display(menuHHCTFxy);
	}
	else if (%type == "ctfloc")
	{
		$HyperPref::FlagHUDLoc = %value;

		if (%value == "left")
		{
			%FlagXPos = 0;
			%FlagYPos = "25%";
		}
		else if (%value == "right")
		{
			%FlagXPos = "100%";
			%FlagYPos = "25%";
		}
		else if (%value == "top")
		{
			%FlagXPos = "50%";
			%FlagYPos = "0";
		}
		else if (%value == "bottom")
		{
			%FlagXPos = "0";
			%FlagYPos = "100%";
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("flagloc");
			%FlagXPos = getWord($HyperPref::FlagPos, 0);
			%FlagYPos = getWord($HyperPref::FlagPos, 1);
		}
		else
		{
			return;
		}
		$Hyper::NewFlagPos = %FlagXPos @ " " @ %FlagYPos;

		Hyper::MakeNewHUDs(false, "ctf", %FlagXPos, %FlagYPos);
		Menu::SetTitle(menuHHCTFLoc, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
		Menu::Display(menuHHCTFLoc);
	}
	else if (%type == "genxy")
	{
		if (getWord(%value, 0) == "x")
			%GenXPos = getWord(%value, 1);
		else if (getWord(%value, 0) == "y")
			%GenYPos = getWord(%value, 1);
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("genloc");
			%GenXPos = getWord($HyperPref::GenPos, 0);
			%GenYPos = getWord($HyperPref::GenPos, 1);
		}
		else
		{
			return;
		}

		if (%value != "default")
		{
			%HUD1x = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 0);");
			%HUD1y = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[0], "label") @ ", 1);");
			if ($HyperPref::NumGenHUDs < $HyperPref::HUDsPerLine)
				%HUD2x = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::NumGenHUDs - 1], "label") @ ", 0);");
			else
				%HUD2x = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::HUDsPerLine - 1], "label") @ ", 0);");
			%HUD2y = eval("HUD::GetCoordValue(" @ Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::NumGenHUDs - 1], "label") @ ", 1);");

			if (((%GenXPos + %HUD1x) < 0) || ((%GenXPos + %HUD2x) > (%ScreenWidth - HUD::Width(Hyper::GetHUDInfo($HyperPref::Gen[0], "label")))))
				%GenXPos = 0;

			%GenXPos += %HUD1x;

			if (((%GenYPos + %HUD1y) < 0) || ((%GenYPos + %HUD2y) > (%ScreenHeight - HUD::Height(Hyper::GetHUDInfo($HyperPref::Gen[$HyperPref::NumGenHUDs - 1], "label")))))
				%GenYPos = 0;

			%GenYPos += %HUD1y;
		}

		$Hyper::NewGenPos = %GenXPos @ " " @ %GenYPos;

		Hyper::MakeNewHUDs(false, "gen", %GenXPos, %GenYPos);
		Menu::SetTitle(menuHHGenxy, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
		Menu::Display(menuHHGenxy);
	}
	else if (%type == "genloc")
	{
		$HyperPref::GenHUDLoc = %value;

		if (%value == "left")
		{
			%GenXPos = 0;
			%GenYPos = "25%";
		}
		else if (%value == "right")
		{
			%GenXPos = "100%";
			%GenYPos = "25%";
		}
		else if (%value == "top")
		{
			%GenXPos = "50%";
			%GenYPos = "0";
		}
		else if (%value == "bottom")
		{
			%GenXPos = "50%";
			%GenYPos = "100%";
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("genloc");
			%GenXPos = getWord($HyperPref::GenPos, 0);
			%GenYPos = getWord($HyperPref::GenPos, 1);
		}
		else
		{
			return;
		}

		$Hyper::NewGenPos = %GenXPos @ " " @ %GenYPos;

		Hyper::MakeNewHUDs(false, "gen", %GenXPos, %GenYPos);
		Menu::SetTitle(menuHHGenLoc, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
		Menu::Display(menuHHGenLoc);
	}
	else if (%type == "perline")
	{
		if ((%value == -1) || (%value == 1))
		{
			$HyperPref::HUDsPerLine += %value;
			if ($HyperPref::HUDsPerLine < 1)
				$HyperPref::HUDsPerLine = 1;
		}
		else if (%value == "default")
			Hyper::DefaultPrefs("perline");
		else
		{
			return;
		}

		if (($HyperPref::GenHUDLoc == "top") || ($HyperPref::GenHUDLoc == "bottom"))
		{
			if ($Hyper::NewGenPos != "")
			{
				%GenXPos = getWord($Hyper::NewGenPos, 0);
				%GenYPos = getWord($Hyper::NewGenPos, 1);
			}
			else
			{
				%GenXPos = getWord($HyperPref::GenPos, 0);
				%GenYPos = getWord($HyperPref::GenPos, 1);
			}
			Hyper::MakeNewHUDs(false, "gen", %GenXPos, %GenYPos);
		}
		Menu::SetTitle(menuHHPerLine, "General HUDs Per Line:  " @ $HyperPref::HUDsPerLine);
		Menu::SetText(menuHHGenCfg, 12, "dHUDs Per Line:  " @ $HyperPref::HUDsPerLine);
		Menu::Display(menuHHPerLine);
	}
	else if (%type == "gencfg")
	{
		%new = false;

		if (%value == "TC")
		{
			$HyperPref::ShowTC = !$HyperPref::ShowTC;
			%tmp = $HyperPref::ShowTC;
		}
		else if (%value == "TK")
		{
			$HyperPref::ShowTK = !$HyperPref::ShowTK;
			%tmp = $HyperPref::ShowTK;
		}
		else if (%value == "TD")
		{
			$HyperPref::ShowTD = !$HyperPref::ShowTD;
			%tmp = $HyperPref::ShowTD;
		}
		else if (%value == "TT")
		{
			$HyperPref::ShowTT = !$HyperPref::ShowTT;
			%tmp = $HyperPref::ShowTT;
		}
		else if (%value == "observer")
		{
			$HyperPref::ShowObserver = !$HyperPref::ShowObserver;
			%tmp = $HyperPref::ShowObserver;
		}
		else if (%value != "default")
		{
			if (Hyper::CheckGenHUDs(%value))
			{
				eval("HUD::Display(" @ Hyper::GetHUDInfo(%value, "label") @ ", false);");
				for (%j = $Hyper::index; %j < $Hyper::c; %j++)
					$HyperPref::Gen[%j] = $HyperPref::Gen[%j + 1];
				$HyperPref::Gen[%j] = "";
				$HyperPref::NumGenHUDs--;
				$Hyper::c--;
				%tmp = Hyper::CheckGenHUDs(%value);
			}
			else
			{
				$HyperPref::Gen[$Hyper::c++] = %value;
				$HyperPref::NumGenHUDs++;
				%new = true;
				%tmp = Hyper::CheckGenHUDs(%value);
			}
		}
		else
		{
			$Hyper::c = -1;
			Hyper::DefaultPrefs("gencfg");
			Hyper::DefaultPrefs("perline");
			for (%i = 0; %i < $Hyper::GenNum; %i++)
			{
				if (%i < ($Hyper::GenNum - 1))
					%tmp = "Show " @ $Hyper::GenCfgMsg[%i] @ ":  " @ eval("Hyper::GetMode(" @ $Hyper::GenCfgVal[%i] @ ");");
				else
					%tmp = $Hyper::GenCfgMsg[%i] @ ":  " @ $HyperPref::HUDsPerLine;
				Menu::SetText(menuHHGenCfg, %i, %tmp);
			}
		}

		Hyper::MakeNewHUDs(%new, "gen", getWord($HyperPref::GenPos, 0), getWord($HyperPref::GenPos, 1));
		if (%new)
			eval("HUD::Display(" @ Hyper::GetHUDInfo(%value, "label") @ ");");
		else if (%value == "default")
			for (%i = 0; %i < $HyperPref::NumGenHUDs; %i++)
				eval("HUD::Display(" @ Hyper::GetHUDInfo($HyperPref::Gen[%i], "label") @ ");");
		Hyper::ResetHUDs();
		if (%value != "default")
			Menu::SetText(menuHHGenCfg, %choice, "Show " @ $Hyper::GenCfgMsg[%choice] @ ":  " @ Hyper::GetMode(%tmp));
		Menu::Display(menuHHGenCfg);
	}
	else if (%type == "pack")
	{
		if ($Hyper::NewPackPos != "")
		{
			%PackXPos = getWord($Hyper::NewPackPos, 0);
			%PackYPos = getWord($Hyper::NewPackPos, 1);
		}
		else
		{
			%PackXPos = getWord($HyperPref::PackPos, 0);
			%PackYPos = getWord($HyperPref::PackPos, 1);
		}

		%new = false;

		if (%value == "show")
		{
			$HyperPref::ShowPack = !$HyperPref::ShowPack;
			if (!HUD::Exists(hudPack) && $HyperPref::ShowPack)
				%new = true;
			else if (HUD::GetDisplayed(hudPack) && !$HyperPref::ShowPack)
				HUD::Display(hudPack, false);
		}
		else if (getWord(%value, 0) == "y")
		{
			%YPos = getWord(%value, 1);
			if (((%YPos + %PackYPos) < 0) || ((%YPos + %PackYPos) > (%ScreenHeight - HUD::Height(hudPack))))
				%YPos = 0;
			%PackYPos += %YPos;
		}
		else if (%value == "center")
		{
			%PackXPos = "50%";
		}
		else if (%value == "left")
		{
			%PackXPos = 0;
		}
		else if (%value == "right")
		{
			%PackXPos = "100%";
		}
		else if (%value == "top")
		{
			%PackYPos = 0;
		}
		else if (%value == "bottom")
		{
			%PackYPos = "100%";
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("pack");
			%PackXPos = getWord($HyperPref::PackPos, 0);
			%PackYPos = getWord($HyperPref::PackPos, 1);
		}
		else
		{
			return;
		}

		$Hyper::NewPackPos = %PackXPos @ " " @ %PackYPos;

		if ($HyperPref::ShowPack)
		{
			Hyper::MakeNewHUDs(%new, "pack", %PackXPos, %PackYPos);
			Hyper::UpdateBackpack();
		}
		Menu::SetText(menuHHPackCfg, 0, "Show Backpack:  " @ Hyper::GetMode($HyperPref::ShowPack));
		Menu::Display(menuHHPackCfg);
	}
	else if (%type == "outnumber")
	{
		if ((%value == -1) || (%value == 1))
		{
			$HyperPref::Outnumber += %value;
			if ($HyperPref::Outnumber < 1)
				$HyperPref::Outnumber = 1;
		}
		else if (%value == "default")
			Hyper::DefaultPrefs("outnumber");
		else
		{
			return;
		}

		Menu::SetTitle(menuHHOutnumber, "Outnumbered by:  " @ $HyperPref::Outnumber);
		Menu::SetText(menuHHMisc, 5, "Outnumbered by:  " @ $HyperPref::Outnumber);
		Menu::Display(menuHHOutnumber);
	}
	else if (%type == "misc")
	{
		if (%value == "victim")
		{
			$HyperPref::ShowVictim = !$HyperPref::ShowVictim;
			%value = $HyperPref::ShowVictim;
		}
		else if (%value == "killer")
		{
			$HyperPref::ShowKiller = !$HyperPref::ShowKiller;
			%value = $HyperPref::ShowKiller;
		}
		else if (%value == "autostart")
		{
			$HyperPref::AutoStart = !$HyperPref::AutoStart;
			%value = $HyperPref::AutoStart;
		}
		else if (%value == "genstart")
		{
			$HyperPref::GenStart = !$HyperPref::GenStart;
			%value = $HyperPref::GenStart;
		}
		else if (%value == "balance")
		{
			$HyperPref::BalanceNotify = !$HyperPref::BalanceNotify;
			%value = $HyperPref::BalanceNotify;
		}
		else if (%value == "default")
		{
			Hyper::DefaultPrefs("misc");
			$HHIndent = 0;
			Hyper::DefaultPrefs("outnumber");
			for (%i = 0; %i < $Hyper::MiscNum; %i++)
			{
				%tmp = $Hyper::MiscMsg[%i];
				if (%i < ($Hyper::MiscNum - 1))
					%tmp = %tmp @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%i] @ ");");
				else
					%tmp = %tmp @ $HyperPref::Outnumber;
				Menu::SetText(menuHHMisc, %i, %tmp);
			}
		}
		else
		{
			return;
		}

		if (%value != "default")
			Menu::SetText(menuHHMisc, %choice, $Hyper::MiscMsg[%choice] @ Hyper::GetMode(%value));
		Menu::Display(menuHHMisc);
	}
}

function Hyper::MakeMenus()
{
	Menu::New(menuHHCTFxy, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
	Menu::AddChoice(menuHHCTFxy, "1Increase x Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"x 1\");");
	Menu::AddChoice(menuHHCTFxy, "2Increase x Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"x 10\");");
	Menu::AddChoice(menuHHCTFxy, "3Decrease x Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"x -1\");");
	Menu::AddChoice(menuHHCTFxy, "4Decrease x Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"x -10\");");
	Menu::AddChoice(menuHHCTFxy, "5Increase y Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"y 1\");");
	Menu::AddChoice(menuHHCTFxy, "6Increase y Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"y 10\");");
	Menu::AddChoice(menuHHCTFxy, "7Decrease y Position 1", "Hyper::ProcessMenu(\"ctfxy\", \"y -1\");");
	Menu::AddChoice(menuHHCTFxy, "8Decrease y Position 10", "Hyper::ProcessMenu(\"ctfxy\", \"y -10\");");
	Menu::AddChoice(menuHHCTFxy, "xDEFAULTS", "Hyper::ProcessMenu(\"ctfxy\", \"default\");");
	Menu::AddChoice(menuHHCTFxy, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"ctfxy\", \"exit\");");

	Menu::New(menuHHCTFLoc, "CTF Location:  x:" @ $Hyper::FlagXPos @ " y:" @ $Hyper::FlagYPos);
	Menu::AddChoice(menuHHCTFLoc, "1Left Side of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"left\");");
	Menu::AddChoice(menuHHCTFLoc, "2Right Side of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"right\");");
	Menu::AddChoice(menuHHCTFLoc, "3Top of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"top\");");
	Menu::AddChoice(menuHHCTFLoc, "4Bottom of Screen", "Hyper::ProcessMenu(\"ctfloc\", \"bottom\");");
	Menu::AddMenu(menuHHCTFLoc, "5Move by X/Y Position", menuHHCTFxy);
	Menu::AddChoice(menuHHCTFLoc, "xDEFAULTS", "Hyper::ProcessMenu(\"ctfloc\", \"default\");");
	Menu::AddChoice(menuHHCTFLoc, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"ctfloc\", \"exit\");");

	Menu::New(menuHHGenxy, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
	Menu::AddChoice(menuHHGenxy, "1Increase x Position 1", "Hyper::ProcessMenu(\"genxy\", \"x 1\");");
	Menu::AddChoice(menuHHGenxy, "2Increase x Position 10", "Hyper::ProcessMenu(\"genxy\", \"x 10\");");
	Menu::AddChoice(menuHHGenxy, "3Decrease x Position 1", "Hyper::ProcessMenu(\"genxy\", \"x -1\");");
	Menu::AddChoice(menuHHGenxy, "4Decrease x Position 10", "Hyper::ProcessMenu(\"genxy\", \"x -10\");");
	Menu::AddChoice(menuHHGenxy, "5Increase y Position 1", "Hyper::ProcessMenu(\"genxy\", \"y 1\");");
	Menu::AddChoice(menuHHGenxy, "6Increase y Position 10", "Hyper::ProcessMenu(\"genxy\", \"y 10\");");
	Menu::AddChoice(menuHHGenxy, "7Decrease y Position 1", "Hyper::ProcessMenu(\"genxy\", \"y -1\");");
	Menu::AddChoice(menuHHGenxy, "8Decrease y Position 10", "Hyper::ProcessMenu(\"genxy\", \"y -10\");");
	Menu::AddChoice(menuHHGenxy, "xDEFAULTS", "Hyper::ProcessMenu(\"genxy\", \"default\");");
	Menu::AddChoice(menuHHGenxy, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"genxy\", \"exit\");");

	Menu::New(menuHHGenLoc, "Gen. Location:  x:" @ $Hyper::GenXPos @ " y:" @ $Hyper::GenYPos);
	Menu::AddChoice(menuHHGenLoc, "1Left Side of Screen", "Hyper::ProcessMenu(\"genloc\", \"left\");");
	Menu::AddChoice(menuHHGenLoc, "2Right Side of Screen", "Hyper::ProcessMenu(\"genloc\", \"right\");");
	Menu::AddChoice(menuHHGenLoc, "3Top of Screen", "Hyper::ProcessMenu(\"genloc\", \"top\");");
	Menu::AddChoice(menuHHGenLoc, "4Bottom of Screen", "Hyper::ProcessMenu(\"genloc\", \"bottom\");");
	Menu::AddMenu(menuHHGenLoc, "5Move by X/Y Position", menuHHGenxy);
	Menu::AddChoice(menuHHGenLoc, "xDEFAULTS", "Hyper::ProcessMenu(\"genloc\", \"default\");");
	Menu::AddChoice(menuHHGenLoc, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"genloc\", \"exit\");");

	Menu::New(menuHHPerLine, "Gen. HUDs Per Line:  " @ $HyperPref::HUDsPerLine);
	Menu::AddChoice(menuHHPerLine, "1Increase", "Hyper::ProcessMenu(\"perline\", 1);");
	Menu::AddChoice(menuHHPerLine, "2Decrease", "Hyper::ProcessMenu(\"perline\", -1);");
	Menu::AddChoice(menuHHPerLine, "xDEFAULT", "Hyper::ProcessMenu(\"perline\", \"default\");");
	Menu::AddChoice(menuHHPerLine, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"perline\", \"exit\");");

	%i = -1;

	$Hyper::GenCfgMsg[%i++] = "Flag Captures";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Caps\")";
	$Hyper::GenCfgMsg[%i++] = "Kills";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Kills\")";
	$Hyper::GenCfgMsg[%i++] = "Deaths";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Deaths\")";
	$Hyper::GenCfgMsg[%i++] = "Mines";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Mines\")";
	$Hyper::GenCfgMsg[%i++] = "Grenades";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Grenades\")";
	$Hyper::GenCfgMsg[%i++] = "Repair Kit";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Repair\")";
	$Hyper::GenCfgMsg[%i++] = "Beacons";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Beacon\")";
	$Hyper::GenCfgMsg[%i++] = "Player Count";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"Players\")";
	$Hyper::GenCfgMsg[%i++] = "Play Time";
	$Hyper::GenCfgVal[%i] = "Hyper::CheckGenHUDs(\"PlayTime\")";
	$Hyper::GenCfgMsg[%i++] = "Total Caps";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTC";
	$Hyper::GenCfgMsg[%i++] = "Total Kills";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTK";
	$Hyper::GenCfgMsg[%i++] = "Total Deaths";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTD";
	$Hyper::GenCfgMsg[%i++] = "Observers";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowObserver";
	$Hyper::GenCfgMsg[%i++] = "Total Time";
	$Hyper::GenCfgVal[%i] = "$HyperPref::ShowTT";
	$Hyper::GenCfgMsg[%i++] = "HUDs Per Line";
	$Hyper::GenCfgKey = "a b c d e f g h i j k l m n o";
	$Hyper::GenCfgType = "Caps Kills Deaths Mines Grenades Repair Beacon Players PlayTime TC TK TD observer TT";
	$Hyper::GenNum = %i + 1;

	Menu::New(menuHHGenCfg, "General HUD Config");
	for (%j = 0; %j < ($Hyper::GenNum - 1); %j++)
		Menu::AddChoice(menuHHGenCfg, getWord($Hyper::GenCfgKey, %j) @ "Show " @ $Hyper::GenCfgMsg[%j] @ ":  " @ eval("Hyper::GetMode(" @ $Hyper::GenCfgVal[%j] @ ");"), "Hyper::ProcessMenu(\"gencfg\", \"" @ getWord($Hyper::GenCfgType, %j) @ "\", " @ %j @ ");");
	Menu::AddMenu(menuHHGenCfg, getWord($Hyper::GenCfgKey, %j) @ $Hyper::GenCfgMsg[%j] @ ":  " @ $HyperPref::HUDsPerLine, menuHHPerLine);
	Menu::AddChoice(menuHHGenCfg, "xDEFAULTS", "Hyper::ProcessMenu(\"gencfg\", \"default\");");
	Menu::AddChoice(menuHHGenCfg, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"gencfg\", \"exit\");");

	Menu::New(menuHHPackCfg, "BackPack Configuration");
	Menu::AddChoice(menuHHPackCfg, "1Show Backpack:  " @ Hyper::GetMode($HyperPref::ShowPack), "Hyper::ProcessMenu(\"pack\", \"show\");");
	Menu::AddChoice(menuHHPackCfg, "2Center", "Hyper::ProcessMenu(\"pack\", \"center\");");
	Menu::AddChoice(menuHHPackCfg, "3Left Side", "Hyper::ProcessMenu(\"pack\", \"left\");");
	Menu::AddChoice(menuHHPackCfg, "4Right Side", "Hyper::ProcessMenu(\"pack\", \"right\");");
	Menu::AddChoice(menuHHPackCfg, "5Top Side", "Hyper::ProcessMenu(\"pack\", \"top\");");
	Menu::AddChoice(menuHHPackCfg, "6Bottom Side", "Hyper::ProcessMenu(\"pack\", \"bottom\");");
	Menu::AddChoice(menuHHPackCfg, "7Increase y Position 1", "Hyper::ProcessMenu(\"pack\", \"y 1\");");
	Menu::AddChoice(menuHHPackCfg, "8Increase y Position 10", "Hyper::ProcessMenu(\"pack\", \"y 10\");");
	Menu::AddChoice(menuHHPackCfg, "9Decrease y Position 1", "Hyper::ProcessMenu(\"pack\", \"y -1\");");
	Menu::AddChoice(menuHHPackCfg, "0Decrease y Position 10", "Hyper::ProcessMenu(\"pack\", \"y -10\");");
	Menu::AddChoice(menuHHPackCfg, "xDEFAULTS", "Hyper::ProcessMenu(\"pack\", \"default\");");
	Menu::AddChoice(menuHHPackCfg, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"pack\", \"exit\");");

	Menu::New(menuHHOutnumber, "Outnumbered by:  " @ $HyperPref::Outnumber);
	Menu::AddChoice(menuHHOutnumber, "1Increase", "Hyper::ProcessMenu(\"outnumber\", 1);");
	Menu::AddChoice(menuHHOutnumber, "2Decrease", "Hyper::ProcessMenu(\"outnumber\", -1);");
	Menu::AddChoice(menuHHOutnumber, "xDEFAULT", "Hyper::ProcessMenu(\"outnumber\", \"default\");");
	Menu::AddChoice(menuHHOutnumber, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"outnumber\", \"exit\");");

	%i = -1;

	$Hyper::MiscMsg[%i++] = "Show Victim:  ";
	$Hyper::MiscVal[%i] = "$HyperPref::ShowVictim";
	$Hyper::MiscMsg[%i++] = "Show Killer:  ";
	$Hyper::MiscVal[%i] = "$HyperPref::ShowKiller";
	$Hyper::MiscMsg[%i++] = "HyperHUD AutoStart:  ";
	$Hyper::MiscVal[%i] = "$HyperPref::AutoStart";
	$Hyper::MiscMsg[%i++] = "General AutoStart:  ";
	$Hyper::MiscVal[%i] = "$HyperPref::GenStart";
	$Hyper::MiscMsg[%i++] = "Team Balance Notify:  ";
	$Hyper::MiscVal[%i] = "$HyperPref::BalanceNotify";
	$Hyper::MiscMsg[%i++] = "Outnumbered by:  ";

	$Hyper::MiscNum = %i + 1;
	%i = -1;

	Menu::New(menuHHMisc, "Miscellaneous Config");
	Menu::AddChoice(menuHHMisc, "1" @ $Hyper::MiscMsg[%i++] @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%i] @ ");"), "Hyper::ProcessMenu(\"misc\", \"victim\", " @ %i @ ");");
	Menu::AddChoice(menuHHMisc, "2" @ $Hyper::MiscMsg[%i++] @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%i] @ ");"), "Hyper::ProcessMenu(\"misc\", \"killer\", " @ %i @ ");");
	Menu::AddChoice(menuHHMisc, "3" @ $Hyper::MiscMsg[%i++] @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%i] @ ");"), "Hyper::ProcessMenu(\"misc\", \"autostart\", " @ %i @ ");");
	Menu::AddChoice(menuHHMisc, "4" @ $Hyper::MiscMsg[%i++] @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%i] @ ");"), "Hyper::ProcessMenu(\"misc\", \"genstart\", " @ %i @ ");");
	Menu::AddChoice(menuHHMisc, "6" @ $Hyper::MiscMsg[%i++] @ eval("Hyper::GetMode(" @ $Hyper::MiscVal[%i] @ ");"), "Hyper::ProcessMenu(\"misc\", \"balance\", " @ %i @ ");");
	Menu::AddMenu(menuHHMisc, "7" @ $Hyper::MiscMsg[%i++] @ $HyperPref::Outnumber, menuHHOutnumber);
	Menu::AddChoice(menuHHMisc, "xDEFAULTS", "Hyper::ProcessMenu(\"misc\", \"default\");");
	Menu::AddChoice(menuHHMisc, "sSAVE PREFERENCES", "Hyper::ProcessMenu(\"misc\", \"exit\");");

	Menu::New(menuHHMain, "HyperHUD Preferences");
	Menu::AddMenu(menuHHMain, "1CTF HUD Location", menuHHCTFLoc);
	Menu::AddMenu(menuHHMain, "2General HUD Location", menuHHGenLoc);
	Menu::AddMenu(menuHHMain, "3General HUD Config", menuHHGenCfg);
	Menu::AddMenu(menuHHMain, "4Backpack HUD Config", menuHHPackCfg);
	Menu::AddMenu(menuHHMain, "5Miscellaneous Config", menuHHMisc);
	Menu::AddChoice(menuHHMain, "xEXIT", "");
}


// Below are our NEW event triggered client functions.

// ===============================================================================================
//  Function: throwRelease
//
//  Purpose: Determine if we have thrown an object.
// ===============================================================================================
function throwRelease(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		%delta = getSimTime() - $throwStartTime;
		if (%delta > 1)
			%delta = 100;
		else
			%delta = floor(%delta * 100);
		remoteEval(2048,throwItem,%type,%delta);

		Event::Trigger(eventThrowRelease, %desc);	// Added this trigger for event use.

	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

// ===============================================================================================
//  Function: use
//
//  Purpose: Determine if we have used an item.
// ===============================================================================================
function use(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		useItem(%type);
		Event::Trigger(eventUse, %desc);	// Added this trigger for event use.
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

function drop(%desc)
{
	%type = getItemType(%desc);
	if (%type != -1) {
		remoteEval(2048,dropItem,%type);
		Event::Trigger(eventDrop, %desc);	// Added this trigger for event use.
	}
	else {
		echo("Unknown item \"" @ %desc @ "\"");
	}
}

// Events
if (Hyper::CheckGenHUDs("Players"))
{
	Event::Attach(eventConnectionAccepted, Hyper::FindClient);	// Initialize and find the last known client.
}

Event::Attach(eventConnectionAccepted, Hyper::Reset);		// Execute our Reset function upon a first-time connection to a server.
Event::Attach(eventChangeMission, Hyper::Reset);			// Also execute the Reset function upon a server-side mission change.
Event::Attach(eventClientChangeTeam, Hyper::onClientChangeTeam);	// See if we have switched teams during gameplay.
Event::Attach(eventExit, Hyper::ProcessTotalTime);

if ($HyperPref::AutoStart)
	Hyper::Toggle();					// Automatically start HyperHUD according to user preference.

bindkey(play, $HyperPref::Toggle, "Hyper::Toggle();");
bindkey(play, $HyperPref::PrefToggle, "Menu::Display(menuHHMain);");
