// ---------------------------------------------------------------------------
// disc_jump.cs -- Version 1.6 -- April 9, 1999
// by Lorne Laliberte (VIS.Writer[SAB] -- writer@videon.wave.ca)
//
// This script includes material from other scripts or is based upon an
// existing script by another author.
//
// http://www.videon.wave.ca/~writer/tribes/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\extras\\disc_jump.cs", "1.6", "Lorne Laliberte", "- April 9, 1999 - disc assisted jumping - www.planetstarsiege.com/lorne/");

include("writer\\inventory_table.cs");

//    
// Based on ShieldJump by ???
// Uses Shields if available, otherwise just take it like a Myrmidon :)
//    
function DiscJump()
{     
	%OldWeapon = $Inv::Name[getMountedItem(0)]; // assumes inventory_table.cs

    if(getItemCount("Disc Launcher"))
	{ 
		  if(getItemCount("Disc"))
		  {
		  	%lagdelay = 0.06;
		  	if(getMountedItem(0) == $Inv::Disc_Launcher) 
		  	{ 
		  		%timedelay = 0;
		  	}
		  	else 
		  	{ 
		  		%timedelay = 0.5;
		  		schedule("use(\"Disc Launcher\");", 0.1);
		  	}
      
		  	// Turn on Shields if we have them
    	  	if(getMountedItem(1) == $Inv::Shield_Pack)
    	  	{	
		  		schedule("use(\"BackPack\");", 0.2 + %timedelay + %lagdelay);
		  	}
      
		  	schedule("postAction(2048, IDACTION_LOOKDOWN, 1);", 0.4 + %timedelay + %lagdelay);
		  	schedule("postAction(2048, IDACTION_MOVEUP, -0);", 0.5 + %timedelay + %lagdelay);
		  	schedule("postAction(2048, IDACTION_FIRE1, -0);", 0.6 + %timedelay + %lagdelay);
		  	schedule("postAction(2048, IDACTION_BREAK1, -0);", 0.7 + %timedelay + %lagdelay);
		  	schedule("postAction(2048, IDACTION_LOOKDOWN, -0);", 0.8 + %timedelay + %lagdelay);
			schedule("postAction(2048, IDACTION_CENTERVIEW, -0);", 0.9 + %timedelay + %lagdelay);

			// Turn off Shields if we have them
    	  	if(getMountedItem(1) == $Inv::Shield_Pack)
    		{	
    			schedule("use(\"BackPack\");", 1 + %timedelay + %lagdelay);
			}

			schedule("use(\"" @ %OldWeapon @ "\");", 1.1 + %timedelay + %lagdelay);
		}
		else
		{
			Client::centerPrint("You don't have any Disc Ammo... Jump aborted", 1); 
    		schedule("Client::centerPrint(\"\", 1);", 3);
		}
	}
	else 
	{ 
			Client::centerPrint("You don't have a Disc Launcher... Jump aborted", 1); 
			schedule("Client::centerPrint(\"\", 1);", 3);
	}
} 


// Bind to my default keys if keys.cs not used
if(!included("writer\\keys.cs"))
{
    EditActionMap("playMap.sae"); 

    // Spinfuser-assisted jumping
    bindCommand(keyboard0, make, l_shift, "x", TO, "DiscJump();");
    bindCommand(keyboard0, break, l_shift, "x", TO, "");
}