// ---------------------------------------------------------------------------
// flood.cs -- Version 1.2 -- April 9, 1999
// by Lorne Laliberte (VIS.Writer[SAB] -- writer@videon.wave.ca)
//
// This script includes material from other scripts or is based upon an
// existing script by another author.
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\flood.cs", "1.2", "Lorne Laliberte", "- April 9, 1999 - flood protection - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");


// This script is only a little different from the flood functions in Presto's
// Say.cs for a good reason: he did it right and I designed this based on his code :)


//
// Call this to test whether enough time has passed to do something
//
// Returns true if a call to Flood::Protect with the same %tag was made
// more than %duration seconds ago, or never made before at all. :)
//
function Flood::protect(%tag, %duration)
{

    %lastTime = $Flood::[%tag];
    %now = GetSimTime();

    if(%duration == "")
    {
        %duration = $Flood::duration[%tag];
    }
    else
    {
        $Flood::duration[%tag] = %duration;
        $Flood::[%tag] = %now;
    }

    return (%lastTime == "") || (%now - %lastTime >= %duration );
}

function Flood::reset()
{
    deleteVariables("$Flood::*");
}

Event::Attach(eventChangeMission, Flood::Reset);
Event::Attach(eventConnected, Flood::Reset);
