// ---------------------------------------------------------------------------
// keys.cs -- Version 1.24 -- May 25, 1999
// by Lorne Laliberte (Writer -- writer@videon.wave.ca)
//
// http://www.planetstarsiege.com/lorne/
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\keys.cs", "1.24", "Lorne Laliberte", "- May 25, 1999 - user key settings - www.planetstarsiege.com/lorne/");

function Writer::bindKeys()
{
    //-----------------------------------------------------------------------------
    // AUTO_REPAIR_KIT.CS
    if(included("writer\\auto_repair_kit.cs"))
    {
        EditActionMap("playMap.sae");

        // Toggle Auto Use Repair Kit mode
        bindCommand(keyboard0, make, shift, "home", TO, "AutoUseRepairKitToggle();");
        bindCommand(keyboard0, break, shift, "home", TO, "");

        // Repair Kit Taunt
        bindCommand(keyboard0, make, alt, "home", TO, "RepairKitTaunt();");
        bindCommand(keyboard0, break, alt, "home", TO, "");

        // Use repair kit -- if you're at an inventory station, you can hold this key down
        // to keep buying and using repair kits
        bindCommand(keyboard0, make, "home", TO, "useRepairKit::start();");
        bindCommand(keyboard0, break, "home", TO, "useRepairKit::stop();");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // CROUCH_TOGGLE.CS
    if(included("writer\\crouch_toggle.cs"))
    {
        EditActionMap("playMap.sae");

        // Toggle crouch
        bindCommand(keyboard0, make, "end", TO, "CrouchToggle();");
        bindCommand(keyboard0, break, "end", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // CUSTOM_WEAPONS.CS
    if(included("writer\\custom_weapons.cs"))
    {
        EditActionMap("playMap.sae");

        bindCommand(keyboard0, make,             "1", TO, "WeaponKey::useWeapon(1);");
        bindCommand(keyboard0, break,            "1", TO, "WeaponKey::break(1);");
        bindCommand(keyboard0, make, r_control,  "1", TO, "WeaponKey::assign(1);");
        bindCommand(keyboard0, break, r_control, "1", TO, "WeaponKey::break(1);");
        bindCommand(keyboard0, make, r_shift,    "1", TO, "WeaponKey::assignAlternate(1);");
        bindCommand(keyboard0, break, r_shift,   "1", TO, "WeaponKey::break(1);");

        bindCommand(keyboard0, make,             "2", TO, "WeaponKey::useWeapon(2);");
        bindCommand(keyboard0, break,            "2", TO, "WeaponKey::break(2);");
        bindCommand(keyboard0, make, r_control,  "2", TO, "WeaponKey::assign(2);");
        bindCommand(keyboard0, break, r_control, "2", TO, "WeaponKey::break(2);");
        bindCommand(keyboard0, make, r_shift,    "2", TO, "WeaponKey::assignAlternate(2);");
        bindCommand(keyboard0, break, r_shift,   "2", TO, "WeaponKey::break(2);");

        bindCommand(keyboard0, make,             "3", TO, "WeaponKey::useWeapon(3);");
        bindCommand(keyboard0, break,            "3", TO, "WeaponKey::break(3);");
        bindCommand(keyboard0, make, r_control,  "3", TO, "WeaponKey::assign(3);");
        bindCommand(keyboard0, break, r_control, "3", TO, "WeaponKey::break(3);");
        bindCommand(keyboard0, make, r_shift,    "3", TO, "WeaponKey::assignAlternate(3);");
        bindCommand(keyboard0, break, r_shift,   "3", TO, "WeaponKey::break(3);");

        bindCommand(keyboard0, make,             "4", TO, "WeaponKey::useWeapon(4);");
        bindCommand(keyboard0, break,            "4", TO, "WeaponKey::break(4);");
        bindCommand(keyboard0, make, r_control,  "4", TO, "WeaponKey::assign(4);");
        bindCommand(keyboard0, break, r_control, "4", TO, "WeaponKey::break(4);");
        bindCommand(keyboard0, make, r_shift,    "4", TO, "WeaponKey::assignAlternate(4);");
        bindCommand(keyboard0, break, r_shift,   "4", TO, "WeaponKey::break(4);");

        bindCommand(keyboard0, make,             "5", TO, "WeaponKey::useWeapon(5);");
        bindCommand(keyboard0, break,            "5", TO, "WeaponKey::break(5);");
        bindCommand(keyboard0, make, r_control,  "5", TO, "WeaponKey::assign(5);");
        bindCommand(keyboard0, break, r_control, "5", TO, "WeaponKey::break(5);");
        bindCommand(keyboard0, make, r_shift,    "5", TO, "WeaponKey::assignAlternate(5);");
        bindCommand(keyboard0, break, r_shift,   "5", TO, "WeaponKey::break(5);");

        bindCommand(keyboard0, make,             "6", TO, "WeaponKey::useWeapon(6);");
        bindCommand(keyboard0, break,            "6", TO, "WeaponKey::break(6);");
        bindCommand(keyboard0, make, r_control,  "6", TO, "WeaponKey::assign(6);");
        bindCommand(keyboard0, break, r_control, "6", TO, "WeaponKey::break(6);");
        bindCommand(keyboard0, make, r_shift,    "6", TO, "WeaponKey::assignAlternate(6);");
        bindCommand(keyboard0, break, r_shift,   "6", TO, "WeaponKey::break(6);");

        bindCommand(keyboard0, make,             "7", TO, "WeaponKey::useWeapon(7);");
        bindCommand(keyboard0, break,            "7", TO, "WeaponKey::break(7);");
        bindCommand(keyboard0, make, r_control,  "7", TO, "WeaponKey::assign(7);");
        bindCommand(keyboard0, break, r_control, "7", TO, "WeaponKey::break(7);");
        bindCommand(keyboard0, make, r_shift,    "7", TO, "WeaponKey::assignAlternate(7);");
        bindCommand(keyboard0, break, r_shift,   "7", TO, "WeaponKey::break(7);");

        bindCommand(keyboard0, make,             "8", TO, "WeaponKey::useWeapon(8);");
        bindCommand(keyboard0, break,            "8", TO, "WeaponKey::break(8);");
        bindCommand(keyboard0, make, r_control,  "8", TO, "WeaponKey::assign(8);");
        bindCommand(keyboard0, break, r_control, "8", TO, "WeaponKey::break(8);");
        bindCommand(keyboard0, make, r_shift,    "8", TO, "WeaponKey::assignAlternate(8);");
        bindCommand(keyboard0, break, r_shift,   "8", TO, "WeaponKey::break(8);");

        bindCommand(keyboard0, make,             "9", TO, "WeaponKey::useWeapon(9);");
        bindCommand(keyboard0, break,            "9", TO, "WeaponKey::break(9);");
        bindCommand(keyboard0, make, r_control,  "9", TO, "WeaponKey::assign(9);");
        bindCommand(keyboard0, break, r_control, "9", TO, "WeaponKey::break(9);");
        bindCommand(keyboard0, make, r_shift,    "9", TO, "WeaponKey::assignAlternate(9);");
        bindCommand(keyboard0, break, r_shift,   "9", TO, "WeaponKey::break(9);");

        bindCommand(keyboard0, make,             "0", TO, "WeaponKey::useWeapon(0);");
        bindCommand(keyboard0, break,            "0", TO, "WeaponKey::break(0);");
        bindCommand(keyboard0, make, r_control,  "0", TO, "WeaponKey::assign(0);");
        bindCommand(keyboard0, break, r_control, "0", TO, "WeaponKey::break(0);");
        bindCommand(keyboard0, make, r_shift,    "0", TO, "WeaponKey::assignAlternate(0);");
        bindCommand(keyboard0, break, r_shift,   "0", TO, "WeaponKey::break(0);");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // DISC_JUMP.CS -- NOT INCLUDED BY DEFAULT (I don't use this any more)
    if(included("writer\\disc_jump.cs"))
    {
        EditActionMap("playMap.sae");

        // Note that you may need to change this key binding to avoid conflicts
        // with the other default bindings -- I don't use this anymore in my config
        // (I disc jump manually instead)

        // Spinfuser-assisted jumping
        bindCommand(keyboard0, make, l_shift, "x", TO, "DiscJump();");
        bindCommand(keyboard0, break, l_shift, "x", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // DROP_AMMO.CS
    if(included("writer\\drop_ammo.cs"))
    {
        EditActionMap("playMap.sae");

        // Drop unnecessary ammo
        bindCommand(keyboard0, make, alt, "n", TO, "dropUnnecessaryAmmo();");
        bindCommand(keyboard0, break, alt, "n", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // FAST_FAVORITES.CS
    if(included("writer\\fast_favorites.cs"))
    {
        function FastFaves::bindKeys()
        {
            echo("binding user's keys for fast favorites");

            EditActionMap("actionMap.sae"); // note: these bindings are always active!

            // Toggle inventory screen on/off
            bindCommand(keyboard0, make, "decimal", TO, "remoteEval(2048, ToggleInventoryMode);");
            bindCommand(keyboard0, break, "decimal", TO, "");

            // Toggle assignment mode on/off
            bindCommand(keyboard0, make, alt, "numpad-", TO, "FastFaves::toggleAssignmentMode();");
            bindCommand(keyboard0, break, alt, "numpad-", TO, "");

            // Toggle auto-buying mode on/off (automatically buy selected loadout)
            bindCommand(keyboard0, make, alt, "numpad+", TO, "FastFaves::AutoBuyToggle();");
            bindCommand(keyboard0, break, alt, "numpad+", TO, "");

            // Toggle "buy extra ammo" mode on/off
            bindCommand(keyboard0, make, alt, "/", TO, "FastFaves::BuyExtraAmmoToggle();");
            bindCommand(keyboard0, break, alt, "/", TO, "");

            // Show the items that will be bought next time we access an inventory station
            bindCommand(keyboard0, make, shift, "l", TO, "FastFaves::PreloadMessage();");
            bindCommand(keyboard0, break, shift, "l", TO, "");

            // Show the current loadout
            bindCommand(keyboard0, make, control, "l", TO, "FastFaves::ShowLoadout();");
            bindCommand(keyboard0, break, control, "l", TO, "");

            // Toggle the weapons list on/off in the preload and loadout messages
            bindCommand(keyboard0, make, alt, "l", TO, "FastFaves::ShowWeaponsToggle();");
            bindCommand(keyboard0, break, alt, "l", TO, "");

            // Fast Inventory selection keys


    // I've pre-empted this call so I can use the decimal key to toggle the inventory screen on/off.
    // If you re-enable this call, make sure you remove or change the decimal key binding above.
    //
    //        FastFaves::bindKey(decimal)

            FastFaves::bindKey(numpad0);
            FastFaves::bindKey(numpad1);
            FastFaves::bindKey(numpad2);
            FastFaves::bindKey(numpad3);
            FastFaves::bindKey(numpad4);
            FastFaves::bindKey(numpad5);
            FastFaves::bindKey(numpad6);
            FastFaves::bindKey(numpad7);
            FastFaves::bindKey(numpad8);
            FastFaves::bindKey(numpad9);

            FastFaves::bindKey(control, decimal);
            FastFaves::bindKey(control, numpad0);
            FastFaves::bindKey(control, numpad1);
            FastFaves::bindKey(control, numpad2);
            FastFaves::bindKey(control, numpad3);
            FastFaves::bindKey(control, numpad4);
            FastFaves::bindKey(control, numpad5);
            FastFaves::bindKey(control, numpad6);
            FastFaves::bindKey(control, numpad7);
            FastFaves::bindKey(control, numpad8);
            FastFaves::bindKey(control, numpad9);

            FastFaves::bindKey(alt, decimal);
            FastFaves::bindKey(alt, numpad0);
            FastFaves::bindKey(alt, numpad1);
            FastFaves::bindKey(alt, numpad2);
            FastFaves::bindKey(alt, numpad3);
            FastFaves::bindKey(alt, numpad4);
            FastFaves::bindKey(alt, numpad5);
            FastFaves::bindKey(alt, numpad6);
            FastFaves::bindKey(alt, numpad7);
            FastFaves::bindKey(alt, numpad8);
            FastFaves::bindKey(alt, numpad9);

            FastFaves::bindKey(shift, decimal);
            FastFaves::bindKey(shift, numpad0);
            FastFaves::bindKey(shift, numpad1);
            FastFaves::bindKey(shift, numpad2);
            FastFaves::bindKey(shift, numpad3);
            FastFaves::bindKey(shift, numpad4);
            FastFaves::bindKey(shift, numpad5);
            FastFaves::bindKey(shift, numpad6);
            FastFaves::bindKey(shift, numpad7);
            FastFaves::bindKey(shift, numpad8);
            FastFaves::bindKey(shift, numpad9);
        }
        Event::Attach(eventFavoritesInitialized, FastFaves::bindKeys);
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // FIRE.CS
    if(included("writer\\fire.cs"))
    {
        EditActionMap("playMap.sae");

        // Set this to your fire button!
        bindCommand(mouse0, make, button0, TO, "onFireButton();");
        bindCommand(mouse0, break, button0, TO, "onFireButtonBreak();");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // FIRE_ON_MY_TARGET.CS
    if(included("writer\\fire_on_my_target.cs"))
    {
        EditActionMap("playMap.sae");

        // Toggle the automatic "Fire on my target" message
        bindCommand(keyboard0, make, alt, "9", TO, "FireOnMyTarget::Toggle();");
        bindCommand(keyboard0, break, alt, "9", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // JET.CS
    if(included("writer\\jet.cs"))
    {
        EditActionMap("playMap.sae");

        // Set this to your jet button!
        bindCommand(mouse0, make, button1, TO, "onJetButton();");
        bindCommand(mouse0, break, button1, TO, "onJetButtonBreak();");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // JUMP.CS
    if(included("writer\\jump.cs"))
    {
        EditActionMap("playMap.sae");

        // Keep jumping while a key is held down or the key is tapped
        bindCommand(keyboard0, make, "space", TO, "Jump(1);");
        bindCommand(keyboard0, break, "space", TO, "Jump(0);");

        // Toggle the "continuous jumping when the key is tapped" mode on/off
        bindCommand(keyboard0, make, control, "space", TO, "TapJumpToggle();");
        bindCommand(keyboard0, break, control, "space", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // LASER_READY.CS
    if(included("writer\\laser_ready.cs"))
    {
        EditActionMap("playMap.sae");

        // Toggle small energy bar on/off
        bindCommand(keyboard0, make, "capslock", TO, "EnergyBar::toggle();");
        bindCommand(keyboard0, break, "capslock", TO, "");

        // Cycle through energy bar positions
        bindCommand(keyboard0, make, shift, "capslock", TO, "EnergyBar::cycle();");
        bindCommand(keyboard0, break, shift, "capslock", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // LITTERBUG.CS
    if(included("writer\\litterbug.cs"))
    {
        EditActionMap("actionMap.sae");

        // Hold key down to buy and drop items for your teammates
        bindCommand(keyboard0, make, "l", TO, "Litterbug::start();");
        bindCommand(keyboard0, break, "l", TO, "Litterbug::stop();");

        // Toggle between hardcoded and dynamic delays for Litterbug
        bindCommand(keyboard0, make, control, "/", TO, "Litterbug::toggleDelay();");
        bindCommand(keyboard0, break, control, "/", TO, "");

        // Select next droppable item
        bindCommand(keyboard0, make, shift, "quote", TO, "Litterbug::next();");
        bindCommand(keyboard0, break, shift, "quote", TO, "");

        // Select previous droppable item
        bindCommand(keyboard0, make, shift, ";", TO, "Litterbug::prev();");
        bindCommand(keyboard0, break, shift, ";", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // PDA_DANCE.CS
    if(included("writer\\pda_dance.cs"))
    {
        EditActionMap("actionMap.sae");

        // Start dancin' and bring up the commander screen
        // or stop dancin' and close the commander screen
        bindCommand(keyboard0, make, alt, "c", TO, "remoteEval(2048, ToggleCommandMode);");
        bindCommand(keyboard0, break, alt, "c", TO, "Dance::pdaDance();");

        // Start or stop dancin' :)
        bindCommand(keyboard0, make, alt, "d", TO, "Dance::pdaDance();");
        bindCommand(keyboard0, break, alt, "d", TO, "");
    }
    //-----------------------------------------------------------------------------
    //-----------------------------------------------------------------------------
    // PILOT_MODE.CS
    if(included("writer\\pilot_mode.cs"))
    {
        EditActionMap("playMap.sae");

        // Turn on pilot mode and cycle through mouse sensitivity settings for flying
        bindCommand(keyboard0, make, l_shift, "c", TO, "PilotMode::On();");

        // Toggle auto-detect Pilot Mode on/off
        bindCommand(keyboard0, make, l_shift, "p", TO, "PilotMode::ToggleAutoDetect();");

        // Set a new jump key to turn off Pilot mode and exit the vehicle
        bindCommand(keyboard0, make, shift, "space", TO, "PilotMode::Off();");
    }
    //-----------------------------------------------------------------------------
    //-----------------------------------------------------------------------------
    // PING.CS
    if(included("writer\\ping.cs"))
    {
        EditActionMap("actionMap.sae");

        // Update ping value
        bindCommand(keyboard0, make, alt, "p", TO, "Ping::get();");
        bindCommand(keyboard0, break, alt, "p", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // SMOOTH_ZOOM.CS
    if(included("writer\\smooth_zoom.cs"))
    {
        // Zoom in while key held down
        bindCommand(keyboard0, make, shift, "z", TO, "SmoothZoom::inKey(1);");
        bindCommand(keyboard0, break, shift, "z", TO, "SmoothZoom::inKey(0);");

        // Zoom out while key held down
        bindCommand(keyboard0, make, shift, "x", TO, "SmoothZoom::outKey(1);");
        bindCommand(keyboard0, break, shift, "x", TO, "SmoothZoom::outKey(0);");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // TAP_THROW.CS
    if(included("writer\\tap_throw.cs"))
    {
        EditActionMap("playMap.sae");

        // Tap key to throw all grenades, press key to throw one grenade
        bindCommand(keyboard0, make, "g", TO, "tapThrow(1, \"Grenade\");");
        bindCommand(keyboard0, break, "g", TO, "tapThrow(0, \"Grenade\");");

        // Tap key to throw all mines, press key to throw one mine
        bindCommand(keyboard0, make, "m", TO, "tapThrow(1, \"Mine\");");
        bindCommand(keyboard0, break, "m", TO, "tapThrow(0, \"Mine\");");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // XHUD.CS
    if(included("writer\\xHUD.cs"))
    {
        EditActionMap("playMap.sae");

        // Cycle through available colours
        bindCommand(keyboard0, make, alt, "]", TO, "xHUD::nextColour();");
        bindCommand(keyboard0, break, alt, "]", TO, "");
    }
    //-----------------------------------------------------------------------------

    //-----------------------------------------------------------------------------
    // ZOOM.CS
    if(included("writer\\zoom.cs"))
    {
        EditActionMap("playMap.sae");

        // Tap key to toggle zoom mode on
        bindCommand(keyboard0, make, "e", TO, "tapAction(1, 0.075, IDACTION_SNIPER_FOV);");
        bindCommand(keyboard0, break, "e", TO, "tapAction(0, 0.075, IDACTION_SNIPER_FOV);");

        // Set zoom levels directly
        bindCommand(keyboard0, make, shift, "1", TO, "Zoom::set(0);");
        bindCommand(keyboard0, make, shift, "2", TO, "Zoom::set(1);");
        bindCommand(keyboard0, make, shift, "3", TO, "Zoom::set(2);");
        bindCommand(keyboard0, make, shift, "4", TO, "Zoom::set(3);");

        // Toggle 2x -> 20x and 20x ->2x rollover on and off
        bindCommand(keyboard0, make, control, "z", TO, "Zoom::toggleRollover();");

        // Increase zoom
        bindCommand(keyboard0, make, "z", TO, "Zoom::in();");

        // Decrease zoom
        bindCommand(keyboard0, make, "x", TO, "Zoom::out();");
    }
    //-----------------------------------------------------------------------------
}
