// ---------------------------------------------------------------------------
// queue.cs -- Version 2.1 -- May 19, 1999
// by Vis-DS.Writer (Lorne Laliberte, writer@videon.wave.ca)
//
// http://www.videon.wave.ca/~writer/strategy/tribes.html
// ---------------------------------------------------------------------------

include("writer\\version.cs");
version("writer\\queue.cs", "2.1", "Lorne Laliberte", "- May 19, 1999 - queue functions - www.planetstarsiege.com/lorne/");

include("writer\\event.cs");

function Queue::count(%name)
{
    return $Queue::end[%name] - $Queue::start[%name];
}

function Queue::push(%name, %value)
{
    %index = $Queue::end[%name]++;
    $Queue::[%name, %index] = %value;
}

function Queue::pop(%name)
{
    %index = $Queue::start[%name]++;
    %value = $Queue::[%name, %index];
    $Queue::[%name, %index] = "";
    if($Queue::start[%name] > $Queue::end[%name])
        $Queue::start[%name] = $Queue::end[%name] = 0;

    return %value;
}

function Queue::flush(%name)
{
    %value = $Queue::[%name, $Queue::end[%name]];
    $Queue::start[%name] = $Queue::end[%name] = 0;
    return %value;
}


function Queue::reset()
{
    deleteVariables("$Queue::*");
}

Event::Attach(eventChangeMission, "Queue::Reset();");
Event::Attach(eventConnected, "Queue::Reset();");
