#include "g_local.h"

cvar_t *matchtime;
cvar_t  *maprepeats;

/*-----------------------------------------------------------------------*/

void JoinIn(edict_t *ent, pmenu_t *p)
{
        int i,j;
        match_t *match;

        //If we couldn't be added to the ladder then don't join in.
        if (!Ladder_Add(ent))
                return;
        //find a free match and put us in it
        for (i = 0; i < MAX_MATCHS; i++)
        {
                match = &matchgame.matchs[i];
                if (match->matchstate == MATCHSTATE_WAITING)
                {
                        for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                        {
                                if (match->players[j] == NULL)
                                {
                                        PMenu_Close(ent);
                                        ent->client->resp.match = match;
                                        match->players[j] = ent;
                                        ent->client->pers.spectator = false;
                                        OonoRespawn(ent);
                                        gi.bprintf (PRINT_HIGH, "%s is now waiting\n", ent->client->pers.netname);
                                        return;
                                }
                        }
                        //To many players so try for the next one
                }
        }
}

void ChaseCam(edict_t *ent, pmenu_t *p)
{
	int i;
	edict_t *e;

	if (ent->client->chase_target) {
		ent->client->chase_target = NULL;
		PMenu_Close(ent);
		return;
	}

	for (i = 1; i <= maxclients->value; i++) {
		e = g_edicts + i;
		if (e->inuse && e->solid != SOLID_NOT) {
			ent->client->chase_target = e;
			PMenu_Close(ent);
			ent->client->update_chase = true;
			break;
		}
	}
}

void ReturnToMain(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
        OonoOpenJoinMenu(ent);
}

void OonoCredits(edict_t *ent, pmenu_t *p);

void DeathmatchScoreboard (edict_t *ent);

/*
void ShowScores(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);

	ent->client->showscores = true;
	ent->client->showinventory = false;
	DeathmatchScoreboard (ent);
}
*/

pmenu_t creditsmenu[] = {
	{ "*Quake II",						PMENU_ALIGN_CENTER, NULL, NULL },
        { "*Top Rung",        PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,								PMENU_ALIGN_CENTER, NULL, NULL },
        { "*Concept",                                       PMENU_ALIGN_CENTER, NULL, NULL }, 
        { "Pat 'OBwan-kenOB' Foy",                         PMENU_ALIGN_CENTER, NULL, NULL },
        { "James 'Skull' Bielby",                         PMENU_ALIGN_CENTER, NULL, NULL },
	{ "*Programming",					PMENU_ALIGN_CENTER, NULL, NULL }, 
        { "James 'Skull' Bielby",                         PMENU_ALIGN_CENTER, NULL, NULL },
        { "*Original Maps",                                                       PMENU_ALIGN_CENTER, NULL, NULL },
        { "James 'Skull' Bielby",                                        PMENU_ALIGN_CENTER, NULL, NULL },
        { "Jens Andreasson",                                        PMENU_ALIGN_CENTER, NULL, NULL },
        { "Noel 'Taltos' Weer",                                        PMENU_ALIGN_CENTER, NULL, NULL },
        { "Pat 'OBwan-kenOB' Foy",                         PMENU_ALIGN_CENTER, NULL, NULL },
        { "Josh '^Dante^' Dalcher",                                        PMENU_ALIGN_CENTER, NULL, NULL },
        { "*Other",                                                     PMENU_ALIGN_CENTER, NULL, NULL },
        { "Josh '^Dante^' Dalcher",                                        PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,								PMENU_ALIGN_CENTER, NULL, NULL },
        { "Return to Main Menu",                        PMENU_ALIGN_LEFT, NULL, ReturnToMain }
};

pmenu_t joinmenu[] = {
	{ "*Quake II",			PMENU_ALIGN_CENTER, NULL, NULL },
        { "*Top Rung",        PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
	{ NULL,					PMENU_ALIGN_CENTER, NULL, NULL },
        { "Join In",              PMENU_ALIGN_LEFT, NULL, JoinIn },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
        { "Chase Camera",               PMENU_ALIGN_LEFT, NULL, ChaseCam },
        { "Credits",                    PMENU_ALIGN_LEFT, NULL, OonoCredits },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
	{ "Use [ and ] to move cursor",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ENTER to select",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "ESC to Exit Menu",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ "(TAB to Return)",	PMENU_ALIGN_LEFT, NULL, NULL },
	{ NULL,					PMENU_ALIGN_LEFT, NULL, NULL },
        { "v" OONO_STRING_VERSION,       PMENU_ALIGN_RIGHT, NULL, NULL },
};

int UpdateJoinMenu(edict_t *ent)
{
	static char levelname[32];

	if (ent->client->chase_target)
                joinmenu[6].text = "Leave Chase Camera";
	else
                joinmenu[6].text = "Chase Camera";

	levelname[0] = '*';
	if (g_edicts[0].message)
		strncpy(levelname+1, g_edicts[0].message, sizeof(levelname) - 2);
	else
		strncpy(levelname+1, level.mapname, sizeof(levelname) - 2);
	levelname[sizeof(levelname) - 1] = 0;

        return 4;
}

void OonoOpenJoinMenu(edict_t *ent)
{
	int team;

        team = UpdateJoinMenu(ent);
	if (ent->client->chase_target)
                team = 6;
	PMenu_Open(ent, joinmenu, team, sizeof(joinmenu) / sizeof(pmenu_t));
}

void OonoCredits(edict_t *ent, pmenu_t *p)
{
	PMenu_Close(ent);
	PMenu_Open(ent, creditsmenu, -1, sizeof(creditsmenu) / sizeof(pmenu_t));
}

/*-----------------------------------------------------------------------*/

//Check if player is in a match
qboolean OonoIsInMatch (edict_t *ent)
{
        gclient_t *cl;
        cl = ent->client;
        if (!cl)      
                return false;
        if (!cl->resp.match)
                return false;
        return true;
}

void OonoRespawn (edict_t *ent)
{
	// clear client on respawn
	ent->client->resp.score = ent->client->pers.score = 0;

	ent->svflags &= ~SVF_NOCLIENT;
	PutClientInServer (ent);

	// add a teleportation effect
	if (!ent->client->pers.spectator)  {
		// send effect
		gi.WriteByte (svc_muzzleflash);
		gi.WriteShort (ent-g_edicts);
		gi.WriteByte (MZ_LOGIN);
		gi.multicast (ent->s.origin, MULTICAST_PVS);

		// hold in place briefly
		ent->client->ps.pmove.pm_flags = PMF_TIME_TELEPORT;
		ent->client->ps.pmove.pm_time = 14;
	}

	ent->client->respawn_time = level.time;

}

//Do whatever stuff needs to be done for the match
void OonoMatchFrame ()
{
        int i,finished,none,count,j,waiting;
        match_t *match;
        finished = 0;
        none = 0;
        waiting = 0;

	if (level.intermissiontime)
		return;

	if (!deathmatch->value)
		return;

        for (i = 0; i < MAX_MATCHS; i++)
        {
                match = &matchgame.matchs[i];
                switch (match->matchstate)
                {
                        case MATCHSTATE_NONE:
                                //Nothing to do
                                none++;
                                break;
                        case MATCHSTATE_WAITING:
                                waiting++;
                                //Check if enough players to start
                                count = 0;
                                for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                                {
                                        if (match->players[j] && match->players[j]->inuse)
                                                count++;
                                }
                                //There is so go to prematch warmup
                                if (count == MAX_PLAYERS_IN_MATCH)
                                {
                                        waiting--;
                                        //30 second warmup
                                        if (!matchgame.endframe || ((matchgame.endframe - level.framenum) > MATCH_ALLOWEDSTART))
                                        {
                                                match->matchstate = MATCHSTATE_PREMATCH;
                                                match->endframe = level.framenum + MATCH_PREMATCHTIME;
                                                matchgame.endframe = match->endframe + MATCH_TIME;
                                                gi.bprintf (PRINT_HIGH, "Match %d: Prematch started\n", i+1);
                                        }
                                        else //go into free for all
                                        {
                                                match->matchstate = MATCHSTATE_FINISHED;
                                                match->endframe = matchgame.endframe;
                                                for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                                                        match->scores[j] = -1000;
                                                gi.bprintf (PRINT_HIGH, "Match %d: Free For All Mode\n", i+1);
                                        }
                                }
                                break;
                        case MATCHSTATE_PREMATCH:
                                count = 0;
                                //Check if players are meant to start now
                                if (match->endframe < level.framenum)
                                {
                                        match->matchstate = MATCHSTATE_RUNNING;
                                        match->endframe = level.framenum + MATCH_TIME;
                                        gi.bprintf (PRINT_HIGH, "Match %d: Match started\n", i+1);
                                }
                                else if (match->endframe < (level.framenum + 110))
                                { // 10 second countdown
                                        count = match->endframe - level.framenum;
                                        count = (count / 10) + 1;
                                }
                                for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                                {
                                        //Assume the player has delt
                                        //with the problem (this if should
                                        //never come true)
                                        if (!match->players[j] || !match->players[j]->inuse)
                                                continue;
                                        match->players[j]->client->countdown = count;
                                        if (match->matchstate != MATCHSTATE_PREMATCH)
                                                OonoRespawn (match->players[j]);
                                }
                                break;
                        case MATCHSTATE_RUNNING:
                                //Check if match is over
                                if (match->endframe < level.framenum)
                                {
                                        match->matchstate = MATCHSTATE_FINISHED;
                                        match->endframe = 0;
                                        gi.bprintf (PRINT_HIGH, "Match %d: Match finished\n", i+1);
                                        for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                                        {
                                                if (!match->players[j] || !match->players[j]->inuse)
                                                {
                                                        match->scores[j] = 0;
                                                        continue;
                                                }
                                                //Copy in scores for later 
                                                match->scores[j] = match->players[j]->client->resp.score;
                                                //Respawn
                                                OonoRespawn (match->players[j]);
                                        }
                                }
                                break;
                        case MATCHSTATE_FINISHED:
                                //Add up finished ones. If their all finished
                                //then go on to next round.
                                finished++;
                                break;
                }
        }
        //If they've all finished then go onto next map
        if (((waiting+none) != MAX_MATCHS) && ((none + finished + waiting) == MAX_MATCHS))
        {
                gi.bprintf (PRINT_HIGH, "All matches finished.\n");
                //Hack the waiting player so that he/she will be counted
                //as they missed the match start
                for (i = 0; i < MAX_MATCHS; i++)
                {
                        match = &matchgame.matchs[i];
                        if (match->matchstate == MATCHSTATE_WAITING)
                        {
                                for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                                {
                                        match->scores[j] = -1000;
                                }
                        }
                }
                Ladder_FinishRound();
                EndDMLevel ();
                return;
        }
}

void OonoInitMatchs ()
{
        int i,j;
        match_t *match;
        edict_t *spot;
        //Clear structure
        memset(&matchgame,0,sizeof(matchgame_t));
        //Search for spawn points for the matches
        spot = NULL;
	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
                i = 0;
                //There's probably one hell of a better way of doing this but
                //it works!
                if (!spot->targetname)
                        i = 0;
                else if (Q_stricmp (spot->targetname, "match1") == 0)
                        i = 0;
                else if (Q_stricmp (spot->targetname, "match2") == 0)
                        i = 1;
                else if (Q_stricmp (spot->targetname, "match3") == 0)
                        i = 2;
                else if (Q_stricmp (spot->targetname, "match4") == 0)
                        i = 3;
                else if (Q_stricmp (spot->targetname, "match5") == 0)
                        i = 4;
                else if (Q_stricmp (spot->targetname, "match6") == 0)
                        i = 5;
                else if (Q_stricmp (spot->targetname, "match7") == 0)
                        i = 6;
                else if (Q_stricmp (spot->targetname, "match8") == 0)
                        i = 7;
                match = &matchgame.matchs[i];
                match->matchstate = MATCHSTATE_WAITING;
                //Traverse spawns and find an empty one
                //If there was no space then it will just be discarded
                for (j = 0; j < MAX_SPAWNS; j++)
                {
                        if (!match->spawns[j])
                        {
                                match->spawns[j] = spot;
                                break;
                        }
                }
        }
        //Start the ladder. eg. put everyone on it into matchs automatically
        Ladder_Start ();
}

void OonoMatchScoreboard (edict_t *ent)
{
        char            entry[1024];
        char            string[1400];
	int		stringlength;
	int		i, j, k;
        int             y,matchtime,score;
	gclient_t	*cl;
	edict_t		*cl_ent;
        int             big;
        match_t         *match;
        char            *matchstate;

	// print level name and exit rules
	string[0] = 0;

	stringlength = strlen(string);

        Com_sprintf (entry, sizeof(entry),
                "xv 0 yv 0 string2 \"  Name         Score Ping Time Status Pos\" "
                "xv 0 yv 8 string2     --------------------------------------- ");
        j = strlen(entry);
        if (stringlength + j > 1024)
                return; //Something went wrong!
        strcpy (string + stringlength, entry);
        stringlength += j;

        y = 16;
        big = 0;
        for (i=0 ; i<MAX_MATCHS ; i++)
	{
                match = &matchgame.matchs[i];
                if (match->matchstate == MATCHSTATE_NONE)
                        continue;
                switch (match->matchstate)
                {
                        case MATCHSTATE_WAITING:
                                matchstate = "W";
                                break;
                        case MATCHSTATE_PREMATCH:
                                matchstate = "P";
                                break;
                        case MATCHSTATE_RUNNING:
                                matchstate = "R";
                                break;
                        case MATCHSTATE_FINISHED:
                                matchstate = "F";
                                break;
                }
                if (match->endframe)
                        matchtime = (match->endframe - level.framenum) / 10;
                else
                        matchtime = 0;
                for (k = 0; k < MAX_PLAYERS_IN_MATCH; k++)
                {
                        cl_ent = match->players[k];
                        if (!cl_ent || !cl_ent->inuse)// || game.clients[i].resp.spectator)
                                continue;
                        cl = cl_ent->client;

                        if (match->matchstate == MATCHSTATE_FINISHED)
                                score = match->scores[k];
                        else
                                score = cl->resp.score;
                        //Hack for free for all
                        if (score == -1000)
                                score = 0;
                        // send the layout
                        Com_sprintf (entry, sizeof(entry),
                                "xv 0 yv %i %s \"  %-12.12s   %3d  %3d  %3d   %2d.%s  %2d\" ",
                                y, (big) ? "string2" : "string",
                                cl->pers.netname,
                                score, cl->ping,
                                matchtime,
                                i+1,matchstate, Ladder_Position(cl_ent));
                        j = strlen(entry);
                        if (stringlength + j > 1024)
                                break;
                        strcpy (string + stringlength, entry);
                        stringlength += j;
                        y += 8;
                }
                big = 1 - big;
                if (stringlength + j > 1024)
                        break;
        }

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

//Disconnects a player from a match (used when they disconnect from game
//but could be used at any time)
void OonoMatchDisconnect(edict_t *ent)
{
        match_t *match;
        int i, matchnum, j;
        Ladder_Remove (ent);
        if (!ent->client->resp.match)
                return;
        match = ent->client->resp.match;
        //Remove ourselves from the match
        for (i = 0; i < MAX_PLAYERS_IN_MATCH; i++)
        {
                if (match->players[i] == ent)
                        match->players[i] = NULL;
        }
        ent->client->resp.match = NULL;
        for (i = 0; i < MAX_MATCHS; i++)
        {
                if (&matchgame.matchs[i] == match)
                        matchnum = i;
        }
        switch (match->matchstate)
        {
                case MATCHSTATE_FINISHED:
                case MATCHSTATE_WAITING:
                        //No need to worry
                        break;
                case MATCHSTATE_PREMATCH:
                case MATCHSTATE_RUNNING:
                        //Now this is where the problems occur!
                        //Plans:
                        //1.Chuck all players out of match
                        //2.Finish match with other player as winner
                        //3.Assign ghost code so player can return
                        //Currently: 2
                        match->matchstate = MATCHSTATE_FINISHED;
                        for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                        {
                                if (!match->players[j] ||
                                (match->players[j] == ent) || !match->players[j]->inuse)
                                {
                                        //Make sure the other player definatly wins
                                        match->scores[j] = -1000;
                                        continue;
                                }
                                //Copy in scores for later
                                match->scores[j] = match->players[j]->client->resp.score;
                                //Respawn them
                                OonoRespawn (match->players[j]);
                        }
                        gi.bprintf (PRINT_HIGH, "Match %d: Match finished\n", matchnum+1);
                        match->endframe = 0;
                        break;
        }
}

float OonoPlayersRangeFromSpot(edict_t *spot, match_t *match)
{
	edict_t	*player;
	float	bestplayerdistance;
	vec3_t	v;
        int k;
        float playerdistance;
        bestplayerdistance = 99999;
        for (k = 0; k < MAX_PLAYERS_IN_MATCH; k++)
        {
                if (!(player = match->players[k]))
                        continue;
                //Makes the first spawn work properly
                //if (!player->inuse)
                //        continue;

		if (player->health <= 0)
			continue;
		VectorSubtract (spot->s.origin, player->s.origin, v);
                playerdistance = VectorLength (v);
		if (playerdistance < bestplayerdistance)
			bestplayerdistance = playerdistance;
	}
	return bestplayerdistance;
}

edict_t *OonoSelectSpawnPoint(match_t *match, edict_t *ignore)
{
        edict_t *spot1;
        float   range, range1;
        int i,j,count;
        if (!match)
                return NULL;
        count = 0;
        range1 = 99999;
        spot1 = NULL;
        for (i = 0; i < MAX_SPAWNS; i++)
        {
                if (!match->spawns[i] || (match->spawns[i] == ignore))
                        continue;
                count++;
                range = OonoPlayersRangeFromSpot(match->spawns[i], match);
                if (range < range1)
		{
			range1 = range;
                        spot1 = match->spawns[i];
                }
        }

	if (!count)
		return NULL;

        if (count == 1)
                spot1 = NULL;
        else
                count -= 1;

        j = rand() % count;

        for (i = 0; i < MAX_SPAWNS; i++)
        {
                if (match->spawns[i])
                        j--;
                if (spot1 && match->spawns[i] == spot1)
                        j++;
                if (j < 1)
                        return match->spawns[i];
        }
        return NULL;
}

edict_t *OonoOtherPlayer(edict_t *ent)
{
        if (!ent)
                return NULL;
        if (!ent->client)
                return NULL;
        if (!ent->client->resp.match)
                return NULL;
        if (ent == ent->client->resp.match->players[0])
                return ent->client->resp.match->players[1];
        if (ent == ent->client->resp.match->players[1])
                return ent->client->resp.match->players[0];
}

void OonoSetStats (edict_t *ent)
{
        edict_t *other;
        int             matchtime;
        match_t         *match;
        int playernum,othernum;
	playernum = ent-g_edicts-1;

        if (ent->client->countdown)
                ent->client->ps.stats[STAT_COUNTDOWNON] = 1;
        else
                ent->client->ps.stats[STAT_COUNTDOWNON] = 0;
        ent->client->ps.stats[STAT_COUNTDOWN] = ent->client->countdown - 1;
        ent->client->ps.stats[STAT_MYNAME] = CS_GENERAL+playernum;
        if (other = OonoOtherPlayer(ent))
        {
                othernum = other-g_edicts-1;
                ent->client->ps.stats[STAT_OTHERFRAGS] = other->client->resp.score;
                ent->client->ps.stats[STAT_OTHERNAME] = CS_GENERAL+othernum;
        }
        else
        {
                ent->client->ps.stats[STAT_OTHERFRAGS] = 0;
                ent->client->ps.stats[STAT_OTHERNAME] = 0;
        }

        match = ent->client->resp.match;
        if (match)
        {
                if (match->endframe)
                        matchtime = (match->endframe - level.framenum) / 10;
                else
                        matchtime = 0;
                gi.configstring (CS_GENERAL+MAX_CLIENTS+playernum, va("%2d:%2.2d", matchtime / 60, matchtime % 60));
                ent->client->ps.stats[STAT_TIMELEFT] = CS_GENERAL+MAX_CLIENTS+playernum;
        }
        else
                ent->client->ps.stats[STAT_TIMELEFT] = 0;
}


/*-----------------------------------------------------------------------*/

qboolean Ladder_Add (edict_t *ent)
{
        int i;
        //Browse down to the first space and put us in it
        for (i = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                if (ladder.players[i])
                        continue;
                ladder.players[i] = ent;
                return true;
        }
        return false;
}

void Ladder_Remove (edict_t *ent)
{
        int i;
        //Browse for us and if we find us then remove
        for (i = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                if (ladder.players[i] == ent)
                        ladder.players[i] = NULL;
        }
        //Defrag the ladder to get rid of the spaces.
        Ladder_Defrag();
}

void Ladder_Defrag ()
{
        int i,j;
        edict_t *ent;
        for (i = 0, j = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                if (ladder.players[i])
                {
                        // We do it like this so if i and j are the same
                        // no change will occur
                        ent = ladder.players[i];
                        ladder.players[i] = NULL;
                        ladder.players[j] = ent;
                        j++;
                }
        }
}

void Ladder_Clear ()
{
        memset (&ladder, 0, sizeof(ladder_t));
        ladder.round = 1;
}

void Ladder_Show (edict_t *ent)
{
        char            entry[1024];
        char            string[1400];
	int		stringlength;
        int             i,j,k;
        int             y,matchtime,score;
	gclient_t	*cl;
	edict_t		*cl_ent;
        match_t         *match;
        char            *matchstate;

	string[0] = 0;

	stringlength = strlen(string);

        Com_sprintf (entry, sizeof(entry),
                "xv 0 yv 0 string2 \"Pos Name         Score Ping Time MS\" "
                "xv 0 yv 8 string2   ----------------------------------- ");
        j = strlen(entry);
        if (stringlength + j > 1024)
                return; //Something went wrong!
        strcpy (string + stringlength, entry);
        stringlength += j;

        y = 16;
        for (i = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                cl_ent = ladder.players[i];
                if (!cl_ent || !cl_ent->inuse || game.clients[i].resp.spectator)
                        continue;
                cl = cl_ent->client;
                matchtime = 0;
                matchstate = "-";
                score = 0;
                if (cl->resp.match)
                {
                        match = cl->resp.match;
                        switch (match->matchstate)
                        {
                                case MATCHSTATE_WAITING:
                                        matchstate = "W";
                                        break;
                                case MATCHSTATE_PREMATCH:
                                        matchstate = "P";
                                        break;
                                case MATCHSTATE_RUNNING:
                                        matchstate = "R";
                                        break;
                                case MATCHSTATE_FINISHED:
                                        matchstate = "F";
                                        break;
                        }
                        if (match->endframe)
                                matchtime = (match->endframe - level.framenum) / 10;
                        if (match->matchstate == MATCHSTATE_FINISHED)
                        {
                                //Find the player in the match
                                for (k = 0; k < MAX_PLAYERS_IN_MATCH; k++)
                                {
                                        if (cl_ent == match->players[k])
                                        {
                                                score = match->scores[k];
                                                break;
                                        }
                                }
                                //Hack for making sure people are out when they should be
                                if (score == -1000)
                                        score = 0;
                        }
                        else
                                score = cl->resp.score;
                }
                // send the layout
                Com_sprintf (entry, sizeof(entry),
                        "xv 0 yv %i %s \" %2d %-12.12s   %3d  %3d  %3d  %s\" ",
                        y, (cl_ent == ent) ? "string2" : "string",
                        i+1,
                        cl->pers.netname,
                        score, cl->ping,
                        matchtime, matchstate);
                j = strlen(entry);
                if (stringlength + j > 1024)
                        break;
                strcpy (string + stringlength, entry);
                stringlength += j;
                y += 8;
        }

	gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

void Ladder_PutInMatch (edict_t *ent)
{
        int i,j;
        match_t *match;
        //find a free match and put us in it
        for (i = 0; i < MAX_MATCHS; i++)
        {
                match = &matchgame.matchs[i];
                if (match->matchstate == MATCHSTATE_WAITING)
                {
                        for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                        {
                                if (match->players[j] == NULL)
                                {
                                        ent->client->resp.match = match;
                                        match->players[j] = ent;
                                        ent->client->pers.spectator = false;
                                        return;
                                }
                        }
                        //To many players so try for the next one
                }
        }
}

//Not used
#if 0
void Ladder_OldReorg ()
{
        int             i,j;
        edict_t         *sorted[MAX_PLAYERS_IN_LADDER], *selected;
        match_t         *match;
        memset(sorted, 0, sizeof(sorted));
        //Reorganise the ladder based on the scores recorded in the matches
        //FIRST PASS: FIND ALL THE WINNERS
        j = 0;
        for (i = 0; i < MAX_MATCHS; i++)
        {
                match = &matchgame.matchs[i];
                if (match->scores[0] > match->scores[1])
                        selected = match->players[0];
                else if (match->scores[0] < match->scores[1])
                        selected = match->players[1];
                else
                        selected = NULL;
                if (selected)
                {
                        if (selected->inuse)
                        {
                                sorted[j] = selected;
                                j++;
                                if (j > 15)
                                        return;
                        }
                }
        }
        //SECOND PASS: FIND ALL THE TIES THAT WERE HIGHER ORIGINALLY
        for (i = 0; i < MAX_MATCHS; i++)
        {
                match = &matchgame.matchs[i];
                if (match->scores[0] == match->scores[1])
                        if (match->scores[0] != -1000)
                                selected = match->players[0];
                        else
                                selected = NULL;
                else
                        selected = NULL;
                if (selected)
                {
                        if (selected->inuse)
                        {
                                sorted[j] = selected;
                                j++;
                                if (j > 15)
                                        return;
                        }
                }
        }
        //THIRD PASS: FIND ALL THE TIES THAT WERE LOWER ORIGINALLY
        for (i = 0; i < MAX_MATCHS; i++)
        {
                match = &matchgame.matchs[i];
                if (match->scores[0] == match->scores[1])
                {
                        if (match->scores[0] != -1000)
                                selected = match->players[1];
                        else
                                selected = NULL;
                }
                else
                        selected = NULL;
                if (selected)
                {
                        if (selected->inuse)
                        {
                                sorted[j] = selected;
                                j++;
                                if (j > 15)
                                        return;
                        }
                }
        }
        //FORTH PASS: FIND ALL THE LOSERS
        for (i = 0; i < MAX_MATCHS; i++)
        {
                match = &matchgame.matchs[i];
                if (match->scores[0] > match->scores[1])
                        selected = match->players[1];
                else if (match->scores[0] < match->scores[1])
                        selected = match->players[0];
                else
                        selected = NULL;
                if (selected)
                {
                        if (selected->inuse)
                        {
                                sorted[j] = selected;
                                j++;
                                if (j > 15)
                                        return;
                        }
                }
                //Special case of joining after matchs can't start
                if (match->scores[0] == -1000 && match->players[0] && match->players[0]->inuse)
                {
                        sorted[j] = match->players[0];
                        j++;
                        if (j > 15)
                                return;
                }
                if (match->scores[0] == -1000 && match->players[1] && match->players[1]->inuse)
                {
                        sorted[j] = match->players[1];
                        j++;
                        if (j > 15)
                                return;
                }
        }
        //Copy the new ladder over the old one
        memcpy(ladder.players, sorted, sizeof(sorted));
}
#endif

edict_t *Ladder_MatchPlayer (match_t *match, int i)
{
        if (!match->players[i])
                return NULL;
        if (!match->players[i]->inuse)
                return NULL;
        return match->players[i];
}

void Ladder_FinishRound ()
{
        Ladder_Reorg ();
        Ladder_AlterStats ();
        ladder.round++;
}

void Ladder_Reorg ()
{
        int i;
        edict_t *winners[MAX_MATCHS], *loosers[MAX_MATCHS];
        match_t *match;
        for (i = 0; i < MAX_MATCHS; i++) 
        {
                match = &matchgame.matchs[i];
                if (match->scores[0] > match->scores[1])
                { //Player 0 won
                        winners[i] = Ladder_MatchPlayer(match, 0);
                        loosers[i] = Ladder_MatchPlayer(match, 1);
                }
                else if (match->scores[0] < match->scores[1])
                { //Player 1 one
                        winners[i] = Ladder_MatchPlayer(match, 1);
                        loosers[i] = Ladder_MatchPlayer(match, 0);
                }
                else
                { //Draw (assume player 0 must have been first before start)
                        winners[i] = Ladder_MatchPlayer(match, 0);
                        loosers[i] = Ladder_MatchPlayer(match, 1);
                }
        }
        //Now make a new ladder from the winners and loosers.
        //Winners from the top two matches
        ladder.players[0] = winners[0];
        ladder.players[1] = winners[1];
        //Winner from the match below and the looser from the match above
        for (i = 1; i < MAX_MATCHS - 1; i++)
        {
                ladder.players[i*2] = loosers[i-1];
                ladder.players[(i*2)+1] = winners[i+1];
        }
        //Loosers from the last two matches
        ladder.players[MAX_PLAYERS_IN_LADDER - 1] = loosers[MAX_MATCHS - 1];
        ladder.players[MAX_PLAYERS_IN_LADDER] = loosers[MAX_MATCHS];
        //Now defrag it to clear up the spaces.
        Ladder_Defrag ();
        //Now use the arrays to add to the wins a looses totals
        for (i = 0; i < MAX_MATCHS; i++)
        {
                if (winners[i])
                        winners[i]->client->resp.stats.wins++;
                if (loosers[i])
                        loosers[i]->client->resp.stats.losses++;
        }
        //Set the topspot figure for the player at the top
        ladder.players[0]->client->resp.stats.numattop++;
        if (ladder.players[0]->client->resp.stats.numattop >
                ladder.players[0]->client->resp.stats.maxtop)
                ladder.players[0]->client->resp.stats.maxtop = ladder.players[0]->client->resp.stats.numattop;
        //Clear top spot figure for everyone else
        for (i = 1; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                if (!ladder.players[i] || !ladder.players[i]->inuse)
                        continue;
                ladder.players[i]->client->resp.stats.numattop = 0;
        }
}

void Ladder_Start ()
{
        int             i;
        edict_t         *ent;
        //Try and start matches with all the people in the ladder paired
        //together
        for (i = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                ent = ladder.players[i];
                if (!ent) //|| !ent->inuse) - We have to assume they're coming back
                        continue;
                //Chuck the player in a match. They should all end up
                //paired correctly
                Ladder_PutInMatch(ent);
        }
}

void Match_Debug ()
{
        int i,j;
        match_t         *match;
        for (i=0 ; i<MAX_MATCHS ; i++)
	{
                match = &matchgame.matchs[i];
                gi.dprintf("%2d",i);
                for (j = 0; j < MAX_PLAYERS_IN_MATCH; j++)
                {
                gi.dprintf(" : ");
                if (!match->players[j])
                        gi.dprintf("No player set");
                else if (!match->players[j]->inuse)
                        gi.dprintf("Player not inuse");
                else
                        gi.dprintf("%s",match->players[j]->client->pers.netname);
                }
                gi.dprintf("\n");
        }
}

void Ladder_Debug ()
{
        int i;
        for (i = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                gi.dprintf("%2d : ",i);
                if (!ladder.players[i])
                        gi.dprintf("No player set");
                else if (!ladder.players[i]->inuse)
                        gi.dprintf("Player not inuse");
                else
                        gi.dprintf("%s",ladder.players[i]->client->pers.netname);
                gi.dprintf("\n");
        }
}

int Ladder_Position (edict_t *ent)
{
        int i;
        for (i = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                if (!ladder.players[i] || !ladder.players[i]->inuse)
                        continue;
                if (ladder.players[i] == ent)
                        return i+1;
        }
        return 0;
}

/*-----------------------------------------------------------------------*/

//Supporting functions for stats display

void Ladder_AlterStats ()
{
        int             i;
        edict_t         *ent;
        //Try and start matches with all the people in the ladder paired
        //together
        for (i = 0; i < MAX_PLAYERS_IN_LADDER; i++)
        {
                ent = ladder.players[i];
                if (!ent || !ent->inuse)
                        continue;
                ent->client->resp.stats.played++;
        }
}

//Turn the favorite-weapon number into a name
char *OonoWeaponNumber2Name (int i)
{
        switch (i)
        {
                case 0:
                        return "Unknown";
                case 1:
                        return "Blaster";
                case 2:
                        return "Shotgun";
                case 3:
                        return "S-Shotgun";
                case 4:
                        return "Machine Gun";
                case 5:
                        return "Chaingun";
                case 6:
                        return "G-Launcher";
                case 7:
                        return "R-Launcher";
                case 8:
                        return "H-Blaster";
                case 9:
                        return "Railgun";
                case 10:
                        return "BFG 10K";
                case 11:
                        return "Grenades";
        }
}

int OonoMOD2WeaponNumber (int mod)
{
         switch (mod)
         {
                case MOD_BLASTER:
                        return 1;
                case MOD_SHOTGUN:
                        return 2;
                case MOD_SSHOTGUN:
                        return 3;
                case MOD_MACHINEGUN:
                        return 4;
                case MOD_CHAINGUN:
                        return 5;
                case MOD_GRENADE:
                case MOD_G_SPLASH:
                        return 6;
                case MOD_ROCKET:
                case MOD_R_SPLASH:
                        return 7;
                case MOD_HYPERBLASTER:
                        return 8;
                case MOD_RAILGUN:
                        return 9;
                case MOD_BFG_LASER:
                case MOD_BFG_BLAST:
                case MOD_BFG_EFFECT:
                        return 10;
                case MOD_HANDGRENADE:
                case MOD_HG_SPLASH:
                case MOD_HELD_GRENADE:
                        return 11;
                default:
                        return 0;
        }
        return 0;
}

//Uses the kills and weaponkills[] to work out the favorite weapon
int OonoBestWeapon (edict_t *ent)
{
        int i,bestsofar,favorite;
        //Work out which is the lowest ranking weapon that has the most kills
        bestsofar = -1;
        favorite = -1;
        for (i = 0;i < 12; i++)
        {
                if (ent->client->resp.stats.weaponkills[i] > bestsofar)
                {
                        bestsofar = ent->client->resp.stats.weaponkills[i];
                        favorite = i;
                }
        }
        return favorite;
}

/****
 * This is the cool ladder thingy that you can bring up. Gives quite a few
 * stats and stuff. Scrollable too!
 ****/

void Ladder_StatShow (edict_t *ent)
{
        char            entry[1024];
        char            string[1400];
        int             stringlength,j;
        int             i,weapnum;
	gclient_t	*cl;
	edict_t		*cl_ent;
                        //[Player][Stat]
        char            data[2][9][13]; //+1 for null char!!
        qboolean        goback,goforward; //For arrows

        if (!ent->client)
                return;

	string[0] = 0;

	stringlength = strlen(string);
        goback = false;
        goforward = false;
        //Check the statspos is valid
        if (ent->client->statspos == 0)
                ent->client->statspos = 0; //No change
        else if ((ent->client->statspos < 0) || (ent->client->statspos > (MAX_PLAYERS_IN_LADDER - 1)))
                ent->client->statspos = 0; //Out of range
        else if (!ladder.players[ent->client->statspos])
                Ladder_StatsPrev (ent); //First player invalid (because a number of people left at once)
        else if (!ladder.players[ent->client->statspos + 1])
                Ladder_StatsPrev (ent); //Second player invalid (this one just makes it look nice)

        //Fill out the arrays
        memset (data, 0, sizeof(data));
        for (i = 0; i < 2; i++)
        {
                cl_ent = ladder.players[i+ent->client->statspos];
                Com_sprintf(data[i][0], 13 ,"%-12d",ent->client->statspos+i+1);
                if (!cl_ent || !cl_ent->inuse)
                        continue;
                cl = cl_ent->client;
                //Name
                Com_sprintf(data[i][1], 13 ,"%-12.12s",cl->pers.netname);
                //Number of matchs played
                Com_sprintf(data[i][2], 13 ,"%-12d",cl->resp.stats.played);
                //Number of matchs won
                Com_sprintf(data[i][3], 13 ,"%-12d",cl->resp.stats.wins);
                //Number of matchs lost
                Com_sprintf(data[i][4], 13 ,"%-12d",cl->resp.stats.losses);
                //Number of matchs spent at number 1 slot
                Com_sprintf(data[i][5], 13 ,"%-12d",cl->resp.stats.maxtop);
                //Number of kills
                Com_sprintf(data[i][6], 13 ,"%-12d",cl->resp.stats.kills);
                weapnum = OonoBestWeapon(cl_ent);
                //Favorite weapon
                Com_sprintf(data[i][7], 13 ,"%-12.12s",OonoWeaponNumber2Name(weapnum));
                if (cl->resp.stats.kills)
                        Com_sprintf(data[i][8], 13 ,"%-12d",(cl->resp.stats.weaponkills[weapnum]*100)/cl->resp.stats.kills);
                else
                        Com_sprintf(data[i][8], 13 ,"%-12d",0);
        }
        //Set back and forward arrows
        if (ent->client->statspos > 0)
                goback = true;
        if ((ent->client->statspos < (MAX_PLAYERS_IN_LADDER - 1)) &&
                (ladder.players[ent->client->statspos+2]))
                goforward = true;

        Com_sprintf (entry, sizeof(entry),
                "xv 0 yv 0 string \"%sPosition%-12.12s%-12.12s%s\" "
                "xv 0 yv 8  string \" Name    %-12.12s%-12.12s\" "
                "xv 0 yv 16 string \" Played  %-12.12s%-12.12s\" "
                "xv 0 yv 24 string \" Won     %-12.12s%-12.12s\" "
                "xv 0 yv 32 string \" Lost    %-12.12s%-12.12s\" "
                "xv 0 yv 40 string \" #1Streak%-12.12s%-12.12s\" "
                "xv 0 yv 48 string \" Kills   %-12.12s%-12.12s\" "
                "xv 0 yv 56 string \" Fav.Weap%-12.12s%-12.12s\" "
                "xv 0 yv 64 string \" %% Use   %-12.12s%-12.12s\" ",
                goback ? "<" : " ",
                data[0][0],data[1][0], goforward ? ">" : " ",
                data[0][1],data[1][1],
                data[0][2],data[1][2],
                data[0][3],data[1][3],
                data[0][4],data[1][4],
                data[0][5],data[1][5],
                data[0][6],data[1][6],
                data[0][7],data[1][7],
                data[0][8],data[1][8]);
        j = strlen(entry);
        if (stringlength + j > 1024)
                return; //Something went wrong!
        strcpy (string + stringlength, entry);
        stringlength += j;

        gi.WriteByte (svc_layout);
	gi.WriteString (string);
}

void Cmd_LadderStats_f (edict_t *ent)
{
	if (!ent->client)
		return;

	ent->client->showinventory = false;
	ent->client->showhelp = false;

	if (ent->client->menu)
                PMenu_Close (ent);

        if (ent->client->stats)
        {
                ent->client->stats = false;
                return;
        }

        //ent->client->showscores = false;
        ent->client->stats = true;

        Ladder_StatShow (ent);
	gi.unicast (ent, true);
}

//Goes on if we are not at the end and it won't leave the second one empty
void Ladder_StatsNext (edict_t *ent)
{
        if ((ent->client->statspos < (MAX_PLAYERS_IN_LADDER - 1)) &&
                (ladder.players[ent->client->statspos+2]))
                ent->client->statspos++;
        Ladder_StatShow (ent);
	gi.unicast (ent, true);
}

// Picks the next statspos down where both columns will be full
void Ladder_StatsPrev (edict_t *ent)
{
        int i, newpos;
        if (ent->client->statspos == 0)
                return;
        //Start at statspos and work back until we can fill both positions
        //or we are at the begining
        newpos = 0;
        for (i = (ent->client->statspos - 1); i > 0; i--)
        {
                if ((ladder.players[i]) &&
                        (ladder.players[i + 1]))
                {
                        newpos = i;
                        break;
                }
        }
        ent->client->statspos = newpos;
        Ladder_StatShow (ent);
	gi.unicast (ent, true);
}

