#define OONO_VERSION                     0.9
#define OONO_VSTRING2(x) #x
#define OONO_VSTRING(x) OONO_VSTRING2(x)
#define OONO_STRING_VERSION  OONO_VSTRING(OONO_VERSION)

#define MAX_PLAYERS_IN_MATCH    2
#define MAX_MATCHS              8
#define MAX_SPAWNS              8
#define MAX_PLAYERS_IN_LADDER   (MAX_PLAYERS_IN_MATCH * MAX_MATCHS)

#define MATCH_TIME              (matchtime->value * 10)   //Time for a match
#define MATCH_PREMATCHTIME      300     //Time for a prematch
#define MATCH_ALLOWEDSTARTI     300     //Time allowed to start a match
                                        //Set to 2 frames to make the ladder
                                        //spawning work. Should fix this!
#define MATCH_ALLOWEDSTART      (MATCH_TIME + MATCH_PREMATCHTIME - MATCH_ALLOWEDSTARTI)

/* Match States */
#define MATCHSTATE_NONE         0       //No space for the match to happen
                                        //(eg. on small maps half the spaces
                                        //will be off)
#define MATCHSTATE_WAITING      1       //Waiting for some players (if there
                                        //is a player they will be in a kind
                                        //of prematch warm-up on their own)
#define MATCHSTATE_PREMATCH     2       //In prematch warm-up
#define MATCHSTATE_RUNNING      3       //Match is running
#define MATCHSTATE_FINISHED     4       //Match is finished but new level
                                        //has not been started. A kind of
                                        //free for all mode.

/*
Matches are not only the matches themselves but also the place where
they can go on.
*/
typedef struct match_s {
        edict_t *players[MAX_PLAYERS_IN_MATCH]; //The players in the match
        int endframe;           //Frame the match (or warmup) will end on
        int scores[MAX_PLAYERS_IN_MATCH]; //Only set at end so we can work
                                          //everything else out easily
        int matchstate;         //Set to one of the matchstates
        edict_t *spawns[MAX_SPAWNS];    //Pointers to this match space's
                                        //spawn points
} match_t;

// Ladders Stats: This is the stats for the player in the ladder
typedef struct lstats_s {
//Not Displayed:
        int numattop;   //Current matchs that we have been at the top
        int weaponkills[12]; //Number of frags with each weapon
                             //(heavily hard-coded) 11 = hand-grenades
                             // 0 = unrecognized
//Displayed:
        int kills;      //Total number of kills on server
        int maxtop;     //Longest streak at the top spot
        int played;     //Number of matchs played
        int wins;       //Number of matchs won
        int losses;     //Number of matchs lost
        int favoriteweapon; //Number of their favorite weapon
} lstats_t;

/*
The ladder structure. This is not cleared between levels. Only when the
server restarts.
1. New players are added at the bottom and go into a free for all mode
2. Winners go up, loosers go down. People who drew and were higher originaly
   are said to have won.
*/
typedef struct ladder_s {
        edict_t *players[MAX_PLAYERS_IN_LADDER]; //All the players
        int round; //Round the ladder is on
        int noplay; //set to the player who couldn't play because there was
                    //no other person to play with. If the next time they still
                    //arn't playing then we swap them with the bloke above them.
        int repeats; //For the map repeating feature
} ladder_t;

typedef struct matchgame_s {
        match_t matchs[MAX_MATCHS]; //The matchs
        int endframe; //Frame when all matches will end (may be longer than a
                      //single match so matches can occur slightly offset).
                      //When this is reached all running matches are finished
} matchgame_t;

matchgame_t matchgame;
ladder_t ladder;

void OonoOpenJoinMenu(edict_t *ent);
qboolean OonoIsInMatch (edict_t *ent);
void OonoRespawn (edict_t *ent);
void EndDMLevel (void);
void OonoMatchFrame ();
void OonoInitMatchs ();
void OonoMatchScoreboard (edict_t *ent);
void OonoMatchDisconnect(edict_t *ent);
edict_t *OonoSelectSpawnPoint(match_t *match, edict_t *ignore);
void OonoSetStats (edict_t *ent);
qboolean Ladder_Add (edict_t *ent);
void Ladder_Remove (edict_t *ent);
void Ladder_Defrag ();
void Ladder_Clear ();
void Ladder_FinishRound ();
void Ladder_Reorg ();
void Ladder_Show (edict_t *ent);
void Ladder_Start ();
void Match_Debug ();
void Ladder_Debug ();
int Ladder_Position (edict_t *ent);
void Ladder_AlterStats ();
void Ladder_StatShow (edict_t *ent);
void Cmd_LadderStats_f (edict_t *ent);
void Ladder_StatsNext (edict_t *ent);
void Ladder_StatsPrev (edict_t *ent);
int OonoMOD2WeaponNumber (int mod);

#define STAT_COUNTDOWNON 18
#define STAT_COUNTDOWN   19
#define STAT_MYNAME      20
#define STAT_OTHERFRAGS  21
#define STAT_OTHERNAME   22
#define STAT_TIMELEFT    23

extern  cvar_t  *matchtime;
extern  cvar_t  *maprepeats;

