!IF "$(OS)" == "Windows_NT"
NULL=
!ELSE 
NULL=nul
!ENDIF 

OUTDIR=.\..\toprung
INTDIR=.\Release

ALL : "$(OUTDIR)\gamex86.dll" "$(OUTDIR)\game.bsc"

CLEAN :
	-@erase "$(INTDIR)\g_ai.obj"
	-@erase "$(INTDIR)\g_ai.sbr"
        -@erase "$(INTDIR)\g_chase.obj"
        -@erase "$(INTDIR)\g_chase.sbr"
	-@erase "$(INTDIR)\g_cmds.obj"
	-@erase "$(INTDIR)\g_cmds.sbr"
	-@erase "$(INTDIR)\g_combat.obj"
	-@erase "$(INTDIR)\g_combat.sbr"
	-@erase "$(INTDIR)\g_func.obj"
	-@erase "$(INTDIR)\g_func.sbr"
	-@erase "$(INTDIR)\g_items.obj"
	-@erase "$(INTDIR)\g_items.sbr"
	-@erase "$(INTDIR)\g_main.obj"
	-@erase "$(INTDIR)\g_main.sbr"
	-@erase "$(INTDIR)\g_misc.obj"
	-@erase "$(INTDIR)\g_misc.sbr"
	-@erase "$(INTDIR)\g_monster.obj"
	-@erase "$(INTDIR)\g_monster.sbr"
	-@erase "$(INTDIR)\g_phys.obj"
	-@erase "$(INTDIR)\g_phys.sbr"
	-@erase "$(INTDIR)\g_save.obj"
	-@erase "$(INTDIR)\g_save.sbr"
	-@erase "$(INTDIR)\g_spawn.obj"
	-@erase "$(INTDIR)\g_spawn.sbr"
        -@erase "$(INTDIR)\g_svcmds.obj"
        -@erase "$(INTDIR)\g_svcmds.sbr"
	-@erase "$(INTDIR)\g_target.obj"
	-@erase "$(INTDIR)\g_target.sbr"
        -@erase "$(INTDIR)\g_toprung.obj"
        -@erase "$(INTDIR)\g_toprung.sbr"
	-@erase "$(INTDIR)\g_trigger.obj"
	-@erase "$(INTDIR)\g_trigger.sbr"
	-@erase "$(INTDIR)\g_utils.obj"
	-@erase "$(INTDIR)\g_utils.sbr"
	-@erase "$(INTDIR)\g_weapon.obj"
	-@erase "$(INTDIR)\g_weapon.sbr"
	-@erase "$(INTDIR)\m_move.obj"
	-@erase "$(INTDIR)\m_move.sbr"
	-@erase "$(INTDIR)\p_client.obj"
	-@erase "$(INTDIR)\p_client.sbr"
	-@erase "$(INTDIR)\p_hud.obj"
	-@erase "$(INTDIR)\p_hud.sbr"
        -@erase "$(INTDIR)\p_menu.obj"
        -@erase "$(INTDIR)\p_menu.sbr"
	-@erase "$(INTDIR)\p_trail.obj"
	-@erase "$(INTDIR)\p_trail.sbr"
	-@erase "$(INTDIR)\p_view.obj"
	-@erase "$(INTDIR)\p_view.sbr"
	-@erase "$(INTDIR)\p_weapon.obj"
	-@erase "$(INTDIR)\p_weapon.sbr"
	-@erase "$(INTDIR)\q_shared.obj"
	-@erase "$(INTDIR)\q_shared.sbr"
	-@erase "$(INTDIR)\vc50.idb"
	-@erase "$(OUTDIR)\game.bsc"
	-@erase "$(OUTDIR)\gamex86.dll"
	-@erase "$(OUTDIR)\gamex86.exp"
	-@erase "$(OUTDIR)\gamex86.lib"

"$(OUTDIR)" :
    if not exist "$(OUTDIR)/$(NULL)" mkdir "$(OUTDIR)"

"$(INTDIR)" :
    if not exist "$(INTDIR)/$(NULL)" mkdir "$(INTDIR)"

CPP=cl.exe
CPP_PROJ=/nologo /G5 /ML /W3 /GX /Zd /O2 /D "WIN32" /D "NDEBUG" /D "_WINDOWS"\
 /FR"$(INTDIR)\\" /Fp"$(INTDIR)\game.pch" /YX /Fo"$(INTDIR)\\" /Fd"$(INTDIR)\\"\
 /c 
CPP_OBJS=.\Release/
CPP_SBRS=.\Release/

.c{$(CPP_OBJS)}.obj:
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

.cpp{$(CPP_OBJS)}.obj:
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

.cxx{$(CPP_OBJS)}.obj:
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

.c{$(CPP_SBRS)}.sbr:
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

.cpp{$(CPP_SBRS)}.sbr:
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

.cxx{$(CPP_SBRS)}.sbr:
   $(CPP) @<<
   $(CPP_PROJ) $< 
<<

MTL=midl.exe
MTL_PROJ=/nologo /D "NDEBUG" /mktyplib203 /win32 
RSC=rc.exe
BSC32=bscmake.exe
BSC32_FLAGS=/nologo /o"$(OUTDIR)\game.bsc" 
BSC32_SBRS= \
	"$(INTDIR)\g_ai.sbr" \
        "$(INTDIR)\g_chase.sbr" \
	"$(INTDIR)\g_cmds.sbr" \
	"$(INTDIR)\g_combat.sbr" \
	"$(INTDIR)\g_func.sbr" \
	"$(INTDIR)\g_items.sbr" \
	"$(INTDIR)\g_main.sbr" \
	"$(INTDIR)\g_misc.sbr" \
	"$(INTDIR)\g_monster.sbr" \
	"$(INTDIR)\g_phys.sbr" \
	"$(INTDIR)\g_save.sbr" \
	"$(INTDIR)\g_spawn.sbr" \
        "$(INTDIR)\g_svcmds.sbr" \
	"$(INTDIR)\g_target.sbr" \
        "$(INTDIR)\g_toprung.sbr" \
	"$(INTDIR)\g_trigger.sbr" \
	"$(INTDIR)\g_utils.sbr" \
	"$(INTDIR)\g_weapon.sbr" \
	"$(INTDIR)\m_move.sbr" \
	"$(INTDIR)\p_client.sbr" \
	"$(INTDIR)\p_hud.sbr" \
        "$(INTDIR)\p_menu.sbr" \
	"$(INTDIR)\p_trail.sbr" \
	"$(INTDIR)\p_view.sbr" \
	"$(INTDIR)\p_weapon.sbr" \
	"$(INTDIR)\q_shared.sbr"

"$(OUTDIR)\game.bsc" : "$(OUTDIR)" $(BSC32_SBRS)
    $(BSC32) @<<
  $(BSC32_FLAGS) $(BSC32_SBRS)
<<

LINK32=link.exe
LINK32_FLAGS=kernel32.lib user32.lib gdi32.lib winmm.lib /nologo\
 /base:"0x20000000" /subsystem:windows /dll /incremental:no\
 /pdb:"$(OUTDIR)\gamex86.pdb" /machine:I386 /def:".\game.def"\
 /out:"$(OUTDIR)\gamex86.dll" /implib:"$(OUTDIR)\gamex86.lib" 
DEF_FILE= \
	".\game.def"
LINK32_OBJS= \
	"$(INTDIR)\g_ai.obj" \
        "$(INTDIR)\g_chase.obj" \
	"$(INTDIR)\g_cmds.obj" \
	"$(INTDIR)\g_combat.obj" \
	"$(INTDIR)\g_func.obj" \
	"$(INTDIR)\g_items.obj" \
	"$(INTDIR)\g_main.obj" \
	"$(INTDIR)\g_misc.obj" \
	"$(INTDIR)\g_monster.obj" \
	"$(INTDIR)\g_phys.obj" \
	"$(INTDIR)\g_save.obj" \
	"$(INTDIR)\g_spawn.obj" \
        "$(INTDIR)\g_svcmds.obj" \
	"$(INTDIR)\g_target.obj" \
        "$(INTDIR)\g_toprung.obj" \
	"$(INTDIR)\g_trigger.obj" \
	"$(INTDIR)\g_utils.obj" \
	"$(INTDIR)\g_weapon.obj" \
	"$(INTDIR)\m_move.obj" \
	"$(INTDIR)\p_client.obj" \
	"$(INTDIR)\p_hud.obj" \
        "$(INTDIR)\p_menu.obj" \
	"$(INTDIR)\p_trail.obj" \
	"$(INTDIR)\p_view.obj" \
	"$(INTDIR)\p_weapon.obj" \
	"$(INTDIR)\q_shared.obj"

"$(OUTDIR)\gamex86.dll" : "$(OUTDIR)" $(DEF_FILE) $(LINK32_OBJS)
    $(LINK32) @<<
  $(LINK32_FLAGS) $(LINK32_OBJS)
<<

DEP_CPP_GAME=\
	".\g_local.h"\
        ".\p_menu.h"\
        ".\g_toprung.h"\
	".\game.h"\
	".\q_shared.h"\

DEP_CPP_PLAYER=\
	".\g_local.h"\
        ".\p_menu.h"\
        ".\g_toprung.h"\
	".\game.h"\
	".\m_player.h"\
        ".\q_shared.h"\
	

"$(INTDIR)\g_ai.obj" "$(INTDIR)\g_ai.sbr" : .\g_ai.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_chase.obj" "$(INTDIR)\g_chase.sbr" : .\g_chase.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_cmds.obj" "$(INTDIR)\g_cmds.sbr" : .\g_cmds.c $(DEP_CPP_PLAYER) "$(INTDIR)"
"$(INTDIR)\g_combat.obj" "$(INTDIR)\g_combat.sbr" : .\g_combat.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_func.obj" "$(INTDIR)\g_func.sbr" : .\g_func.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_items.obj" "$(INTDIR)\g_items.sbr" : .\g_items.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_main.obj" "$(INTDIR)\g_main.sbr" : .\g_main.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_misc.obj" "$(INTDIR)\g_misc.sbr" : .\g_misc.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_monster.obj" "$(INTDIR)\g_monster.sbr" : .\g_monster.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_phys.obj" "$(INTDIR)\g_phys.sbr" : .\g_phys.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_save.obj" "$(INTDIR)\g_save.sbr" : .\g_save.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_spawn.obj" "$(INTDIR)\g_spawn.sbr" : .\g_spawn.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_svcmds.obj" "$(INTDIR)\g_svcmds.sbr" : .\g_svcmds.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_target.obj" "$(INTDIR)\g_target.sbr" : .\g_target.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_toprung.obj" "$(INTDIR)\g_toprung.sbr" : .\g_toprung.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_trigger.obj" "$(INTDIR)\g_trigger.sbr" : .\g_trigger.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_utils.obj" "$(INTDIR)\g_utils.sbr" : .\g_utils.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\g_weapon.obj" "$(INTDIR)\g_weapon.sbr" : .\g_weapon.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\m_move.obj" "$(INTDIR)\m_move.sbr" : .\m_move.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\p_client.obj" "$(INTDIR)\p_client.sbr" : .\p_client.c $(DEP_CPP_PLAYER) "$(INTDIR)"
"$(INTDIR)\p_hud.obj" "$(INTDIR)\p_hud.sbr" : .\p_hud.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\p_menu.obj" "$(INTDIR)\p_menu.sbr" : .\p_menu.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\p_trail.obj" "$(INTDIR)\p_trail.sbr" : .\p_trail.c $(DEP_CPP_GAME) "$(INTDIR)"
"$(INTDIR)\p_view.obj" "$(INTDIR)\p_view.sbr" : .\p_view.c $(DEP_CPP_PLAYER) "$(INTDIR)"
"$(INTDIR)\p_weapon.obj" "$(INTDIR)\p_weapon.sbr" : .\p_weapon.c $(DEP_CPP_PLAYER) "$(INTDIR)"
"$(INTDIR)\q_shared.obj" "$(INTDIR)\q_shared.sbr" : .\q_shared.c q_shared.h "$(INTDIR)"
