

#ifndef __MODEL_H__
#define __MODEL_H__


	#include "basetypes_de.h"


	//------------------------------------------------------------------ //
	// Defines.
	//------------------------------------------------------------------ //

	#define MODELFILE_TOKEN "MonolithExport Model File v6"

	// Model node types.
	#define MNODE_NILL			1
	#define MNODE_TRIS			2
	#define MNODE_DEFORMATION	4 // Deformation node (used with MNODE_TRIS).

	// Key types.
	#define KEYTYPE_POSITION	0
	#define KEYTYPE_CALLBACK	1

	
	#define MODELFLAG_TOUCHED	1	// Used by client.

	
	typedef unsigned char KeyType;
	typedef void (*KeyCallback)(void *pTracker, struct AnimKeyFrame_t *pFrame);
	

	typedef struct ModelString_t
	{
		struct ModelString_t *m_pNext;
		char m_String[1];
	} ModelString;


	typedef struct ModelSphere_t
	{
		DVector	m_Center;
		float	m_Radius;
	} ModelSphere;


	typedef struct ModelVert_t
	{
		// Vertex position.
		DVector			m_Vec;

		float			tu, tv;

		// The vertex normal compressed into bytes.
		char			m_Normal[3];
		
		// The transform attached to this vertex.  This basically indexes
		// CModel::m_RootNode's transform tree iterated depth first.
		unsigned char	m_TransformIndex;
		
		// These are the indices of the model vertices that this vertex replaces.
		// These are only really used for 'extra' vertices (vertices that
		// got added for extra levels of detail).
		unsigned short	m_Replacements[2];
	} ModelVert;


	typedef struct UVPair_t
	{
		float tu, tv;
	} UVPair;


	typedef struct ModelTri_t
	{
		unsigned short	m_Indices[3];
		char			m_Normal[3];
		unsigned char	m_TransformIndex; // Same as ModelVert::m_TransformIndex.
	} ModelTri;


	typedef struct NodeKeyFrame_t
	{
		DVector		m_Translation;
		float		m_Quaternion[4];
	} NodeKeyFrame;


	// Deformation vertex position for a keyframe.
	typedef struct DefVertex_t
	{
		unsigned char m_Pos[3];
	} DefVertex;
	

	typedef struct AnimNode_t
	{
		// Points to its model node.
		struct ModelNode_t	*m_pNode;
		struct ModelAnim_t	*m_pAnim;

		// Deformation vertex positions for each keyframe.
		// This array is m_pAnim->m_nKeyFrames*m_pNode->m_nIndices in size.
		// Indexed as (keyframe, index) = m_DefVertices[(keyframe*m_pNode->m_nIndices)+index].
		DefVertex		*m_DefVertices;
		
		struct TempDefVertex_t *m_TempVertices; // Used by the exporter.

		// Since m_DefVertices are encoded in bytes, this scales and shifts them into their real coordinates.
		DVector			m_Scale;
		DVector			m_Shift;
	
		// Number of keyframes is m_pAnim->m_nKeyFrames.
		struct NodeKeyFrame_t	*m_KeyFrames;

		// Parent animnode.  Root has NULL.
		struct AnimNode_t *		m_pParentNode;

		// Number of children is m_pNode->m_nChildren.
		struct AnimNode_t **	m_Children;
	} AnimNode;


	typedef struct AnimKeyFrame_t
	{
		unsigned long	m_Time;

		DVector			m_BoundMin;
		DVector			m_BoundMax;

		// A string of information about this key..
		char*			m_pString;
		
		KeyType			m_KeyType;
		KeyCallback		m_Callback;
		
		// User data for the callback.
		void			*m_pUser1;
	} AnimKeyFrame;


	typedef struct ModelAnim_t
	{
		char			*m_pName;
		unsigned long	m_msTime;

		// User dimensions.. settable in ModelEdit.
		DVector			m_vDims;

		// Deformation nodes.  Size is Model::m_nDNodes.
		AnimNode		**m_DNodes;
		
		// Internal dimensions used for visibility.		
		DVector			m_BoundMin;
		DVector			m_BoundMax;
		float			m_BoundRadius;	// Magnitude of the largest of m_BoundMin and m_BoundMax.

		AnimKeyFrame	*m_KeyFrames;
		unsigned long	m_nKeyFrames;

//		AnimNode		m_RootNode;
		AnimNode *		m_AnimNodes;
	} ModelAnim;


	typedef struct ModelNode_t
	{
		struct ModelNode_t	*m_Children;
		unsigned long		m_nChildren;

		char			*m_pName;

		// Bounding box for this node, in the node's local space.
		DVector			m_BoundMin;
		DVector			m_BoundMax;

		void*			m_pSoftElem;

		// Which transform this node uses.
		unsigned short	m_TransformIndex;

		// These indices define which vertices (in Model::m_Verts) the animation data reference.
		// (If this node is a deformation node).
		unsigned short	*m_Indices;
		unsigned long	m_nIndices;
		
		// Only used temporarily while exporting a model.
		unsigned short	m_iVertexStart, m_iVertexEnd;

		unsigned char	m_Flags;
	} ModelNode;


	typedef struct ModelTriStrip_t
	{
		unsigned short	m_IndexStart;
		unsigned short	m_nIndices;
	} ModelTriStrip;


	typedef struct Model_t
	{
		// Model link for a linked list.

			DLink			m_Link;

		
		// Misc. data.

			// Not necessarily set..
			char			*m_pFilename;

			unsigned long	m_GeometryMemory;	// How much memory is used by geometry.
			unsigned long	m_AnimationMemory;	// How much memory is used by animation.

			DVector			m_BoundMin;
			DVector			m_BoundMax;
			float			m_BoundRadius;	// Magnitude of the largest of m_BoundMin and m_BoundMax.

			Nexus			m_Nexus;		// Used by engine stuff to know when it's being freed.
											// Its m_pData points at the Model.

			unsigned long	m_FileID;		// Used by server.
			unsigned long	m_Flags;		// MODELFLAG flags above.  Used by various things.

	
		// Geometry data.

			// The root node in the node tree.
			ModelNode		m_RootNode;

			// The flat node list, generated by PREORDER traversal of the node tree.
			ModelNode		**m_FlatNodeList;
			unsigned long	m_nNodes;

			// Flat deformation node list, generated by preorder traversal of the tree.
			ModelNode		**m_DNodes;
			unsigned long	m_nDNodes;

			// m_nNodes/4 and +1 if m_nNodes%4 != 0.
			unsigned long	m_nDWordNodes;

			// The complete vertex list.
			unsigned long	m_nVerts;
			ModelVert		*m_Verts;
			
			// This tells how many of the vertices are from the original list
			// (not added by a new level of detail..)
			unsigned long	m_nNormalVerts;

			// All the tris, sorted in pairs by order of LOD (ie: at LOD 3, 
			// the tris that you'll use start at m_ModelTris[6]).
			unsigned long	m_nModelTris;
			ModelTri		*m_ModelTris;

			// UV and skin coordinates.  The size of each of these is m_nModelTris*3.
			UVPair			*m_UVCoords;
			UVPair			*m_SkinCoords;

			// The number of LODs that have been calculated on this guy.
			unsigned long	m_NumberOfLODs;
			float			m_fLodStartDist;	// Beginning distance when LOD switches from 0 to 1
			float			m_fLodIncrement;	// Incremental distance for subsequent LOD
			float			m_fLodMaxDist;		// Maximum distance, beyond which object not seen

			float			m_MipmapDistAdd;	// Adds to the distance calculated for mipmapping.

			// This is a WORD[m_NumberOfLODs] array.  It tells where the
			// vertex list begins for each level of detail (ie: you can discard
			// anything in m_Verts below m_VertexStartNums[iLOD]).
			unsigned short	*m_VertexStartNums;

			// These are allocated when you load the model.  You can use these
			// with model_CreateTransforms().
			// (Number of transforms = m_nNodes).
			DMatrix			*m_Transforms;
			unsigned long	m_nTransforms;

			// The command string for the model.  This is used for sequences of commands
			// that get stored with the model (like LOD ranges...)
			char			*m_CommandString;

			// All a model's strings are stored in here, since there are 
			// tons of redundant strings (like "").
			ModelString		*m_StringList;


			// When it gets past this distance, the renderer draws indexed triangles
			// which are 5-11% faster, but vertices with texture coordinates not matching
			// look wierd.
			float			m_DrawIndexedDist;
			
			// Tri strips.
			ModelTriStrip	*m_TriStrips;
			unsigned long	m_nTriStrips;
			
			unsigned short	*m_TriStripIndices;
			unsigned long	m_nTriStripIndices;

			// Unstripped tris.
			ModelTri		**m_UnstrippedTris;
			unsigned long	m_nUnstrippedTris;

		
		// Animation data.

			ModelAnim		*m_Anims;
			unsigned long	m_nAnims;

	} Model;


#endif  // __MODEL_H__

