
// This defines a DirectEngine stream.  All the things that load
// themselves from files just get a pointer to a DStream, so tools
// and stuff can just wrap up FILEs and engine stuff can use rezfiles.

#ifndef __DSTREAM_H__
#define __DSTREAM_H__

	
	// Helper macro to read/write data if your stream pointer is called pStream.
	#define STREAM_READ(_x_) pStream->Read(pStream, &(_x_), sizeof(_x_));
	#define STREAM_WRITE(_x_) pStream->Write(pStream, &(_x_), sizeof(_x_));
	

	typedef struct DStream_t
	{
		void			(*Read)(struct DStream_t *pFile, void *pData, unsigned long size);
		
		// Reads a string stored as 2 byte length, then characters.
		void			(*ReadString)(struct DStream_t *pFile, char *pStr, unsigned long maxChars);

		void			(*Write)(struct DStream_t *pFile, void *pData, unsigned long size);
		void			(*WriteString)(struct DStream_t *pFile, char *pStr);

		// 0 = no errors
		// 1 = an error occured
		int				(*ErrorStatus)(struct DStream_t *pFile);
		
		void			(*SeekTo)(struct DStream_t *pFile, unsigned long offset);
		unsigned long	(*GetPos)(struct DStream_t *pFile);
		unsigned long	(*GetLen)(struct DStream_t *pFile);
	} DStream;


#endif  // __DSTREAM_H__



