/* main.c - main program, to test the INI file reading functions.
 *
 * 16 December 1997 - Andrew Wood <ivarch@ps.cus.umist.ac.uk>
 */

#include <stdio.h>
#include <stdlib.h>
#include "iv_ini.h"

#define TEST_FILE	"test.ini"


void main (void) {
  int i,j;
  int num_sections;
  int num_keys;
  char ** section;
  char ** key;
  char * value;
  
  num_sections = ini_list_sections (&section, TEST_FILE);
  
  printf ("Number of sections found: %d\n", num_sections);
  
  for (i = 0; i < num_sections; i++) {

    printf ("%2d: [%s]\n", i+1, section[i]);

    num_keys = ini_list_keys (&key, TEST_FILE, section[i]);

    printf ("    Keys found: %d\n", num_keys);

    for (j = 0; j < num_keys; j++) {
      value = ini_key_value (TEST_FILE, section[i], key[j], "<none found>");
      printf ("    %2d: '%s' = '%s'\n", j+1, key[j], value);
    }
    ini_free_array (key, num_keys);
  }
}
