// fenix@io.com: vertex arrays
/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "quakedef.h"
#include "gl_rva.h"



vavertex_t* global_vertex_array;
unsigned*   global_indice_array;

int global_vertex_array_size;
int global_indice_array_size;

int mode_table[] = {
    /* R_POINTS         */ GL_POINTS,
    /* R_LINES          */ GL_LINES,
    /* R_LINE_STRIP     */ GL_LINE_STRIP,
    /* R_LINE_LOOP      */ GL_LINE_LOOP,
    /* R_TRIANGLES      */ GL_TRIANGLES,
    /* R_TRIANGLE_STRIP */ GL_TRIANGLE_STRIP,
    /* R_TRIANGLE_FAN   */ GL_TRIANGLE_FAN,
    /* R_QUADS          */ GL_QUADS,
    /* R_QUAD_STRIP     */ GL_QUAD_STRIP,
    /* R_POLYGON        */ GL_POLYGON        
};



/* R_ArrayPointer
 ****************************************************************************/
void R_ArrayPointer(vavertex_t* va, unsigned fields)
{
   if (fields & R_VERTEX3) {
       glEnableClientState(GL_VERTEX_ARRAY);
       glVertexPointer(3, GL_FLOAT, sizeof(vavertex_t), &va->x);
   }
   else if (fields & R_VERTEX2) {
       glEnableClientState(GL_VERTEX_ARRAY);
       glVertexPointer(2, GL_FLOAT, sizeof(vavertex_t), &va->x);
   }
   else {
       glDisableClientState(GL_VERTEX_ARRAY);
   }

   if (fields & R_COLOR4) {
      glEnableClientState(GL_COLOR_ARRAY);
      glColorPointer(4, GL_UNSIGNED_BYTE, sizeof(vavertex_t), &va->r);
   }
   else if (fields & R_COLOR3) {
      glEnableClientState(GL_COLOR_ARRAY);
      glColorPointer(3, GL_UNSIGNED_BYTE, sizeof(vavertex_t), &va->r);
   } 
   else {
      glDisableClientState(GL_COLOR_ARRAY);
   }

   if (fields & R_TEXCOORD2) {
      glEnableClientState(GL_TEXTURE_COORD_ARRAY);
      glTexCoordPointer(2, GL_FLOAT, sizeof(vavertex_t), &va->s);
   }
   else {
      glDisableClientState(GL_TEXTURE_COORD_ARRAY);
   }
}



/* R_DrawArray
 ****************************************************************************/
void R_DrawArray(R_MODE mode, int first, size_t count)
{
   glDrawArrays(mode_table[mode], first, count);
}



/* R_DrawElements
 ****************************************************************************/
void R_DrawElements(R_MODE mode, size_t count, unsigned* indices)
{
   glDrawElements(mode_table[mode], count, GL_UNSIGNED_INT, indices);
}



/* R_DrawRangeElements
 ****************************************************************************/
void R_DrawRangeElements(R_MODE mode, unsigned start, unsigned end, size_t count, unsigned* indices)
{
//   glDrawRangeElements(mode_table[mode], start, end, count, GL_UNSIGNED_INT, indices);
}





