/*
Copyright (C) 2000 Jason Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "shaders.h"



int main(int argc, char* argv[])
{
   int   i;
   FILE* f;

   if (argc == 1) {
      // If there are no arguments, parse shaders from stdin.
      sh_parse(NULL, NULL);
   }
   else {
      // Else, Parse each file on the command line.
      for (i = 1; i < argc; i++) {
         f = fopen(argv[i], "r");

         if (!f) {
            fprintf(stderr, "Could not open file '%s'.\n", argv[i]);
            continue;
         }

         sh_message_set_file(argv[i]);
         sh_input_set_file(f);
         sh_parse(NULL, NULL);
      }
   }

   return 0;
}


